% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Top level file, to build the Checker.
%###############################################################################

%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module(library(file_systems), [close_all_streams/0]).

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% LOAD ENHANCED DEFECT REPORTING
%===============================================================================
:- use_module('../simplifier/defectreporting.pro').
%===============================================================================

%===============================================================================
% DYNAMIC FEATURES PRE-LOAD
%===============================================================================

% Establish sicstus settings.
:- set_prolog_flag(unknown, error).

% Establish all dynamic predicates.
:- include('dynamics.pro').
%===============================================================================

%===============================================================================
%FIXED SYSTEM CONFIGURATION
%-------------------------------------------------------------------------------
%This information will be the same for every execution of the tool.
%===============================================================================
:-use_module('../simplifier/data__system.pro',
             [add_system_toolname/1]).

:-add_system_toolname('Proof Checker').
%===============================================================================

%===============================================================================
% LOAD SYSTEM
%===============================================================================
:- include('loadsicstus.pro').
%===============================================================================

%===============================================================================
% runtime_entry(start).
%-------------------------------------------------------------------------------
% This is a special Sicstus predicate, which will be automatically invoked
% when restoring a saved state. It is the top level, or main, predicate.
%===============================================================================

runtime_entry(start):-
    startup_sequence,
    close_all_streams,
    halt(0),
    !.
%===============================================================================

%===============================================================================
% BUILD SAV AND HALT
%===============================================================================

buildsav:-
    zero_defects_reported,
    save_program('checker.sav'),
    close_all_streams,
    halt(0).

buildsav:-
    report_total_defects,
    close_all_streams,
    halt(1).
%===============================================================================

%###############################################################################
%END-OF-FILE
