# -----------------------------------------------------------------------------
#  (C) Altran Praxis Limited
# -----------------------------------------------------------------------------
# 
#  The SPARK toolset is free software; you can redistribute it and/or modify it
#  under terms of the GNU General Public License as published by the Free
#  Software Foundation; either version 3, or (at your option) any later
#  version. The SPARK toolset is distributed in the hope that it will be
#  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#  Public License for more details. You should have received a copy of the GNU
#  General Public License distributed with the SPARK toolset; see file
#  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
#  the license.
# 
# =============================================================================

################################################################################
# PURPOSE
#-------------------------------------------------------------------------------
# Common Makefile
# For Linux, Windows, Solaris or Mac OS X (aka Darwin).
################################################################################

.SUFFIXES:

################################################################################
# BUILD CONFIGURATION
################################################################################

# The available configuration variables are as follows.
#
# DEBUG
# -----
# yes (Build with debugging support)
# no  (Build without debugging support)
#
# COVER (COVERage)
# ----------------
# yes (Build with coverage support)
# no  (Build without debugging support)

################################################################################
# DETERMINE HOST INFORMATION
################################################################################

# Determine which platform this Makefile is being run on.
TARGET:=$(shell uname -s)
GCC_TARGET:=$(shell gcc -dumpmachine)

# Canonicalize the target string.
ifeq ($(findstring CYGWIN_NT,${TARGET}),CYGWIN_NT)
    TARGET:=Windows
endif

################################################################################
# DYNAMIC DEPENDENCIES
################################################################################

# By default, do not build with debug.
ifeq (${DEBUG},)
    DEBUG:=no
endif

# By default, do not build with coverage.
ifeq (${COVER},)
    COVER:=no
endif

# Check to make sure that that debug and coverage have not been simultaneously
# requested.
ifeq (${DEBUG},yes)
    ifeq (${COVER},yes)
        $(error Can not build with debug and coverage simultaneously)
    endif
endif

################################################################################
# PLATFORM INDEPENDENT CONFIGURATION
################################################################################

# Location of lib
CUSTOMER_LIB:=${ROOT}/lib/spark/current

# Common compiler options.
COMMON_OPTS:=-g -gnatwae -gnat05 -gnatwl -gnaty3abefhiklnprt -I${CUSTOMER_LIB} -I${COMMON}/versioning -I${ROOT}/examiner -gnatf -k
GNATMAKE_OPTS:=${COMMON_OPTS} -O2 -fno-strict-aliasing
BIND_OPTS:=-E

# Override compiler options for debug. No optimization, plus full
# validity and overflow checks.
ifeq (${DEBUG},yes)
    GNATMAKE_OPTS:=${COMMON_OPTS} -O0 -gnatVa -gnato -fno-eliminate-unused-debug-types
endif

# Override compiler options for coverage. No optimization, plus
# additional options for coverage analysis.
ifeq (${COVER},yes)
    GNATMAKE_OPTS:=${COMMON_OPTS} -O0 -fprofile-arcs -ftest-coverage
endif

# Options to submit to gnatprep.
# DEBUG: The Examiner raises a fatal error during self-analysis with
#        Source_Reference pragmas in place. Thus, the handy "-r" option
#        is removed until the error is fixed.
PREP_OPTS:=-c

# Common compiler options.
SICSTUS_LIBS:=codesio
SICSTUS_SWITCHES:=-f --nologo --noinfo
SAV_EXTN:=.sav

################################################################################
# PLATFORM SPECIFIC CONFIGURATION
################################################################################

BUILD_VICTOR:=false

# Linux.
ifeq (${TARGET},Linux)
    EXE_EXTN:=
    TAR:=tar
    PREP_TARGET:=Intel_Linux
    ifeq (${GCC_TARGET},x86_64-pc-linux-gnu)
        ADDRESS_SIZE:=64
    else
        ADDRESS_SIZE:=32
    endif
    BUILD_VICTOR:=true
    SPLD_CONF:=
endif

# Windows.
ifeq (${TARGET},Windows)
    EXE_EXTN:=.exe
    TAR:=tar
    PREP_TARGET:=Intel_WinNT
    ifeq (${GCC_TARGET},i686-pc-mingw32)
        ADDRESS_SIZE:=32
        BUILD_VICTOR:=true
    else
        ADDRESS_SIZE:=64
    endif
    # Do not embedded a manifest (the auto-generated manifest has false dependencies).
    SPLD_CONF:=--no-embed-manifest
endif

# Solaris.
ifeq (${TARGET},SunOS)
    EXE_EXTN:=
    TAR:=gtar
    PREP_TARGET:=SPARC_Solaris
    ADDRESS_SIZE:=32
    SPLD_CONF:=
endif

# Darwin (Mac OS X 10.5 or 10.6, 64-bit).
ifeq (${TARGET},Darwin)
    EXE_EXTN:=
    TAR:=tar
    PREP_TARGET:=Darwin
    ADDRESS_SIZE:=64
    BUILD_VICTOR:=true
    SPLD_CONF:=

    # The full-blown implementation of symbolic tracebacks is not
    # working on GNAT Pro at the moment, so
    # force local compilation of dummy GNAT.Traceback.Symbolic in
    # examiner/g-trasym.adb
    GNATMAKE_OPTS:=-a ${GNATMAKE_OPTS}
endif

# If SPARKCPUS is not explicitly set, default to 1.
ifeq (${SPARKCPUS},)
    SPARKCPUS:=1
endif

################################################################################
# TARGETS
################################################################################

all:

standardclean:
	rm -f *.o *.ali
	if [ -d vcg ]; then rm -f vcg/*.dic; fi

targetclean:
	rm -f ${OUTPUT_NAME}${EXE_EXTN}
	rm -f b~*.ad[sb]

vcclean:
	-find vcg -type f -name "*.vcg" -delete
	-find vcg -type f -name "*.fdl" -delete
	-find vcg -type f -name "*.rls" -delete
	-find vcg -type f -name "*.siv" -delete
	-find vcg -type f -name "*.slg" -delete
	-find vcg -type f -name "*.sli" -delete
	-find vcg -type f -name "*.lsb" -delete
	-find vcg -type f -name "*.log" -delete
	-find vcg -type f -name "*.dpc" -delete
	-find vcg -type f -name "*.sdp" -delete
	-find vcg -type f -name "*.zlg" -delete
	-find vcg -type f -name "*.zsl" -delete
	-find vcg -type f -name "*.vct" -delete
	-find vcg -type f -name "*.vlg" -delete
	-find vcg -type f -name "*.vsm" -delete
	rm -f vcg/*.rep vcg/mainunits95.xml
	-find vcg -depth -mindepth 1 -type d | grep -v -e '/\.svn' | xargs rmdir --ignore-fail-on-non-empty

################################################################################
# END-OF-FILE
