-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;
with LexTokenManager;
with STree;

use type STree.Iterator;

--# inherit CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         E_Strings,
--#         LexTokenManager,
--#         SPARK_IO,
--#         SP_Symbols,
--#         STree;

package Casing is

   --  If the relevant casing switch is enable, this procedure compare
   --  2 strings (STR and LEX_STR). The procedure raises a warning if
   --  the 2 strings have different casing.
   procedure Check_String_Casing
     (Str      : in E_Strings.T;
      Lex_Str  : in LexTokenManager.Lex_String;
      Position : in LexTokenManager.Token_Position);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Lex_Str,
   --#                                         Position,
   --#                                         SPARK_IO.File_Sys,
   --#                                         Str;

   --  If the relevant casing switch is enable, this procedure compare
   --  2 strings (LEX_STR1 and LEX_STR2). The procedure raises a
   --  warning if the 2 strings have different casing.
   procedure Check_Casing
     (Lex_Str1 : in LexTokenManager.Lex_String;
      Lex_Str2 : in LexTokenManager.Lex_String;
      Position : in LexTokenManager.Token_Position);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Lex_Str1,
   --#                                         Lex_Str2,
   --#                                         Position,
   --#                                         SPARK_IO.File_Sys;

   --  This procedure runs CHECK_CASING for all the identifiers in the
   --  subtree with the top node TOP_NODE.
   procedure Check_Node_Casing (Top_Node : in STree.SyntaxNode);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         Top_Node;

end Casing;
