-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function Get_Record_Component (The_Record_Type : RawDict.Type_Info_Ref;
                               Number          : Positive) return Symbol is
   Result : Symbol;

   --------------------------------------------------------------------------------

   function Get_Extended_Record_Component (The_Record_Type : RawDict.Type_Info_Ref;
                                           Number          : Positive) return Symbol
   --# global in Dict;
   is
      Component      : Iterator;
      Current_Record : RawDict.Type_Info_Ref;
      Low, High      : Positive;
   begin
      Current_Record := The_Record_Type;
      High           := Get_Number_Of_Extended_Components (The_Record_Type => Current_Record);
      loop
         Low := (High - Get_Number_Of_Actual_Components (The_Record_Type => Current_Record)) + 1;
         exit when Number in Low .. High; -- found which bit of the record model holds field

         -- move down Inherit chain
         Current_Record := Get_Type (The_Symbol => CurrentSymbol (First_Record_Component (Type_Mark => Current_Record)));
         High           := Low - 1;
      end loop;
      -- on exit, Current_Record indicates the record that holds field number is the
      -- range Low .. High
      Component := First_Record_Component (Type_Mark => Current_Record);
      -- if type is extended then the above returns the Inherit field which we don't
      -- want so we skip it thus:
      if Type_Is_Extended_Tagged (Type_Mark => Current_Record) then
         Component := NextSymbol (Component);
      end if;
      -- now loop through to find desired field
      for I in Positive range Low .. Number - 1 loop
         Component := NextSymbol (Component);
      end loop;
      return CurrentSymbol (Component);
   end Get_Extended_Record_Component;

begin -- Get_Record_Component
   if Type_Is_Extended_Tagged (Type_Mark => The_Record_Type) then
      Result := Get_Extended_Record_Component (The_Record_Type => The_Record_Type,
                                               Number          => Number);
   else
      Result := Get_Non_Extended_Record_Component (The_Record_Type => The_Record_Type,
                                                   Number          => Number);
   end if;
   return Result;
end Get_Record_Component;
