-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body SPARK.Ada.Strings.Maps is
   --# hide SPARK.Ada.Strings.Maps;

   function Character_Range_To_Set
     (Span : Character_Range) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps.To_Set
           (Span => Standard.Ada.Strings.Maps.Character_Range'
              (Low  => Span.Low,
               High => Span.High)));
   end Character_Range_To_Set;

   function Operator_Equal (Left, Right : Character_Set) return Boolean is
   begin
      return Standard.Ada.Strings.Maps."="
        (Left  => Standard.Ada.Strings.Maps.Character_Set (Left),
         Right => Standard.Ada.Strings.Maps.Character_Set (Right));
   end Operator_Equal;

   function Operator_Not (Right : Character_Set) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps."not"
           (Right => Standard.Ada.Strings.Maps.Character_Set (Right)));
   end Operator_Not;

   function Operator_And (Left, Right : Character_Set) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps."and"
           (Left  => Standard.Ada.Strings.Maps.Character_Set (Left),
            Right => Standard.Ada.Strings.Maps.Character_Set (Right)));
   end Operator_And;

   function Operator_Or (Left, Right : Character_Set) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps."or"
           (Left  => Standard.Ada.Strings.Maps.Character_Set (Left),
            Right => Standard.Ada.Strings.Maps.Character_Set (Right)));
   end Operator_Or;

   function Operator_Xor (Left, Right : Character_Set) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps."xor"
           (Left  => Standard.Ada.Strings.Maps.Character_Set (Left),
            Right => Standard.Ada.Strings.Maps.Character_Set (Right)));
   end Operator_Xor;

   function Operator_Minus
     (Left, Right : Character_Set) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps."-"
           (Left  => Standard.Ada.Strings.Maps.Character_Set (Left),
            Right => Standard.Ada.Strings.Maps.Character_Set (Right)));
   end Operator_Minus;

   function Is_In
     (Arg_Element : Character;
      Arg_Set     : Character_Set) return Boolean is
   begin
      return Standard.Ada.Strings.Maps.Is_In
        (Element => Arg_Element,
         Set     => Standard.Ada.Strings.Maps.Character_Set (Arg_Set));
   end Is_In;

   function Is_Subset
     (Elements : Character_Set;
      Arg_Set  : Character_Set) return Boolean is
   begin
      return Standard.Ada.Strings.Maps.Is_Subset
        (Elements => Standard.Ada.Strings.Maps.Character_Set (Elements),
         Set      => Standard.Ada.Strings.Maps.Character_Set (Arg_Set));
   end Is_Subset;

   function Character_Sequence_To_Set
     (Arg_Sequence : String) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps.To_Set (Sequence => Arg_Sequence));
   end Character_Sequence_To_Set;

   function Singleton_To_Set (Singleton : Character) return Character_Set is
   begin
      return Character_Set
        (Standard.Ada.Strings.Maps.To_Set (Singleton => Singleton));
   end Singleton_To_Set;

   function Value
     (Map         : Character_Mapping;
      Arg_Element : Character) return Character is
   begin
      return Standard.Ada.Strings.Maps.Value
        (Map     => Standard.Ada.Strings.Maps.Character_Mapping (Map),
         Element => Arg_Element);
   end Value;

   function To_Mapping
     (Arg_From, To : String) return Character_Mapping is
   begin
      return Character_Mapping
        (Standard.Ada.Strings.Maps.To_Mapping (To   => To,
                                               From => Arg_From));
   end To_Mapping;

end SPARK.Ada.Strings.Maps;
