-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Strings.Not_SPARK                                               --
--                                                                           --
-- Description                                                               --
--   This package provides the features of Ada.Strings which are not         --
--   compatible with SPARK. Please refer to the Ada LRM description of       --
--   Ada.Strings for usage information.                                      --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings;

package SPARK.Ada.Strings.Not_SPARK is

   pragma Warnings ("Y"); -- Turn off warnings for Ada 2005 features

   Wide_Space      : constant Wide_Character      := ' ';

   --  The following declaration is for Ada 2005 (AI-285)

   Wide_Wide_Space : constant Wide_Wide_Character := ' ';

   ------------------------------------------------
   -- Conversion functions from SPARK.Ada to Ada --
   ------------------------------------------------

   function To_Alignment
     (From : Alignment) return Standard.Ada.Strings.Alignment;
   function To_Truncation
     (From : Truncation) return Standard.Ada.Strings.Truncation;
   function To_Membership
     (From : Membership) return Standard.Ada.Strings.Membership;
   function To_Direction
     (From : Direction) return Standard.Ada.Strings.Direction;
   function To_Trim_End
     (From : Trim_End) return Standard.Ada.Strings.Trim_End;

end SPARK.Ada.Strings.Not_SPARK;
