-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Crypto.Debug                                                        --
--                                                                           --
-- Description                                                               --
--                                                                           --
-- Simple output facilities for the types declared in SPARK.Crypto           --
--                                                                           --
-- Language                                                                  --
--   Specification : SPARK                                                   --
--   Private Part  : N/A                                                     --
--   Body          : Ada                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   Depends on and uses Ada.Text_IO                                         --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   None                                                                    --
-------------------------------------------------------------------------------

with SPARK;
with SPARK.Crypto;
--# inherit SPARK,
--#         SPARK.Crypto,
--#         SPARK.Unsigned;
package SPARK.Crypto.Debug
is

   -- Prints Msg followed by Count Bytes from S to Standard_Output
   procedure Show_Msg_8 (Msg   : in String;
                         S     : in Crypto.Byte_Seq;
                         Count : in Natural);
   --# derives null from Msg, S, Count;
   --# pre S'First = 0 and
   --#     Count <= S'Length;

end SPARK.Crypto.Debug;
