-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         E_Strings,
--#         Heap,
--#         LexTokenManager,
--#         LexTokenManager.Relation_Algebra,
--#         LexTokenManager.Relation_Algebra.String,
--#         LexTokenManager.Seq_Algebra,
--#         RelationAlgebra,
--#         SeqAlgebra,
--#         SparkFormatCommandLineData,
--#         SparkLex,
--#         SPARK_IO,
--#         SP_Symbols,
--#         Statistics;

package SPARKProgram is

   procedure Reformat_Annotations (Input, Output : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     SparkFormatCommandLineData.Content;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#           out SparkLex.Curr_Line;
   --# derives ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         SPARK_IO.File_Sys,
   --#         Statistics.TableUsage      from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Input,
   --#                                         LexTokenManager.State,
   --#                                         Output,
   --#                                         SparkFormatCommandLineData.Content,
   --#                                         SPARK_IO.File_Sys &
   --#         SparkLex.Curr_Line         from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Input,
   --#                                         LexTokenManager.State,
   --#                                         Output,
   --#                                         SparkFormatCommandLineData.Content,
   --#                                         SPARK_IO.File_Sys;

   procedure Copy (Input, Output : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Input,
   --#                                Output;

end SPARKProgram;
