-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Text_IO;
with Sparklalr_Common;
with Sparklalr_Error;
with Sparklalr_Input;
with Sparklalr_Symbol;

--# inherit Command_Line_Options,
--#         SPARK.Ada.Command_Line,
--#         SPARK.Ada.Strings.Unbounded,
--#         SPARK.Ada.Text_IO,
--#         SPARK.Ada.Text_IO.Unbounded_String,
--#         Sparklalr_Char_Class,
--#         Sparklalr_Common,
--#         Sparklalr_Error,
--#         Sparklalr_Goto,
--#         Sparklalr_Input,
--#         Sparklalr_Level,
--#         Sparklalr_Memory,
--#         Sparklalr_Parser,
--#         Sparklalr_Symbol,
--#         SPARK_Ada_Integer_Text_IO,
--#         Symbols_Dump;

package Sparklalr_Memory.Dump
--# own State;
is

   Max_Sym : constant := 766; -- = TERM_LIM + NON_TERM_LIM

   subtype Contents_T is Integer range -Sparklalr_Common.Prod_Lim .. Max_Sym;

   Item_Table_Size   : constant := 20000;
   Memory_Table_Size : constant := 20000;

   subtype Pt_Item is Natural range 0 .. Item_Table_Size;
   subtype Pt_Memory is Natural range 0 .. Memory_Table_Size;

   Null_Pt_Memory : constant Pt_Memory;

   procedure Initialise;
   --# global in     Command_Line_Options.State;
   --#        in out SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#           out Sparklalr_Memory.Max_Right;
   --#           out Sparklalr_Memory.Prod_No;
   --#           out Sparklalr_Memory.Prod_Sum;
   --#           out Sparklalr_Memory.Stat_No;
   --#           out State;
   --# derives SPARK.Ada.Command_Line.State,
   --#         SPARK.Ada.Text_IO.The_Standard_Error,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Command_Line_Options.State &
   --#         Sparklalr_Memory.Max_Right,
   --#         Sparklalr_Memory.Prod_No,
   --#         Sparklalr_Memory.Prod_Sum,
   --#         Sparklalr_Memory.Stat_No              from  &
   --#         State                                 from Command_Line_Options.State;

   procedure Mem_Dump;
   --# global in     Command_Line_Options.State;
   --#        in     Sparklalr_Memory.Prod_No;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     State;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives SPARK.Ada.Command_Line.State,
   --#         SPARK.Ada.Text_IO.The_Standard_Error  from *,
   --#                                                    Command_Line_Options.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Memory.Stat_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Memory.Stat_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   function Prodstart (P : in Pt_Memory) return Pt_Memory;
   --# global in State;

   procedure Dump_Items (F    : in out SPARK.Ada.Text_IO.File_Type;
                         S, T : in     Pt_Memory);
   --# global in     State;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    S,
   --#                                                    State,
   --#                                                    Symbols_Dump.State,
   --#                                                    T;

   procedure Dump_Prdns (F : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     Sparklalr_Memory.Prod_No;
   --#        in     State;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   procedure Summary;
   --# global in     Sparklalr_Memory.Prod_No;
   --#        in     State;
   --#        in out Sparklalr_Memory.Prod_Sum;
   --#           out Sparklalr_Memory.Max_Right;
   --# derives Sparklalr_Memory.Max_Right,
   --#         Sparklalr_Memory.Prod_Sum  from Sparklalr_Memory.Prod_No,
   --#                                         Sparklalr_Memory.Prod_Sum,
   --#                                         State;

   procedure New_State (S      : in     Pt_Memory;
                        Result :    out Integer);
   --# global in     Sparklalr_Memory.Stat_No;
   --#        in out State;
   --# derives Result from S,
   --#                     Sparklalr_Memory.Stat_No,
   --#                     State &
   --#         State  from *,
   --#                     S;

   procedure Gen_Terminal_Like;
   --# global in     Symbols_Dump.State;
   --#        in out State;
   --# derives State from *,
   --#                    Symbols_Dump.State;

   procedure Findntredns (F : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     Command_Line_Options.State;
   --#        in     Sparklalr_Memory.Prod_No;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out State;
   --# derives F,
   --#         Sparklalr_Error.State,
   --#         State                                 from *,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Command_Line_Options.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   procedure Mem_Stats (Std_Out : in     Boolean;
                        F       : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    State,
   --#                                                    Std_Out;

   procedure Productions_Package_Out (F : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     Sparklalr_Memory.Max_Right;
   --#        in     Sparklalr_Memory.Prod_No;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     State;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F                                     from *,
   --#                                                    Sparklalr_Memory.Max_Right,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Memory.Stat_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   procedure Rhs_Process
     (F          : in out SPARK.Ada.Text_IO.File_Type;
      Symb       : in out Sparklalr_Symbol.Symbol;
      Gram_Rules : in     Boolean;
      Col        : in out Sparklalr_Error.Err_Col_T;
      Signpost   : in     Sparklalr_Input.Symbol_Set_Type);
   --# global in     Command_Line_Options.State;
   --#        in     Sparklalr_Char_Class.Charmap;
   --#        in out SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Input.State;
   --#        in out Sparklalr_Level.State;
   --#        in out Sparklalr_Memory.Prod_No;
   --#        in out State;
   --#        in out Symbols_Dump.State;
   --# derives Col,
   --#         F,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_Input.State                 from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Command_Line.State,
   --#         SPARK.Ada.Text_IO.The_Standard_Error,
   --#         Sparklalr_Memory.Prod_No              from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Output,
   --#         State                                 from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symb,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Level.State                 from *,
   --#                                                    Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Gram_Rules,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symb,
   --#                                                    Symbols_Dump.State &
   --#         Symb                                  from Col,
   --#                                                    Command_Line_Options.State,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         Symbols_Dump.State                    from *,
   --#                                                    Col,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Input.State;

   procedure Lhs_Process
     (F          : in out SPARK.Ada.Text_IO.File_Type;
      Gram_Rules : in     Boolean;
      Token      : in     Sparklalr_Common.Id_Name;
      Col        : in     Sparklalr_Error.Err_Col_T);
   --# global in     Command_Line_Options.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --#        in out Symbols_Dump.State;
   --# derives F,
   --#         State,
   --#         Symbols_Dump.State                    from *,
   --#                                                    Symbols_Dump.State,
   --#                                                    Token &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Command_Line_Options.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State,
   --#                                                    Token &
   --#         Sparklalr_Error.State                 from *,
   --#                                                    Col,
   --#                                                    State,
   --#                                                    Symbols_Dump.State,
   --#                                                    Token &
   --#         Sparklalr_Level.State                 from *,
   --#                                                    Gram_Rules,
   --#                                                    Symbols_Dump.State,
   --#                                                    Token;

   procedure State_Generation (F : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     Command_Line_Options.State;
   --#        in     Sparklalr_Memory.Prod_No;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Goto.State;
   --#        in out Sparklalr_Parser.State;
   --#        in out State;
   --#           out Sparklalr_Memory.Stat_No;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Command_Line_Options.State,
   --#                                                    Sparklalr_Goto.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Error.State,
   --#         Sparklalr_Goto.State,
   --#         Sparklalr_Parser.State,
   --#         State                                 from *,
   --#                                                    Sparklalr_Goto.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         Sparklalr_Memory.Stat_No              from Sparklalr_Goto.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    Sparklalr_Parser.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   -- Getter
   function Get_Next (Ptr : in Pt_Memory) return Pt_Memory;
   --# global in State;

   function Get_Contents (Ptr : in Pt_Memory) return Contents_T;
   --# global in State;

   function Get_Item (Ptr : in Pt_Memory) return Pt_Item;
   --# global in State;

   function Get_Mem_Pt (Ptr : in Pt_Memory) return Pt_Memory;
   --# global in State;

   function Get_Dot (Ptr : in Pt_Item) return Pt_Memory;
   --# global in State;

   function Get_Lh_Lset (Ptr : in Pt_Item;
                         I   : in Sparklalr_Common.Term_Range) return Boolean;
   --# global in State;

   function Get_Terminal_Like (S : in Sparklalr_Common.Sym_Range) return Boolean;
   --# global in State;

   function Get_State (S : in Sparklalr_Common.State_Range) return Pt_Memory;
   --# global in State;

   function Get_Ntrdn (I : in Sparklalr_Common.Non_Term_Range) return Pt_Memory;
   --# global in State;

private

   Null_Pt_Memory : constant Pt_Memory := 0;

end Sparklalr_Memory.Dump;
