-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings;

package RegularExpression is

   type Object is private;

   function Create (E_Str : E_Strings.T) return Object;
   --
   -- Creates a regular expression from E_Str.
   -- If E_Str does not represent a valid regular expression a null object is returned.

   ------------------------------------------------------
   -- Accessors
   ------------------------------------------------------

   function Is_Null (O : Object) return Boolean;

   function Matches (E_Str       : E_Strings.T;
                     The_Reg_Exp : Object) return Boolean;
   --
   -- Returns True is E_Str matches TheRegularExp

private

   type Object is record
      The_Reg_Exp : E_Strings.T;
      Is_Null_Exp : Boolean;
   end record;

   Null_Object : constant Object := Object'(The_Reg_Exp => E_Strings.Empty_String,
                                            Is_Null_Exp => True);

end RegularExpression;
