/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.HashMap;
import java.util.Map;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertiesCommandLineConverter
extends AbstractCommandLineConverter<Map<String, String>> {
    private static final String SYSTEM_PROP = "D";

    @Override
    public void configure(CommandLineParser parser) {
        parser.option(SYSTEM_PROP, "system-prop").hasArguments().hasDescription("Set system property of the JVM (e.g. -Dmyprop=myvalue).");
    }

    @Override
    protected Map<String, String> newInstance() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> convert(ParsedCommandLine options, Map<String, String> properties) throws CommandLineArgumentException {
        for (String keyValueExpression : options.option(SYSTEM_PROP).getValues()) {
            int pos = keyValueExpression.indexOf("=");
            if (pos < 0) {
                properties.put(keyValueExpression, "");
                continue;
            }
            properties.put(keyValueExpression.substring(0, pos), keyValueExpression.substring(pos + 1));
        }
        return properties;
    }
}

