/* sqlheavy-common-function.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-common-function.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>

#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
const gchar* sql_heavy_sqlite_errstr (gint ec);
GValue* sql_heavy_common_function_checksum (GChecksumType cs, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error);
GValue* sql_heavy_common_function_convert_blob (GConverter* converter, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error);
static guint8* _vala_array_dup1 (guint8* self, int length);


/**
     * Implementation of a REGEXP function using GRegex
     *
     * SQLite includes special support for a function named REGEXP,
     * which is left unimplemented by SQLite. This function provides a
     * basic implementation based on the regex support in GLib.
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     */
static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


GValue* sql_heavy_common_function_regex (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GRegex* regex;
	GValueArray* _tmp0_;
	GValue* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* str_expr;
	SQLHeavyUserFunctionContext* _tmp3_;
	const gchar* _tmp4_;
	GValue* _tmp5_ = NULL;
	GValue* _tmp6_;
	GValue* gv_expr;
	GValue* _tmp7_;
	GValueArray* _tmp21_;
	GValue* _tmp22_ = NULL;
	GValue* _tmp23_;
	GValue* arg;
	GValue* _tmp24_;
	GValue* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GRegex* _tmp30_;
	GValue* _tmp31_;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	GValue* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	regex = NULL;
	_tmp0_ = args;
	_tmp1_ = g_value_array_get_nth (_tmp0_, (guint) 0);
	_tmp2_ = g_value_get_string (_tmp1_);
	str_expr = _tmp2_;
	_tmp3_ = ctx;
	_tmp4_ = str_expr;
	_tmp5_ = sql_heavy_user_function_context_get_user_data (_tmp3_, _tmp4_);
	_tmp6_ = __g_value_dup0 (_tmp5_);
	gv_expr = _tmp6_;
	_tmp7_ = gv_expr;
	if (_tmp7_ == NULL) {
		SQLHeavyUserFunctionContext* _tmp14_;
		const gchar* _tmp15_;
		GRegex* _tmp16_;
		GValue _tmp17_ = {0};
		{
			const gchar* _tmp8_;
			GRegex* _tmp9_;
			GRegex* _tmp10_;
			_tmp8_ = str_expr;
			_tmp9_ = g_regex_new (_tmp8_, G_REGEX_OPTIMIZE | G_REGEX_DOLLAR_ENDONLY, 0, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch1_g_regex_error;
				}
				__vala_GValue_free0 (gv_expr);
				_g_regex_unref0 (regex);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_regex_unref0 (regex);
			regex = _tmp10_;
		}
		goto __finally1;
		__catch1_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			GError* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			_tmp13_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ERROR, "Unable to compile regular expression: %s", _tmp12_);
			_inner_error_ = _tmp13_;
			_g_error_free0 (e);
			goto __finally1;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_GValue_free0 (gv_expr);
				_g_regex_unref0 (regex);
				return NULL;
			} else {
				__vala_GValue_free0 (gv_expr);
				_g_regex_unref0 (regex);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp14_ = ctx;
		_tmp15_ = str_expr;
		_tmp16_ = regex;
		g_value_init (&_tmp17_, G_TYPE_REGEX);
		g_value_set_boxed (&_tmp17_, (GRegex*) _tmp16_);
		sql_heavy_user_function_context_set_user_data (_tmp14_, _tmp15_, &_tmp17_);
		G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	} else {
		GValue* _tmp18_;
		void* _tmp19_ = NULL;
		GRegex* _tmp20_;
		_tmp18_ = gv_expr;
		_tmp19_ = g_value_get_boxed (_tmp18_);
		_tmp20_ = _g_regex_ref0 ((GRegex*) _tmp19_);
		_g_regex_unref0 (regex);
		regex = _tmp20_;
	}
	_tmp21_ = args;
	_tmp22_ = g_value_array_get_nth (_tmp21_, (guint) 1);
	_tmp23_ = __g_value_dup0 (_tmp22_);
	arg = _tmp23_;
	_tmp24_ = arg;
	if (_tmp24_ == NULL) {
		GValue* _tmp25_ = NULL;
		_tmp25_ = g_new0 (GValue, 1);
		g_value_init (_tmp25_, G_TYPE_BOOLEAN);
		g_value_set_boolean (_tmp25_, FALSE);
		result = _tmp25_;
		__vala_GValue_free0 (arg);
		__vala_GValue_free0 (gv_expr);
		_g_regex_unref0 (regex);
		return result;
	}
	_tmp26_ = arg;
	_tmp27_ = G_VALUE_HOLDS (_tmp26_, G_TYPE_STRING);
	if (!_tmp27_) {
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_;
		_tmp28_ = sql_heavy_sqlite_errstr (SQLITE_MISMATCH);
		_tmp29_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp28_);
		_inner_error_ = _tmp29_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			__vala_GValue_free0 (arg);
			__vala_GValue_free0 (gv_expr);
			_g_regex_unref0 (regex);
			return NULL;
		} else {
			__vala_GValue_free0 (arg);
			__vala_GValue_free0 (gv_expr);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp30_ = regex;
	_tmp31_ = arg;
	_tmp32_ = g_value_get_string (_tmp31_);
	_tmp33_ = g_regex_match (_tmp30_, _tmp32_, 0, NULL);
	_tmp34_ = g_new0 (GValue, 1);
	g_value_init (_tmp34_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp34_, _tmp33_);
	result = _tmp34_;
	__vala_GValue_free0 (arg);
	__vala_GValue_free0 (gv_expr);
	_g_regex_unref0 (regex);
	return result;
}


GValue* sql_heavy_common_function_checksum (GChecksumType cs, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValueArray* _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue* _tmp2_;
	GValue* arg;
	GValue* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = args;
	_tmp1_ = g_value_array_get_nth (_tmp0_, (guint) 0);
	_tmp2_ = __g_value_dup0 (_tmp1_);
	arg = _tmp2_;
	_tmp3_ = arg;
	_tmp4_ = G_VALUE_HOLDS (_tmp3_, G_TYPE_STRING);
	if (_tmp4_) {
		GChecksumType _tmp5_;
		GValue* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GValue* _tmp9_ = NULL;
		_tmp5_ = cs;
		_tmp6_ = arg;
		_tmp7_ = g_value_get_string (_tmp6_);
		_tmp8_ = g_compute_checksum_for_string (_tmp5_, _tmp7_, (gsize) (-1));
		_tmp9_ = g_new0 (GValue, 1);
		g_value_init (_tmp9_, G_TYPE_STRING);
		g_value_take_string (_tmp9_, _tmp8_);
		result = _tmp9_;
		__vala_GValue_free0 (arg);
		return result;
	} else {
		GValue* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = arg;
		_tmp11_ = G_VALUE_HOLDS (_tmp10_, G_TYPE_BYTE_ARRAY);
		if (_tmp11_) {
			GChecksumType _tmp12_;
			GValue* _tmp13_;
			void* _tmp14_ = NULL;
			guint8* _tmp15_;
			gint _tmp15__length1;
			gchar* _tmp16_ = NULL;
			GValue* _tmp17_ = NULL;
			_tmp12_ = cs;
			_tmp13_ = arg;
			_tmp14_ = g_value_get_boxed (_tmp13_);
			_tmp15_ = ((GByteArray*) _tmp14_)->data;
			_tmp15__length1 = (gint) ((GByteArray*) _tmp14_)->len;
			_tmp16_ = g_compute_checksum_for_data (_tmp12_, _tmp15_, _tmp15__length1);
			_tmp17_ = g_new0 (GValue, 1);
			g_value_init (_tmp17_, G_TYPE_STRING);
			g_value_take_string (_tmp17_, _tmp16_);
			result = _tmp17_;
			__vala_GValue_free0 (arg);
			return result;
		} else {
			const gchar* _tmp18_ = NULL;
			GError* _tmp19_;
			_tmp18_ = sql_heavy_sqlite_errstr (SQLITE_MISMATCH);
			_tmp19_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp18_);
			_inner_error_ = _tmp19_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_GValue_free0 (arg);
				return NULL;
			} else {
				__vala_GValue_free0 (arg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	__vala_GValue_free0 (arg);
}


/**
     * Implementation of a MD5 function using GChecksum
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see sha1
     * @see sha256
     */
GValue* sql_heavy_common_function_md5 (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	SQLHeavyUserFunctionContext* _tmp0_;
	GValueArray* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = ctx;
	_tmp1_ = args;
	_tmp2_ = sql_heavy_common_function_checksum (G_CHECKSUM_MD5, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp3_;
	return result;
}


/**
     * Implementation of a SHA-1 function using GChecksum
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see sha256
     * @see md5
     */
GValue* sql_heavy_common_function_sha1 (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	SQLHeavyUserFunctionContext* _tmp0_;
	GValueArray* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = ctx;
	_tmp1_ = args;
	_tmp2_ = sql_heavy_common_function_checksum (G_CHECKSUM_SHA1, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp3_;
	return result;
}


/**
     * Implementation of a SHA-256 function using GChecksum
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see sha1
     * @see md5
     */
GValue* sql_heavy_common_function_sha256 (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	SQLHeavyUserFunctionContext* _tmp0_;
	GValueArray* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = ctx;
	_tmp1_ = args;
	_tmp2_ = sql_heavy_common_function_checksum (G_CHECKSUM_SHA256, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp3_;
	return result;
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


GValue* sql_heavy_common_function_convert_blob (GConverter* converter, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValueArray* _tmp0_;
	GValue* _tmp1_;
	gint _tmp1__length1;
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue arg;
	guint8* in_data = NULL;
	gint in_data_length1 = 0;
	gint _in_data_size_ = 0;
	gboolean _tmp4_ = FALSE;
	GByteArray* _tmp14_;
	GByteArray* res;
	gsize bytes_read = 0UL;
	gsize bytes_written = 0UL;
	guint8* _tmp15_ = NULL;
	guint8* outbuf;
	gint outbuf_length1;
	gint _outbuf_size_;
	gint in_offset;
	guint8* _tmp48_;
	gint _tmp48__length1;
	GValue* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (converter != NULL, NULL);
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = args;
	_tmp1_ = _tmp0_->values;
	_tmp1__length1 = (gint) _tmp0_->n_values;
	_tmp2_ = _tmp1_[0];
	if (G_IS_VALUE (&_tmp2_)) {
		g_value_init (&_tmp3_, G_VALUE_TYPE (&_tmp2_));
		g_value_copy (&_tmp2_, &_tmp3_);
	} else {
		_tmp3_ = _tmp2_;
	}
	arg = _tmp3_;
	_tmp4_ = G_VALUE_HOLDS (&arg, G_TYPE_STRING);
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		_tmp5_ = g_value_get_string (&arg);
		_tmp7_ = string_to_utf8 (_tmp5_, &_tmp6_);
		in_data = (g_free (in_data), NULL);
		in_data = (guint8*) _tmp7_;
		in_data_length1 = _tmp6_;
		_in_data_size_ = in_data_length1;
	} else {
		gboolean _tmp8_ = FALSE;
		_tmp8_ = G_VALUE_HOLDS (&arg, G_TYPE_BYTE_ARRAY);
		if (_tmp8_) {
			void* _tmp9_ = NULL;
			guint8* _tmp10_;
			gint _tmp10__length1;
			guint8* _tmp11_;
			gint _tmp11__length1;
			_tmp9_ = g_value_get_boxed (&arg);
			_tmp10_ = ((GByteArray*) _tmp9_)->data;
			_tmp10__length1 = (gint) ((GByteArray*) _tmp9_)->len;
			_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup1 (_tmp10_, _tmp10__length1) : ((gpointer) _tmp10_);
			_tmp11__length1 = _tmp10__length1;
			in_data = (g_free (in_data), NULL);
			in_data = _tmp11_;
			in_data_length1 = _tmp11__length1;
			_in_data_size_ = in_data_length1;
		} else {
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_;
			_tmp12_ = sql_heavy_sqlite_errstr (SQLITE_MISMATCH);
			_tmp13_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp12_);
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				return NULL;
			} else {
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp14_ = g_byte_array_new ();
	res = _tmp14_;
	_tmp15_ = g_new0 (guint8, 4096);
	outbuf = _tmp15_;
	outbuf_length1 = 4096;
	_outbuf_size_ = outbuf_length1;
	in_offset = 0;
	while (TRUE) {
		{
			gint _tmp16_;
			guint8* _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_ = 0;
			gint end;
			GConverterFlags _tmp19_ = 0;
			gint _tmp20_;
			guint8* _tmp21_;
			gint _tmp21__length1;
			GConverter* _tmp22_;
			guint8* _tmp23_;
			gint _tmp23__length1;
			gint _tmp24_;
			gint _tmp25_;
			guint8* _tmp26_;
			gint _tmp26__length1;
			GConverterFlags _tmp27_;
			gsize _tmp28_ = 0UL;
			gsize _tmp29_ = 0UL;
			GConverterResult _tmp30_ = 0;
			GConverterResult cr;
			gboolean _tmp31_ = FALSE;
			GConverterResult _tmp32_;
			gboolean _tmp34_;
			_tmp16_ = in_offset;
			_tmp17_ = in_data;
			_tmp17__length1 = in_data_length1;
			_tmp18_ = MIN (_tmp16_ + 256, _tmp17__length1);
			end = _tmp18_;
			_tmp20_ = end;
			_tmp21_ = in_data;
			_tmp21__length1 = in_data_length1;
			if (_tmp20_ >= _tmp21__length1) {
				_tmp19_ = G_CONVERTER_INPUT_AT_END;
			} else {
				_tmp19_ = G_CONVERTER_NO_FLAGS;
			}
			_tmp22_ = converter;
			_tmp23_ = in_data;
			_tmp23__length1 = in_data_length1;
			_tmp24_ = in_offset;
			_tmp25_ = end;
			_tmp26_ = outbuf;
			_tmp26__length1 = outbuf_length1;
			_tmp27_ = _tmp19_;
			_tmp30_ = g_converter_convert (_tmp22_, _tmp23_ + _tmp24_, (gsize) (_tmp25_ - _tmp24_), (void*) _tmp26_, (gsize) _tmp26__length1, _tmp27_, &_tmp28_, &_tmp29_, &_inner_error_);
			bytes_read = _tmp28_;
			bytes_written = _tmp29_;
			cr = _tmp30_;
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			_tmp32_ = cr;
			if (_tmp32_ == G_CONVERTER_CONVERTED) {
				_tmp31_ = TRUE;
			} else {
				GConverterResult _tmp33_;
				_tmp33_ = cr;
				_tmp31_ = _tmp33_ == G_CONVERTER_FINISHED;
			}
			_tmp34_ = _tmp31_;
			if (_tmp34_) {
				guint8* _tmp35_;
				gint _tmp35__length1;
				guint8* data;
				gint data_length1;
				gint _data_size_;
				gsize _tmp36_;
				gint _tmp37_;
				GByteArray* _tmp38_;
				guint8* _tmp39_;
				gint _tmp39__length1;
				GConverterResult _tmp40_;
				_tmp35_ = outbuf;
				_tmp35__length1 = outbuf_length1;
				data = _tmp35_;
				data_length1 = _tmp35__length1;
				_data_size_ = data_length1;
				_tmp36_ = bytes_written;
				data_length1 = (gint) _tmp36_;
				_tmp37_ = data_length1;
				_tmp38_ = res;
				_tmp39_ = data;
				_tmp39__length1 = data_length1;
				g_byte_array_append (_tmp38_, _tmp39_, _tmp39__length1);
				_tmp40_ = cr;
				if (_tmp40_ == G_CONVERTER_FINISHED) {
					break;
				} else {
					gint _tmp41_;
					gsize _tmp42_;
					_tmp41_ = in_offset;
					_tmp42_ = bytes_read;
					in_offset = _tmp41_ + ((gint) _tmp42_);
				}
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp43_;
			GError* _tmp46_;
			const gchar* _tmp47_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp43_ = e;
			if (g_error_matches (_tmp43_, G_IO_ERROR, G_IO_ERROR_PARTIAL_INPUT)) {
				guint8* _tmp44_;
				gint _tmp44__length1;
				gint _tmp45_ = 0;
				_tmp44_ = outbuf;
				_tmp44__length1 = outbuf_length1;
				_tmp45_ = _tmp44__length1 + 4096;
				outbuf = g_renew (guint8, outbuf, _tmp44__length1 + 4096);
				(_tmp45_ > outbuf_length1) ? memset (outbuf + outbuf_length1, 0, sizeof (guint8) * (_tmp45_ - outbuf_length1)) : NULL;
				outbuf_length1 = _tmp45_;
				_outbuf_size_ = _tmp45_;
			}
			_tmp46_ = e;
			_tmp47_ = _tmp46_->message;
			g_error ("sqlheavy-common-function.vala:138: %s", _tmp47_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				outbuf = (g_free (outbuf), NULL);
				_g_byte_array_unref0 (res);
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				return NULL;
			} else {
				outbuf = (g_free (outbuf), NULL);
				_g_byte_array_unref0 (res);
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp48_ = outbuf;
	_tmp48__length1 = outbuf_length1;
	g_free (_tmp48_);
	_tmp49_ = g_new0 (GValue, 1);
	g_value_init (_tmp49_, G_TYPE_BYTE_ARRAY);
	g_value_take_boxed (_tmp49_, res);
	result = _tmp49_;
	outbuf = (g_free (outbuf), NULL);
	in_data = (g_free (in_data), NULL);
	G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
	return result;
}


/**
     * Implementation of a ZLib COMPRESS function
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see decompress
     */
GValue* sql_heavy_common_function_compress (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GZlibCompressor* _tmp0_;
	GZlibCompressor* _tmp1_;
	SQLHeavyUserFunctionContext* _tmp2_;
	GValueArray* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	GValue* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = g_zlib_compressor_new (G_ZLIB_COMPRESSOR_FORMAT_RAW, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = ctx;
	_tmp3_ = args;
	_tmp4_ = sql_heavy_common_function_convert_blob ((GConverter*) _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp6_;
	return result;
}


/**
     * Implementation of a ZLib DECOMPRESS function
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see compress
     */
GValue* sql_heavy_common_function_decompress (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GZlibDecompressor* _tmp0_;
	GZlibDecompressor* _tmp1_;
	SQLHeavyUserFunctionContext* _tmp2_;
	GValueArray* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	GValue* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = g_zlib_decompressor_new (G_ZLIB_COMPRESSOR_FORMAT_RAW);
	_tmp1_ = _tmp0_;
	_tmp2_ = ctx;
	_tmp3_ = args;
	_tmp4_ = sql_heavy_common_function_convert_blob ((GConverter*) _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp6_;
	return result;
}



