/*
	SRG - Squid Report Generator
	Template class for an srg report, this class should be used
		as a base. IE. you should create a class that inherits from
		this one.
	Copyright 2005 University of Waikato

	This file is part of SRG.

	SRG is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	SRG is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with SRG; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef REPORT_H
#define REPORT_H

#include "srg.h"
#include <functional>

template <typename T>
struct LessByBytesTransferred: binary_function<T const *, T const *, bool>
{
	bool operator()(T *x, T *y) const
	{
		summary_info xstats = x->getStats();
		summary_info ystats = y->getStats();
		return less<unsigned long long>()(ystats.bytesTransferred, 
				xstats.bytesTransferred);
	}
};
template <typename T>
struct LessByBytesMissed: binary_function<T const *, T const *, bool>
{
	bool operator()(T *x, T *y) const
	{
		summary_info xstats = x->getStats();
		summary_info ystats = y->getStats();
		return less<unsigned long long>()(ystats.bytesMissed, 
				xstats.bytesMissed);
	}
};


class Report {
  
 public:
  
  Report(char * name);
  ~Report();

  void process_line(const log_line *line);
  summary_info getStats();
  void updateStats();
  char * getName();
  void generate_report(char *);
  bool create_files(const log_line *line);
  
 protected:
  
  void zeroStats();
 
  char * mName;
  summary_info stats;

};

#endif // REPORT_H
