use ui;
use core:geometry;
use graphics;

class TextWindow extends Frame {
	TextPainter p;

	init() {
		init("Text", Size(300, 400)) {}

		painter = p;

		create();
	}

	Bool onClick(Bool pressed, Point at, MouseButton button) {
		if (pressed) {
			if (button == MouseButton:right) {
				var iter = p.text.text.begin;
				p.text.color(iter, iter + 1, blue);
				repaint();
			} else {
				p.setFont(Font("Courier", 20));
			}
		}
		return true;
	}
}

class TextPainter extends Painter {
	Text text;
	Brush color;
	Brush hl;

	Brush[] bg;

	Text[] lines;
	Float[] baseline;

	Rect[] rects;

	init() {
		Font f("Arial", 25);
		Font f2("Arial", 20);
		f2.italic = true;
		f2.underline = true;
		// f2.weight = 700;

		init() {
			text = Text("ABÅÄあお☃😀!\n\tà̖\n👩‍💻\nLast line", f);
			color = SolidBrush(black);
			hl = SolidBrush(red);
		}

		{
			var iter = text.text.begin();
			text.color(iter + 3, iter + 6, green);
			text.color(iter + 2, iter + 4, red);

			text.underline(iter + 1, iter + 4);
			text.underline(iter, iter + 2);

			text.italic(iter, iter + 3);
		}

		bg << SolidBrush(green + white * 0.6);
		bg << SolidBrush(red + white * 0.6);
		bg << SolidBrush(blue + white * 0.6);
		bg << SolidBrush(yellow);

		for (l in text.lineInfo) {
			lines << Text(l.text, f2);
			baseline << l.baseline;
		}

		updateBoxes();
	}

	void setFont(Font f) {
		text = Text(text.text, f);

		updateBoxes();
		repaint();
	}

	void updateBoxes() {
		baseline.clear();
		for (l in text.lineInfo) {
			baseline << l.baseline;
		}

		var iter = text.text.begin();
		var end = text.text.end();
		rects.clear();

		while (iter != end) {
			var next = iter;
			next++;
			if (iter.v != Char(10)) {
				var bounds = text.boundsOf(iter, next);
				if (bounds.any)
					rects << bounds[0];
				else
					print("Empty bounds for ${iter.v}");
			}

			iter = next;
		}
	}

	Bool render(Size size, Graphics g) {
		Point offset(8, 8);
		Nat colorId = 0;
		for (r in rects) {
			g.fill(r + offset, bg[colorId]);
			if (++colorId == bg.count)
				colorId = 0;
		}

		for (b in baseline) {
			g.line(Point(0, offset.y + b), Point(size.w, offset.y + b), hl);
		}

		g.draw(text, color, offset);

		offset.y += text.size.h + 8;
		for (l in lines) {
			g.draw(l, color, offset);
			offset.y += l.size.h;
		}

		false;
	}
}

void text() {
	TextWindow window;
	window.waitForClose();
}
