use core;
use core:debug;

// Test some object cloning!

value CloneVal {
	Dbg z;

	init() {
		init() {
			z(8);
		}
	}
}

// Base class for cloning.
class CloneBase {
	Int a;
	Dbg b;
	CloneVal v;

	init() {
		init() {
			a = 2;
			b(3);
		}
	}

}

// Derived class for cloning.
class CloneDerived extends CloneBase {
	Int c;

	init() {
		init() {
			c = 4;
		}
	}

	init(CloneDerived o) {
		init(o) {
			c = o.c + 1;
		}
	}

	void deepCopy(CloneEnv e) {
		super:deepCopy(e);
		c++;
	}
}

Bool testClone() {
	CloneBase a;
	CloneBase c = clone(a);
	disjoint(a, c);
}

Bool testCloneDerived() {
	CloneDerived a;
	CloneDerived c = a.clone;
	disjoint(a, c) & (c.c == 6);
}

Bool testCloneValue() {
	CloneVal a;
	CloneVal b = a.clone;
	disjoint(a.z, b.z);
}

Int testCloneArray() {
	Dbg[] array = Dbg:[Dbg(1), Dbg(2), Dbg(3), Dbg(4)];
	Dbg[] c = array.clone;

	Int sum = 0;
	for (Nat i = 0; i < c.count; i++) {
		if (disjoint(array[i], c[i])) {
			sum = sum + c[i].get;
		}
	}
	sum;
}
