use core:lang;
use lang:bs;

class EffectDecl extends NamedDecl {
	Scope scope;
	SrcPos pos;
	Str name;
	SrcName result;
	NameParam[] params;

	init(Scope scope, SrcName result, SStr name, NameParam[] params) {
		init() {
			scope = scope;
			pos = name.pos;
			result = result;
			name = name.v;
			params = params;
		}
	}

	protected Named doCreate() : override {
		Scope fScope = fileScope(scope, pos);

		Value result = fScope.value(result);
		var params = params.resolve(fScope);

		return Effect(pos, name, result, params);
	}
}

class HandlerDecl extends NamedDecl {
	Scope scope;
	SrcPos pos;
	Str name;
	SrcName result;
	SrcName param;
	SHandlerBody body;

	init(Scope scope, SStr name, SrcName result, SrcName param, SHandlerBody body) {
		init() {
			scope = fileScope(scope, name.pos);
			pos = name.pos;
			name = name.v;
			result = result;
			param = param;
			body = body;
		}
	}

	protected Named doCreate() : override {
		return Handler(pos, scope, name, body, scope.value(result), scope.value(param));
	}
}
