use experimental:effects;
use experimental:templates;
use test;

effect choose()->Bool;
effect fail()->void;

template <T>
handler PickOne(T->Maybe<T>) {
	choose(), k {
		var first = k.call(true);
		if (first.empty)
			first = k.call(false);
		return first;
	}
	fail(), k {
		return null;
	}
	return x {
		return x;
	}
}

template <T>
handler PickAll(T->Array<T>) {
	choose(), k {
		Array<T> result = k.call(true);
		result.append(k.call(false));
		return result;
	}
	fail(), k {
		return [];
	}
	return x {
		return [x];
	}
}

Int choose(Int first, Int last) {
	if (first >= last) {
		fail();
		return 0; // NB. will not be executed.
	} else if (choose()) {
		return first;
	} else {
		return choose(first + 1, last);
	}
}

Nat choose(Nat first, Nat last) {
	if (first >= last) {
		fail();
		return 0; // NB. will not be executed.
	} else if (choose()) {
		return first;
	} else {
		return choose(first + 1, last);
	}
}

template <T>
T choose(Array<T> in) {
	// Note: No error handling necessary, choose will fail internally.
	return in[choose(0, in.count)];
}

suite Backtrack {
	var r = with PickAll<Array<Int>> handle {
		Int a = choose(1, 6);
		Int b = choose(1, 6);
		Int c = choose(1, 6);
		if (a*a + b*b != c*c)
			fail();
		[a, b, c];
	};
	print("Result: ${r}");
}
