/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// cppunit
#include <cppunit/TextTestRunner.h>
#include <cppunit/TestResult.h>
#include <cppunit/CompilerOutputter.h>
#ifdef _WIN32
#include "debugstream.h"
#endif // _WIN32

// gmock
#include <gmock/gmock.h>
using namespace testing;


// sc
#include "subcommander-test/RunningBookmarkTest.h"
#include "subcommander-test/CommandStartedFinishedTest.h"
#include "subcommander-test/PreserveSwitchStatusTest.h"
#include "subcommander-test/WcViewCmdProgressTest.h"
#include "subcommander-test/WcViewWithDeepChange.h"
#include "subcommander-test/WcViewSimilarFolderNames.h"
#include "subcommander-test/WcViewModelMoveTest.h"
#include "subcommander-test/TextStatusFilterTest.h"
#include "subcommander-test/ProjectItemTest.h"
#include "subcommander-test/ProjectSorterTest.h"
#include "subcommander-test/StatusCacheTest.h"
#include "subcommander-test/WcStatusInfoTest.h"
#include "subcommander-test/WcViewItemProxyModel/WcViewItemProxyModelTest.h"
#include "subcommander-test/settings/ProjectReaderTest.h"
#include "subcommander-test/settings/SingleProjectReaderTest.h"
#include "sublib-test/LayoutSettingsHandlerTest.h"
#include "sublib-test/PathSimplifierTest.h"
#include "util-test/Link.h"
#include "util/apr.h"


// qt
#include <QtGui/QApplication>

// sys
#include <stdio.h>


static int runGTest()
{
  return RUN_ALL_TESTS();
}

static int runCppUnit()
{
  CppUnit::TextTestRunner runner;

#ifdef _WIN32  
  dostream ostream;
  runner.setOutputter( new CppUnit::CompilerOutputter(&runner.result(),ostream) ); 
#endif // _WIN32

  // build test suite tree
  CppUnit::TestSuite* all = new CppUnit::TestSuite( "all" );
  {
    CppUnit::TestSuite* sc = new CppUnit::TestSuite( "sc" );
    all->addTest(sc);
    {
      sc->addTest( WcViewItemProxyModelTest::suite() );
      sc->addTest( WcViewSimilarFolderNames::suite() );
      sc->addTest( WcViewWithDeepChange::suite() );
      sc->addTest( WcViewModelMoveTest::suite() );
      sc->addTest( TextStatusFilterTest::suite() );
      sc->addTest( ProjectItemTest::suite() );
      sc->addTest( ProjectReaderTest::suite() );
      sc->addTest( SingleProjectReaderTest::suite() );
      sc->addTest( ProjectSorterTest::suite() );
      sc->addTest( StatusCacheTest::suite() );
      sc->addTest( WcStatusInfoTest::suite() );
    }

    CppUnit::TestSuite* bm = new CppUnit::TestSuite( "bookmark" );
    all->addTest(bm);
    {
      sc->addTest( RunningBookmarkTest::suite() );
    }

    CppUnit::TestSuite* cmd = new CppUnit::TestSuite( "command" );
    all->addTest(cmd);
    {
      sc->addTest( CommandStartedFinishedTest::suite() );
      sc->addTest( WcViewCmdProgressTest::suite() );
    }
    
    CppUnit::TestSuite* wcviewmodel = new CppUnit::TestSuite( "wcviewmodel" );
    all->addTest(wcviewmodel);
    {
      sc->addTest( PreserveSwitchStatusTest::suite() );
    }    

    CppUnit::TestSuite* settings = new CppUnit::TestSuite( "settings" );
    all->addTest(settings);
    {
      sc->addTest( LayoutSettingsHandlerTest::suite() );
    }    

    CppUnit::TestSuite* sublib = new CppUnit::TestSuite( "sublib" );
    all->addTest(sublib);
    {
      sc->addTest( PathSimplifierTest::suite() );
    }    
  }

  // all->findTest( "sc" )
  runner.addTest( all );

  return 
    runner.run() ? EXIT_SUCCESS : EXIT_FAILURE;
}


int testrunner( int argc, char* argv[] )
{
  // init
  apr::initialize(argc,argv);
  QApplication app(argc,argv);

  InitGoogleMock(&argc,argv);
  runGTest();

  runCppUnit();

  getc(stdin);

  return EXIT_SUCCESS;
}

LINK_TESTCASE (ASingleItemFolder);
LINK_TESTCASE (AnItemFinder);
LINK_TESTCASE (AddingARootItemToAModel);
LINK_TESTCASE (AddingABadItemToAModel);
LINK_TESTCASE (AddingItemsToAModel);
LINK_TESTCASE (AnEmptyModel);
LINK_TESTCASE (AnyModel);
