/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <vorbis/vorbisfile.h>

#include "ogg.hh"
#define _(str) str

bool TagOgg::extract_from_file(std::string const path, bool const ignore_standards_fields) {
	Tag::extract_from_file(path);
	OggVorbis_File vf;

	/* open the file/pipe on stdin */
	if (ov_fopen((char *) path.c_str(), &vf) != 0) {
		std::cerr << _("Could not open input as an OggVorbis file.") << std::endl;
		return false;
	}
  

	/* Read Vorbis Comment tag */	
	vorbis_comment *comment;
	
	comment = ov_comment(&vf, -1);
  	if (comment != NULL) { 
		std::string vector;
		for (int i = 0; i < comment->comments; i++) {
			add_vector(comment->user_comments[i], ignore_standards_fields);
		}
	}	
	else
		std::cerr << _("Could not read Vorbis Comment tag.") << std::endl;

	
	ov_clear(&vf);
	return (comment != NULL);
}
