C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       ***********************
                        SUBROUTINE LECMCL (NDIM)
C                       ***********************
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   LECTURE ET INTERPRETATION DU FICHIER syrthes.data       *
C              Lecture des mots-cles pour les options du calcul        *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! R  !                                             !
C   !/NLOFCT/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "syrth.h"
#include "regul.h"
C
C**********************************************************************
C
      INTEGER NDIM
C
      INTEGER I1,I2,II1,II2,LCH
      LOGICAL LVERIF,ERR
C
      CHARACTER*200 CHAINE,FORMA
      DOUBLE PRECISION XITER,XDT
      INTEGER NITER
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      LVERIF = .TRUE.
      ERR    = .FALSE.
C
C     Valeurs par defaut des parametres
C     ---------------------------------
C
      NDIM = 0
      NCTHFS = 3
      IAXISY = 0
      LGEOMS = .TRUE.
      LGEOMF = .FALSE.
      LRESUF = .FALSE.
      LCHROF = .FALSE.
      LHISOL = .FALSE.
      LSDEPL = .FALSE.
      LCLEXP = .FALSE.
      LSTOKC = .FALSE.
      LECCOR = .FALSE.
      LCFACE = .FALSE.
      LCOSTA = .FALSE.
      LRAY   = .FALSE.
      LTMAX  = .FALSE.
      LREGUL = .FALSE.
      LCOIN = .FALSE.
      NITMXS = 50
      NCHROS = -1
      NLISTS = -1
      NFREQS = 1
      NAXE   = 2
      ISOTRO = 1
      NBLBLA = 2
      NDPROP = 1
      NDFLUV = 1
      EPSGCS = 1.D-6
      NTSMAX = 0
      DTAUTO = -1.
      DTAUTM = 1000.
      NDTMUL = 0
      RDTTS  = 0.
      DCORMX = 1.e6
C
      TITSOL = 'THERMIQUE SOLIDE SYRTHES'
C
C
C     1- LECTURE DE LA CHAINE
C     =======================
C
      REWIND(NFCLCT)
C
C     Boucle de lecture....
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLCT,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) GOTO 10
C
C
C     =======================
C     0- VARIABLES CARACTERES
C     =======================
C
C     0.1- TITRE DU CALCUL (TITSOL) 
C     -----------------------------
      IF ( CHAINE(I1:I2).EQ. 
     *     'TITRE POUR LE CALCUL SOLIDE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            TITSOL = ' '
            TITSOL(1:LCH) = CHAINE(I1:I2)
C
C
C     0.2- CONDITIONS AUX LIMITES PAR NOEUD OU FACE (LCFACE) 
C     ------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'CONDITIONS LIMITES PAR NOEUD OU PAR FACE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'FACE') THEN
              LCFACE = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NOEUD') THEN
              LCFACE = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     0.4- DEFINITION DES FLUX VOLUMIQUES PAR (NDFLUV)
C     ------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *           'DEFINITION DES FLUX VOLUMIQUES PAR=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'NOEUD') THEN
              NDFLUV = 1
            ELSEIF (CHAINE(I1:I2) .EQ. 'ELEMENT') THEN
              NDFLUV = 2
            ELSEIF (CHAINE(I1:I2) .EQ. 'NOEUD PAR ELEMENT') THEN
              NDFLUV = 3
            ELSE
              GOTO 9999
            ENDIF
C
C     0.3- DEFINITION DES PROPRIETES PHYSIQUES PAR (NDPROP)
C     ------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *           'DEFINITION DES PROPRIETES PHYSIQUES PAR=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'NOEUD') THEN
              NDPROP = 1
            ELSEIF (CHAINE(I1:I2) .EQ. 'ELEMENT') THEN
              NDPROP = 2
            ELSEIF (CHAINE(I1:I2) .EQ. 'NOEUD PAR ELEMENT') THEN
              NDPROP = 3
            ELSE
              GOTO 9999
            ENDIF
C
C
C     =====================
C     1- VARIABLES LOGIQUES
C     =====================
C

C     1.2- MAILLAGE FLUIDE = SOLIDE (LGEOMS)
C     -----------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'ECRITURE MAILLAGE SOLIDE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LGEOMS = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LGEOMS = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.3- ECRITURE MAILLAGE PEAU FLUIDE (LGEOMF)       
C     -----------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'ECRITURE MAILLAGE PEAU FLUIDE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LGEOMF = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LGEOMF = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.4- ECRITURE RESULTATS PEAU FLUIDE (LRESUF)       
C     -----------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'ECRITURE RESULTATS PEAU FLUIDE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LRESUF = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LRESUF = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.5- ECRITURE CHRONO PEAU FLUIDE (LCHROF) 
C     ---------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'ECRITURE CHRONO PEAU FLUIDE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LCHROF = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LCHROF = .FALSE.
            ENDIF
C
C     1.6- HISTORIQUE SOLIDE (LHISOL) 
C     -------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'HISTORIQUES CONDUCTION=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LHISOL = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LHISOL = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.8- TRAITEMENT IMPLICITE DES TERMES D'ECHANGE (LCLEXP) 
C     -------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'TRAITEMENT IMPLICITE DES TERMES D ECHANGE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LCLEXP = .FALSE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LCLEXP = .TRUE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.9- SOLIDE EN TRANSLATION (LSDEPL) 
C     -----------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'SOLIDE EN TRANSLATION=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LSDEPL = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LSDEPL = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.10- STOCKAGE DES CORRESPONDANTS SUR FICHIER (LSTOKC) 
C     ------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'STOCKAGE DES CORRESPONDANTS SUR FICHIER=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LSTOKC = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LSTOKC = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.11- LECTURE DES CORRESPONDANTS SUR FICHIER (LECCOR) 
C     -----------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'LECTURE DES CORRESPONDANTS SUR FICHIER=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LECCOR = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LECCOR = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.12- APPROCHE COQUE - SIMULATION STATIONNAIRE (LCOSTA)
C     -------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'APPROCHE COQUE - SIMULATION STATIONNAIRE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LCOSTA = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LCOSTA = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.13- PRISE EN COMPTE DU RAYONNEMENT (LRAY)
C     ------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PRISE EN COMPTE DU RAYONNEMENT CONFINE=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LRAY = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LRAY = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.14- CHAMP DE TEMPERATURES MAXIMALES (LTMAX)
C     ------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'CHAMP DE TEMPERATURES MAXIMALES=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LTMAX = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LTMAX = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.15- ACTIVATION DU MODULE DE REGULATION (LREGUL)
C     ------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'ACTIVATION DU MODULE DE REGULATION=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LREGUL = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LREGUL = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.16- SUITE DE CALCUL (LSUISO)
C     -----------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 'SUITE DE CALCUL=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LSUISO = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LSUISO = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.17- CALCUL AXISYMETRIQUE 
C     --------------------------
      ELSE IF ( CHAINE(I1:I2).EQ.
     *     'AXE D AXISYMETRIE (AUCUN,OX,OY)=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'AUCUN') THEN
              IAXISY=0
            ELSEIF (CHAINE(I1:I2) .EQ. 'OX') THEN
              IAXISY=1
            ELSEIF (CHAINE(I1:I2) .EQ. 'OY') THEN
              IAXISY=2
            ELSE
              GOTO 9999
            ENDIF
C
C     =====================
C     2- VARIABLES ENTIERES
C     =====================
C
C
C     2.0- DIMENSION DU PROBLEME (NDIM) 
C     ---------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'DIMENSION DU PROBLEME=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NDIM
C
C     2.1- PAS DES SORTIES CHRONO SOLIDE (NCHROS)
C     -------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PAS DES SORTIES CHRONO SOLIDE=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NCHROS
C
C     2.2- PAS DES SORTIES LISTING SOLIDE (NLISTS) 
C     --------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PAS DES SORTIES LISTING SOLIDE=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NLISTS
C
C
C     2.3- NOMBRE ITERATIONS SOLVEUR SOLIDE (NITMXS) 
C     ------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'NOMBRE ITERATIONS SOLVEUR SOLIDE=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NITMXS
C
C     2.4- FREQUENCE DU CALCUL SOLIDE (NFREQS) 
C     ----------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'FREQUENCE DU CALCUL SOLIDE=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NFREQS
C
C     2.5- CONDUCTIVITE ISOTROPE, ORTHOTROPE OU ANISOTROPE (ISOTRO) 
C     -------------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'ISOTROPIE DU MATERIAU=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) ISOTRO
            IF (ISOTRO.LT.1 .OR. ISOTRO.GT.3) THEN
              WRITE(NFECRA,2600)
              ERR = .TRUE.
            ENDIF
C
C     2.6- NOMBRE DE PAS DE TEMPS SOLIDE (NTSMAX) 
C     ------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'NOMBRE DE PAS DE TEMPS SOLIDES=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NTSMAX
C
C     2.7- NOMBRE DE DIRECTIONS PERIODIQUES (NBDIPR) 
C     ----------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'NOMBRE DE DIRECTIONS PERIODIQUES=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NBDIPR
            IF (ISOTRO.LT.0 .OR. ISOTRO.GT.3) THEN
              WRITE(NFECRA,2800)
              ERR = .TRUE.
            ENDIF
C
C
C     2.8- NIVEAU DES IMPRESSIONS POUR LE SOLIDE (NBLBLA) 
C     ---------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'NIVEAU DES IMPRESSIONS POUR LE SOLIDE=') THEN
C
C           Recherche de la position de l'entier
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NBLBLA
            IF(NBLBLA .GT. 3) NBLBLA=NBLBLA-1000
            IF (NBLBLA.LT.0) THEN
              WRITE(NFECRA,2900)
              ERR = .TRUE.
            ENDIF
C
C
C     ====================
C     3- VARIABLES REELLES
C     ====================
C
C     3.1- PRECISION POUR LE SOLVEUR SOLIDE (EPSGCS) 
C     ------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PRECISION POUR LE SOLVEUR SOLIDE=') THEN
C
C           Recherche de la position du reel
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) EPSGCS
C
C     3.2- PAS DE TEMPS AUTOMATIQUE 
C     -----------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PAS DE TEMPS AUTOMATIQUE=') THEN
C
C           Recherche de la position du reel
            CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) DTAUTO,DTAUTM

C 
C     3.3- PAS DE TEMPS SOLIDE (RDTTS) 
C     --------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PAS DE TEMPS SOLIDE=') THEN
C
C           Recherche de la position du reel
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) RDTTS
C                
C     3.4- Pas de temps multiples
C     --------------------------
      ELSEIF (CHAINE(I1:I2) .EQ. 'PAS DE TEMPS MULTIPLES=') THEN  
         CALL POSREE(CHAINE(I2+2:),2,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('R',CHAINE(I1:I2),LCH,2,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) XITER,XDT
         NDTMUL=NDTMUL+1
         NITER=INT(XITER)
         IF (NDTMUL.GT.1) THEN
            IF (NITER.LE.IDTMUL(NDTMUL-1)) THEN
               WRITE(NFECRA,3400)
               ERR=.TRUE.
            ENDIF
         ENDIF
         IDTMUL(NDTMUL)=NITER
         XDTMUL(NDTMUL)=XDT
C     
C     3.5- Recherche optimisee des correspondants fluide/solide
C          Eloignement maxi des correspondnats (a priori)
C     --------------------------
      ELSEIF (CHAINE(I1:I2) .EQ. 
     * 'RECHERCHE OPTIMISEE DES CORRESPONDANTS - ELOIGNEMENT MAXI=') 
     *   THEN
C        Recherche de la position du reel
         CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('R',CHAINE(I1:I2),LCH,1,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) DCORMX

      ENDIF
      GOTO 10
C
 999  CONTINUE
C
C
C     ===================================================
C     4- GESTION DES OPTIONS PRIORITAIRES ET OBLIGATOIRES
C     ===================================================
C
C     4.1- "pas de temps solide"
C     --------------------------
      IF (ABS(RDTTS).LT.1.D-16 .AND. NDTMUL.EQ.0) THEN
        WRITE(NFECRA,4000)
        ERR = .TRUE.
      ENDIF
C
      IF (NDTMUL.GT.0) THEN
        IF (IDTMUL(NDTMUL).LT.NTSMAX) THEN
          WRITE(NFECRA,4050)
          ERR = .TRUE.
        ENDIF          
      ENDIF
C
C     4.4- "lecture-ecriture des correspondants"
C     -----------------------------------------
C     La lecture et l'ecriture ne sont pas permises simultanement
      IF (LSTOKC .AND. LECCOR) THEN
         WRITE(NFECRA,4400)
         LSTOKC = .FALSE.
         LECCOR = .FALSE.
      ENDIF
C
C     4.5- "Dimension du probeme
C     --------------------------
      IF (NDIM.NE.2 .AND. NDIM.NE.3) THEN
        WRITE(NFECRA,4500)
        ERR = .TRUE.
      ENDIF
C
C
C
C     STOP EN CAS D'ERREUR DE DONNEES
C     -------------------------------
      IF (ERR) STOP
C
C
C
      GOTO 500
C
C     =================================
C     5. GESTION DES ERREURS DE LECTURE
C     =================================
C
 9999 WRITE(NFECRA,5000) CHAINE
      STOP
C
  500 CONTINUE
C
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
 2600 FORMAT(/,' %% ERREUR LECMCL : MOT-CLE "ISOTROPIE DU MATERIAU"',/,
     &       '             Les valeurs possibles sont :',/,
     &       '               1 : materiau isotrope',/,
     &       '               2 : materiau orthotrope',/,
     &       '               3 : materiau anisotrope')
C
 2800 FORMAT(/,' %% ERREUR LECMCL : MOT-CLE "NOMBRE DE DIRECTIONS',
     &       ' PERIODIQUES"',/,
     &       '             Les valeurs possibles sont 0,1,2 ou 3')
 2900 FORMAT(/,' %% ERREUR LECMCL : MOT-CLE "NIVEAU DES IMPRESSIONS ',
     &       'POUR LE SOLIDE"',/,
     &       '             Les valeurs possibles sont 0,1,2 ou 3')
 3400 FORMAT(/,' %% ERREUR LECMCL : MOT-CLE "PAS DE TEMPS MULTIPLES"',/,
     &       '             Les numeros d''iterations doivent etre ',
     & 'donnes en ordre croissant.')
C
 4000 FORMAT(/,' %% ERREUR LECMCL : MOT-CLE "PAS DE TEMPS SOLIDE"',/,
     &       '             Le pas de temps ne peut etre nul !')
 4050 FORMAT(/,' %% ERREUR LECMCL : MOT-CLE ',
     &         '"PAS DE TEMPS MULTIPLES"',/,
     &  13X,'Le pas de temps multiple n''est pas defini',/, 
     &  13X,'jusqu''au nombre de pas de temps demande')
 4300 FORMAT(/,' %% ERREUR LECMCL : OPTIONS INCOMPATIBLES',/,
     & 20X,'En modele coque sans fourniture d''un maillage exterieur',/,
     & 20X,'le traitement des conditions aux limites par face n''est',
     &     ' pas autorise',/,
     &  20X,'Deux solutions s''offrent a vous :',/,
     &  20X,'   --> realiser un maillage surfacique de la coque',/,
     &  20X,'   --> traiter les conditions aux limites par noeud')
C
 4400 FORMAT(/,' $$ ATTENTION LECMCL : MOTS-CLES "STOCKAGE DES ',
     &       'CORRESPONDANTS SUR FICHIER"',/,
     &       '                             et "LECTURE DES ',
     &       'CORRESPONDANTS SUR FICHIER"',/,
     &       '    Ces 2 options ne peuvent etre activees ',
     &       'simultanement ',/,
     &       '    --> On recalcule les correspondants et ',
     &       'le calcul se poursuit de facon normale...')     
C
 4500 FORMAT(/,' %% ERREUR SYRMCL : MOT-CLE "DIMENSION DU PROBLEME"',/,
     &  13X,'L''initialisation de ce mot-cle est obligatoire',/,
     &  13X,'Les valeurs possibles sont :',/,
     &  13X,'  2 : Probleme bidimensionnel',/,
     &  13X,'  3 : Probleme tridimensionnel')
 5000 FORMAT(/,' %% ERREUR LECMCL : Erreur dans le fichier de donnees',
     * /,20X,'au cours de la lecture des mots-cles ',/,
     *   20X,'Ligne concernee : ',A)
c
C----
C FIN
C----
C
      RETURN
      END
