/****************************************************************************
**			TAU Portable Profiling Package			   **
**			http://www.cs.uoregon.edu/research/tau	           **
*****************************************************************************
**    Copyright 1997  						   	   **
**    Department of Computer and Information Science, University of Oregon **
**    Advanced Computing Laboratory, Los Alamos National Laboratory        **
****************************************************************************/
/***************************************************************************
**	File 		: SprocLayer.h				  **
**	Description 	: TAU Profiling Package Sproc Support Layer	  **
**	Author		: Sameer Shende					  **
**	Contact		: sameer@cs.uoregon.edu sameer@acl.lanl.gov 	  **
**	Flags		: Compile with				          **
**			  -DPROFILING_ON to enable profiling (ESSENTIAL)  **
**			  -DPROFILE_STATS for Std. Deviation of Excl Time **
**			  -DSGI_HW_COUNTERS for using SGI counters 	  **
**			  -DPROFILE_CALLS  for trace of each invocation   **
**			  -DSGI_TIMERS  for SGI fast nanosecs timer	  **
**			  -DTULIP_TIMERS for non-sgi Platform	 	  **
**			  -DPOOMA_STDSTL for using STD STL in POOMA src   **
**			  -DPOOMA_TFLOP for Intel Teraflop at SNL/NM 	  **
**			  -DPOOMA_KAI for KCC compiler 			  **
**			  -DDEBUG_PROF  for internal debugging messages   **
**                        -DPROFILE_CALLSTACK to enable callstack traces  **
**	Documentation	: See http://www.cs.uoregon.edu/research/tau      **
***************************************************************************/

#ifndef _SPROCLAYER_H_
#define _SPROCLAYER_H_

//////////////////////////////////////////////////////////////////////
//
// class SprocLayer
//
// This class is used for supporting pthreads in RtsLayer class.
//////////////////////////////////////////////////////////////////////

#ifdef TAU_SPROC
#include <ulocks.h>
class SprocLayer 
{ // Layer for RtsLayer to interact with pthreads 
  public:
 	
 	SprocLayer () { }  // defaults
	~SprocLayer () { } 

	static int RegisterThread(void); // called before any profiling code
        static int InitializeThreadData(void);     // init thread mutexes
        static int InitializeDBMutexData(void);     // init tauDB mutex
        static int InitializeEnvMutexData(void);     // init tauEnv mutex
	static int GetThreadId(void); 	 // gets 0..N-1 thread id
	static int LockDB(void);	 // locks the tauDBMutex
	static int UnLockDB(void);	 // unlocks the tauDBMutex
	static int LockEnv(void);	 // locks the tauEnvMutex
	static int UnLockEnv(void);	 // unlocks the tauEnvMutex

  private:
        static usptr_t * tauArena; // Shared memory arena /dev/zero on SGI
	static int 	 tauThreadCount;     // counter
	static usema_t * tauThreadCountMutex;  // to protect tauThreadCount
	static usema_t * tauDBMutex;  // to protect TheFunctionDB
	static usema_t * tauEnvMutex;  // second mutex
	
};
#endif // TAU_SPROC 

#endif // _SPROCLAYER_H_

	

/***************************************************************************
 * $RCSfile: SprocLayer.h,v $   $Author: amorris $
 * $Revision: 1.3 $   $Date: 2005/11/11 03:46:47 $
 * POOMA_VERSION_ID: $Id: SprocLayer.h,v 1.3 2005/11/11 03:46:47 amorris Exp $
 ***************************************************************************/


