## $Id: events.py,v 1.2 2003/09/07 21:40:15 riq Exp $
##
## Tenes Empanadas Graciela
##
## Copyright (C) 2000,2003 Ricardo Quesada
##
## Author: Ricardo Calixto Quesada <riq@coresecurity.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; only version 2 of the License
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.


#
# class Event based on sjbrown (http://sjbrown.ezide.com/writing-games.html)
#


class Event( object ):
    """this is a superclass for any events that might be generated by an
    object and sent to the EventManager"""
    def __init__(self):
        pass

class MouseMotionEvent( Event ):
    def __init__(self, pos = (0,0) ):
        self._pos = pos
        Event.__init__(self)

    def getPos( self ):
        return self._pos

    def setPos( self, pos ):
        self._pos = pos

class MouseButton( Event ):
    def __init__(self, buttons ):
        self._buttons = buttons
        Event.__init__(self)

    def getButtons(self):
        return self._buttons

class MouseButtonUp( MouseButton ):
    pass

class MouseButtonDown( MouseButton ):
    pass

class QuitEvent( Event ):
    def __init__(self):
        Event.__init__(self)
