package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenPhysicalConnectionService invokes the vpc.OpenPhysicalConnectionService API synchronously
func (client *Client) OpenPhysicalConnectionService(request *OpenPhysicalConnectionServiceRequest) (response *OpenPhysicalConnectionServiceResponse, err error) {
	response = CreateOpenPhysicalConnectionServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenPhysicalConnectionServiceWithChan invokes the vpc.OpenPhysicalConnectionService API asynchronously
func (client *Client) OpenPhysicalConnectionServiceWithChan(request *OpenPhysicalConnectionServiceRequest) (<-chan *OpenPhysicalConnectionServiceResponse, <-chan error) {
	responseChan := make(chan *OpenPhysicalConnectionServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenPhysicalConnectionService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenPhysicalConnectionServiceWithCallback invokes the vpc.OpenPhysicalConnectionService API asynchronously
func (client *Client) OpenPhysicalConnectionServiceWithCallback(request *OpenPhysicalConnectionServiceRequest, callback func(response *OpenPhysicalConnectionServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenPhysicalConnectionServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenPhysicalConnectionService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenPhysicalConnectionServiceRequest is the request struct for api OpenPhysicalConnectionService
type OpenPhysicalConnectionServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenPhysicalConnectionServiceResponse is the response struct for api OpenPhysicalConnectionService
type OpenPhysicalConnectionServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenPhysicalConnectionServiceRequest creates a request to invoke OpenPhysicalConnectionService API
func CreateOpenPhysicalConnectionServiceRequest() (request *OpenPhysicalConnectionServiceRequest) {
	request = &OpenPhysicalConnectionServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "OpenPhysicalConnectionService", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenPhysicalConnectionServiceResponse creates a response to parse from OpenPhysicalConnectionService response
func CreateOpenPhysicalConnectionServiceResponse() (response *OpenPhysicalConnectionServiceResponse) {
	response = &OpenPhysicalConnectionServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
