//
// Copyright 2018 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.20.0-devel
// 	protoc        v3.11.4
// source: proto/gnmi_ext/gnmi_ext.proto

// Package gnmi_ext defines a set of extensions messages which can be optionally
// included with the request and response messages of gNMI RPCs. A set of
// well-known extensions are defined within this file, along with a registry for
// extensions defined outside of this package.

package gnmi_ext

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// RegisteredExtension is an enumeration acting as a registry for extensions
// defined by external sources.
type ExtensionID int32

const (
	ExtensionID_EID_UNSET ExtensionID = 0
	// An experimental extension that may be used during prototyping of a new
	// extension.
	ExtensionID_EID_EXPERIMENTAL ExtensionID = 999
)

// Enum value maps for ExtensionID.
var (
	ExtensionID_name = map[int32]string{
		0:   "EID_UNSET",
		999: "EID_EXPERIMENTAL",
	}
	ExtensionID_value = map[string]int32{
		"EID_UNSET":        0,
		"EID_EXPERIMENTAL": 999,
	}
)

func (x ExtensionID) Enum() *ExtensionID {
	p := new(ExtensionID)
	*p = x
	return p
}

func (x ExtensionID) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExtensionID) Descriptor() protoreflect.EnumDescriptor {
	return file_proto_gnmi_ext_gnmi_ext_proto_enumTypes[0].Descriptor()
}

func (ExtensionID) Type() protoreflect.EnumType {
	return &file_proto_gnmi_ext_gnmi_ext_proto_enumTypes[0]
}

func (x ExtensionID) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExtensionID.Descriptor instead.
func (ExtensionID) EnumDescriptor() ([]byte, []int) {
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP(), []int{0}
}

// The Extension message contains a single gNMI extension.
type Extension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Ext:
	//	*Extension_RegisteredExt
	//	*Extension_MasterArbitration
	Ext isExtension_Ext `protobuf_oneof:"ext"`
}

func (x *Extension) Reset() {
	*x = Extension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Extension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Extension) ProtoMessage() {}

func (x *Extension) ProtoReflect() protoreflect.Message {
	mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Extension.ProtoReflect.Descriptor instead.
func (*Extension) Descriptor() ([]byte, []int) {
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP(), []int{0}
}

func (m *Extension) GetExt() isExtension_Ext {
	if m != nil {
		return m.Ext
	}
	return nil
}

func (x *Extension) GetRegisteredExt() *RegisteredExtension {
	if x, ok := x.GetExt().(*Extension_RegisteredExt); ok {
		return x.RegisteredExt
	}
	return nil
}

func (x *Extension) GetMasterArbitration() *MasterArbitration {
	if x, ok := x.GetExt().(*Extension_MasterArbitration); ok {
		return x.MasterArbitration
	}
	return nil
}

type isExtension_Ext interface {
	isExtension_Ext()
}

type Extension_RegisteredExt struct {
	RegisteredExt *RegisteredExtension `protobuf:"bytes,1,opt,name=registered_ext,json=registeredExt,proto3,oneof"` // A registered extension.
}

type Extension_MasterArbitration struct {
	// Well known extensions.
	MasterArbitration *MasterArbitration `protobuf:"bytes,2,opt,name=master_arbitration,json=masterArbitration,proto3,oneof"` // Master arbitration extension.
}

func (*Extension_RegisteredExt) isExtension_Ext() {}

func (*Extension_MasterArbitration) isExtension_Ext() {}

// The RegisteredExtension message defines an extension which is defined outside
// of this file.
type RegisteredExtension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id  ExtensionID `protobuf:"varint,1,opt,name=id,proto3,enum=gnmi_ext.ExtensionID" json:"id,omitempty"` // The unique ID assigned to this extension.
	Msg []byte      `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`                          // The binary-marshalled protobuf extension payload.
}

func (x *RegisteredExtension) Reset() {
	*x = RegisteredExtension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisteredExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisteredExtension) ProtoMessage() {}

func (x *RegisteredExtension) ProtoReflect() protoreflect.Message {
	mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisteredExtension.ProtoReflect.Descriptor instead.
func (*RegisteredExtension) Descriptor() ([]byte, []int) {
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP(), []int{1}
}

func (x *RegisteredExtension) GetId() ExtensionID {
	if x != nil {
		return x.Id
	}
	return ExtensionID_EID_UNSET
}

func (x *RegisteredExtension) GetMsg() []byte {
	if x != nil {
		return x.Msg
	}
	return nil
}

// MasterArbitration is used to select the master among multiple gNMI clients
// with the same Roles. The client with the largest election_id is honored as
// the master.
// The document about gNMI master arbitration can be found at
// https://github.com/openconfig/reference/blob/master/rpc/gnmi/gnmi-master-arbitration.md
type MasterArbitration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Role       *Role    `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	ElectionId *Uint128 `protobuf:"bytes,2,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
}

func (x *MasterArbitration) Reset() {
	*x = MasterArbitration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterArbitration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterArbitration) ProtoMessage() {}

func (x *MasterArbitration) ProtoReflect() protoreflect.Message {
	mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterArbitration.ProtoReflect.Descriptor instead.
func (*MasterArbitration) Descriptor() ([]byte, []int) {
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP(), []int{2}
}

func (x *MasterArbitration) GetRole() *Role {
	if x != nil {
		return x.Role
	}
	return nil
}

func (x *MasterArbitration) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

// Representation of unsigned 128-bit integer.
type Uint128 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	High uint64 `protobuf:"varint,1,opt,name=high,proto3" json:"high,omitempty"`
	Low  uint64 `protobuf:"varint,2,opt,name=low,proto3" json:"low,omitempty"`
}

func (x *Uint128) Reset() {
	*x = Uint128{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Uint128) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Uint128) ProtoMessage() {}

func (x *Uint128) ProtoReflect() protoreflect.Message {
	mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Uint128.ProtoReflect.Descriptor instead.
func (*Uint128) Descriptor() ([]byte, []int) {
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP(), []int{3}
}

func (x *Uint128) GetHigh() uint64 {
	if x != nil {
		return x.High
	}
	return 0
}

func (x *Uint128) GetLow() uint64 {
	if x != nil {
		return x.Low
	}
	return 0
}

// There can be one master for each role. The role is identified by its id.
type Role struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Role) Reset() {
	*x = Role{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Role) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Role) ProtoMessage() {}

func (x *Role) ProtoReflect() protoreflect.Message {
	mi := &file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Role.ProtoReflect.Descriptor instead.
func (*Role) Descriptor() ([]byte, []int) {
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP(), []int{4}
}

func (x *Role) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

var File_proto_gnmi_ext_gnmi_ext_proto protoreflect.FileDescriptor

var file_proto_gnmi_ext_gnmi_ext_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74,
	0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x08, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x22, 0xa8, 0x01, 0x0a, 0x09, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x45, 0x78, 0x74, 0x12,
	0x4c, 0x0a, 0x12, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x72, 0x62, 0x69, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6e,
	0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x72, 0x62,
	0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x05, 0x0a,
	0x03, 0x65, 0x78, 0x74, 0x22, 0x4e, 0x0a, 0x13, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65,
	0x78, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x03, 0x6d, 0x73, 0x67, 0x22, 0x6b, 0x0a, 0x11, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x72,
	0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65,
	0x78, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x32, 0x0a,
	0x0b, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x2e, 0x55, 0x69,
	0x6e, 0x74, 0x31, 0x32, 0x38, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0x2f, 0x0a, 0x07, 0x55, 0x69, 0x6e, 0x74, 0x31, 0x32, 0x38, 0x12, 0x12, 0x0a, 0x04,
	0x68, 0x69, 0x67, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68,
	0x12, 0x10, 0x0a, 0x03, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x6c,
	0x6f, 0x77, 0x22, 0x16, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x2a, 0x33, 0x0a, 0x0b, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x49, 0x44,
	0x5f, 0x55, 0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x10, 0x45, 0x49, 0x44, 0x5f,
	0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0xe7, 0x07, 0x42,
	0x2b, 0x5a, 0x29, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70,
	0x65, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6e, 0x6d, 0x69, 0x5f, 0x65, 0x78, 0x74, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_proto_gnmi_ext_gnmi_ext_proto_rawDescOnce sync.Once
	file_proto_gnmi_ext_gnmi_ext_proto_rawDescData = file_proto_gnmi_ext_gnmi_ext_proto_rawDesc
)

func file_proto_gnmi_ext_gnmi_ext_proto_rawDescGZIP() []byte {
	file_proto_gnmi_ext_gnmi_ext_proto_rawDescOnce.Do(func() {
		file_proto_gnmi_ext_gnmi_ext_proto_rawDescData = protoimpl.X.CompressGZIP(file_proto_gnmi_ext_gnmi_ext_proto_rawDescData)
	})
	return file_proto_gnmi_ext_gnmi_ext_proto_rawDescData
}

var file_proto_gnmi_ext_gnmi_ext_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_proto_gnmi_ext_gnmi_ext_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_proto_gnmi_ext_gnmi_ext_proto_goTypes = []interface{}{
	(ExtensionID)(0),            // 0: gnmi_ext.ExtensionID
	(*Extension)(nil),           // 1: gnmi_ext.Extension
	(*RegisteredExtension)(nil), // 2: gnmi_ext.RegisteredExtension
	(*MasterArbitration)(nil),   // 3: gnmi_ext.MasterArbitration
	(*Uint128)(nil),             // 4: gnmi_ext.Uint128
	(*Role)(nil),                // 5: gnmi_ext.Role
}
var file_proto_gnmi_ext_gnmi_ext_proto_depIdxs = []int32{
	2, // 0: gnmi_ext.Extension.registered_ext:type_name -> gnmi_ext.RegisteredExtension
	3, // 1: gnmi_ext.Extension.master_arbitration:type_name -> gnmi_ext.MasterArbitration
	0, // 2: gnmi_ext.RegisteredExtension.id:type_name -> gnmi_ext.ExtensionID
	5, // 3: gnmi_ext.MasterArbitration.role:type_name -> gnmi_ext.Role
	4, // 4: gnmi_ext.MasterArbitration.election_id:type_name -> gnmi_ext.Uint128
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_proto_gnmi_ext_gnmi_ext_proto_init() }
func file_proto_gnmi_ext_gnmi_ext_proto_init() {
	if File_proto_gnmi_ext_gnmi_ext_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Extension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisteredExtension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterArbitration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Uint128); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Role); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_proto_gnmi_ext_gnmi_ext_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Extension_RegisteredExt)(nil),
		(*Extension_MasterArbitration)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_proto_gnmi_ext_gnmi_ext_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_proto_gnmi_ext_gnmi_ext_proto_goTypes,
		DependencyIndexes: file_proto_gnmi_ext_gnmi_ext_proto_depIdxs,
		EnumInfos:         file_proto_gnmi_ext_gnmi_ext_proto_enumTypes,
		MessageInfos:      file_proto_gnmi_ext_gnmi_ext_proto_msgTypes,
	}.Build()
	File_proto_gnmi_ext_gnmi_ext_proto = out.File
	file_proto_gnmi_ext_gnmi_ext_proto_rawDesc = nil
	file_proto_gnmi_ext_gnmi_ext_proto_goTypes = nil
	file_proto_gnmi_ext_gnmi_ext_proto_depIdxs = nil
}
