/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.event;

import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;

public class PZoomEventHandler
extends PDragSequenceEventHandler {
    private static final double ZOOM_SENSITIVITY = 0.001;
    private double minScale = 0.0;
    private double maxScale = Double.MAX_VALUE;
    private Point2D viewZoomPoint;

    public PZoomEventHandler() {
        this.setEventFilter(new PInputEventFilter(4));
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double minScale) {
        this.minScale = minScale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double maxScale) {
        this.maxScale = maxScale;
    }

    protected void dragActivityFirstStep(PInputEvent event) {
        this.viewZoomPoint = event.getPosition();
        super.dragActivityFirstStep(event);
    }

    protected void dragActivityStep(PInputEvent event) {
        PCamera camera = event.getCamera();
        double dx = event.getCanvasPosition().getX() - this.getMousePressedCanvasPoint().getX();
        double scaleDelta = 1.0 + 0.001 * dx;
        double currentScale = camera.getViewScale();
        double newScale = currentScale * scaleDelta;
        if (newScale < this.minScale) {
            scaleDelta = this.minScale / currentScale;
        }
        if (this.maxScale > 0.0 && newScale > this.maxScale) {
            scaleDelta = this.maxScale / currentScale;
        }
        camera.scaleViewAboutPoint(scaleDelta, this.viewZoomPoint.getX(), this.viewZoomPoint.getY());
    }
}

