#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.thunar_uca"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[5062]; const double alignment; void * const ptr;}  thunar_uca_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\344\000\000\000\000\000\000\050\007\000\000\000"
  "\000\000\000\000\000\000\000\000\002\000\000\000\005\000\000\000"
  "\005\000\000\000\006\000\000\000\006\000\000\000\034\306\353\132"
  "\003\000\000\000\344\000\000\000\011\000\166\000\360\000\000\000"
  "\022\016\000\000\113\120\220\013\004\000\000\000\022\016\000\000"
  "\004\000\114\000\030\016\000\000\034\016\000\000\240\124\352\031"
  "\001\000\000\000\034\016\000\000\005\000\114\000\044\016\000\000"
  "\050\016\000\000\111\334\057\122\005\000\000\000\050\016\000\000"
  "\004\000\114\000\054\016\000\000\064\016\000\000\324\265\002\000"
  "\377\377\377\377\064\016\000\000\001\000\114\000\070\016\000\000"
  "\074\016\000\000\241\031\050\256\002\000\000\000\074\016\000\000"
  "\007\000\114\000\104\016\000\000\110\016\000\000\210\172\166\223"
  "\003\000\000\000\110\016\000\000\012\000\166\000\130\016\000\000"
  "\305\023\000\000\145\144\151\164\157\162\056\165\151\000\000\000"
  "\322\267\000\000\001\000\000\000\170\332\355\135\155\157\333\070"
  "\022\376\236\137\301\063\260\350\066\027\071\161\234\244\331\275"
  "\044\213\276\245\050\156\321\073\134\273\167\037\003\132\242\055"
  "\136\051\122\113\122\161\174\277\376\206\224\344\310\266\154\113"
  "\162\022\113\252\012\054\326\261\305\321\160\310\207\317\220\034"
  "\162\256\176\173\010\030\272\047\122\121\301\257\173\203\376\111"
  "\017\021\356\012\217\362\311\165\357\217\157\267\316\145\357\267"
  "\233\203\253\277\070\016\372\104\070\221\130\023\017\115\251\366"
  "\321\204\141\217\240\141\177\170\331\077\105\216\023\077\164\200"
  "\340\337\255\220\210\213\351\021\032\021\255\211\104\236\340\257"
  "\064\042\036\325\110\373\124\145\212\037\041\105\271\113\022\131"
  "\224\053\252\264\102\121\050\270\371\203\110\015\152\130\221\036"
  "\011\045\161\355\313\103\051\102\363\013\121\010\163\017\011\355"
  "\023\071\245\212\240\200\050\220\066\211\305\303\267\150\114\031"
  "\351\037\130\325\050\007\105\306\330\045\067\040\356\112\222\077"
  "\043\052\101\000\243\243\353\336\104\177\377\153\357\321\006\303"
  "\376\340\264\167\154\237\323\044\010\031\274\024\271\014\053\165"
  "\335\373\346\107\034\313\077\134\374\021\352\042\144\017\205\130"
  "\022\256\257\173\237\364\367\017\024\063\061\351\335\130\165\257"
  "\022\045\147\210\343\200\134\367\134\314\235\261\160\043\325\273"
  "\271\305\114\221\253\343\364\201\374\347\065\325\214\364\220\226"
  "\230\053\120\000\217\030\174\071\043\120\334\274\031\275\165\065"
  "\250\272\115\110\040\074\314\172\067\337\144\264\365\175\036\031"
  "\343\210\151\147\112\075\355\367\156\316\116\116\212\226\360\011"
  "\235\370\032\212\234\027\050\242\264\024\063\307\264\217\023\133"
  "\256\230\166\172\026\022\307\247\346\161\317\132\171\245\200\353"
  "\123\346\041\333\310\034\063\307\376\171\335\273\037\211\207\244"
  "\101\340\031\061\372\057\161\165\332\224\320\142\357\340\127\104"
  "\227\237\053\337\170\033\064\300\266\241\356\240\256\070\363\202"
  "\134\145\042\255\005\177\267\240\110\125\145\240\324\161\374\202"
  "\205\357\102\354\176\007\174\154\226\117\036\102\100\325\106\341"
  "\253\205\000\150\254\144\221\120\050\152\154\323\273\071\131\127"
  "\205\025\175\257\216\255\131\227\255\276\331\260\137\204\046\043"
  "\041\276\307\115\315\323\277\066\153\167\117\025\005\314\345\167"
  "\317\002\115\123\246\330\110\110\217\310\024\172\027\153\213\255"
  "\324\325\176\153\006\146\356\270\202\105\001\127\327\103\370\054"
  "\305\124\135\137\332\021\171\351\331\025\333\174\222\324\213\355"
  "\062\201\117\203\336\162\211\212\206\251\336\157\213\130\150\160"
  "\132\246\054\130\303\121\320\223\240\043\155\060\156\256\306\326"
  "\246\217\205\267\274\067\267\171\362\315\376\073\036\021\226\364"
  "\107\170\325\035\263\177\347\225\335\241\001\166\155\204\274\362"
  "\261\242\171\264\164\367\005\036\370\265\254\274\110\021\047\342"
  "\320\266\214\362\212\125\012\070\011\004\247\256\351\035\023\002"
  "\014\141\055\012\324\042\147\145\105\075\140\106\047\353\007\244"
  "\114\101\354\272\306\327\030\121\106\327\075\143\275\014\260\021"
  "\014\161\310\360\127\142\074\060\077\270\015\032\113\320\065\151"
  "\175\253\153\354\160\344\010\071\336\372\256\274\261\176\363\230"
  "\277\266\171\311\130\073\130\153\354\372\105\254\260\314\322\042"
  "\054\132\070\147\154\137\073\306\127\001\330\107\153\322\107\200"
  "\305\046\176\131\200\125\051\256\205\140\232\206\216\046\017\072"
  "\027\146\337\300\253\065\217\042\061\266\036\156\354\137\300\107"
  "\254\301\355\145\014\074\156\344\121\005\116\353\214\030\157\304"
  "\076\344\012\156\004\202\177\314\243\176\131\225\374\324\041\250"
  "\122\037\243\336\075\370\317\312\111\334\305\042\142\236\251\077"
  "\017\032\334\237\063\204\001\116\264\053\151\150\335\312\066\360"
  "\306\207\307\372\324\202\076\262\366\155\010\213\254\250\334\062"
  "\062\031\324\206\114\126\055\335\022\116\311\124\254\030\265\140"
  "\205\022\301\051\313\050\215\165\244\106\130\242\251\117\070\122"
  "\204\201\031\315\162\214\371\221\152\022\240\261\024\101\107\110"
  "\117\103\110\203\332\020\222\212\106\167\246\041\133\301\106\137"
  "\243\221\251\113\055\230\150\156\330\206\320\320\242\276\055\343"
  "\240\323\332\160\320\222\231\133\102\100\052\006\236\041\223\251"
  "\117\135\077\113\101\053\354\323\107\277\023\174\117\020\011\102"
  "\170\313\330\356\066\304\144\202\376\120\004\275\072\176\025\177"
  "\111\224\331\057\060\077\250\216\146\232\330\355\063\064\343\212"
  "\040\200\366\150\005\313\274\217\353\122\013\226\111\355\332\020"
  "\222\131\120\267\145\034\063\334\057\330\346\333\141\043\361\060"
  "\250\045\302\326\126\146\053\151\056\166\233\165\042\166\254\337"
  "\023\160\147\145\376\114\052\210\176\246\334\145\221\227\316\273"
  "\070\061\070\300\162\146\166\252\101\232\046\122\275\206\231\033"
  "\202\027\000\256\202\014\315\366\321\127\102\222\351\131\054\153"
  "\136\004\061\062\041\360\005\240\121\114\055\265\142\304\250\322"
  "\146\252\250\242\060\024\322\356\313\317\037\277\307\222\032\375"
  "\324\121\102\346\051\203\003\313\053\115\165\144\143\010\314\054"
  "\221\341\210\103\253\046\332\046\057\356\243\377\230\337\100\060"
  "\221\216\213\201\321\231\215\043\120\350\147\322\237\364\321\117"
  "\267\107\350\247\017\360\337\227\327\010\113\202\140\130\364\216"
  "\362\034\006\034\206\214\272\106\023\104\356\101\042\035\243\100"
  "\110\123\111\014\323\134\236\114\113\251\112\046\253\306\261\370"
  "\010\375\160\105\224\340\154\266\044\017\104\221\007\170\006\176"
  "\310\025\124\245\241\113\271\034\117\346\166\154\033\015\267\217"
  "\210\225\267\221\267\157\051\127\265\304\326\335\345\202\003\353"
  "\306\301\265\312\230\024\157\363\057\016\112\243\370\273\146\215"
  "\112\022\106\026\172\137\276\253\125\030\337\336\231\035\155\062"
  "\217\350\101\152\246\014\334\140\024\213\341\206\000\315\011\064"
  "\143\347\101\230\041\301\216\123\066\334\050\031\337\012\351\246"
  "\300\237\301\054\065\023\210\374\116\274\036\202\361\302\143\104"
  "\202\256\066\000\350\056\162\361\035\261\041\100\167\151\043\316"
  "\237\125\123\320\205\170\261\356\307\033\136\265\261\347\344\367"
  "\236\317\001\236\220\270\363\120\363\161\320\333\124\376\011\072"
  "\316\123\320\366\072\071\324\025\334\061\037\173\067\036\210\203"
  "\151\232\166\340\001\356\250\131\060\022\140\316\142\202\267\215"
  "\135\133\000\334\352\301\157\360\314\203\237\322\063\106\326\112"
  "\266\375\066\365\222\051\067\350\130\353\260\257\225\124\307\131"
  "\361\260\076\213\257\076\370\136\156\244\333\060\055\376\073\231"
  "\215\004\226\036\272\373\232\324\152\037\023\344\202\123\332\072"
  "\316\037\317\352\063\177\074\155\303\374\061\353\253\315\201\326"
  "\022\147\255\062\065\025\232\215\176\117\241\234\232\055\161\306"
  "\110\051\137\154\347\351\121\151\147\156\336\312\045\275\271\156"
  "\376\264\217\371\123\246\265\010\264\143\067\215\332\014\314\367"
  "\306\112\026\204\353\340\371\334\163\245\245\006\333\313\224\351"
  "\264\045\123\046\143\122\307\332\261\233\046\165\323\244\132\116"
  "\223\366\354\217\276\367\211\273\310\027\174\063\107\024\237\252"
  "\230\135\346\257\032\113\035\205\350\213\320\164\234\054\075\225"
  "\265\326\076\267\345\053\372\204\245\151\347\043\267\013\346\226"
  "\135\104\034\141\106\307\150\046\042\064\305\134\043\014\377\243"
  "\066\116\314\215\244\062\064\044\354\116\201\057\246\066\024\200"
  "\055\054\307\203\214\170\313\300\254\325\177\063\042\015\147\061"
  "\045\220\117\047\076\233\041\250\225\010\002\002\163\100\057\175"
  "\215\157\102\005\254\241\220\322\004\246\167\360\256\120\232\015"
  "\001\053\222\130\375\154\260\064\074\055\321\224\162\117\114\121"
  "\200\071\260\205\054\035\067\340\111\074\165\100\204\351\021\102"
  "\066\165\337\377\254\066\053\034\206\362\132\261\351\377\331\255"
  "\111\204\263\265\150\074\020\226\225\105\030\243\241\242\377\063"
  "\376\007\367\352\037\055\220\251\152\313\142\005\056\366\274\326"
  "\223\241\325\254\221\167\105\311\027\201\214\270\146\363\350\263"
  "\004\311\275\067\223\245\230\105\143\133\057\356\177\031\253\305"
  "\273\143\305\317\002\231\357\260\347\321\164\323\054\303\263\366"
  "\214\221\353\013\105\340\221\221\270\047\345\343\347\022\260\053"
  "\343\046\155\055\134\172\052\151\073\135\211\011\144\035\111\366"
  "\242\076\353\265\303\046\220\353\175\251\220\314\315\223\131\100"
  "\205\113\174\301\200\132\217\237\176\331\152\047\351\165\244\233"
  "\067\145\013\047\147\265\137\066\176\164\315\131\370\067\071\147"
  "\341\363\041\261\170\036\376\264\021\240\050\065\316\156\072\034"
  "\077\054\255\372\322\001\371\213\247\336\200\131\136\273\033\356"
  "\151\161\267\362\002\125\110\037\300\045\215\035\346\341\151\025"
  "\011\331\040\011\173\365\011\314\055\115\340\136\241\345\206\165"
  "\002\357\142\215\316\367\021\030\126\156\114\332\066\056\325\154"
  "\167\042\063\157\265\076\356\131\323\072\354\172\317\334\154\353"
  "\215\005\143\142\152\327\152\226\103\104\125\321\030\317\330\301"
  "\374\265\212\162\123\211\303\352\346\051\074\373\174\366\136\077"
  "\170\201\136\137\225\221\367\215\230\363\146\042\346\346\047\376"
  "\314\175\322\254\212\150\055\051\114\376\210\332\270\321\063\177"
  "\054\155\370\370\206\056\004\236\102\144\057\323\141\336\246\115"
  "\266\034\011\312\305\346\066\262\104\300\111\377\362\144\361\337"
  "\331\306\115\273\343\355\172\327\035\160\203\172\203\346\242\251"
  "\240\371\322\201\246\275\240\251\071\323\274\151\052\150\274\016"
  "\064\355\005\315\260\336\240\271\154\052\150\076\164\240\151\057"
  "\150\316\352\015\232\137\232\012\232\161\007\232\366\202\346\274"
  "\336\240\031\234\064\025\065\267\035\152\332\213\232\213\232\243"
  "\146\320\236\025\147\033\315\220\275\354\064\075\134\157\343\034"
  "\152\013\262\246\103\344\264\345\213\145\203\323\026\102\104\031"
  "\214\140\306\026\061\242\072\220\324\025\044\065\137\034\033\014"
  "\333\003\222\020\153\077\227\102\136\051\344\121\011\177\213\355"
  "\067\137\165\110\331\027\122\152\276\042\066\070\153\027\122\326"
  "\060\311\253\071\124\150\107\053\365\005\113\315\127\302\006\347"
  "\077\000\255\240\305\053\330\346\076\132\207\232\272\242\246\356"
  "\113\141\027\077\004\305\254\303\115\107\067\265\005\316\176\127"
  "\303\152\034\303\337\111\357\316\116\064\353\354\304\146\263\167"
  "\022\073\211\077\244\304\374\001\045\367\341\044\005\154\174\030"
  "\031\174\236\336\366\374\233\053\236\136\135\063\160\256\167\350"
  "\336\141\265\351\246\316\165\003\362\372\301\170\145\050\305\043"
  "\247\100\176\331\265\003\342\206\266\052\232\114\365\242\102\062"
  "\325\141\227\114\365\305\223\251\332\136\072\154\370\075\021\267"
  "\146\336\363\117\154\056\074\257\307\175\021\141\254\213\152\112"
  "\212\210\105\175\273\304\252\073\120\346\246\224\012\113\146\156"
  "\101\036\242\217\046\171\173\046\265\101\132\303\305\053\025\114"
  "\266\001\163\133\202\147\216\275\005\000\063\163\312\115\373\144"
  "\341\002\075\163\177\121\304\274\305\053\030\342\304\011\013\213"
  "\036\175\364\071\276\244\110\205\304\245\343\331\122\176\202\104"
  "\003\004\322\111\234\341\300\352\146\262\015\050\024\104\360\321"
  "\034\270\043\346\024\236\075\156\107\265\017\177\006\024\106\133"
  "\301\323\164\011\207\175\375\240\377\166\330\367\204\373\272\001"
  "\151\220\162\032\156\135\203\035\166\211\144\167\044\313\301\233"
  "\206\263\345\277\060\237\020\364\063\340\320\011\360\303\353\132"
  "\020\246\064\072\065\205\055\063\312\166\151\143\237\211\052\263"
  "\066\156\001\117\176\036\057\244\011\112\250\316\310\200\261\036"
  "\031\362\303\063\244\247\002\331\113\145\045\211\327\362\325\021"
  "\042\226\140\155\136\242\050\040\222\272\230\041\153\033\164\352"
  "\014\055\025\032\036\045\066\251\017\027\300\165\001\325\352\050"
  "\346\125\245\245\331\031\170\344\125\233\374\257\343\263\075\363"
  "\331\240\146\174\166\331\154\076\173\033\206\004\113\145\256\256"
  "\114\022\050\003\234\314\235\135\230\162\365\353\016\327\365\005"
  "\324\363\330\217\224\014\341\264\311\067\026\015\053\336\130\164"
  "\326\204\336\037\200\347\001\356\232\275\260\150\333\102\320\156"
  "\213\120\105\026\242\316\056\237\372\326\242\225\173\207\063\221"
  "\123\345\057\251\337\340\373\176\170\224\213\016\017\253\354\345"
  "\266\054\067\205\277\363\215\342\025\246\003\171\142\312\137\002"
  "\374\002\273\375\155\273\154\151\005\147\070\362\250\270\263\276"
  "\346\223\342\354\255\221\213\156\253\006\324\267\014\144\035\104"
  "\232\163\366\145\005\042\366\032\275\147\200\210\275\251\257\203"
  "\310\323\102\304\066\226\363\230\246\002\072\132\207\264\232\036"
  "\240\131\101\232\231\344\077\003\320\276\231\313\233\073\234\265"
  "\237\212\006\155\367\326\356\251\107\236\303\133\373\267\221\333"
  "\101\244\203\110\363\275\065\141\226\303\237\001\042\377\260\333"
  "\325\035\104\072\210\324\334\315\352\342\330\153\264\242\076\154"
  "\304\212\372\306\064\027\147\155\110\113\274\174\053\176\343\016"
  "\040\227\112\015\223\133\213\135\005\044\133\020\322\136\207\124"
  "\344\024\123\167\265\177\221\355\306\056\147\161\261\115\352\137"
  "\332\224\026\200\052\024\232\305\077\023\231\250\322\034\123\161"
  "\122\051\205\254\137\145\322\070\272\176\066\275\224\215\245\304"
  "\166\257\073\115\114\145\217\173\046\111\027\325\102\232\052\145"
  "\062\075\046\017\314\103\062\115\210\110\034\063\111\211\207\260"
  "\312\204\155\052\032\204\154\371\371\307\040\311\321\154\113\210"
  "\044\272\065\161\232\074\325\125\213\045\115\027\122\150\231\223"
  "\254\361\253\240\320\330\262\375\021\302\032\061\202\215\066\074"
  "\275\274\112\145\164\261\201\233\000\363\304\046\331\053\256\026"
  "\045\365\321\333\044\075\027\146\154\166\144\003\105\241\071\347"
  "\301\242\066\056\065\143\326\064\022\207\263\131\252\263\211\071"
  "\165\241\045\061\050\017\335\335\263\147\157\355\214\242\177\160"
  "\160\170\150\055\013\175\103\213\140\241\155\114\174\015\214\261"
  "\324\146\356\134\066\200\011\020\032\141\331\257\165\016\207\325"
  "\302\263\175\046\200\050\235\273\276\211\251\216\353\350\265\236"
  "\067\337\153\075\357\222\263\165\023\263\135\056\175\351\016\030"
  "\167\022\137\346\140\154\231\203\235\205\110\251\374\241\316\235"
  "\016\340\236\066\357\000\156\034\062\212\271\113\320\373\271\343"
  "\375\234\007\162\013\072\023\057\160\216\067\257\056\371\365\250"
  "\342\216\225\167\301\112\133\052\247\252\113\325\134\254\142\346"
  "\307\253\143\115\140\236\003\123\232\233\203\253\143\152\042\353"
  "\307\000\343\233\203\377\003\357\270\241\153\000\050\165\165\141"
  "\171\051\157\162\147\057\000\000\002\000\000\000\170\146\143\145"
  "\057\000\000\000\005\000\000\000\165\143\141\057\006\000\000\000"
  "\000\000\000\000\057\000\000\000\001\000\000\000\164\150\165\156"
  "\141\162\057\000\003\000\000\000\143\150\157\157\163\145\162\056"
  "\165\151\000\000\000\000\000\000\154\034\000\000\001\000\000\000"
  "\170\332\315\131\115\163\333\066\020\275\373\127\240\070\244\207"
  "\206\242\323\214\073\235\104\122\306\166\344\214\247\256\065\143"
  "\313\351\264\027\015\104\256\110\324\040\300\002\240\076\372\353"
  "\273\000\145\305\266\110\212\212\053\333\276\130\037\273\213\335"
  "\267\017\017\113\250\373\151\221\011\062\003\155\270\222\075\372"
  "\256\163\110\011\310\110\305\134\046\075\172\063\072\013\176\245"
  "\237\372\007\335\037\202\340\200\340\337\231\322\104\252\371\133"
  "\062\001\153\101\223\130\311\037\055\201\230\133\142\123\156\310"
  "\234\333\224\044\202\305\360\226\030\056\043\050\337\020\056\015"
  "\067\326\220\042\127\322\275\001\155\161\005\037\062\206\134\103"
  "\304\054\304\044\327\052\167\337\200\041\114\306\104\331\024\364"
  "\234\033\040\031\030\214\226\224\341\361\123\062\345\002\072\007"
  "\101\200\251\161\211\211\114\131\004\175\014\327\325\360\117\301"
  "\065\006\020\174\322\243\211\275\375\211\176\053\357\175\347\335"
  "\317\064\364\166\026\262\134\340\242\044\022\314\230\036\035\245"
  "\205\144\372\046\142\247\251\122\230\036\045\071\323\040\155\217"
  "\176\261\267\237\071\023\052\241\175\237\157\167\225\345\222\110"
  "\226\101\217\306\060\145\205\260\301\234\307\066\245\375\243\303"
  "\303\156\170\147\322\354\221\002\117\122\113\373\357\217\266\272"
  "\330\145\016\101\212\245\322\176\354\223\331\352\300\255\000\112"
  "\254\146\322\140\235\154\042\360\303\045\030\332\077\055\214\125"
  "\031\071\216\054\142\142\266\347\152\254\126\313\300\041\037\224"
  "\220\320\376\110\027\260\341\030\245\134\304\304\167\103\062\021"
  "\370\267\075\072\233\250\305\012\070\264\121\223\277\041\262\167"
  "\230\043\262\047\370\055\341\217\355\320\022\011\107\004\233\200"
  "\040\314\372\216\133\225\023\327\357\265\205\137\340\333\373\272"
  "\350\367\055\066\313\233\050\035\203\276\353\335\057\217\213\252"
  "\163\063\071\213\220\217\330\272\266\036\063\156\070\366\000\261"
  "\273\272\031\324\072\155\324\124\135\327\171\306\022\240\217\355"
  "\066\027\345\221\222\201\173\171\307\232\200\313\251\322\031\163"
  "\255\257\113\242\066\220\341\377\142\240\243\135\374\132\125\135"
  "\345\270\144\202\047\222\366\017\073\207\365\156\335\260\104\346"
  "\021\210\141\005\212\155\221\275\160\224\153\201\254\247\146\345"
  "\366\372\123\025\044\142\222\040\142\123\236\024\032\025\246\334"
  "\160\254\334\160\110\146\144\364\234\013\144\166\236\003\323\270"
  "\145\326\222\106\062\046\261\265\332\070\167\013\013\213\312\047"
  "\013\103\260\151\044\302\345\031\332\336\162\031\033\242\246\336"
  "\301\164\016\016\116\123\210\156\175\210\067\302\176\144\044\325"
  "\060\355\321\324\332\334\174\010\303\130\105\246\263\230\106\320"
  "\121\072\011\335\213\320\172\255\013\313\274\202\125\136\364\115"
  "\142\077\242\161\201\053\132\117\020\027\055\144\356\143\277\076"
  "\303\234\204\000\157\355\226\177\120\026\061\014\365\024\323\331"
  "\245\311\205\201\040\143\372\266\310\253\045\245\311\167\321\206"
  "\040\115\274\172\036\036\317\065\313\267\171\265\246\361\246\341"
  "\206\221\327\315\314\321\004\265\332\356\054\230\147\332\213\305"
  "\076\044\163\015\241\155\350\164\333\155\272\051\354\215\052\175"
  "\370\054\275\116\141\221\343\330\262\273\343\254\265\243\353\256"
  "\325\000\144\306\141\356\065\002\133\355\006\043\267\373\005\116"
  "\130\156\143\162\234\155\314\203\326\067\303\133\015\361\165\244"
  "\335\166\217\377\100\271\121\163\132\345\364\004\354\252\234\333"
  "\242\320\134\111\165\065\043\004\355\053\142\126\016\033\016\102"
  "\207\040\255\013\120\325\134\034\143\265\011\326\025\236\035\137"
  "\134\157\115\363\311\030\371\000\006\045\213\211\225\273\126\163"
  "\057\331\063\067\061\123\222\042\144\002\064\326\344\105\175\134"
  "\104\154\034\225\043\354\330\215\345\343\110\360\350\326\131\232"
  "\271\073\157\174\365\005\116\206\141\303\202\216\146\243\341\347"
  "\341\007\142\300\026\271\023\376\042\303\243\013\307\161\250\044"
  "\326\303\266\154\014\201\006\126\347\106\003\340\165\135\273\156"
  "\345\273\011\163\246\142\304\370\313\350\267\361\365\340\142\160"
  "\072\072\037\136\216\257\317\057\277\134\264\302\174\023\367\010"
  "\221\116\266\041\276\056\164\274\066\157\017\173\335\111\260\165"
  "\270\151\033\240\301\271\336\261\326\311\263\144\122\130\353\206"
  "\232\247\252\315\110\051\061\141\272\245\314\050\315\357\206\224"
  "\262\305\303\253\363\301\345\350\330\067\371\353\340\152\164\176"
  "\172\174\261\253\374\074\111\273\154\231\177\140\354\122\254\150"
  "\067\032\016\057\116\216\257\306\347\247\303\313\353\135\343\335"
  "\033\270\135\054\027\003\331\373\327\140\174\162\063\032\015\057"
  "\167\015\147\122\247\032\132\073\041\237\062\141\140\153\000\327"
  "\134\026\307\253\006\327\156\372\235\165\030\161\072\361\041\113"
  "\045\306\045\306\345\022\073\150\261\003\333\362\074\160\003\162"
  "\345\014\176\214\211\063\042\335\021\171\177\110\355\074\217\134"
  "\327\077\204\271\023\072\300\222\003\263\314\046\012\205\171\167"
  "\371\137\313\171\223\014\071\124\167\326\375\357\326\216\025\133"
  "\374\045\320\236\351\342\117\264\377\237\057\203\362\376\312\075"
  "\252\151\167\303\041\226\244\124\162\210\137\013\165\040\303\110"
  "\031\022\307\130\377\157\257\374\371\276\301\341\251\004\322\220"
  "\251\031\354\233\102\061\066\326\302\036\110\364\331\007\176\345"
  "\064\362\012\124\002\275\157\022\255\200\176\166\032\171\022\341"
  "\320\272\147\036\025\371\036\070\364\273\313\275\221\101\276\262"
  "\045\121\022\010\236\346\057\316\247\104\005\105\276\157\046\041"
  "\324\057\303\042\174\360\225\173\327\043\134\343\145\230\124\126"
  "\367\252\270\344\122\332\273\056\071\300\237\217\117\333\237\254"
  "\126\343\223\214\077\254\037\247\126\217\023\025\244\153\276\054"
  "\134\207\162\367\100\337\256\001\323\211\132\074\212\125\177\227"
  "\130\023\143\352\256\006\357\005\171\030\340\036\000\335\360\356"
  "\267\265\376\101\067\274\367\353\334\177\071\023\376\022\000\050"
  "\165\165\141\171\051" };

static GStaticResource static_resource = { thunar_uca_resource_data.data, sizeof (thunar_uca_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_MODULE_EXPORT
GResource *thunar_uca_get_resource (void);
GResource *thunar_uca_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(thunar_ucaresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(thunar_ucaresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(thunar_ucaresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(thunar_ucaresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void thunar_ucaresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void thunar_ucaresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
