#!/bin/bash

result=0

for in_file in test/test-graph-samples/*.in
do
	out_file="${in_file%.*}.out"
	diff_output=$(diff -C 1 "$out_file" <(cat $in_file | test/test-graph 2> /dev/null))
	if [ $? == 0 ]
	then
		echo "ok - Graph generated by $in_file matches $out_file"
	else
		echo "not ok - Graph generated by $in_file does not match $out_file"
		echo "$diff_output" | sed "s/^/# /"
		result=$(($result+1))
	fi
done

exit $result
