/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_GUI_ABOUT_HPP
#define INDII_GUI_ABOUT_HPP

#include "../reg/Components.hpp"

#include "wx/window.h"
#include "wx/dialog.h"
#include "wx/textctrl.h"
#include "wx/panel.h"

namespace indii {
/**
 * Show the about dialog.
 *
 * @param parent The parent window.
 */
void showAboutDialog(wxWindow* parent, const indii::Components::Component c);

/**
 * Registration dialog.
 */
class About : public wxDialog {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  About(wxWindow* parent, const indii::Components::Component c);

  /**
   * Register button event.
   */
  void OnButtonRegister(wxCommandEvent& evt);

  /**
   * Key text control set focus event.
   */
  void OnSetFocus(wxChildFocusEvent& evt);

  /**
   * Key text control kill focus event.
   */
  void OnKillFocus(wxFocusEvent& evt);

  /**
   * Activate button event.
   */
  void OnButtonActivate(wxCommandEvent& evt);

  /**
   * Facebook button event.
   */
  void OnButtonFacebook(wxCommandEvent& evt);
  
  /**
   * Flickr button event.
   */
  void OnButtonFlickr(wxCommandEvent& evt);

  /**
   * Twitter button event.
   */
  void OnButtonTwitter(wxCommandEvent& evt);

  /**
   * Instagram button event.
   */
  void OnButtonInstagram(wxCommandEvent& evt);

  /**
   * Close button event.
   */
  void OnButtonClose(wxCommandEvent& evt);
  
  /**
   * Close.
   */
  void OnClose(wxCloseEvent& evt);
  
private:
  /**
   * Registration panel.
   */
  wxPanel* pnlReg;
  
  /**
   * Key textbox.
   */
  wxTextCtrl* txtKey;
  
  /**
   * Register button.
   */
  wxButton* butRegister;
  
  /**
   * Activate button.
   */
  wxButton* butActivate;
  
  /**
   * Component.
   */
  Components::Component c;
  
  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_REGISTER = 987,
    ID_TXT_KEY,
    ID_BUT_ACTIVATE,
    ID_BUT_FACEBOOK,
    ID_BUT_FLICKR,
    ID_BUT_TWITTER,
    ID_BUT_INSTAGRAM
  };
  
  DECLARE_EVENT_TABLE()
};
}

#endif
