# $Id: negotiate.tcl 1385 2008-03-06 19:14:22Z sergei $

namespace eval negotiate {
    set ::NS(negotiate) http://jabber.org/protocol/feature-neg
    set seq 0
}

proc negotiate::get_handler {type connid from lang child} {
    variable handler

    debugmsg negotiate "$type: [list $from $child]"

    jlib::wrapper:splitxml $child tag vars isempty cdata children

    set error 1
    set fields {}
    foreach form $children {
	jlib::wrapper:splitxml $form tag1 vars1 isempty1 cdata1 children1
	if {$tag1 == "x" && \
		[jlib::wrapper:getattr $vars1 xmlns] == $::NS(data) && \
		[jlib::wrapper:getattr $vars1 type] == "submit"} {

		foreach field $children1 {
		    jlib::wrapper:splitxml $field \
			    tag2 vars2 isempty2 cdata2 children2

		    if {$tag2 != "field"} continue

		    set feature [jlib::wrapper:getattr $vars2 var]

		    if {![info exists handler($feature)]} continue

		    set error 0

		    # TODO
		    set opts [eval $handler($feature) \
				   [list $type $connid $from $lang $children2]]

		    lappend fields $opts
	    }
	}
    }
    if {$error} {
	return [list error cancel feature-not-implemented]
    } else {
	set res [jlib::wrapper:createtag feature \
		     -vars [list xmlns $::NS(negotiate)] \
		     -subtags [list [jlib::wrapper:createtag x \
					 -vars [list xmlns $::NS(data) \
						     type result] \
					 -subtags $fields]]]
	return [list result $res]
    }
}

iq::register_handler get feature $::NS(negotiate) \
		     [list [namespace current]::negotiate::get_handler get]
iq::register_handler set feature $::NS(negotiate) \
		     [list [namespace current]::negotiate::get_handler set]

proc negotiate::register_handler {feature h} {
    variable handler

    set handler($feature) $h
}

proc negotiate::send_request {connid to feature} {
    variable seq
    variable tmp

    set i [incr seq]

    set fieldtags {}
    if {$feature != ""} {
	lappend fieldtags [jlib::wrapper:createtag field \
			       -vars [list var $feature]]
    }

    jlib::send_iq get \
	[jlib::wrapper:createtag feature \
	     -vars [list xmlns $::NS(negotiate)] \
	     -subtags [list [jlib::wrapper:createtag x \
				 -vars [list xmlns $::NS(data) \
					     type  submit] \
				 -subtags $fieldtags]]] \
	-to $to \
	-command [list negotiate::recv_request_response $connid $to $i] \
	-connection $connid

    vwait [namespace current]::tmp($i)
    set res $tmp($i)
    unset tmp($i)
    return $res
}

proc negotiate::recv_request_response {connid jid seq res child} {
    variable tmp

    if {$res != "OK"} {
	set tmp($seq) [list $res $child]
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {$tag == "feature"} {
	jlib::wrapper:splitxml \
	    [lindex $children 0] tag1 vars1 isempty1 chdata1 children1

	data::draw_window $children1 \
	    [list [namespace current]::send_negotiation_form $connid $jid]
    }

    set tmp($seq) [list OK {}]
}

proc negotiate::send_negotiation_form {connid jid w restags} {
    catch { destroy $w.error.msg }
    $w.bbox itemconfigure 0 -state disabled

    jlib::send_iq set [jlib::wrapper:createtag feature \
			   -vars [list xmlns $::NS(negotiate)] \
			   -subtags [jlib::wrapper:createtag x \
					 -vars [list xmlns $::NS(data) \
						     type  submit] \
					 -subtags $restags]] \
	-to $jid \
	-connection $connid \
	-command [list data::test_error_res $w]
}

