/****************************************************************************
    Copyright (C) 1987-2015 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Last edit by hansen on Sun May  1 15:58:51 2005
****************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include "tkgate.h"

static short fontmetrics_Helvetica[];
static short fontmetrics_HelveticaBold[];
static short fontmetrics_HelveticaOblique[];
static short fontmetrics_HelveticaBoldOblique[];
static short fontmetrics_TimesRoman[];
static short fontmetrics_TimesBold[];
static short fontmetrics_TimesItalic[];
static short fontmetrics_TimesBoldItalic[];
static short fontmetrics_Symbol[];
short fontmetrics_Courier = 600;
short fontmetrics_Kanji = 1200;

char *psFontNameTable[FF_MAX][FP_MAX] = {
  {"Courier", "Courier-Bold", "Courier-Italic", "Courier-BoldItalic"},
  {"Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique"},
  {"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic"},
  {"Symbol", "Symbol", "Symbol", "Symbol"},
  {"Ryumin-Light-H", "Ryumin-Light-H", "Ryumin-Light-H", "Ryumin-Light-H"}
};


short *psFontWidthTable[FF_MAX][FP_MAX] = {
  {0,0,0,0},
  {fontmetrics_Helvetica,fontmetrics_HelveticaBold,fontmetrics_HelveticaOblique,fontmetrics_HelveticaBoldOblique},
  {fontmetrics_TimesRoman,fontmetrics_TimesBold,fontmetrics_TimesItalic,fontmetrics_TimesBoldItalic},
  {fontmetrics_Symbol,fontmetrics_Symbol,fontmetrics_Symbol,fontmetrics_Symbol},
  {0,0,0,0},
};

/*****************************************************************************/
/* Font Metric Data **********************************************************/
/*****************************************************************************/

static short fontmetrics_Helvetica[] = {
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 355, 556, 556, 889, 667, 221, 333, 333,
  389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556,
  556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667,
  611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667,
  611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 222, 556,
  556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556,
  556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334,
  584, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 333, 556, 556, 167, 556, 556, 556,
  556, 191, 333, 556, 333, 333, 500, 500, 278, 556, 556, 556, 278, 278,
  537, 350, 222, 333, 333, 556, 1000, 1000, 278, 611, 278, 333, 333,
  333, 333, 333, 333, 333, 333, 278, 333, 333, 278, 333, 333, 333, 1000,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 1000, 278, 370, 278, 278, 278, 278, 556, 778, 1000, 365,
  278, 278, 278, 278, 278, 889, 278, 278, 278, 278, 278, 278, 222, 611,
  944, 611, 278, 278, 278, 278,
};

static short fontmetrics_HelveticaBold[] = {
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 333, 474, 556, 556, 889, 722, 278, 333, 333, 389, 584, 278, 333, 278, 278,
  556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 584, 584, 584, 611,
  975, 722, 722, 722, 722, 667, 611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
  667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556,
  278, 556, 611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611,
  611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389, 584, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 333, 556, 556, 167, 556, 556, 556, 556, 238, 500, 556, 333, 333, 611, 611,
  278, 556, 556, 556, 278, 278, 556, 350, 278, 500, 500, 556,1000,1000, 278, 611,
  278, 333, 333, 333, 333, 333, 333, 333, 333, 278, 333, 333, 278, 333, 333, 333,
  1000,278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278,1000, 278, 370, 278, 278, 278, 278, 611, 778,1000, 365, 278, 278, 278, 278,
  278, 889, 278, 278, 278, 278, 278, 278, 278, 611, 944, 611, 278, 278, 278, 278,
};

static short fontmetrics_HelveticaOblique[] = {
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 355, 556, 556, 889, 667, 222, 333, 333,
  389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556,
  556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667,
  611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667,
  611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 222, 556,
  556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556,
  556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334,
  584, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 333, 556, 556, 167, 556, 556, 556,
  556, 191, 333, 556, 333, 333, 500, 500, 278, 556, 556, 556, 278, 278,
  537, 350, 222, 333, 333, 556, 1000, 1000, 278, 611, 278, 333, 333,
  333, 333, 333, 333, 333, 333, 278, 333, 333, 278, 333, 333, 333, 1000,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 1000, 278, 370, 278, 278, 278, 278, 556, 778, 1000, 365,
  278, 278, 278, 278, 278, 889, 278, 278, 278, 278, 278, 278, 222, 611,
  944, 611, 278, 278, 278, 278,
};

static short fontmetrics_HelveticaBoldOblique[] = {
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 333, 474, 556, 556, 889, 722, 278, 333, 333,
  389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556,
  556, 556, 333, 333, 584, 584, 584, 611, 975, 722, 722, 722, 722, 667,
  611, 778, 722, 278, 556, 722, 611, 833, 722, 778, 667, 778, 722, 667,
  611, 722, 667, 944, 667, 667, 611, 333, 278, 333, 584, 556, 278, 556,
  611, 556, 611, 556, 333, 611, 611, 278, 278, 556, 278, 889, 611, 611,
  611, 611, 389, 556, 333, 611, 556, 778, 556, 556, 500, 389, 280, 389,
  584, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 278, 278, 278, 278, 278, 333, 556, 556, 167, 556, 556, 556,
  556, 238, 500, 556, 333, 333, 611, 611, 278, 556, 556, 556, 278, 278,
  556, 350, 278, 500, 500, 556, 1000, 1000, 278, 611, 278, 333, 333,
  333, 333, 333, 333, 333, 333, 278, 333, 333, 278, 333, 333, 333, 1000,
  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
  278, 278, 1000, 278, 370, 278, 278, 278, 278, 611, 778, 1000, 365,
  278, 278, 278, 278, 278, 889, 278, 278, 278, 278, 278, 278, 278, 611,
  944, 611, 278, 278, 278, 278,
};

static short fontmetrics_TimesRoman[] = {
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 333, 408, 500, 500, 833, 778, 333, 333, 333,
  500, 564, 250, 333, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500,
  500, 500, 278, 278, 564, 564, 564, 444, 921, 722, 667, 667, 722, 611,
  556, 722, 722, 333, 389, 722, 611, 889, 722, 722, 556, 722, 667, 556,
  611, 722, 722, 944, 722, 722, 611, 333, 278, 333, 469, 500, 333, 444,
  500, 444, 500, 444, 333, 500, 500, 278, 278, 500, 278, 778, 500, 500,
  500, 500, 333, 389, 278, 500, 500, 722, 500, 500, 444, 480, 200, 480,
  541, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 333, 500, 500, 167, 500, 500, 500,
  500, 180, 444, 500, 333, 333, 556, 556, 250, 500, 500, 500, 250, 250,
  453, 350, 333, 444, 444, 500, 1000, 1000, 250, 444, 250, 333, 333,
  333, 333, 333, 333, 333, 333, 250, 333, 333, 250, 333, 333, 333, 1000,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 889, 250, 276, 250, 250, 250, 250, 611, 722, 889, 310, 250,
  250, 250, 250, 250, 667, 250, 250, 250, 278, 250, 250, 278, 500, 722,
  500, 250, 250, 250, 250,
};

static short fontmetrics_TimesBold[] = {
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 333, 555, 500, 500, 1000, 833, 333, 333, 333,
  500, 570, 250, 333, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500,
  500, 500, 333, 333, 570, 570, 570, 500, 930, 722, 667, 722, 722, 667,
  611, 778, 778, 389, 500, 778, 667, 944, 722, 778, 611, 778, 722, 556,
  667, 722, 722, 1000, 722, 722, 667, 333, 278, 333, 581, 500, 333, 500,
  556, 444, 556, 444, 333, 500, 556, 278, 333, 556, 278, 833, 556, 500,
  556, 556, 444, 389, 333, 556, 500, 722, 500, 500, 444, 394, 220, 394,
  520, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 333, 500, 500, 167, 500, 500, 500,
  500, 278, 500, 500, 333, 333, 556, 556, 250, 500, 500, 500, 250, 250,
  540, 350, 333, 500, 500, 500, 1000, 1000, 250, 500, 250, 333, 333,
  333, 333, 333, 333, 333, 333, 250, 333, 333, 250, 333, 333, 333, 1000,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 1000, 250, 300, 250, 250, 250, 250, 667, 778, 1000, 330,
  250, 250, 250, 250, 250, 722, 250, 250, 250, 278, 250, 250, 278, 500,
  722, 556, 250, 250, 250, 250,
};

static short fontmetrics_TimesItalic[] = {
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 333, 420, 500, 500, 833, 778, 333, 333, 333,
  500, 675, 250, 333, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500,
  500, 500, 333, 333, 675, 675, 675, 500, 920, 611, 611, 667, 722, 611,
  611, 722, 722, 333, 444, 667, 556, 833, 667, 722, 611, 722, 611, 500,
  556, 722, 611, 833, 611, 556, 556, 389, 278, 389, 422, 500, 333, 500,
  500, 444, 500, 444, 278, 500, 500, 278, 278, 444, 278, 722, 500, 500,
  500, 500, 389, 389, 278, 500, 444, 667, 444, 444, 389, 400, 275, 400,
  541, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 389, 500, 500, 167, 500, 500, 500,
  500, 214, 556, 500, 333, 333, 500, 500, 250, 500, 500, 500, 250, 250,
  523, 350, 333, 556, 556, 500, 889, 1000, 250, 500, 250, 333, 333, 333,
  333, 333, 333, 333, 333, 250, 333, 333, 250, 333, 333, 333, 889, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 889, 250, 276, 250, 250, 250, 250, 556, 722, 944, 310, 250, 250,
  250, 250, 250, 667, 250, 250, 250, 278, 250, 250, 278, 500, 667, 500,
  250, 250, 250, 250,
};

static short fontmetrics_TimesBoldItalic[] = {
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 389, 555, 500, 500, 833, 778, 333, 333, 333,
  500, 570, 250, 333, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500,
  500, 500, 333, 333, 570, 570, 570, 500, 832, 667, 667, 667, 722, 667,
  667, 722, 778, 389, 500, 667, 611, 889, 722, 722, 611, 722, 667, 556,
  611, 722, 667, 889, 667, 611, 611, 333, 278, 333, 570, 500, 333, 500,
  500, 444, 500, 444, 333, 500, 556, 278, 278, 500, 278, 778, 556, 500,
  500, 500, 389, 389, 278, 556, 444, 667, 500, 444, 389, 348, 220, 348,
  570, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 389, 500, 500, 167, 500, 500, 500,
  500, 278, 500, 500, 333, 333, 556, 556, 250, 500, 500, 500, 250, 250,
  500, 350, 333, 500, 500, 500, 1000, 1000, 250, 500, 250, 333, 333,
  333, 333, 333, 333, 333, 333, 250, 333, 333, 250, 333, 333, 333, 1000,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 944, 250, 266, 250, 250, 250, 250, 611, 722, 944, 300, 250,
  250, 250, 250, 250, 722, 250, 250, 250, 278, 250, 250, 278, 500, 722,
  500, 250, 250, 250, 250,
};

static short fontmetrics_Symbol[] = {
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 333, 713, 500, 549, 833, 778, 439, 333, 333,
  500, 549, 250, 549, 250, 278, 500, 500, 500, 500, 500, 500, 500, 500,
  500, 500, 278, 278, 549, 549, 549, 444, 549, 722, 667, 722, 612, 611,
  763, 603, 722, 333, 631, 722, 686, 889, 722, 722, 768, 741, 556, 592,
  611, 690, 439, 768, 645, 795, 611, 333, 863, 333, 658, 500, 500, 631,
  549, 549, 494, 439, 521, 411, 603, 329, 603, 549, 549, 576, 521, 549,
  549, 521, 549, 603, 439, 576, 713, 686, 493, 686, 494, 480, 200, 480,
  549, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250,
  250, 250, 250, 250, 250, 250, 762, 620, 247, 549, 167, 713, 500, 753,
  753, 753, 753, 1042, 987, 603, 987, 603, 400, 549, 411, 549, 549, 713,
  494, 460, 549, 549, 549, 549, 1000, 603, 1000, 658, 823, 686, 795,
  987, 768, 768, 823, 768, 768, 713, 713, 713, 713, 713, 713, 713, 768,
  713, 790, 790, 890, 823, 549, 250, 713, 603, 603, 1042, 987, 603, 987,
  603, 494, 329, 790, 790, 786, 713, 384, 384, 384, 384, 384, 384, 494,
  494, 494, 494, 250, 329, 274, 686, 686, 686, 384, 384, 384, 384, 384,
  384, 494, 494, 494, 250,
};

