+++
title = "features"
type  = "docs"
weight = 2
bookCollapseSection = true
+++

# features

ここでは、toml11が提供する主な機能について、例を挙げながら説明します。

## [ファイル・文字列をパースする](parsing_files)

ファイルや文字列をパースする関数と、それが出力するエラーの扱い方について説明します。

以下の内容を含みます。

- ファイルをパースする
- 文字列をパースする
- バイト列をパースする
- 例外を投げずにファイルをパースする
- 例外を投げずに文字列をパースする
- 例外を投げずにバイト列をパースする

## [`toml::value`から値を取り出す](value)

`toml::value`が持つデータの型を調べ、取り出す方法、型変換を行う方法について説明します。

以下の内容を含みます。

- メンバ関数を使って値の型を調べる
- メンバ関数を使って値にアクセスする
- コメントにアクセスする
- インラインテーブル・ドットキーの取り扱い
- 日付情報の取り扱い
- `toml::get<T>`を使って変換する
- `toml::get_or`を使って失敗時の値を指定する
- `toml::find<T>`を使って検索と変換を行う
- `toml::find_or`を使って失敗時の値を指定する
- ユーザー定義型との変換を定義する
- `toml::visit`で関数を適用する
- `toml::value`を構築する

## [エラーメッセージを作る](error_message)

`toml::value`の値を使って、TOMLファイル中の位置情報つきのエラーメッセージを生成する方法について説明します。

以下の内容を含みます。

- `toml::value` の位置情報を取り出す
- エラーメッセージを構築する
- 出力に色を付ける

## [TOMLファイルを出力する](serialize)

`toml::value`の値をフォーマットする方法と、可能なフォーマット指定について説明します。

以下の内容を含みます。

- `toml::value`の値ごとにフォーマットを指定する
- `toml::value`をフォーマットして文字列化する

## [`toml::value`の型を変更する](configure_types)

`toml::value`が格納する型（`integer_type`や`table_type`をカスタマイズする方法について説明します。

以下の内容を含みます。

- `type_config`の定義
- `ordered_type_config`を使用する
- コメントを保存しないようにする
- `std::deque`などの異なるコンテナを使用する
- `boost::multiprecision`などの異なる数値型を使用する

## [TOMLリテラル](literal)

C++内にTOMLファイルを埋め込むための`_toml`リテラルについて説明します。

以下の内容を含みます。

- TOMLリテラルを使用する

## [TOML言語バージョン](toml_spec)

toml11がサポートするTOML言語のバージョン、主にTOML-v1.1.0で追加された言語機能を制御する方法について説明します。

以下の内容を含みます。

- TOML言語の1.1.0を使用する
- TOML言語の1.1.0の一部の機能のみ使用する

## [TOML言語拡張](extension)

toml11独自のTOML言語拡張について説明します。

以下の内容を含みます。

- `null` をサポートする
- 浮動小数点数の16進数フォーマットをサポートする
- 数値に単位を付けられるようにする

