#include <iostream>
#include <ctype.h>

#include "Symmetry.hh"
#include "PointConfiguration.hh"
  
int main(const int argc, const char** argv) {
  using namespace topcom;


  using namespace topcom;
  
  if (argc < 2) {
    std::cerr << "usage: " << argv[0] << " n" << std::endl;
    return 1;
  }
  parameter_type n = atoi(argv[1]);
  if (n <= 0) {
    std::cerr << "n > 0 required" << std::endl;
    return 1;
  }

  CommandlineOptions::init(argc - 1, argv + 1);

  // first compute the group A_n generated by all 3-cycles:
  symmetry_collectordata A_data;
  Permutation cycle(n, 3);
  do {
    Symmetry s(cycle, true);
    A_data.insert(s);
  } while (cycle.lexnext());
  SymmetryGroup A(n, A_data);
  std::pair<PointConfiguration, SymmetryGroup> B_A(A.permutation_polytope(false));
  std::cout << B_A.first << std::endl;
  B_A.second.write_generators(std::cout);
  std::cout << std::endl;
  
  return 0;
}

// eof B_A.cc
