/* procuux.c -- Read and process .Log/uux/
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include    "tua_4_hdb.h"

#if HDB_UUCP

#if defined(DIRENT) || defined(_POSIX_VERSION)
#include <dirent.h>
#define NLENGTH(dirent) (strlen((dirent)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define dirent direct
#define NLENGTH(dirent) ((dirent)->d_namlen)
#ifdef USG
#ifdef SYSNDIR
#include <sys/ndir.h>
#else /* not SYSNDIR */
#include <ndir.h>
#endif /* not SYSNDIR */
#else /* not USG */
#include <sys/dir.h>		/* Assume SYSDIR, or not if you want. */
#endif /* not USG */
#endif /* not (DIRENT or _POSIX_VERSION) */

static void
DEFUN (ProcUuxEntry, (fp, sys),
       FILE * fp AND
       char *sys)
{
  char line[LINE_BUFFER_SIZE];
  system_rec_t *sr = insert_system (sys);

  if (!sr->Killed)
    {
#ifdef DEBUG
      if (be_verbose)
	fprintf (stderr, "\n%s:\n", sys);
#endif
      
      while (fgets (line, LINE_BUFFER_SIZE, fp) != NULL)
	{
	  command_rec_t *cr;
	  user_rec_t *ur;
	  day_rec_t *dr;
	  char *User;
	  Date_t Date;
	  extern int EXFUN(atoi, (CONST char *));
	  char commandline[LINE_BUFFER_SIZE];
	  char *argument, *command;

	  debug_newline();
	  
	  User = strtok (line, " ");
	  ur = insert_user (User);
	  (void) strtok (NULL, "(");
	  
	  Date.Month = atoi (strtok (NULL, "/"));
	  Date.Day = atoi (strtok (NULL, "-"));
	  dr = insert_day (Date);
	  (void) strtok (NULL, "(");
	  sprintf (commandline, "(%s) %s ", sys,
		   (command = strtok (NULL, " ")));
	  argument = strtok (NULL, ")\n");
	  if (argument != NULL)
	    strcat (commandline, argument);
	  if (!ur->Killed)
	    {
	      cr = insert_command (&ur->Commands, commandline);
	      cr->Number++;
	    }
	  cr = insert_command (&dr->Commands, commandline);
	  cr->Number++;
	  sprintf (commandline, "%s ", command);
	  if (argument != NULL)
	    strcat (commandline, argument);
	  cr = insert_command (&sr->Commands, commandline);
	  cr->Number++;
	}
    }
}

int
DEFUN_VOID (read_uux_log)
{
  DIR *dirfp = NULL;
  struct dirent *direntry;
  char dirname[LPNMAX];
  int ret_value = OK;

  if (do_command_report_opt)
    {
      sprintf (dirname, "%s/%s", logs_prefix_path_opt, UUX_DIR);
      if ((dirfp = opendir (dirname)) == NULL)
	{
	  LOG ("cannot read %s", dirname);
	  ret_value = ERROR;
	}
      else
	{
#ifdef DEBUG
	  if (be_verbose)
	    fputs ("\nProcessing uux logs:", stderr);
#endif
	  
	  while ((direntry = readdir (dirfp)) != NULL)
	    {
	      FILE *UuxFp;
	      char PathName[LPNMAX];
	      char System[15];

	      if (*direntry->d_name == '.')
		continue;

	      sprintf (System, "%.*s", (int) NLENGTH (direntry), direntry->d_name);

	      if (just_some_system_opt &&
		  (search_system (System) == (system_rec_t *) NULL))
		continue;

	      sprintf (PathName, "%s/%s/%s", logs_prefix_path_opt, UUX_DIR, System);
	      debug_filename (PathName);
	      if ((UuxFp = fopen (PathName, "r")) == (FILE *) NULL)
		{
		  LOG ("cannot open %s", PathName);
		  ret_value = ERROR;
		  break;
		}

	      ProcUuxEntry (UuxFp, System);
	      debug_end();
	      fclose (UuxFp);
	    }
	}
    }

  if (dirfp)
    closedir (dirfp);

  return ret_value;
}

#endif /* HDB_UUCP */
