/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"


char *keys[MAX_CQ]={"F5", "F6", "F7", "F8", "F11", "F12"};

struct menu_item no_cq_defined_menu[] = {
    {CTEXT(T_NO_CQ), "", M_BAR, NULL, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0},
};


/************************** CW *******************************/
 
char cw_str[MAX_STR_LEN], cw_speed_str[EQSO_LEN];
int cw_repeat;
char cw_ts_str[EQSO_LEN];
int cw_allowifundef;    


void refresh_cq_cw(void *xxx){
    struct cq *cq;

    cq = (struct cq *)xxx;
    
    STORE_STR(cq, cw_str);
    cq->cw_speed = atoi(cw_speed_str);
    cq->cw_repeat = cw_repeat;
    cq->cw_ts  = atoi(cw_ts_str);
    cq->cw_allowifundef = cw_allowifundef;
}

char *cq_cw_msg[] = {
   CTEXT(T_TEXT), 
   CTEXT(T_SPEED), 
   CTEXT(T_REPEAT),
   CTEXT(T_DELAY), 
   CTEXT(T_ALLOW_UNDEF),
   "", /* OK */
   "", /* Cancel */
};


void cq_cw_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, cq_cw_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, cq_cw_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, cq_cw_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, cq_cw_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, cq_cw_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, cq_cw_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, cq_cw_msg + 3, dlg->items + 2, 1, &max);
    min_group_width(term, cq_cw_msg + 3, dlg->items + 2, 1, &min);
    max_group_width(term, cq_cw_msg + 4, dlg->items + 2, 1, &max);
    min_group_width(term, cq_cw_msg + 4, dlg->items + 2, 1, &min);
    
    max_buttons_width(term, dlg->items + 5, 2, &max);
    min_buttons_width(term, dlg->items + 5, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, cq_cw_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_cw_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 5, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, cq_cw_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_cw_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 5, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void cq_cw(cba_t cba){

    struct dialog *d;
    int i;
    int no;
    struct cq *cq;


    no = (int)GETCBA(cba, int_);
    cq = g_ptr_array_index(cfg->cqs, no);
    
    safe_strncpy0(cw_str, cq->cw_str, MAX_STR_LEN);
    g_snprintf(cw_speed_str, EQSO_LEN, "%d", cq->cw_speed);
    cw_repeat = cq->cw_repeat;
    g_snprintf(cw_ts_str, EQSO_LEN, "%d", cq->cw_ts);
    cw_allowifundef = cq->cw_allowifundef;

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_CW_CQ);
    d->fn = cq_cw_fn;
    d->refresh = (void (*)(void *))refresh_cq_cw;
    d->refresh_data = (void *)cq;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = cw_str;
    d->items[i].maxl = 60;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = cw_speed_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = cfg->cwda_maxwpm;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cw_repeat;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = cw_ts_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 300;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cw_allowifundef;
    

    d->items[++i].type = D_BUTTON; /* 5 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
                               
}

void menu_cq_cw(cba_t cba){
    int i;
    char *c;
    struct menu_item *mi = NULL;
    struct cq *cq;
    char example[40];
    

    for (i=0; i<cfg->cqs->len; i++){
        cq = (struct cq *) g_ptr_array_index(cfg->cqs, i);
        
        safe_strncpy0(example, cq->cw_str, 40);
        c = g_strdup_printf(VTEXT(T_CW_DSCS), i, keys[i], cq->cw_repeat?'R':' ', example);
        if (!mi) if (!(mi = new_menu(3))) return;
        add_to_menu(&mi, 
                stracpy(c), 
                "", "", 
                MENU_FUNC cq_cw, (cba_t)i, 0);    
        g_free(c);
    }
    if (i) 
        do_menu(mi, CBA0);
    else
        do_menu(no_cq_defined_menu, CBA0);
}


/*********************** SSB ****************************/

char ssb_file[MAX_STR_LEN];
int ssb_repeat;
char ssb_ts_str[EQSO_LEN];

void refresh_cq_ssb(void *xxx){
    struct cq *cq;

    cq = (struct cq *)xxx;
    
    STORE_STR(cq, ssb_file);
    cq->ssb_repeat = ssb_repeat;
    cq->ssb_ts  = atoi(ssb_ts_str);
}

char *cq_ssb_msg[] = {
   CTEXT(T_FILENAME), 
   CTEXT(T_REPEAT),
   CTEXT(T_DELAY), 
   "", /* OK */
   "", /* Cancel */
};


void cq_ssb_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, cq_ssb_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, cq_ssb_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, cq_ssb_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, cq_ssb_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, cq_ssb_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, cq_ssb_msg + 2, dlg->items + 2, 1, &min);
    
    max_buttons_width(term, dlg->items + 3, 2, &max);
    min_buttons_width(term, dlg->items + 3, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, cq_ssb_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_ssb_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, cq_ssb_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 3, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, cq_ssb_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_ssb_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, cq_ssb_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 3, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void cq_ssb(cba_t cba){

    struct dialog *d;
    int i;
    int no;
    struct cq *cq;


    no = (int)GETCBA(cba, int_);            
    cq = g_ptr_array_index(cfg->cqs, no);
    
    safe_strncpy0(ssb_file, cq->ssb_file, MAX_STR_LEN);
    ssb_repeat = cq->ssb_repeat;
    g_snprintf(ssb_ts_str, EQSO_LEN, "%d", cq->ssb_ts);

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_SSB_CQ);
    d->fn = cq_ssb_fn;
    d->refresh = (void (*)(void *))refresh_cq_ssb;
    d->refresh_data = (void *)cq;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssb_file;
    d->items[i].maxl = 60;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssb_repeat;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssb_ts_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 300;
    
    d->items[++i].type = D_BUTTON; /* 3 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
                               
}


void menu_cq_ssb(cba_t cba){
    int i;
    char *c;
    struct menu_item *mi = NULL;
    struct cq *cq;
    char example[20];
    

    for (i=0; i<cfg->cqs->len; i++){
        cq = (struct cq *) g_ptr_array_index(cfg->cqs, i);

        safe_strncpy0(example, cq->ssb_file, 20);
        c = g_strdup_printf(VTEXT(T_SSB_DSCS), i, keys[i], cq->ssb_repeat?'R':' ', example);
        if (!mi) if (!(mi = new_menu(3))) return;
        add_to_menu(&mi, 
                stracpy(c), 
                "", "", 
                MENU_FUNC cq_ssb, (cba_t)i, 0);    
        g_free(c);
    }
    if (i) 
        do_menu(mi, CBA0);
    else
        do_menu(no_cq_defined_menu, CBA0);
}



/******************* CWDAEMON **********************************/

int cwda_type;
char cwda_device[MAX_STR_LEN];
char cwda_hostname[MAX_STR_LEN];
char udp_port_str[EQSO_LEN];
char speed_str[EQSO_LEN];
char weight_str[EQSO_LEN];
char minwpm_str[EQSO_LEN], maxwpm_str[EQSO_LEN];
int cwda_spk;
char leadin_str[EQSO_LEN];
char autgive_str[EQSO_LEN];
    
void refresh_cwda(void *xxx){
    
	cfg->cwda_type=cwda_type;
    STORE_STR(cfg, cwda_device);
    STORE_STR(cfg, cwda_hostname);
    cfg->cwda_udp_port = atoi(udp_port_str);
    cfg->cwda_speed = atoi(speed_str);
    cfg->cwda_weight = atoi(weight_str);
    if (cfg->cwda_weight < 30) cfg->cwda_weight = 30;
    if (cfg->cwda_weight > 70) cfg->cwda_weight = 70;
    cfg->cwda_minwpm = atoi(minwpm_str);
    cfg->cwda_maxwpm = atoi(maxwpm_str);
    cfg->cwda_spk = cwda_spk;
    cfg->cwda_leadin = atoi(leadin_str);
    cfg->cwda_autgive = atoi(autgive_str);
	
	free_cwdaemon(cwda);
	cwda=init_cwdaemon();
}


void menu_cwda(cba_t cba){

    struct dialog *d;
    int i;
    
	cwda_type=cfg->cwda_type;
    safe_strncpy0(cwda_device, cfg->cwda_device, MAX_STR_LEN);
    safe_strncpy0(cwda_hostname, cfg->cwda_hostname, MAX_STR_LEN);
    g_snprintf(udp_port_str, EQSO_LEN, "%d", cfg->cwda_udp_port);
    g_snprintf(speed_str, EQSO_LEN, "%d", cfg->cwda_speed);
    if (cfg->cwda_weight < 30 || cfg->cwda_weight > 70) cfg->cwda_weight = 50;
    g_snprintf(weight_str, EQSO_LEN, "%d", cfg->cwda_weight);
    g_snprintf(minwpm_str, EQSO_LEN, "%d", cfg->cwda_minwpm);
    g_snprintf(maxwpm_str, EQSO_LEN, "%d", cfg->cwda_maxwpm);
    cwda_spk=cfg->cwda_spk;
    g_snprintf(leadin_str, EQSO_LEN, "%d", cfg->cwda_leadin);
    g_snprintf(autgive_str, EQSO_LEN, "%d", cfg->cwda_autgive);

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_CW_DAEMON);
//  d->fn = cwda_fn;
    d->fn = dlg_pf_fn;
    d->refresh = (void (*)(void *))refresh_cwda;
    d->refresh_data = NULL;
    d->y0 = 1;
    
    d->items[i=0].type = D_CHECKBOX;  /* 0 */
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_NONE;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "None";
	
    d->items[++i].type = D_CHECKBOX; 
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_PARPORT;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "parport";
	
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_TTYS;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "ttys";
	
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_DAVAC4;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "Davac4";
    d->items[i].wrap = 1;
	
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_CWD;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "cwdaemon";
	
    d->items[++i].type = D_CHECKBOX;    /* 5 */
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_WINKEY;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "winkey";

    d->items[++i].type = D_CHECKBOX;    /* 6 */
    d->items[i].gid = 1;
    d->items[i].gnum = CWD_WINKEY4;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_type;
    d->items[i].msg = "winkey+davac4";
    d->items[i].wrap = 1;
	
    d->items[++i].type = D_FIELD;       
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = cwda_device;
    d->items[i].maxl = 20;
    d->items[i].msg = CTEXT(T_DEVICE);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = cwda_hostname;
    d->items[i].maxl = 20;
    d->items[i].msg = CTEXT(T_HOSTNAME);
    
    d->items[++i].type = D_FIELD;    
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = udp_port_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 65535;
    d->items[i].msg = CTEXT(T_UDPPORT);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;      
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = speed_str;
    d->items[i].maxl = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = cfg->cwda_maxwpm;
    d->items[i].msg = CTEXT(T_INIT_SPEED);
    
    d->items[++i].type = D_FIELD;     /* 10 */ 
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = weight_str;
    d->items[i].maxl = 3;
    d->items[i].msg = CTEXT(T_INIT_WEIGHT);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;  
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = minwpm_str;
    d->items[i].maxl = 5;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 99;
    d->items[i].msg = CTEXT(T_WPMFROM);
    
    d->items[++i].type = D_FIELD;  
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = maxwpm_str;
    d->items[i].maxl = 5;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 99;
    d->items[i].msg = CTEXT(T_WPMTO);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_CHECKBOX;  
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&cwda_spk;
    d->items[i].msg = CTEXT(T_USE_SPK);
    
    d->items[++i].type = D_FIELD;  
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = leadin_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 10000;
    d->items[i].msg = CTEXT(T_LEADIN);
    d->items[i].wrap = 1;

    d->items[++i].type = D_FIELD;     /* 15 */
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = autgive_str;
    d->items[i].maxl = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 9;
    d->items[i].msg = CTEXT(T_AUTGIVE);
    d->items[i].wrap = 2;

    d->items[++i].type = D_BUTTON;    
    d->items[i].gid = 0;
    d->items[i].fn = dlg_winkey_opts;
    d->items[i].text = VTEXT(T_WINKEYOPTS);
    d->items[i].wrap = 2;
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;    
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    d->items[i].align = AL_BUTTONS;
    d->items[i].wrap = 1;
    
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
                               
}


/*********************** SSBD ****************************/

#ifdef HAVE_SNDFILE

#define MAX_RECORD_FORMAT 7
int record_format; /* index 0..MAX_RECORD_FORMAT-1 */
extern char ssbd_format_str[MAX_STR_LEN];
extern char ssbd_oss_src[MAX_STR_LEN];
extern char ssbd_alsa_src[MAX_STR_LEN];

char *record_format_msg[]={
    CTEXT(T_PCM8),
    CTEXT(T_PCM16),
    CTEXT(T_ULAW),
    CTEXT(T_ALAW),
    CTEXT(T_IMAADPCM),
    CTEXT(T_MSADPCM),
    CTEXT(T_GSM610)
};

int record_formats[]={
    SF_FORMAT_WAV | SF_FORMAT_PCM_U8,
    SF_FORMAT_WAV | SF_FORMAT_PCM_16,
    SF_FORMAT_WAV | SF_FORMAT_ULAW,
    SF_FORMAT_WAV | SF_FORMAT_ALAW,
    SF_FORMAT_WAV | SF_FORMAT_IMA_ADPCM,
    SF_FORMAT_WAV | SF_FORMAT_MS_ADPCM,
    SF_FORMAT_WAV | SF_FORMAT_GSM610
};

void record_format_func (cba_t cba){
    int active;
    
    active=cba.int_;
    if (active<0 || active>=MAX_RECORD_FORMAT) return;
    record_format = active;
    safe_strncpy0(ssbd_format_str,_(CTEXT(T_PCM8+record_format)),MAX_STR_LEN);
    redraw_later();
    
}

int dlg_record_format(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel;
    struct menu_item *mi;
    
    if (!(mi = new_menu(1))) return 0;
    for (i = 0; i < MAX_RECORD_FORMAT; i++) {
        add_to_menu(&mi, record_format_msg[i], "", "", MENU_FUNC record_format_func, (cba_t)i, 0);
    }
    sel = record_format;
    if (sel < 0) sel = 0;
    if (sel>=MAX_RECORD_FORMAT) sel=0;
    do_menu_selected(mi, (cba_t)record_format, sel);
    return 0;
}

/* ------------------------ */    

void alsa_src_func (cba_t cba){
    int i, active;
    GString *labels;
    gchar **items;
    
    active=cba.int_;

    labels=g_string_sized_new(100);
#ifdef HAVE_ALSA
    alsa_get_sources(labels);
#endif    
    items=g_strsplit(labels->str, ";", 0);
    for (i=0;items[i]!=NULL;i++);/* dbg("items[%d]=%s\n", i, items[i]);*/
/*    dbg("alsa_src_func: active=%d max=%d\n", active, i);*/
    dbg("alsa_src_func(%d) labels='%s'\n", active, labels->str);
    
    if (active<0 || active>i) goto x;
    if (active==0)
        safe_strncpy0(ssbd_alsa_src,VTEXT(T_RECSRC_NONE),MAX_STR_LEN);
    else
        safe_strncpy0(ssbd_alsa_src,items[active-1],MAX_STR_LEN);
    dbg("  ssbd_alsa_src='%s'\n", ssbd_alsa_src);
    redraw_later();
x:;    
    g_string_free(labels, 1);
    g_strfreev(items);
}

int dlg_alsa_src(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel;
    struct menu_item *mi;
    GString *labels;
    gchar **items;
    
    labels=g_string_sized_new(100);


#ifdef HAVE_ALSA
    alsa_get_sources(labels);
#endif    
    items=g_strsplit(labels->str, ";", 0);
    dbg("dlg_alsa_src() labels='%s'\n", labels->str);
    if (!(mi = new_menu(1))) goto x;
    add_to_menu(&mi, stracpy(VTEXT(T_RECSRC_NONE)), "", "", MENU_FUNC alsa_src_func, (cba_t)0, 0);
    sel=0;
    for (i = 0; items[i]!=NULL; i++) {
        add_to_menu(&mi, stracpy(items[i]), "", "", MENU_FUNC alsa_src_func, (cba_t)(i+1), 0);
        if (strcmp(items[i], ssbd_alsa_src)==0) sel=i+1;
    }
    dbg("  sel=%d\n", sel);
    do_menu_selected(mi, CBA0, sel);
x:;    
    g_string_free(labels, 1);
    g_strfreev(items);
    return 0;
}
    
/* ------------------------ */    

void oss_src_func (cba_t cba){
    int i, active;
    GString *labels;
    gchar **items;
    
    active=cba.int_;

    labels=g_string_sized_new(100);
#ifdef HAVE_OSS
    oss_get_sources(labels);
#endif
    items=g_strsplit(labels->str, ";", 0);
    for (i=0;items[i]!=NULL;i++);/* dbg("items[%d]=%s\n", i, items[i]);*/
    dbg("oss_src_func: active=%d max=%d\n", active, i);

    if (active<0 || active>i) goto x;
    if (active==0)
        safe_strncpy0(ssbd_oss_src,VTEXT(T_RECSRC_NONE),MAX_STR_LEN);
    else
        safe_strncpy0(ssbd_oss_src,items[active-1],MAX_STR_LEN);
    redraw_later();
x:;    
    g_string_free(labels, 1);
    g_strfreev(items);
}

int dlg_oss_src(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel;
    struct menu_item *mi;
    GString *labels;
    gchar **items;
    
    labels=g_string_sized_new(100);

#ifdef HAVE_OSS
    oss_get_sources(labels);
#endif
    items=g_strsplit(labels->str, ";", 0);
    dbg("labels='%s'\n", labels->str);
    if (!(mi = new_menu(1))) goto x;
    add_to_menu(&mi, stracpy(VTEXT(T_RECSRC_NONE)), "", "", MENU_FUNC oss_src_func, (cba_t)0, 0);
    sel=0;
    for (i = 0; items[i]!=NULL; i++) {
        add_to_menu(&mi, stracpy(items[i]), "", "", MENU_FUNC oss_src_func, (cba_t)(i+1), 0);
        if (strcmp(items[i], ssbd_oss_src)==0) sel=i+1;
    }
    dbg("sel=%d\n", sel);
    do_menu_selected(mi, CBA0, sel);
x:;    
    g_string_free(labels, 1);
    g_strfreev(items);
    return 0;
}
    
/* ------------------------ */    
int ssbd_type;
int ssbd_record;
char ssbd_maxmin_str[EQSO_LEN], ssbd_diskfree_str[EQSO_LEN];
int ssbd_format; /* 0x100xx */
char ssbd_format_str[MAX_STR_LEN];
char ssbd_channels_str[EQSO_LEN], ssbd_samplerate_str[EQSO_LEN];
char ssbd_plev_str[EQSO_LEN], ssbd_rlev_str[EQSO_LEN];
char ssbd_template[MAX_STR_LEN];

char ssbd_pcm_play[EQSO_LEN], ssbd_pcm_rec[EQSO_LEN];
char ssbd_period_time_str[EQSO_LEN], ssbd_buffer_time_str[EQSO_LEN];
char ssbd_alsa_mixer[EQSO_LEN];
char ssbd_alsa_src[MAX_STR_LEN];
    
char ssbd_dsp[MAX_STR_LEN];
char ssbd_maxfrag_str[EQSO_LEN];
char ssbd_mixer[MAX_STR_LEN];
char ssbd_oss_src[MAX_STR_LEN];

char ssbd_hostname[MAX_STR_LEN],ssbd_udp_port_str[EQSO_LEN];

void refresh_ssbd(void *xxx){
    
    STORE_INT(cfg, ssbd_type);
    STORE_INT(cfg, ssbd_record);
    STORE_SINT(cfg, ssbd_maxmin);
    STORE_SINT(cfg, ssbd_diskfree);
    if (record_format<0 || record_format>=MAX_RECORD_FORMAT){
        cfg->ssbd_format = SF_FORMAT_WAV | SF_FORMAT_GSM610;
    }else{
        cfg->ssbd_format = record_formats[record_format];
    }
    dbg("refresh_ssbd: record_formats[%d]=0x%x (%s)\n", record_format, cfg->ssbd_format, _(CTEXT(T_PCM8+record_format)));
    STORE_SINT(cfg, ssbd_channels);
    STORE_SINT(cfg, ssbd_samplerate);
    STORE_SINT(cfg, ssbd_plev);
    STORE_SINT(cfg, ssbd_rlev);
    STORE_STR(cfg, ssbd_template);

    STORE_STR(cfg, ssbd_pcm_play);
    STORE_STR(cfg, ssbd_pcm_rec);
    STORE_SINT(cfg, ssbd_period_time);
    STORE_SINT(cfg, ssbd_buffer_time);
    STORE_STR(cfg, ssbd_alsa_mixer);
    if (strcmp(ssbd_alsa_src, VTEXT(T_RECSRC_NONE))==0){
        strcpy(ssbd_alsa_src, "");
    }
    STORE_STR(cfg, ssbd_alsa_src);

    
    dbg("refresh_ssbd: ssbd_alsa_src='%s'\n", cfg->ssbd_alsa_src);

    STORE_STR(cfg, ssbd_dsp);
    STORE_SINT(cfg, ssbd_maxfrag);
    STORE_STR(cfg, ssbd_mixer);
    if (strcmp(ssbd_oss_src, VTEXT(T_RECSRC_NONE))==0){
        strcpy(ssbd_oss_src, "");
    }
    STORE_STR(cfg, ssbd_oss_src);
    dbg("refresh_ssbd: ssbd_oss_src='%s'\n", cfg->ssbd_oss_src);

    STORE_STR(cfg, ssbd_hostname);
    STORE_SINT(cfg, ssbd_udp_port);

    free_ssbd(ssbd);
    free_dsp(dsp);
    dsp=init_dsp();
    ssbd=init_ssbd();
}

char *ssbd_msg[] = {
    CTEXT(T_ALSA),          /* 0 */
    CTEXT(T_OSS),
    CTEXT(T_SSBD),
    CTEXT(T_RECORD), 
    CTEXT(T_MAXMIN), 
    CTEXT(T_DISKFREE),/* 5 */
    CTEXT(T_FORMAT),
    CTEXT(T_CHANNELS),      
    CTEXT(T_SAMPLERATE),
    "Playback volume",
    "Capture volume",   /* 10 */
    CTEXT(T_TEMPLATE),  

    CTEXT(T_PCM_PLAY),  
    CTEXT(T_PCM_REC),
    CTEXT(T_PERIOD),         
    CTEXT(T_BUFFER),       /* 15 */
    CTEXT(T_ALSA_MIXER),
    CTEXT(T_CAPTURE),      

    CTEXT(T_DSP), 
    CTEXT(T_MAXFRAG),   
    CTEXT(T_MIXER),         /* 20 */  
    CTEXT(T_RECSRC),
    
    CTEXT(T_SSBD_HOSTNAME), 
    CTEXT(T_UDPPORT),

    "", /* OK */       /* 24 */ 
    "", /* Cancel */
};

    /*CTEXT(T_PCM8),      
    CTEXT(T_PCM16), 
    CTEXT(T_ULAW), 
    CTEXT(T_ALAW), 
    CTEXT(T_IMAADPCM),  
    CTEXT(T_MSADPCM),   
    CTEXT(T_GSM610), 
    CTEXT(T_RECSRC_NONE),   
    CTEXT(T_RECSRC_MIC),   
    CTEXT(T_RECSRC_LINE), */  

void ssbd_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, ssbd_msg + 0, dlg->items + 0, 3, &max);
    min_group_width(term, ssbd_msg + 0, dlg->items + 0, 3, &min);
    max_group_width(term, ssbd_msg + 3, dlg->items + 3, 4, &max);
    min_group_width(term, ssbd_msg + 3, dlg->items + 3, 4, &min);
    max_group_width(term, ssbd_msg + 7, dlg->items + 7, 4, &max);
    min_group_width(term, ssbd_msg + 7, dlg->items + 7, 4, &min);
    max_group_width(term, ssbd_msg +11, dlg->items +11, 1, &max);
    min_group_width(term, ssbd_msg +11, dlg->items +11, 1, &min);

    max_group_width(term, ssbd_msg +12, dlg->items +12, 4, &max);
    min_group_width(term, ssbd_msg +12, dlg->items +12, 4, &min);
    max_group_width(term, ssbd_msg +16, dlg->items +16, 2, &max);
    min_group_width(term, ssbd_msg +16, dlg->items +16, 2, &min);
    
    max_group_width(term, ssbd_msg +18, dlg->items +18, 2, &max);
    min_group_width(term, ssbd_msg +18, dlg->items +18, 2, &min);
    max_group_width(term, ssbd_msg +20, dlg->items +20, 2, &max);
    min_group_width(term, ssbd_msg +20, dlg->items +20, 2, &min);
    
    max_group_width(term, ssbd_msg +22, dlg->items +22, 2, &max);
    min_group_width(term, ssbd_msg +22, dlg->items +22, 2, &min);

    max_buttons_width(term, dlg->items +24, 2, &max);
    min_buttons_width(term, dlg->items +24, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group1(NULL, term, ssbd_msg + 0, dlg->items + 0, 3, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, ssbd_msg + 3, dlg->items + 3, 4, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, ssbd_msg + 7, dlg->items + 7, 4, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, ssbd_msg +11, dlg->items +11, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group1(NULL, term, ssbd_msg +12, dlg->items +12, 4, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, ssbd_msg +16, dlg->items +16, 2, 0, &y, w, &rw);
    y++;
    dlg_format_group1(NULL, term, ssbd_msg +18, dlg->items +18, 2, 0, &y, w, &rw);
    dlg_format_group1(NULL, term, ssbd_msg +20, dlg->items +20, 2, 0, &y, w, &rw);
    y++;
    dlg_format_group1(NULL, term, ssbd_msg +22, dlg->items +22, 2, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +24, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group1(term, term, ssbd_msg + 0, dlg->items + 0, 3, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, ssbd_msg + 3, dlg->items + 3, 4, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, ssbd_msg + 7, dlg->items + 7, 4, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, ssbd_msg +11, dlg->items +11, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group1(term, term, ssbd_msg +12, dlg->items +12, 4, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, ssbd_msg +16, dlg->items +16, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group1(term, term, ssbd_msg +18, dlg->items +18, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group1(term, term, ssbd_msg +20, dlg->items +20, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group1(term, term, ssbd_msg +22, dlg->items +22, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 24, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
}

void do_ssbd(void){
    struct dialog *d;
    int i;
    GString *labels;
    gchar *c;
    
    labels=g_string_sized_new(100);

    ssbd_type = cfg->ssbd_type;
    ssbd_record = cfg->ssbd_record;
    g_snprintf(ssbd_maxmin_str, EQSO_LEN, "%d", cfg->ssbd_maxmin);
    g_snprintf(ssbd_diskfree_str, EQSO_LEN, "%d", cfg->ssbd_diskfree);
    ssbd_format=cfg->ssbd_format;
    record_format=0;
    for (i=0;i<MAX_RECORD_FORMAT;i++) if (record_formats[i]==ssbd_format) record_format=i;
    safe_strncpy0(ssbd_format_str,_(CTEXT(T_PCM8+record_format)),MAX_STR_LEN);
    dbg("do_ssbd: ssbd_format=0x%x (%s)  record_format=%d\n", ssbd_format, ssbd_format_str, record_format);
    g_snprintf(ssbd_channels_str, EQSO_LEN, "%d", cfg->ssbd_channels);
    g_snprintf(ssbd_samplerate_str, EQSO_LEN, "%d", cfg->ssbd_samplerate);
    g_snprintf(ssbd_plev_str, EQSO_LEN, "%d", cfg->ssbd_plev);
    g_snprintf(ssbd_rlev_str, EQSO_LEN, "%d", cfg->ssbd_rlev);
    safe_strncpy0(ssbd_template, cfg->ssbd_template, MAX_STR_LEN);

    safe_strncpy0(ssbd_pcm_play, cfg->ssbd_pcm_play, EQSO_LEN);
    safe_strncpy0(ssbd_pcm_rec,  cfg->ssbd_pcm_rec,  EQSO_LEN);
    g_snprintf(ssbd_period_time_str, EQSO_LEN, "%d", cfg->ssbd_period_time);
    g_snprintf(ssbd_buffer_time_str, EQSO_LEN, "%d", cfg->ssbd_buffer_time);
    safe_strncpy0(ssbd_alsa_mixer, cfg->ssbd_alsa_mixer, EQSO_LEN);
/*    safe_strncpy0(ssbd_alsa_src,   cfg->ssbd_alsa_src, MAX_STR_LEN);*/
    
    dbg("do_ssbd: cfg->ssbd_alsa_src='%s'\n", cfg->ssbd_alsa_src);
    if (cfg->ssbd_alsa_src && strlen(cfg->ssbd_alsa_src)>0){
        safe_strncpy0(ssbd_alsa_src,cfg->ssbd_alsa_src,MAX_STR_LEN);
    }else{
        safe_strncpy0(ssbd_alsa_src, VTEXT(T_RECSRC_NONE), MAX_STR_LEN);
    }
    dbg("do_ssbd: ssbd_alsa_src='%s'\n", ssbd_alsa_src);

    safe_strncpy0(ssbd_dsp, cfg->ssbd_dsp, MAX_STR_LEN);
    g_snprintf(ssbd_maxfrag_str, EQSO_LEN, "%d", cfg->ssbd_maxfrag);
    safe_strncpy0(ssbd_mixer, cfg->ssbd_mixer, MAX_STR_LEN);
    
    dbg("do_ssbd: cfg->ssbd_oss_src='%s'\n", cfg->ssbd_oss_src);
    if (cfg->ssbd_oss_src){
        if (!*cfg->ssbd_oss_src) c=NULL;
        else c=cfg->ssbd_oss_src;
    }else{
        c=NULL;
#ifdef HAVE_OSS
        c=oss_recsrc2source(cfg->ssbd_recsrc);
#endif
    }
    dbg("do_ssbd: cfg->ssbd_recsrc=%d label='%s'\n", cfg->ssbd_recsrc, c);
    if (c){
        safe_strncpy0(ssbd_oss_src,c,MAX_STR_LEN);
    }else{
        safe_strncpy0(ssbd_oss_src, VTEXT(T_RECSRC_NONE), MAX_STR_LEN);
    }
    

    safe_strncpy0(ssbd_hostname, cfg->ssbd_hostname, MAX_STR_LEN);
    g_snprintf(ssbd_udp_port_str, EQSO_LEN, "%d", cfg->ssbd_udp_port);
    
    g_string_free(labels, 0);

    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_AUDIO);
    d->fn = ssbd_fn;
    d->refresh = (void (*)(void *))refresh_ssbd;
    
    d->items[i=0].type = D_CHECKBOX;  /* 0 */
    d->items[i].gid = 1;
    d->items[i].gnum = DSPT_ALSA;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = DSPT_OSS;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = DSPT_SSBD;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&ssbd_record;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_maxmin_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 10000;

    d->items[++i].type = D_FIELD;      /* 5 */
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_diskfree_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 10000;
 
    d->items[++i].type = D_BUTTON;     
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_record_format;
    d->items[i].text = ssbd_format_str;
 
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_channels_str;
    d->items[i].maxl = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 8;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_samplerate_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 4000;
    d->items[i].gnum = 180000;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_plev_str;
    d->items[i].maxl = 4;
    d->items[i].fn   = check_number;
    d->items[i].gid  = -1;
    d->items[i].gnum = 100;
    
    d->items[++i].type = D_FIELD;    /* 10 */
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_rlev_str;
    d->items[i].maxl = 4;
    d->items[i].fn   = check_number;
    d->items[i].gid  = -1;
    d->items[i].gnum = 100;
    
    d->items[++i].type = D_FIELD;  
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_template;
    d->items[i].maxl = 30;
    
    d->items[++i].type = D_FIELD;    
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_pcm_play;
    d->items[i].maxl = 15;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_pcm_rec;
    d->items[i].maxl = 15;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_period_time_str;
    d->items[i].maxl = 5;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1000;
    
    d->items[++i].type = D_FIELD;   /* 15 */   
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_buffer_time_str;
    d->items[i].maxl = 5;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1000;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_alsa_mixer;
    d->items[i].maxl = 15;
    
    d->items[++i].type = D_BUTTON;  
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_alsa_src;
    d->items[i].text = ssbd_alsa_src;

    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_dsp;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_maxfrag_str;
    d->items[i].maxl = 5;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 20;
    
    d->items[++i].type = D_FIELD;    /* 20 */     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_mixer;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_BUTTON; 
    d->items[i].gid  = 0;
    d->items[i].fn   = dlg_oss_src;
    d->items[i].text = ssbd_oss_src;

    d->items[++i].type = D_FIELD;    
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = ssbd_hostname;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = ssbd_udp_port_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 65535;
    
    d->items[++i].type = D_BUTTON; /* 24 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}


void menu_ssbd(cba_t cba){
    
    do_ssbd();
}
#endif //HAVE_SNDFILE


/*********************** NETWORK ****************************/

char net_if_ignore[MAX_STR_LEN],net_ip_ignore[MAX_STR_LEN],net_ip_announce[MAX_STR_LEN];
int trace_bcast, trace_sock, trace_recv, trace_send, trace_qsos, trace_sdev;

void refresh_net(void *xxx){
    
    STORE_STR(cfg, net_if_ignore);
    STORE_STR(cfg, net_ip_ignore);
    STORE_STR(cfg, net_ip_announce);
    STORE_INT(cfg, trace_bcast);
    STORE_INT(cfg, trace_sock);
    STORE_INT(cfg, trace_recv);
    STORE_INT(cfg, trace_send);
    STORE_INT(cfg, trace_qsos);
    STORE_INT(cfg, trace_sdev);
    free_net_ifaces(net);
    init_net_ifaces(net);
}


void do_net(void){

    struct dialog *d;
    int i;
    
    safe_strncpy0(net_if_ignore, cfg->net_if_ignore, MAX_STR_LEN);
    safe_strncpy0(net_ip_ignore, cfg->net_ip_ignore, MAX_STR_LEN);
    safe_strncpy0(net_ip_announce, cfg->net_ip_announce, MAX_STR_LEN);
    trace_bcast=cfg->trace_bcast;
    trace_sock=cfg->trace_sock;
    trace_recv=cfg->trace_recv;
    trace_send=cfg->trace_send;
    trace_qsos=cfg->trace_qsos;

    
    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_NETWORK);
    d->fn = dlg_pf_fn;
    d->refresh = (void (*)(void *))refresh_net;
    d->y0 = 1;
    
    d->items[i=0].type = D_FIELD;     /* 0 */
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = net_if_ignore;
    d->items[i].maxl = 24;
    d->items[i].msg = CTEXT(T_IF_IGNORE);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = net_ip_ignore;
    d->items[i].maxl = 24;
    d->items[i].msg = CTEXT(T_IP_IGNORE);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;     
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = net_ip_announce;
    d->items[i].maxl = 24;
    d->items[i].msg = CTEXT(T_IP_ANNOUNCE);
    d->items[i].wrap = 2;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_bcast;
    d->items[i].msg = CTEXT(T_TRACE_BCAST);
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_sock;
    d->items[i].msg = CTEXT(T_TRACE_SOCK);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_CHECKBOX;   /* 5 */
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_recv;
    d->items[i].msg = CTEXT(T_TRACE_RECV);
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_send;
    d->items[i].msg = CTEXT(T_TRACE_SEND);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_qsos;
    d->items[i].msg = CTEXT(T_TRACE_QSOS);
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&trace_sdev;
    d->items[i].msg = CTEXT(T_TRACE_SDEV);
    d->items[i].wrap = 2;
    
    d->items[++i].type = D_BUTTON; /* 8 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    d->items[i].align = AL_BUTTONS;
    d->items[i].wrap = 1;
    
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
                               
}


void menu_network(cba_t cba){
    
    do_net();
}



