/*
    Tucnak - VHF contest log
    Copyright (C) 2002-20011  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Interface for MSVC compiler
*/

#include "header.h"
#include <string.h>
#include <stdio.h>
#include <tchar.h>

int CALLBACK WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow){
	WSADATA wsaData;
    char **items;
	int argc;
	char *argv[100];

	WSAStartup(MAKEWORD(2, 0), &wsaData);
	
    items = g_strsplit(lpCmdLine, " ", 0);
	argv[0]="tucnak.exe";
    for (argc=1; items[argc-1] != 0 && argc < 100; argc++){
		if (items[argc-1] == NULL) break;
        argv[argc] = items[argc-1];
    }
    main(argc, argv);
    g_strfreev(items);
}

char *txt_settings = "Argument -s unsupported under MSVC\n";

int gettimeofday(struct timeval *tv, void *dummy){
	struct _timeb t;
	_ftime_s(&t);
	tv->tv_sec = (long)t.time;
	tv->tv_usec = t.millitm * 1000;
	return 0;
}

struct tm *gmtime_r(time_t *timep, struct tm *result){
	gmtime_s(result, timep);
	return result;
}



int setenv(const char *name, const char *value, int overwrite){
	_putenv_s(name, value);
	return 0;
}


char *strerror_r(int err_no, char *buf, int size){
	sprintf_s(buf, size, "Error %d", err_no);
	return buf;
}




void disable_screensaver(void){
}

/* file */

int open(const char *pathname, int flags){
	errno = 2;
	return -1;
}

int close(int fd){
	return -1;
}

int read(int fd, void *buf, int count){
	return recv(fd, (char *)buf, count, 0);
}

int write(int fd, const void *buf, int count){
	return send(fd, (char *)buf, count, 0);
} 


int ftruncate(int fd, off_t length){
	return -1;
}







/* ntpq */
struct ntpq *ntpq;

struct ntpq *init_ntpq(){
	return NULL;
}

void free_ntpq(struct ntpq *ntpq){ 
}


/* os_dep.h */

static int get_e(char *env)
{
    char *v;
    if ((v = getenv(env))) return atoi(v);
    return 0;
}


/* socket */

char *sock_strerror_r(int err_no, char *buf, int size){
	sprintf_s(buf, size, "Winsock error %d", err_no);
	return buf;
}



/* directory */
DIR *opendir(char *name){
    size_t base_length;
	char *all;
	DIR *dir = 0;

    if(!name || !*name) {
        errno = EINVAL;
        return NULL;
    }
    
    base_length = strlen(name);
    /* search pattern must end with suitable wildcard */
    all = strchr("/\\", name[base_length - 1]) ? "*" : "/*";

    if((dir = (DIR *) malloc(sizeof *dir)) != 0 &&
       (dir->name = (char *) malloc(base_length + strlen(all) + 1)) != 0)
    {
        strcat(strcpy(dir->name, name), all);

        if((dir->handle = (long) _findfirst(dir->name, &dir->info)) != -1)
        {
            dir->result.d_name[0] = '\0';
        }
        else /* rollback */
        {
            free(dir->name);
            free(dir);
            dir = 0;
        }
    }
    else /* rollback */
    {
        free(dir);
        dir   = 0;
        errno = ENOMEM;
    }
    return dir;
}


struct dirent *readdir(DIR *dir){
	struct dirent *result = 0;

    if(dir && dir->handle != -1)
    {
        if(!dir->result.d_name[0] != '\0' || _findnext(dir->handle, &dir->info) != -1)
        {
            result         = &dir->result;
            safe_strncpy(result->d_name, dir->info.name, _MAX_PATH);
        }	
		errno = 0;
    }
    else
    {
        errno = EBADF;
    }

    return result;
}

int closedir(DIR *dir){
	int result = -1;

    if(dir)
    {
        if(dir->handle != -1)
        {
            result = _findclose(dir->handle);
        }

        free(dir->name);
        free(dir);
    }

    if(result == -1) /* map all errors to EBADF */
    {
        errno = EBADF;
    }

    return result;
}
