/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of glibc as seen bellow

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

/* Copyright (C) 1992-1998, 2000, 2002 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include "header.h"

#ifdef _MSC_VER
#include "msvc.h"
#define __builtin_expect(expression, value) (expression)
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifndef _D_ALLOC_NAMLEN
#define _D_ALLOC_NAMLEN(d) (sizeof((d)->d_name)+1)
#endif

int tucnak_scandir (char *dir, struct dirent ***namelist, int (*select) (const struct dirent *), int (*cmp) (const void *, const void *))
{
    DIR *dp;
    struct dirent **v;// = NULL;
    size_t vsize = 0, i;
    struct dirent *d;
    int save;
   
	v = NULL;
    //dbg("tucnak_scandir('%s')\n", dir);
	wokna(dir);
    dp = opendir(dir);
    if (dp == NULL) return -1;

    save = errno;
    errno = 0;

    i = 0;
    while (1){
        struct dirent *vnew;
        size_t dsize;
        
        d = readdir(dp);
        if (!d) break;
        if (select != NULL && (*select)(d) == 0) continue;

        /* Ignore errors from select or readdir */
        errno = 0;

        if (__builtin_expect (i == vsize, 0)){
            struct dirent **new_;
            if (vsize == 0) vsize = 10;
            else vsize *= 2;
            new_ = (struct dirent **) realloc (v, vsize * sizeof (*v));
            if (new_ == NULL) break;
            v = new_;
        }

        dsize = &d->d_name[_D_ALLOC_NAMLEN (d)] - (char *) d;
        vnew = (struct dirent *) malloc (dsize);
        if (vnew == NULL) break;
        v[i++] = (struct dirent *) memcpy (vnew, d, dsize);
    }

    if (__builtin_expect (errno, 0) != 0)
    {
        save = errno;
        while (i > 0) free (v[--i]);
        free (v);
        i = -1;
    }
    else
    {
      /* Sort the list if we have a comparison function to sort with.  */
        if (cmp != NULL) qsort (v, i, sizeof (*v), cmp);
        *namelist = v;
    }

    closedir (dp);
    errno = save;
    return i;
}
                                                                                                                                     
int tucnak_alphasort(const void *a, const void *b)
{
  return strcoll ((*(const struct dirent **) a)->d_name,
                  (*(const struct dirent **) b)->d_name);
}
