/*
 * unity-webapps-binding-utils.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <glib.h>

#include <string.h>

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"
#include "npapi-headers/headers/npruntime.h"


bool
is_null_or_void (NPVariant variant)
{
  return NPVARIANT_IS_NULL(variant) || NPVARIANT_IS_VOID(variant);
}

gchar *
create_safe_string_for (const NPVariant * const pVariant)
{
  g_return_val_if_fail (NULL != pVariant, NULL);

  char * pSafeString = (gchar*)g_malloc0 (NPVARIANT_TO_STRING(*pVariant).UTF8Length + 1);
  g_strlcpy (pSafeString
	     , NPVARIANT_TO_STRING(*pVariant).UTF8Characters
	     , NPVARIANT_TO_STRING(*pVariant).UTF8Length + 1);

  return pSafeString;
}

gboolean
is_boolean_convertible_value (NPVariant variant)
{
  return NPVARIANT_IS_BOOLEAN(variant)
    || NPVARIANT_IS_INT32(variant)
    || NPVARIANT_IS_DOUBLE(variant);
}

gboolean
extract_boolean_value_from (NPVariant variant)
{
  // TODO mmh defaults to?
  gboolean value = false;
  if (! is_boolean_convertible_value(variant))
    {
      g_warning("Non boolean convertible NPAPI variant");
      return value;
    }

  if (NPVARIANT_IS_INT32(variant))
    {
      value = NPVARIANT_TO_INT32(variant) != 0;
    }
  else if (NPVARIANT_IS_BOOLEAN(variant))
    {
      value = NPVARIANT_TO_BOOLEAN(variant);
    }
  else
    {
      value = NPVARIANT_TO_DOUBLE(variant) != 0.0;
    }

  return value;
}
