/*
 * unity-webapps-binding.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_WEBAPPS_BINDING_UTILS_H)
#define UNITY_WEBAPPS_BINDING_UTILS_H

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/nptypes.h"

#define REACHED_UNITY_WEBAPPS_FUNC_CALL() \
    if (unity_webapps_binding_test_is_test_mode_on()) \
    { \
    unity_webapps_binding_test_reached_func_call ();    \
    return result;  \
    } \
    do {} while (false)

#define ADD_NPOBJECT_RETAIN_FOR_CONTEXT(npp,context,object) \
  if (! unity_webapps_binding_test_is_test_mode_on()) \
  { \
    unity_npapi_plugin_t * pPlugin = (unity_npapi_plugin_t *) npp->pdata; \
    if (NULL != pPlugin) \
      { \
        unity_npapi_add_retained_objects_for_context (pPlugin,context,object); \
      } \
  }

/**
 * Checks if a given NPVariant's value is fo null of voif "type"
 *
 */
bool
is_null_or_void (NPVariant variant);


/**
 * Extracts the string from a given NPVariant. The returned chunk
 * of memory needs to be freed.
 *
 * @return null terminated string or NULL (in case of error)
 */
gchar *
create_safe_string_for (const NPVariant * const pVariant);


/**
 * Checks is a given NPVariant is of a type "compatible" or
 * coertible to a boolean type. The criteria are pretty broad.
 *
 */
gboolean
is_boolean_convertible_value (NPVariant variant);


gboolean
extract_boolean_value_from (NPVariant variant);


#endif // UNITY_WEBAPPS_BINDING_UTILS_H
