/* i086-dos16.sys.h
   created from i086-dos16.sys.bin, 6986 (0x1b4a) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2013 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2013 Laszlo Molnar
   Copyright (C) 2000-2013 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I086_DOS16_SYS_SIZE    6986
#define STUB_I086_DOS16_SYS_ADLER32 0x06390a78
#define STUB_I086_DOS16_SYS_CRC32   0xf265794c

unsigned char stub_i086_dos16_sys[6986] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 148,  2,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  53,  0, 50,  0,255,255,255,255,  0,  0, 10,  0,  0,  0, 96, 80,
/* 0x0040 */  83, 81, 82, 86, 87, 85,190,  0,  0,191,  0,  0,137,241,  6, 30,
/* 0x0050 */   7,253,243,164,252,187,  0,128,135,247,131,238,  0, 25,237, 87,
/* 0x0060 */ 233,255,255, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,
/* 0x0070 */   0,  0,  0,  0,  0,  0,  0,  0, 45,164,232, 11,  0,114,250, 65,
/* 0x0080 */ 232,  6,  0,227, 21,227, 20,115,  6,131,233,  3,114,  6,136,204,
/* 0x0090 */ 172,247,208,149, 49,201,232,  6,  0, 17,201,117,  8, 65,232,  6,
/* 0x00a0 */   0,115,251, 65, 65, 65,129,253,  0,243,131,209,  1,141,  3,150,
/* 0x00b0 */ 243,164,150,235,  0,232,  2,  0, 17,201,  1,219,117,  4,173, 17,
/* 0x00c0 */ 192,147,195, 94,185,  0,  0,172, 44,232, 60,  1,119,249,193,  4,
/* 0x00d0 */   8, 41, 52,139, 28,134,223, 41,243,137, 28,173,226,  3,176,232,
/* 0x00e0 */ 176,233, 95,185,  0,  0,242,174,117, 20,117,  2,193,  5,  8, 41,
/* 0x00f0 */  61,139, 29,134,223, 41,251,137, 29,175,235,  3,  7, 97, 93, 95,
/* 0x0100 */  94, 90, 89, 91, 88,233,254,255,102,105,108,101, 32,102,111,114,
/* 0x0110 */ 109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10,
/* 0x0120 */  83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,
/* 0x0130 */ 109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,
/* 0x0140 */  32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x0150 */  76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,
/* 0x0160 */ 102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,
/* 0x0170 */  32, 32, 48, 32, 83, 89, 83, 77, 65, 73, 78, 49, 32, 32, 32, 32,
/* 0x0180 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48,
/* 0x0190 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x01a0 */  48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x01b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x01c0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 83, 89,
/* 0x01d0 */  83, 73, 50, 56, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x01e0 */  48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x01f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0200 */  51,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0210 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,
/* 0x0220 */  32, 83, 89, 83, 73, 48, 56, 54, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x0230 */  48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0240 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0250 */  48, 48, 48, 51,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x0260 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x0270 */  32, 32, 51, 32, 83, 89, 83, 77, 65, 73, 78, 50, 32, 32, 32, 32,
/* 0x0280 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 55, 32, 32, 48, 48, 48, 48,
/* 0x0290 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x02a0 */  48, 48, 48, 48, 48, 48, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x02b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x02c0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 83, 89,
/* 0x02d0 */  83, 83, 66, 66, 66, 80, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x02e0 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x02f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0300 */  53,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0310 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53,
/* 0x0320 */  32, 83, 89, 83, 67, 65, 76, 76, 84, 32, 32, 32, 32, 32, 32, 48,
/* 0x0330 */  48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0340 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0350 */  48, 48, 48, 53,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x0360 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x0370 */  32, 32, 54, 32, 83, 89, 83, 77, 65, 73, 78, 51, 32, 32, 32, 32,
/* 0x0380 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48,
/* 0x0390 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x03a0 */  48, 48, 48, 48, 48, 48, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x03b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x03c0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 85, 80,
/* 0x03d0 */  88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x03e0 */  48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x03f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0400 */  54, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0410 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56,
/* 0x0420 */  32, 83, 89, 83, 67, 85, 84, 80, 79, 32, 32, 32, 32, 32, 32, 48,
/* 0x0430 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0440 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0450 */  48, 48, 48, 55, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x0460 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x0470 */  32, 32, 57, 32, 78, 82, 86, 50, 66, 49, 54, 48, 32, 32, 32, 32,
/* 0x0480 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48,
/* 0x0490 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x04a0 */  48, 48, 48, 48, 48, 48, 55, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x04b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x04c0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 82,
/* 0x04d0 */  86, 68, 68, 79, 78, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x04e0 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x04f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0500 */  56, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0510 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x0520 */  78, 76, 89, 10, 32, 49, 49, 32, 78, 82, 86, 68, 82, 69, 84, 85,
/* 0x0530 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x0540 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0550 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 53, 32, 32, 50, 42,
/* 0x0560 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x0570 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x0580 */  50, 32, 78, 82, 86, 68, 69, 67, 79, 49, 32, 32, 32, 32, 32, 32,
/* 0x0590 */  48, 48, 48, 48, 48, 48, 49,101, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x05a0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x05b0 */  48, 48, 48, 48, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x05c0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x05d0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 82, 86, 76,
/* 0x05e0 */  69, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x05f0 */  48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0600 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 53,
/* 0x0610 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0620 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 78,
/* 0x0630 */  82, 86, 71, 84, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x0640 */  48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0650 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0660 */  48, 97, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x0670 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x0680 */  53, 32, 78, 82, 86, 68, 69, 67, 79, 50, 32, 32, 32, 32, 32, 32,
/* 0x0690 */  48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x06a0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x06b0 */  48, 48, 48, 48, 97,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x06c0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x06d0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 54, 32, 67, 65, 76, 76,
/* 0x06e0 */  84, 82, 49, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x06f0 */  48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0700 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 51,
/* 0x0710 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0720 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x0730 */  89, 10, 32, 49, 55, 32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 32,
/* 0x0740 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x0750 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0760 */  32, 32, 48, 48, 48, 48, 48, 48, 99,101, 32, 32, 50, 42, 42, 48,
/* 0x0770 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x0780 */  79, 78, 76, 89, 10, 32, 49, 56, 32, 67, 84, 49, 54, 83, 85, 66,
/* 0x0790 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x07a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x07b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 49, 32, 32, 50,
/* 0x07c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x07d0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 67, 84, 49, 54,
/* 0x07e0 */  73, 48, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x07f0 */  48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0800 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 51,
/* 0x0810 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0820 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 48, 32, 67,
/* 0x0830 */  65, 76, 76, 84, 82, 73, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x0840 */  48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0850 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0860 */  48,100, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x0870 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x0880 */  79, 78, 76, 89, 10, 32, 50, 49, 32, 67, 84, 49, 54, 69, 56, 48,
/* 0x0890 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x08a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x08b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100,101, 32, 32, 50,
/* 0x08c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x08d0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32, 67, 84, 49, 54,
/* 0x08e0 */  69, 57, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x08f0 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0900 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 48,
/* 0x0910 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0920 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 67,
/* 0x0930 */  65, 76, 76, 84, 82, 73, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x0940 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0950 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0960 */  48,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x0970 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x0980 */  79, 78, 76, 89, 10, 32, 50, 52, 32, 67, 84, 49, 54, 74, 69, 78,
/* 0x0990 */  68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x09a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x09b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 56, 32, 32, 50,
/* 0x09c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x09d0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x09e0 */  50, 53, 32, 67, 84, 49, 54, 74, 85, 76, 50, 32, 32, 32, 32, 32,
/* 0x09f0 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x0a00 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0a10 */  48, 48, 48, 48, 48,101, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0a20 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x0a30 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 67, 84, 49,
/* 0x0a40 */  54, 73, 50, 56, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x0a50 */  48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0a60 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101,
/* 0x0a70 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0a80 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32,
/* 0x0a90 */  67, 84, 49, 54, 83, 85, 66, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x0aa0 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ab0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x0ac0 */  48, 48,101,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x0ad0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x0ae0 */  50, 56, 32, 67, 84, 49, 54, 73, 48, 56, 55, 32, 32, 32, 32, 32,
/* 0x0af0 */  32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48,
/* 0x0b00 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0b10 */  48, 48, 48, 48, 48,102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0b20 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x0b30 */  89, 10, 32, 50, 57, 32, 67, 65, 76, 76, 84, 82, 73, 54, 32, 32,
/* 0x0b40 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x0b50 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0b60 */  32, 32, 48, 48, 48, 48, 48, 48,102, 57, 32, 32, 50, 42, 42, 48,
/* 0x0b70 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x0b80 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32,
/* 0x0b90 */  83, 89, 83, 77, 65, 73, 78, 53, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x0ba0 */  48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0bb0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x0bc0 */  48, 48,102, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x0bd0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x0be0 */  51, 49, 32, 83, 89, 83, 73, 50, 56, 54, 50, 32, 32, 32, 32, 32,
/* 0x0bf0 */  32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48,
/* 0x0c00 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0c10 */  48, 48, 48, 48, 48,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0c20 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x0c30 */  89, 10, 32, 51, 50, 32, 83, 89, 83, 73, 48, 56, 54, 50, 32, 32,
/* 0x0c40 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48,
/* 0x0c50 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c60 */  32, 32, 48, 48, 48, 48, 48, 48,102,101, 32, 32, 50, 42, 42, 48,
/* 0x0c70 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x0c80 */  79, 78, 76, 89, 10, 32, 51, 51, 32, 83, 89, 83, 74, 85, 77, 80,
/* 0x0c90 */  49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x0ca0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0cb0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 48, 53, 32, 32, 50,
/* 0x0cc0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0cd0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83,
/* 0x0ce0 */  89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48,
/* 0x0cf0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,
/* 0x0d00 */  83, 77, 65, 73, 78, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0d10 */  83, 89, 83, 77, 65, 73, 78, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d20 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 49,
/* 0x0d30 */  54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50,
/* 0x0d40 */  66, 49, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0d50 */  32, 32, 32,100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,  9, 48,
/* 0x0d60 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 69, 67, 79, 50,
/* 0x0d70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0d80 */  32, 32, 67, 65, 76, 76, 84, 82, 49, 54,  9, 48, 48, 48, 48, 48,
/* 0x0d90 */  48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 48, 48, 48,
/* 0x0da0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x0db0 */  76, 76, 84, 82, 73, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0dc0 */  67, 65, 76, 76, 84, 82, 73, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0dd0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x0de0 */  73, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76,
/* 0x0df0 */  84, 82, 73, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0e00 */  32, 32, 32,100, 32, 32, 83, 89, 83, 73, 50, 56, 54, 49,  9, 48,
/* 0x0e10 */  48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 73, 50, 56, 54, 49,
/* 0x0e20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0e30 */  32, 32, 83, 89, 83, 73, 48, 56, 54, 49,  9, 48, 48, 48, 48, 48,
/* 0x0e40 */  48, 48, 48, 32, 83, 89, 83, 73, 48, 56, 54, 49, 10, 48, 48, 48,
/* 0x0e50 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,
/* 0x0e60 */  83, 77, 65, 73, 78, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0e70 */  83, 89, 83, 77, 65, 73, 78, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0e80 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 83, 66, 66,
/* 0x0e90 */  66, 80,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 83,
/* 0x0ea0 */  66, 66, 66, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0eb0 */  32, 32, 32,100, 32, 32, 83, 89, 83, 67, 65, 76, 76, 84,  9, 48,
/* 0x0ec0 */  48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 67, 65, 76, 76, 84,
/* 0x0ed0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0ee0 */  32, 32, 83, 89, 83, 77, 65, 73, 78, 51,  9, 48, 48, 48, 48, 48,
/* 0x0ef0 */  48, 48, 48, 32, 83, 89, 83, 77, 65, 73, 78, 51, 10, 48, 48, 48,
/* 0x0f00 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80,
/* 0x0f10 */  88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0f20 */  85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f30 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 67, 85, 84,
/* 0x0f40 */  80, 79,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 67,
/* 0x0f50 */  85, 84, 80, 79, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0f60 */  32, 32, 32,100, 32, 32, 78, 82, 86, 68, 68, 79, 78, 69,  9, 48,
/* 0x0f70 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 68, 79, 78, 69,
/* 0x0f80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0f90 */  32, 32, 78, 82, 86, 68, 82, 69, 84, 85,  9, 48, 48, 48, 48, 48,
/* 0x0fa0 */  48, 48, 48, 32, 78, 82, 86, 68, 82, 69, 84, 85, 10, 48, 48, 48,
/* 0x0fb0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x0fc0 */  86, 68, 69, 67, 79, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0fd0 */  78, 82, 86, 68, 69, 67, 79, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0fe0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 76, 69, 68,
/* 0x0ff0 */  48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 76,
/* 0x1000 */  69, 68, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1010 */  32, 32, 32,100, 32, 32, 78, 82, 86, 71, 84, 68, 48, 48,  9, 48,
/* 0x1020 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 71, 84, 68, 48, 48,
/* 0x1030 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1040 */  32, 32, 67, 84, 49, 54, 73, 50, 56, 54,  9, 48, 48, 48, 48, 48,
/* 0x1050 */  48, 48, 48, 32, 67, 84, 49, 54, 73, 50, 56, 54, 10, 48, 48, 48,
/* 0x1060 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x1070 */  49, 54, 83, 85, 66, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1080 */  67, 84, 49, 54, 83, 85, 66, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1090 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 48,
/* 0x10a0 */  56, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,
/* 0x10b0 */  73, 48, 56, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x10c0 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 73, 50,  9, 48,
/* 0x10d0 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 73, 50,
/* 0x10e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x10f0 */  32, 32, 67, 84, 49, 54, 69, 56, 48, 48,  9, 48, 48, 48, 48, 48,
/* 0x1100 */  48, 48, 48, 32, 67, 84, 49, 54, 69, 56, 48, 48, 10, 48, 48, 48,
/* 0x1110 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x1120 */  49, 54, 69, 57, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1130 */  67, 84, 49, 54, 69, 57, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1140 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 74, 69,
/* 0x1150 */  78, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,
/* 0x1160 */  74, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1170 */  32, 32, 32,100, 32, 32, 67, 84, 49, 54, 74, 85, 76, 50,  9, 48,
/* 0x1180 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 74, 85, 76, 50,
/* 0x1190 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x11a0 */  32, 32, 67, 84, 49, 54, 73, 50, 56, 55,  9, 48, 48, 48, 48, 48,
/* 0x11b0 */  48, 48, 48, 32, 67, 84, 49, 54, 73, 50, 56, 55, 10, 48, 48, 48,
/* 0x11c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x11d0 */  49, 54, 83, 85, 66, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x11e0 */  67, 84, 49, 54, 83, 85, 66, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x11f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 48,
/* 0x1200 */  56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,
/* 0x1210 */  73, 48, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1220 */  32, 32, 32,100, 32, 32, 83, 89, 83, 77, 65, 73, 78, 53,  9, 48,
/* 0x1230 */  48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 77, 65, 73, 78, 53,
/* 0x1240 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1250 */  32, 32, 83, 89, 83, 73, 50, 56, 54, 50,  9, 48, 48, 48, 48, 48,
/* 0x1260 */  48, 48, 48, 32, 83, 89, 83, 73, 50, 56, 54, 50, 10, 48, 48, 48,
/* 0x1270 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,
/* 0x1280 */  83, 73, 48, 56, 54, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1290 */  83, 89, 83, 73, 48, 56, 54, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x12a0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 74, 85, 77,
/* 0x12b0 */  80, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 74,
/* 0x12c0 */  85, 77, 80, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x12d0 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x12e0 */  48, 48, 48, 48, 32, 97,116,116,114,105, 98,117,116,101, 10, 48,
/* 0x12f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1300 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,105,
/* 0x1310 */ 110,116,101,114,114,117,112,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1320 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x1330 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,112,121, 95,115,111,
/* 0x1340 */ 117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x1350 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x1360 */  48, 48, 48, 48, 32, 99,111,112,121, 95,100,101,115,116,105,110,
/* 0x1370 */  97,116,105,111,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1380 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x1390 */  48, 48, 48, 48, 48, 32,110,101,103, 95,101, 95,108,101,110, 10,
/* 0x13a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x13b0 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x13c0 */  99, 97,108,108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10,
/* 0x13d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x13e0 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x13f0 */ 111,114,105,103,105,110, 97,108, 95,115,116,114, 97,116,101,103,
/* 0x1400 */ 121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1410 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 77, 65,
/* 0x1420 */  73, 78, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x1430 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1440 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x1450 */  82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1460 */  32, 32, 97,116,116,114,105, 98,117,116,101, 10, 48, 48, 48, 48,
/* 0x1470 */  48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32,
/* 0x1480 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 77, 65, 73, 78, 49, 10,
/* 0x1490 */  48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 49,
/* 0x14a0 */  54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,105,110,116,101,114,
/* 0x14b0 */ 114,117,112,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x14c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89,
/* 0x14d0 */  83, 77, 65, 73, 78, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x14e0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x14f0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1500 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32,
/* 0x1510 */  32, 32, 32, 32, 32, 99,111,112,121, 95,115,111,117,114, 99,101,
/* 0x1520 */  10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95,
/* 0x1530 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121,
/* 0x1540 */  95,100,101,115,116,105,110, 97,116,105,111,110, 10, 48, 48, 48,
/* 0x1550 */  48, 48, 48, 49, 54, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32,
/* 0x1560 */  32, 32, 32, 32, 32, 32, 32, 32,110,101,103, 95,101, 95,108,101,
/* 0x1570 */ 110, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1580 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 77, 65,
/* 0x1590 */  73, 78, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x15a0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x15b0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x15c0 */  82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x15d0 */  32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 10, 82, 69, 76, 79,
/* 0x15e0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x15f0 */  79, 82, 32, 91, 78, 82, 86, 50, 66, 49, 54, 48, 93, 58, 10, 79,
/* 0x1600 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x1610 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x1620 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x1630 */  67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69,
/* 0x1640 */  67, 79, 50, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x1650 */  56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1660 */  82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1670 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1680 */  91, 78, 82, 86, 68, 68, 79, 78, 69, 93, 58, 10, 79, 70, 70, 83,
/* 0x1690 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x16a0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x16b0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x16c0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,
/* 0x16d0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x16e0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 82, 69,
/* 0x16f0 */  84, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x1700 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1710 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x1720 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1730 */  32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67,
/* 0x1740 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x1750 */  82, 32, 91, 78, 82, 86, 68, 69, 67, 79, 49, 93, 58, 10, 79, 70,
/* 0x1760 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1770 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1780 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x1790 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49,
/* 0x17a0 */  54, 48, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56,
/* 0x17b0 */  54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x17c0 */  86, 68, 69, 67, 79, 50, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32,
/* 0x17d0 */  82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x17e0 */  32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79,
/* 0x17f0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x1800 */  79, 82, 32, 91, 78, 82, 86, 68, 69, 67, 79, 50, 93, 58, 10, 79,
/* 0x1810 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x1820 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x1830 */  48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x1840 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x1850 */  49, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1860 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,
/* 0x1870 */  76, 84, 82, 49, 54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1880 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1890 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x18a0 */  50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x18b0 */  32, 32, 32, 32, 99, 97,108,108,116,114,105, 99,107, 95, 99, 97,
/* 0x18c0 */ 108,108,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x18d0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,
/* 0x18e0 */  76, 84, 82, 73, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x18f0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1900 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1910 */  50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x1920 */  32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 10, 82, 69,
/* 0x1930 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x1940 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 53, 93, 58,
/* 0x1950 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x1960 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x1970 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,
/* 0x1980 */  95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,108,
/* 0x1990 */ 108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10, 10, 82, 69,
/* 0x19a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x19b0 */  32, 70, 79, 82, 32, 91, 67, 84, 49, 54, 74, 69, 78, 68, 93, 58,
/* 0x19c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x19d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x19e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x19f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1a00 */  68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1a10 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,
/* 0x1a20 */  84, 49, 54, 74, 85, 76, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x1a30 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1a40 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x1a50 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x1a60 */  32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 73, 54, 10, 10,
/* 0x1a70 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x1a80 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 54,
/* 0x1a90 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x1aa0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x1ab0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x1ac0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,
/* 0x1ad0 */  65, 76, 76, 84, 82, 73, 53, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1ae0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1af0 */  91, 83, 89, 83, 74, 85, 77, 80, 49, 93, 58, 10, 79, 70, 70, 83,
/* 0x1b00 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b10 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1b20 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54,
/* 0x1b30 */  32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108,
/* 0x1b40 */  95,115,116,114, 97,116,101,103,121, 10
};
