/************************************************************************
 **
 **  @file   dialogheight.h
 **  @author Roman Telezhynskyi <dismine(at)gmail.com>
 **  @date   November 15, 2013
 **
 **  @brief
 **  @copyright
 **  This source code is part of the Valentina project, a pattern making
 **  program, whose allow create and modeling patterns of clothing.
 **  Copyright (C) 2013-2015 Valentina project
 **  <https://gitlab.com/smart-pattern/valentina> All Rights Reserved.
 **
 **  Valentina is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Valentina is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Valentina.  If not, see <http://www.gnu.org/licenses/>.
 **
 *************************************************************************/

#ifndef DIALOGHEIGHT_H
#define DIALOGHEIGHT_H

#include <qcompilerdetection.h>
#include <QMetaObject>
#include <QObject>
#include <QString>
#include <QtGlobal>

#include "../vmisc/def.h"
#include "dialogtool.h"

namespace Ui
{
    class DialogHeight;
}

/**
 * @brief The DialogHeight class dialog for ToolHeight. Help create point and edit option.
 */
class DialogHeight final : public DialogTool
{
    Q_OBJECT // NOLINT
public:
    DialogHeight(const VContainer *data, quint32 toolId, QWidget *parent = nullptr);
    ~DialogHeight() override;

    auto GetPointName() const -> QString;
    void SetPointName(const QString &value);

    auto GetTypeLine() const -> QString;
    void SetTypeLine(const QString &value);

    auto GetBasePointId() const -> quint32;
    void SetBasePointId(const quint32 &value);

    auto GetP1LineId() const -> quint32;
    void SetP1LineId(const quint32 &value);

    auto GetP2LineId() const -> quint32;
    void SetP2LineId(const quint32 &value);

    auto GetLineColor() const -> QString;
    void SetLineColor(const QString &value);

    void SetNotes(const QString &notes);
    auto GetNotes() const -> QString;
public slots:
    void ChosenObject(quint32 id, const SceneObject &type) override;
    void PointNameChanged() override;
protected:
    void ShowVisualization() override;
    /**
     * @brief SaveData Put dialog data in local variables
     */
    void SaveData() override;
    auto IsValid() const -> bool final;
private:
    Q_DISABLE_COPY_MOVE(DialogHeight) // NOLINT

    /** @brief ui keeps information about user interface */
    Ui::DialogHeight *ui;

    QString m_pointName{};

    bool m_flagError{true};
    bool m_flagName{true};

    /** @brief number number of handled objects */
    qint32 m_number{0};
};

//---------------------------------------------------------------------------------------------------------------------
inline auto DialogHeight::IsValid() const -> bool
{
    return m_flagError && m_flagName;
}

#endif // DIALOGHEIGHT_H
