#serial 1

# Find QT4 libraries either with pkg-config or as OS X frameworks

AC_DEFUN([VALKNUT_FIND_QT4],
[
  AC_ARG_ENABLE([frameworks],
    [AS_HELP_STRING([--enable-frameworks],[Use OS X frameworks for QT4 (default=disabled)])],
    [ USE_FRAMEWORKS="$enableval" ],
    [ USE_FRAMEWORKS="no" ]
  )
  AM_CONDITIONAL([USE_FRAMEWORKS], [test x$USE_FRAMEWORKS = "xyes"])
  
  AC_ARG_WITH([framework-dir],
    [AS_HELP_STRING([--with-framework-dir=DIR],[Specify the directory containing QtCore.framework (default=/Library/Frameworks)])],
    [ FRAMEWORK_DIR="$withval" ],
    [ FRAMEWORK_DIR="/Library/Frameworks" ]
  )
  AC_SUBST(FRAMEWORK_DIR)
  
  AC_MSG_CHECKING([how to find QT4 libraries])
  if test "x${USE_FRAMEWORKS}" = "xyes"
  then
    AC_MSG_RESULT([in OS X frameworks])
  else
    AC_MSG_RESULT([normal libraries])
  fi
  
  if test "x${USE_FRAMEWORKS}" = "xyes"
  then
    AC_MSG_NOTICE([Assuming QT >= 4.3 development frameworks are installed])
    
    QTCORE_LIBS="-Wl,-framework,CoreFoundation,-framework,QtCore"
    QTCORE_CFLAGS="-I${FRAMEWORK_DIR}/QtCore.framework/Versions/Current/Headers"
    
    QTGUI_LIBS="-Wl,-framework,QtGui"
    QTGUI_CFLAGS="-I${FRAMEWORK_DIR}/QtGui.framework/Versions/Current/Headers"
    
    QTNETWORK_LIBS="-Wl,-framework,QtNetwork"
    QTNETWORK_CFLAGS="-I${FRAMEWORK_DIR}/QtNetwork.framework/Versions/Current/Headers"
    
    QT3SUPPORT_LIBS="-Wl,-framework,Qt3Support"
    QT3SUPPORT_CFLAGS="-I${FRAMEWORK_DIR}/Qt3Support.framework/Versions/Current/Headers -DQT3_SUPPORT_WARNINGS"
  else
    PKG_CHECK_MODULES([QTCORE], [QtCore >= 4.3.0])
    PKG_CHECK_MODULES([QTGUI], [QtGui >= 4.3.0])
    PKG_CHECK_MODULES([QTNETWORK], [QtNetwork >= 4.3.0])
    PKG_CHECK_MODULES([QT3SUPPORT], [Qt3Support >= 4.3.0])
    QT3SUPPORT_CFLAGS="$QT3SUPPORT_CFLAGS -DQT3_SUPPORT_WARNINGS"
  fi
  
  AC_SUBST(QTCORE_LIBS)
  AC_SUBST(QTCORE_CFLAGS)
  AC_SUBST(QTGUI_LIBS)
  AC_SUBST(QTGUI_CFLAGS)
  AC_SUBST(QTNETWORK_LIBS)
  AC_SUBST(QTNETWORK_CFLAGS)
  AC_SUBST(QT3SUPPORT_LIBS)
  AC_SUBST(QT3SUPPORT_CFLAGS)
  
  ac_save_LIBS="$LIBS"
  ac_save_CPPFLAGS="$CPPFLAGS"
  
  AC_MSG_CHECKING([if the QtCore flags work])
  
  LIBS="$LIBS $QTCORE_LIBS"
  CPPFLAGS="$CPPFLAGS $QTCORE_CFLAGS"
  
  AC_LINK_IFELSE([AC_LANG_SOURCE(
[[
#include <QStringList>

int main()
{
	QStringList * list = new QStringList();
	delete list;
	return 0;
}
]]
)],
  [ AC_MSG_RESULT([yes]) ],
  [ AC_MSG_ERROR([no - the test QtCore program failed to link, check config.log for details]) ]
  )
  
  AC_MSG_CHECKING([if the QtGui flags work])
  
  LIBS="$LIBS $QTGUI_LIBS"
  CPPFLAGS="$CPPFLAGS $QTGUI_CFLAGS"
  
  AC_LINK_IFELSE([AC_LANG_SOURCE(
[[
#include <QDialog>

int main()
{
	QDialog * dialog = new QDialog();
	delete dialog;
	return 0;
}
]]
)],
  [ AC_MSG_RESULT([yes]) ],
  [ AC_MSG_ERROR([no - the test QtGui program failed to link, check config.log for details]) ]
  )
  
  AC_MSG_CHECKING([if the QtNetwork flags work])
  
  LIBS="$LIBS $QTNETWORK_LIBS"
  CPPFLAGS="$CPPFLAGS $QTNETWORK_CFLAGS"
  
  AC_LINK_IFELSE([AC_LANG_SOURCE(
[[
#include <QHttp>

int main()
{
	QHttp * http = new QHttp();
	delete http;
	return 0;
}
]]
)],
  [ AC_MSG_RESULT([yes]) ],
  [ AC_MSG_ERROR([no - the test QtNetwork program failed to link, check config.log for details]) ]
  )
  
  AC_MSG_CHECKING([if the Qt3Support flags work])
  
  LIBS="$LIBS $QT3SUPPORT_LIBS"
  CPPFLAGS="$CPPFLAGS $QT3SUPPORT_CFLAGS"
  
  AC_LINK_IFELSE([AC_LANG_SOURCE(
[[
#include <Q3ListView>

int main()
{
	Q3ListView * listview = new Q3ListView();
	delete listview;
	return 0;
}
]]
)],
  [ AC_MSG_RESULT([yes]) ],
  [ AC_MSG_ERROR([no - the test Qt3Support program failed to link, check config.log for details]) ]
  )
  
  LIBS="$ac_save_LIBS"
  CPPFLAGS="$ac_save_CPPFLAGS"
  
  dnl find QT4 programs
  
  if test "x${USE_FRAMEWORKS}" = "xyes"
  then
    QTPREFIX="/Developer/Tools"
  else
    QTPREFIX="`pkg-config --variable=prefix QtCore`/bin"
  fi
  
  AC_PATH_PROGS([UIC], [uic-qt4 uic], [], [$QTPREFIX:$PATH])
  AC_PATH_PROGS([MOC], [moc-qt4 moc], [], [$QTPREFIX:$PATH])
  AC_PATH_PROGS([LRELEASE], [lrelease-qt4 lrelease], [], [$QTPREFIX:$PATH])
  AC_PATH_PROGS([LUPDATE], [lupdate-qt4 lupdate], [], [$QTPREFIX:$PATH])
]
)
