/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb2/vdkb_image.h>
#include <vdk/FileDialog.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_fixed.h>
#include <vdkb2/vdkxpmbrowser.h>
#include "./pixmaps/apple.xpm"
#include "./pixmaps/copy.xpm"

/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBImage
// put here vdk class name string
#define VDK_CLASS "VDKImage"
// put here vdk class name 
#define VDK_ANCESTOR  VDKImage
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "image"
extern char* wi_widget_prompts[];
static char buff[256];

// used to autogenerate default
// labelbutton  names and captions

int CLASS::Counter = 0;
/* 
 label properties names
 */
char* vdkimage_props[] = { GLYPH,GLYPH_BYDATA, 0 };

//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////
/*
  - constructor
 */
// default pixmap
// defined in vdkb_local.cc 
extern char** default_pixmap;

CLASS::CLASS(char* name, VDKForm* owner,
				 char* pixfile):
  VDK_ANCESTOR(owner,pixfile,NULL,true),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties
  for(t=0; vdkimage_props[t]; t++)
    proplist.add(VDKBProperty(vdkimage_props[t]));
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  SetSize(20,20);
}

CLASS::CLASS(char* name, VDKForm* owner,
				 char** pixdata):
  VDK_ANCESTOR(owner,(const char**) pixdata,NULL,true),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties 
  for(t=0; vdkimage_props[t]; t++)
    proplist.add(VDKBProperty(vdkimage_props[t]));
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;", PROP_GLYPH,(char*) GetProp(GLYPH));
  fprintf(fp,"\n\t%s%s;", PROP_GLYPH_BYDATA,
	  (char*) GetProp(GLYPH_BYDATA));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* pixmap = NULL;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // creates a default pixmap
    pixmap = new CLASS(buff,owner,default_pixmap);
  return owner->AddToSelf(pixmap,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_glyph[128];
  char bydata[16];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  if(parser.GetParam(obj_glyph,buffer,PROP_GLYPH) && 
     strcmp(obj_glyph,NIHIL_PROP))
    ;
  else
    strcpy(obj_glyph,"");
  if(parser.GetParam(bydata,buffer,PROP_GLYPH_BYDATA) && 
     strcmp(bydata,NIHIL_PROP))
    ;
  else
    strcpy(bydata,"");

  // some cases...
  if(*obj_glyph)
    {
      if(strcmp(bydata,CHECK_YES))
	sprintf(tmp,"\n%s = new %s(this,%s%s%s);",
	      obj_name,VDK_CLASS,"\"", obj_glyph, "\"");
      else
	{
	  int z = 0;
	  char* local = new char[strlen(obj_glyph)+1], *p = NULL;
	  strcpy(local,obj_glyph);
	  sprintf(buff,"\n#include \"%s\"",local);
	  // refuses to include twice same file
	  VDKString symbol(local);
	  if(parser.decSymbols.find(symbol))
	    {
#if 0
	      printf("\nsymbol:%s already declared", (char*) symbol);
	      fflush(stdout);
#endif
	      strcpy(tmp,"");
	    }
	  else
	    {
	      strcpy(tmp,buff);
	      parser.decSymbols.add(symbol);
	    }
	  p = get_shortfilename(local);
	  // changes <.-> to _
	  if(!p)
	    p = local;
	  for(; p[z];z++)
	    {
	      if((p[z] == '.') || 
		 (p[z] == '-')
		 )
		p[z] = '_';
	    }
	  sprintf(buff,"\n%s = new %s(this,%s);",obj_name,VDK_CLASS, p);
	  strcat(tmp,buff);
	  delete [] local;
	}
      
    }
  else
    sprintf(tmp,"\n%s = new %s(this,%s);",
	    obj_name, VDK_CLASS, "(char*) NULL");

  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
		    char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_glyph[256];
  char bydata[16];
  //char arg[64];
  CLASS* pixmap;
// get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get glyph
  if(parser.GetParam(obj_glyph,buffer,PROP_GLYPH) && 
     strcmp(obj_glyph,NIHIL_PROP))
    ;
  else
      strcpy(obj_glyph,"");
  // get glyph by data
  if(parser.GetParam(bydata,buffer,PROP_GLYPH_BYDATA) && 
     strcmp(bydata,NIHIL_PROP))
    ;
  else
      strcpy(bydata,"");
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      if(*obj_glyph)
	pixmap = new CLASS(obj_name,owner,obj_glyph);
      else
	pixmap = new CLASS(obj_name,owner,default_pixmap);
      // glyph
      if(*obj_glyph)
	pixmap->SetPropValue(GLYPH,obj_glyph);
      // glyph by data
      if(*bydata)
	pixmap->SetPropValue(GLYPH_BYDATA,bydata);
      // pack widget to container
      return owner->PackToSelf(pixmap, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,h_box,shadow_etched_in);
  VDKTable *table = new VDKTable(inspector,2,2);
  // table->SetSize(219,-1);
  VDKBox* bbox = new VDKBox(inspector,h_box);
  VDKCustomButton* set = new VDKCustomButton(inspector,(const char**) apple_xpm, NULL);
  set->SetTip(_(wi_widget_prompts[7]));
  set->Relief = (GtkReliefStyle) 2;
  bbox->Add(set,l_justify,false,false,0);
  set->Parent(this);
  SignalConnect(set,"clicked",&CLASS::OnSetGlyph);

  VDKString s = GetProp(GLYPH);
  shortname = new VDKCustomButton(inspector,(const char**) copy_xpm,NULL);
  shortname->Relief = (GtkReliefStyle) 2;
  shortname->SetTip(_(wi_widget_prompts[9]));
  shortname->Enabled = strcmp((char*) s,NIHIL_PROP);
  bbox->Add(shortname,l_justify,false,false,0);
  shortname->Parent(this);
  SignalConnect(shortname,"clicked",&CLASS::OnSetShortName);
  table->AddToCell(bbox,0,0);


  pixfile = new VDKEntry(inspector,0,
			 !strcmp((char*) s,NIHIL_PROP) ? NULL : (char*) s);
  pixfile->SetSize(120,-1);
  pixfile->Editable = true;
  table->AddToCell(pixfile,0,1);
  pixfile->Parent(this);
  pixfile->SetTip(_("Enter \"nihil\" to reset assigned pixmap"));
  SignalConnect(pixfile,"activate",&CLASS::OnSetGlyph);

  s = GetProp(GLYPH_BYDATA);
  bydata = new VDKCheckButton(inspector,_(wi_widget_prompts[58]));
  bydata->SetTip(_(wi_widget_prompts[59]));
  table->AddToCell(bydata,1,0);
  bydata->Checked = !strcmp((char*) s, CHECK_YES);
  bydata->Parent(this);
  SignalConnect(bydata,"toggled",&CLASS::OnToggleBydata);

  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
//////////////////////////////////////////////////////
// These response methods actually change both 
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnToggleBydata(VDKObject*)
{
  SetPropValue(GLYPH_BYDATA, bydata->Checked ? CHECK_YES : CHECK_NO);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetGlyph(VDKObject* sender)
{
  char* pix = pixfile->Text;
  if(sender == pixfile)
    {
      if (!strcmp(pix,NIHIL_PROP))
	{
	  const char** file = (const char**) default_pixmap;
	  SetPropValue(GLYPH,pix);
	  SetImage(file);
	  inspector->FormNeedToBeChanged();
	  shortname->Enabled = false;
	}
    }
  else
    {
      FileStringArray selections;
      VDKXpmBrowser *child = new VDKXpmBrowser(Owner(),&selections,
					       _(file_dialog_prompts[0]));
      child->ShowModal();
      if(selections.size() > 0)
	{
	  SetImage((char*) selections[0]);
	  pixfile->Text = (char*) selections[0];
	  SetPropValue(GLYPH,(char*) selections[0]);
	  inspector->FormNeedToBeChanged();
	  shortname->Enabled = true;
	}
    }
  return true;
}
/*
 */
bool
CLASS::OnSetShortName(VDKObject*)
{
  VDKString s = GetProp(GLYPH);
  VDKString path;
  VDKBProject* project;
  VDKBProjectManager* prjman;
  if(!inspector)
    return true;
  prjman =  dynamic_cast<VDKBProjectManager*>(inspector->Owner());
  if(!prjman)
    return true;
  project = prjman->Project();
  if(!project)
    return true;
  path = project->Path;
  sprintf(buff,"cp %s %s/",(char*) s, (char*) path);
  system(buff);
  char* p = get_shortfilename((char*) s);
  if(p)
    {
      VDKString short_name = p;
      pixfile->Text = (char*) short_name;
      SetPropValue(GLYPH,(char*) short_name);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
