/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb2/vdkb_menuitem.h>
#include <vdkb2/vdkb_menu.h>
#include <vdk/FileDialog.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_menu.h>
#include <vdkb2/vdkxpmbrowser.h>
#include <vdkb2/vdkb_fixed.h>
#include "./pixmaps/apple.xpm"
#include "./pixmaps/copy.xpm"
extern char* wi_widget_prompts[];
static char buff[256];

// used to autogenerate default
// labelbutton  names and captions

int VDKBMenuItem::Counter = 0;
/*
 label properties names
 */
char* vdkmenuitem_props[] =
{
"Glyph","Caption","Checked",GLYPH_BYDATA,0
};
/*
menu item signals names && nicknames
Default response method name will be made by:
On<objectname><nickname>.
*/
char* vdkmenuitem_signals[] =
{
"activate_signal",0
};
char* vdkmenuitem_nicknames[] =
{
"Activate",0
};
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(VDKBMenuItem,VDKMenuItem);
DEFINE_EVENT_LIST(VDKBMenuItem,VDKMenuItem);
///////////////////////////////////////////////////
typedef struct  { VDKBMenuItem* vdkbmenuitem; VDKMenuItem* vdkmenuitem; } DelBoxInfo;

static void GlobalDelBox(GtkWidget* widget, gpointer gp)
{
  g_return_if_fail(widget != NULL);
  g_return_if_fail(gp != NULL);
  DelBoxInfo* info = reinterpret_cast<DelBoxInfo*>(gp);
  printf("\nGlobalDelBox()");
  fflush(stdout);
  info->vdkbmenuitem->DelBox(info->vdkmenuitem);
}
/*
 */
bool
VDKBMenuItem:: DelBox(VDKObject* sender)
{
  /*
    if(boxlist.size() > 0)
    boxlist[0]->Destroy();
  */
  VDKBEventContainer* container =
    dynamic_cast<VDKBEventContainer*>(Parent());
  //
  if(container)
    {
      container->boxlist.remove(this);
      container->RemoveObject(this);
      // if we are deleting last menu item
      // we delete menu container as well
      if(container->boxlist.size() <=0 &&
	 dynamic_cast<VDKBMenu*>(container)
	 )
	((VDKBMenu*) container)->DelBox(NULL);
      // notify to inspector that object was deleted
      // and set ownerform Active to NULL
      VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
      if(ownerform)
	{
	  ownerform->Active = NULL;
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    prjman->objInspector->SetActive(NULL);
	}
    }
  return true;
}

/*
 */
bool
VDKBMenuItem::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
      ownerform->SetBoxSize(NULL);
  return true;
}
/*
  - handle mouse button click
 */
bool
VDKBMenuItem::ButtonPressed(VDKObject* sender, GdkEvent* ev)
{
  VDKBProjectManager* prjman = NULL;
  GdkEventButton* event = (GdkEventButton*) ev;
  VDKBMenu* menu = dynamic_cast<VDKBMenu*>(Parent());
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());

  if(ownerform)
    prjman = dynamic_cast<VDKBProjectManager*>(ownerform->Owner());

  // activates widget
  if(ownerform && ownerform->Active)
    ownerform->Active->ClearMark();
  if(ownerform)
    ownerform->Active = this;
  Mark();
  /*
    parse button pressed
   */
  switch(event->button)
    {
      // right mouse button, as usual invokes inspector
      // and stops signal here
    case 3:
      /*
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(this);
      */
      popmenu->Popup();
      return true;

      // left mouse
      // if menu item does not contains a submenus
      // invokes inspector as usual and stop signal here.
    case 1:
      if(boxlist.size() <= 0)
	{
	  if(prjman && prjman->objInspector)
		prjman->objInspector->SetActive(menu ?  NULL : this);
	  return true;
	}
      // otherwise set inspector inactive (will be called
      // as modal dialog with pop menu)
      else if( prjman && prjman->objInspector)
	  prjman->objInspector->SetActive(NULL);
      // if parent menu is locked stop signal here
      // otherwise let it proceed to parent menu until gui form.
      return menu ? menu->Locked : false;
    }
  return false;
}
/*
OBSOLETE
 */
bool
VDKBMenuItem::UnlockMenu(VDKObject* sender)
{
  if(boxlist.size() > 0)
     ((VDKBMenu*)boxlist[0])->Locked = false;
  return true;
}
/*
OBSOLETE
 */
void
VDKBMenuItem::  InvokeMenuItemInspector()
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  /*
  printf("\ninvoking, owner:%p",ownerform);
  fflush(stdout);
  */
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	      dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(this);
      popmenu->Popup();
    }

}
/*
  - handle enter event
 */
bool
VDKBMenuItem::OnEnter(VDKObject* sender, GdkEvent* ev)
{
 return false;
}
/*
  - handle enter event
 */
bool
VDKBMenuItem::ButtonReleased(VDKObject* sender, GdkEvent* ev)
{
 return false;
}
/*
  - handle leave event
 */
bool
VDKBMenuItem::OnLeave(VDKObject* sender, GdkEvent* ev)
{
  /*
    important !!
    leave:    return true;
    here !!
    (obscure reason)
  */
  return true;
}
/*
A VDKBMenuItem can add only VDKBMenu
(this submnenus)
 */
void
VDKBMenuItem::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  VDKBMenu* menu = dynamic_cast<VDKBMenu*>(wid);
  if(menu)
    {
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(ObjectFromVDK()->WrappedWidget()),
				wid->WrappedWidget());
      boxlist.add(wid);
      items.add(wid);
      wid->Parent(this);
      wid->Setup();
      gtk_widget_show(wid->Widget());
    }
  else
    ; // FIX ME: warn user

}
/*
 */
bool
VDKBMenuItem::AddMenu(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(ObjectFromVDK()->Owner());
  if(!ownerform)
    return true;
  GtkMenu* thismenu = NULL;
  //  boxlist on menu item can have just on item
  if(boxlist.size() <= 0)
    {
      for(sprintf(buff,"Menu%d",VDKBMenu::Counter);
	  ownerform->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBMenu::Counter++)
	sprintf(buff,"Menu%d",VDKBMenu::Counter);
      VDKBMenu* menu = new VDKBMenu(buff,ownerform);
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(ObjectFromVDK()->WrappedWidget()),
				menu->WrappedWidget());
      ownerform->Changed = true;
      boxlist.add(menu);
      items.add(menu);
      menu->Parent(this);
      menu->Setup();
      ownerform->Active = menu;
      // add first menu item by default
      MakeWidget(ownerform);
      thismenu = GTK_MENU(menu->ObjectFromVDK()->Widget());
      ((VDKMenu*) menu->ObjectFromVDK())->Popup();
      SetTip(_("Double click to lock/unlock menu"));
    }
    else
	((VDKMenu*)boxlist[0])->Popup();
  return true;
}
/*
invokde modal object inspector
*/
bool
VDKBMenuItem::SetProperties(VDKObject*)
{
  VDKBProjectManager* prjman = NULL;
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  prjman = dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
  if(prjman)
    {
      // hides main WI
      if(prjman->objInspector)
	prjman->objInspector->Visible = false;
      VDKBObjectInspector* dlg = new VDKBObjectInspector(prjman,NULL);
      dlg->Setup();
      dlg->SetActive(this);
      dlg->ShowModal();
      // shows  main WI
      if(prjman->objInspector)
	prjman->objInspector->Visible = true;
    }
  return true;
}

//////////////////////////////////////////////////////////////
/*
  - constructor
 */
VDKBMenuItem::VDKBMenuItem(char* name, VDKForm* owner, char* prompt):
  VDKMenuItem(owner, prompt ? prompt : name),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list label button properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkmenuitem_props[t]; t++)
    proplist.add(VDKBProperty(vdkmenuitem_props[t]));
  if(prompt)
    SetPropValue("Caption",prompt);
  SetPropValue("Checked",CHECK_FALSE);
  // add to  signal list
  for(t=0; vdkmenuitem_signals[t]; t++)
    siglist.add(VDKBSignal(vdkmenuitem_signals[t],
			   this,
			   vdkmenuitem_nicknames[t]));
  // connects events.
  EventConnect("button_press_event",&VDKBMenuItem::ButtonPressed);
  // makes a pop menu
  popmenu = new VDKMenu(Owner());
  VDKMenuItem* unlock =  new VDKMenuItem(popmenu,"Nop");
  unlock->Enabled = false;
  popmenu->Separator();
  VDKMenuItem* addmenu = new VDKMenuItem(popmenu,_("Add a menu"));
  popmenu->Separator();
  VDKMenuItem* setsize = new VDKMenuItem(popmenu,_(wi_widget_prompts[19]));
  popmenu->Separator();
  VDKMenuItem* setprops = new VDKMenuItem(popmenu,_("Set properties"));
  VDKMenuItem* delBox = new VDKMenuItem(popmenu,_("Remove menu item"));  

  /*
  DelBoxInfo info;
  info.vdkbmenuitem = this;
  info.vdkmenuitem = delBox;
  gtk_signal_connect(GTK_OBJECT(delBox->WrappedWidget()),
		     "activate",
		     GTK_SIGNAL_FUNC(GlobalDelBox),
		     &info);
  */
  SignalConnect(delBox,"activate",&VDKBMenuItem::DelBox);
  SignalConnect(setsize,"activate",&VDKBMenuItem::SetBoxSize);
  SignalConnect(addmenu,"activate",&VDKBMenuItem::AddMenu);
  SignalConnect(setprops,"activate",&VDKBMenuItem::SetProperties);

  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
}

////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
VDKBMenuItem::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\tGlyph:%s;",(char*) GetProp("Glyph"));
  fprintf(fp,"\n\t%s%s;", PROP_GLYPH_BYDATA,
	  (char*) GetProp(GLYPH_BYDATA));
  fprintf(fp,"\n\tCaption:\"%s\";",(char*) GetProp("Caption"));
  fprintf(fp,"\n\tChecked:%s;",(char*) GetProp("Checked"));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
VDKBMenuItem::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  for(sprintf(buff,"MenuItem%d",VDKBMenuItem::Counter);
      owner->ChildWithName(buff)!= (VDKObject*) NULL;
      VDKBMenuItem::Counter++)
    sprintf(buff,"MenuItem%d",VDKBMenuItem::Counter);
  // a menu item can be added only to a menubar
  // or menu
  GdkEventButton* event = NULL;
  if(ev)
    event = (GdkEventButton*) ev;
  if(owner->Active)
    {
      VDKBMenubar* menubar = dynamic_cast<VDKBMenubar*>(owner->Active);
      if(menubar)
	{
	  VDKMenuItem* menuitem = new VDKBMenuItem(buff,owner);
	  menubar->AddWidget(menuitem, event ? event->state : 0);
	  return 0;
	}
      else
	{
	  VDKBMenu* menu = dynamic_cast<VDKBMenu*>(owner->Active);
	  if(menu)
	    {
	      VDKBMenuItem* menuitem = new VDKBMenuItem(buff,owner);
	      menu->AddWidget(menuitem, event ? event->state : 0);
	      return 0;
	    }
	  else
	    return 2;
	}
	return 2;
    }
  return 3;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
VDKBMenuItem::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_glyph[256];
  char bydata[16];
  char obj_caption[128];
  char obj_checked[16];
  VDKBMenuItem* menuitem;
// get name, and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // no parent widget , error
  if(!strcmp(obj_parent,NIHIL_PROP))
    return false;
  // get glyph
  if(parser.GetParam(obj_glyph,buffer,"Glyph:") &&
     strcmp(obj_glyph,NIHIL_PROP))
    ;
  else
      strcpy(obj_glyph,"");
  if(parser.GetParam(bydata,buffer,PROP_GLYPH_BYDATA) && 
     strcmp(bydata,NIHIL_PROP))
    ;
  else
    strcpy(bydata,"");
  // get caption
  if(parser.GetParam(obj_caption,buffer,"Caption:") &&
     strcmp(obj_caption,NIHIL_PROP))
    ;
  else
      strcpy(obj_caption,"");
  // get checked
  if(parser.GetParam(obj_checked,buffer,"Checked:") &&
     strcmp(obj_checked,NIHIL_PROP))
    ;
  else
      strcpy(obj_checked,"");
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      menuitem = new VDKBMenuItem(obj_name,owner);
      if(*obj_glyph)
	{
	  VDKRawPixmap* pix = new VDKRawPixmap(owner,obj_glyph);
	  menuitem->SetPixmap(pix);
	}
      if(*obj_caption)
	{
	  menuitem->SetPropValue("Caption",obj_caption);
	  menuitem->Caption = obj_caption;
	}
      if(*obj_checked)
	{
	  menuitem->SetPropValue("Checked",obj_checked);
	  menuitem->Checked = !strcmp(obj_checked,CHECK_TRUE);
	}
      /////////////////////////////////////////
      // call ancestor to set common properties
      VDKBObject::CreateWidget(menuitem,buffer,parser);
      // glyph
      if(*obj_glyph)
	menuitem->SetPropValue("Glyph",obj_glyph);
      // glyph by data
      if(*bydata)
	menuitem->SetPropValue(GLYPH_BYDATA,bydata);
      // prepares packing args based on those loaded by
      // VDKBObject::CreateWidget()
      int justification = l_justify;
      int expand=0,fill=0,padding=0;
      char* p = (char*)  menuitem->GetProp(JUSTIFY_INTERNAL);
      justification = atoi(p);
      p = (char*) menuitem->GetProp(EXPAND_INTERNAL);
      expand = atoi(p);
      p = (char*) menuitem->GetProp("_Fill");
      fill = atoi(p);
      p = (char*) menuitem->GetProp("_Padding");
      padding = atoi(p);
      // last arg make  AddWidget() to use packing args.
      // By default all new widgets are added to a form
      // with l_justify,false,false,false.
      // always append as l_justify since the order depends
      // on widget position into parent widget list
      container->AddWidget(menuitem,
			   l_justify, /*justification*/
			   expand,fill,padding,true);
      if(justification == r_justify)
	gtk_menu_item_right_justify(GTK_MENU_ITEM(menuitem->Widget()));
    }
  else
    return false;
return true;
}
/*
 */

char*
VDKBMenuItem::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_glyph[128];
  char bydata[16];
  char obj_caption[128];
  char obj_checked[16];
  *obj_glyph = '\0';
  // get name, and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  // no parent widget , error
  if(!strcmp(obj_parent,NIHIL_PROP))
    return NULL;
  source = new char[4096];
  *source = '\0';
  // check if it is a separator
  if(parser.GetParam(obj_caption,buffer,"Caption:") &&
     !strcmp(obj_caption,"@sep"))
    {
	sprintf(source,"\n%s->Separator();",obj_parent);
	return source;
    }
  bool nls_support = parser.CheckNLSSupport();
  sprintf(tmp,"\n%s = new VDKMenuItem(this,\"%s\",NULL);",
	  obj_name,obj_name);
  strcpy(source,tmp);

  if(parser.GetParam(obj_glyph,buffer,PROP_GLYPH) && 
     strcmp(obj_glyph,NIHIL_PROP))
    ;
  else
    strcpy(obj_glyph,"");
  if(parser.GetParam(bydata,buffer,PROP_GLYPH_BYDATA) && 
     strcmp(bydata,NIHIL_PROP))
    ;
  else
    strcpy(bydata,"");
    // some cases...
  if(*obj_glyph)
    {
      if(strcmp(bydata,CHECK_YES))
	  sprintf(tmp,
		  "\nVDKRawPixmap *%s_pix = new VDKRawPixmap(this,\"%s\");",
		  obj_name,obj_glyph);
      else
	{
	  int z = 0;
	  char* local = new char[strlen(obj_glyph)+1], *p = NULL;
	  strcpy(local,obj_glyph);
	  sprintf(buff,"\n#include \"%s\"",local);
	  // refuses to include twice same file
	  VDKString symbol(local);
	  if(parser.decSymbols.find(symbol))
	    {
#if 0
	      printf("\nsymbol:%s already declared", (char*) symbol);
	      fflush(stdout);
#endif
	      strcpy(tmp,"");
	    }
	  else
	    {
	      strcpy(tmp,buff);
	      parser.decSymbols.add(symbol);
	    }
	  p = get_shortfilename(local);
	  // changes <.-> to _
	  if(!p)
	    p = local;
	  for(; p[z];z++)
	    {
	      if((p[z] == '.') || 
		 (p[z] == '-')
		 )
		p[z] = '_';
	    }
	  sprintf(buff,
		  "\nVDKRawPixmap *%s_pix = new VDKRawPixmap(this,%s);",
		  obj_name,p);
	  strcat(tmp,buff);
	  delete [] local;
	}
      strcat(source,tmp);
      sprintf(tmp,"\n%s->SetPixmap(%s_pix);",obj_name,obj_name);
      strcat(source,tmp);      
    }
  /*
    // set glyph
    if(parser.GetParam(obj_glyph,buffer,"Glyph:") &&
    strcmp(obj_glyph,NIHIL_PROP))
    {
    sprintf(tmp,
    "\nVDKRawPixmap *%s_pix = new VDKRawPixmap(this,\"%s\");",
    obj_name,obj_glyph);
    strcat(source,tmp);
    sprintf(tmp,"\n%s->SetPixmap(%s_pix);",obj_name,obj_name);
    strcat(source,tmp);
    }
  */

  // get caption
  if(parser.GetParam(obj_caption,buffer,"Caption:") &&
     strcmp(obj_caption,NIHIL_PROP))
    {
      if(nls_support)
	sprintf(tmp,
		"\n%s->Caption = _(\"%s\");", obj_name,obj_caption);
      else
	sprintf(tmp,
	      "\n%s->Caption = \"%s\";", obj_name,obj_caption);
      strcat(source,tmp);
    }
  // get checked
  if(parser.GetParam(obj_checked,buffer,"Checked:") &&
     strcmp(obj_checked,NIHIL_PROP))
    {
      sprintf(tmp,
	     "\n%s->Checked = %s;", obj_name,obj_checked);
      strcat(source,tmp);
    }
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete props;
    }
  // prepares arguments to add widget to container
  // always append as l_justify since the order depends
  // on widget position into parent widget list
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(tmp,"\n%s->Add(%s,%s,%s,%s,%s);",
	      obj_parent,obj_name,
	      "l_justify" /*justify*/,
	      expand,fill,padding);
      strcat(source,tmp);
      // check if actually has to be right justified
      if(atoi(justify) == r_justify)
	{
	sprintf(tmp,
		"gtk_menu_item_right_justify(GTK_MENU_ITEM(%s->Widget()));",
		obj_name);
	strcat(source,tmp);
	}
    }
  else
    {
      sprintf(tmp,"\n%s->Add(%s);",
	      obj_parent,obj_name);
      strcat(source,tmp);
    }
  // visible property must be wrote after adding it to a parent
  // container. That's the reason why is written here and not
  // in vdkb_object class as should be.
  // written only if == false
  if(parser.GetParam(arg,buffer,PROP_VISIBLE) && !strcmp(arg,CHECK_FALSE))
   {
     sprintf(tmp,"\n%s->Visible = %s;",obj_name,arg);
     strcat(source,tmp);
   }
  return source;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer*
VDKBMenuItem::ExtraWidget(VDKBObjectInspector* isp)
{
  // FIX ME: lang support
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* vframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);

  VDKTable *table = new VDKTable(inspector,4,2);
  // table->SetSize(219,-1);
  VDKBox* hbox = new VDKBox(inspector,h_box);
  VDKCustomButton* set = new VDKCustomButton(inspector,(const char**) apple_xpm, NULL);
  set->Relief = (GtkReliefStyle) 2;
  set->SetTip(_(wi_widget_prompts[7]));
  hbox->Add(set,l_justify,false,false,0);
  set->Parent(this);
  SignalConnect(set,"clicked",&VDKBMenuItem::OnSetGlyph);
  shortname = new VDKCustomButton(inspector,(const char**) copy_xpm,NULL);
  shortname->Relief = (GtkReliefStyle) 2;
  shortname->SetTip(_(wi_widget_prompts[9]));
  VDKString s = GetProp("Glyph");
  shortname->Enabled = strcmp((char*) s,NIHIL_PROP);
  hbox->Add(shortname,l_justify,false,false,0);
  shortname->Parent(this);
  SignalConnect(shortname,"clicked",&VDKBMenuItem::OnSetShortName);
  table->AddToCell(hbox,0,0);

  pixfile = new VDKEntry(inspector,0,
			 !strcmp((char*) s,NIHIL_PROP) ? NULL : (char*) s);
  pixfile->SetSize(100,-1);
  pixfile->SetTip(_("Enter \"nihil\" to reset assigned pixmap"));
  table->AddToCell(pixfile,0,1);
  pixfile->Parent(this);
  SignalConnect(pixfile,"activate",&VDKBMenuItem::OnSetGlyph); 
  s = GetProp(GLYPH_BYDATA);

  bydata = new VDKCheckButton(inspector,_(wi_widget_prompts[58]));
  bydata->SetTip(_(wi_widget_prompts[59]));
  table->AddToCell(bydata,1,0);
  bydata->Checked = !strcmp((char*) s, CHECK_YES);
  bydata->Parent(this);
  SignalConnect(bydata,"toggled",&VDKBMenuItem::OnToggleBydata);
  checked = new VDKCheckButton(inspector,_(wi_widget_prompts[41]));
  checked->Checked = GetProp("Checked") == True;
  table->AddToCell(checked,1,1);
  checked->Parent(this);
  SignalConnect(checked,"toggled",&VDKBMenuItem::OnSetChecked);

  VDKLabel* label = new VDKLabel(inspector,_(wi_widget_prompts[0]));
  label->Justify = GTK_JUSTIFY_RIGHT;
  table->AddToCell(label,2,0);
  caption = new VDKEntry(inspector,0,(char*) GetProp("Caption"));
  caption->SetSize(100,-1);
  SignalConnect(caption,"activate",&VDKBMenuItem::OnSetCaption);
  table->AddToCell(caption,2,1);
  caption->Parent(this);

  vframe->Add(table,l_justify,false,false,false);

  return vframe;
}
//////////////////////////////////////////////////////
// These response methods actually change both
// properties on widget and gui widget properties
//////////////////////////////////////////////////////

/*
 */
bool
VDKBMenuItem::OnToggleBydata(VDKObject*)
{
  SetPropValue(GLYPH_BYDATA, bydata->Checked ? (char*) "yes" : 
	       (char*) "no");
  inspector->FormNeedToBeChanged();
  return true;
}


bool
VDKBMenuItem::RepackWidget(VDKObject*)
{
  /*
  printf("\nVDKBMenuItem::RepackWidget()");
  fflush(stdout);
  */
  return true;
}
/*
 */
bool
VDKBMenuItem::OnSetChecked(VDKObject*)
{
  bool flag =  checked->Checked;
  SetPropValue("Checked",flag ? CHECK_TRUE : CHECK_FALSE);
  Checked = flag;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
VDKBMenuItem::OnSetCaption(VDKObject*)
{
  if(strlen(caption->Text)>0)
    {
      sprintf(buff,"%s",(char*) caption->Text);
      SetPropValue("Caption",buff);
      Caption = caption->Text;
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
extern char** default_pixmap;
bool
VDKBMenuItem::OnSetGlyph(VDKObject* sender)
{
  char* pix = pixfile->Text;
  if(sender == pixfile)
    {
      if (!strcmp(pix,NIHIL_PROP))
	{
	  SetPropValue(GLYPH,pix);
	  SetPixmap(NULL);
	  inspector->FormNeedToBeChanged();
	}
    }
  else
    {
      FileStringArray selections;
      VDKXpmBrowser *child = new VDKXpmBrowser(Owner(),&selections,
					       _(file_dialog_prompts[0]));
      child->ShowModal();
      if(selections.size() > 0)
	{
	  VDKRawPixmap *newpix = new VDKRawPixmap(this,(char*) selections[0]);
	  SetPixmap(newpix);
	  pixfile->Text = (char*) selections[0];
	  SetPropValue(GLYPH,(char*) selections[0]);
	  inspector->FormNeedToBeChanged();
	  shortname->Enabled = true;
	}
    }
  return true;
}
/*
 */
bool
VDKBMenuItem::OnSetShortName(VDKObject*)
{
  VDKString s = GetProp(GLYPH);
  VDKString path;
  VDKBProject* project;
  VDKBProjectManager* prjman;
  if(!inspector)
    return true;
  prjman =  dynamic_cast<VDKBProjectManager*>(inspector->Owner());
  if(!prjman)
    return true;
  project = prjman->Project();
  if(!project)
    return true;
  path = project->Path;
  sprintf(buff,"cp %s %s/",(char*) s, (char*) path);
  system(buff);
  char* p = get_shortfilename((char*) s);
  if(p)
    {
      VDKString short_name = p;
      pixfile->Text = (char*) short_name;
      SetPropValue(GLYPH,(char*) short_name);
      shortname->Enabled = false;
      inspector->FormNeedToBeChanged();
    }
  return true;
}







