/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import spec.jbb.JBButil;

class SaveOutput
extends PrintStream {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    static OutputStream logfile;
    static PrintStream oldStdout;
    static PrintStream oldStderr;

    SaveOutput(PrintStream printStream) {
        super(printStream);
    }

    public static void start(String string) throws IOException {
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
        System.setOut(new SaveOutput(System.out));
        System.setErr(new SaveOutput(System.err));
    }

    public static void stop() {
        System.setOut(oldStdout);
        System.setErr(oldStderr);
        try {
            logfile.close();
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Exception: " + exception.getMessage(), exception);
        }
    }

    public void write(int n) {
        try {
            logfile.write(n);
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Exception: " + exception.getMessage(), exception);
            this.setError();
        }
        super.write(n);
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            logfile.write(byArray, n, n2);
        }
        catch (Exception exception) {
            JBButil.getLog().log(Level.WARNING, "Exception: " + exception.getMessage(), exception);
            this.setError();
        }
        super.write(byArray, n, n2);
    }
}

