/*-------------------------------------------------------------------------*\

	FILE........: DTMFCOMM.H
	TYPE........: C Header File
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 21/10/96

	Constants common to the DTMF decoder modules.

\*-------------------------------------------------------------------------*/

#ifndef __DTMFCOMM__
#define __DTMFCOMM__

/* General defines */

#define NDTMF 		120	/* number of samples in DTMF frame	*/

/* DTMF return codes ---------------------------------------------------*/

#define DTMF_VALID	 0	/* vaid tone pair decoded, key returned	*/
#define DTMF_BUF	-1	/* buffer not full yet			*/
#define DTMF_LEVLO	-2	/* signal level too low			*/
#define DTMF_FWDTWST	-3	/* low tone level greater than high	*/
#define DTMF_REVTWST	-4	/* high tone level greater than low	*/
#define DTMF_FRMHALF1	-7	/* frame half 2 > frame half 1		*/
#define DTMF_FRMHALF2	-8	/* frame half 1 > frames half 2		*/
#define DTMF_ETONES	-9	/* E in tones not equal to Ey in frame	*/

#endif
