#!/bin/sh

echo 'Format.eprintf "%s@." (Sys.getcwd());;' | ocaml 1>/dev/null 2> /tmp/regtests.cwd

DIR=`cat /tmp/regtests.cwd`
rm -f /tmp/regtests.cwd
LIBDIR=`grep "libdir" $DIR/src/version.ml | sed -e 's|[^"]*"\([^"]*\)"[^"]*|\1|g' | head -n 1`
LANG=

echofilename () {
  echo "========== file $1 =========="
}

mycat() {
  echofilename $1
  sed -e "s|jessie_[0-9]\+|jessie_<num>|g" $1
}

mycatfilterdir () {
  echofilename $1
  sed -e "s|$DIR|HOME|g" -e "s|$LIBDIR|WHYLIB|g" $1
}

case $1 in
  *.java)
        d=`dirname $1`
	b=`basename $1 .java`
        f=$d/$b
	mycat $f.java
	echo "========== krakatoa execution =========="
	rm -f $f.jc
	rm -f $f.jloc
	opt=""
	if grep JAVACARD $f.java ; then
	    opt=-javacard
	fi
	KRAKATOALIB=$DIR/lib bin/krakatoa.opt -gen-only $opt $1 || exit 1
	mycat $f.jc
	mycatfilterdir $f.jloc
	echo "========== jessie execution =========="
	rm -f $f.makefile
	rm -f $d/why/$b.why
	rm -f $f.loc
	WHYLIB=$DIR/lib bin/jessie.opt -locs $f.jloc -why-opt -split-user-conj $f.jc || exit 2
	mycatfilterdir $f.makefile
	mycatfilterdir $f.loc
	mycat $d/why/$b.why
	;;
  *.c)
        d=`dirname $1`
	b=`basename $1 .c`
        j=$d/$b.jessie
        f=$j/$b
	mycat $1
	echo "========== frama-c -jessie execution =========="
	rm -f $f.jc
	rm -f $f.cloc
	FRAMAC_PLUGIN=$DIR/frama-c-plugin frama-c -jessie -jessie-gen-only $1 || exit 1
	mycat $f.jc
	mycatfilterdir $f.cloc
	echo "========== jessie execution =========="
	rm -f $f.makefile
	rm -f $j/why/$b.why
	rm -f $f.loc
	WHYLIB=$DIR/lib bin/jessie.opt -locs $f.cloc -why-opt -split-user-conj $f.jc || exit 2
	mycatfilterdir $f.makefile
	mycatfilterdir $f.loc
	mycat $j/why/$b.why
	;;
  *)
	echo "don't know what to do with $1"
	exit 1
esac
