/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim;

import fr.ove.openmath.jome.ctrlview.bidim.DisplayableImpl;
import fr.ove.openmath.jome.ctrlview.bidim.GraphicContext;
import fr.ove.openmath.jome.ctrlview.bidim.images.ImageLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class ImageSymbol
extends DisplayableImpl {
    private String imgId;
    private Image symbolInit;
    private Image symbol;
    private ImageObserver observer;
    private Insets insets = new Insets(0, 0, 0, 0);

    public ImageSymbol(String string, ImageObserver imageObserver) {
        this.symbolInit = ImageLoader.getImage(string);
        this.observer = imageObserver;
        this.imgId = string;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        super.setGraphicContext(graphicContext);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphicContext.getFont());
        float f = ImageLoader.getHeightFactor(this.imgId);
        int n = fontMetrics.getHeight();
        this.insets.top = Math.round(ImageLoader.getTopInset(this.imgId) * (float)n);
        this.insets.bottom = Math.round(ImageLoader.getBottomInset(this.imgId) * (float)n);
        this.insets.left = Math.round(ImageLoader.getLeftInset(this.imgId) * (float)n);
        this.insets.right = Math.round(ImageLoader.getRightInset(this.imgId) * (float)n);
        this.setHeight(Math.round((float)n * f + (float)this.insets.top + (float)this.insets.bottom));
        float f2 = ImageLoader.getBaseline(this.imgId);
        int n2 = f2 == -1.0f ? Math.round((float)fontMetrics.getAscent() * f) : Math.round((float)n * f * f2);
        this.setAscent(n2 + this.insets.top);
        this.setDescent(this.getHeight() - n2);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.symbol, this.insets.left, this.insets.top, this.observer);
    }

    public Dimension getPreferredSize() {
        MediaTracker mediaTracker = new MediaTracker((Component)this.observer);
        this.symbol = this.symbolInit.getScaledInstance(-1, this.getHeight() - this.insets.top - this.insets.bottom, 4);
        mediaTracker.addImage(this.symbol, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.print(interruptedException.toString());
        }
        mediaTracker.removeImage(this.symbol);
        return new Dimension(this.symbol.getWidth(this.observer) + this.insets.left + this.insets.right, this.getHeight());
    }

    public Image getSymbol() {
        return this.symbol;
    }
}

