/*
 *========================================================================
 * $Id: get_proc_version.c 163 2005-09-14 22:54:20Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "xmlsysd.h"

/*
 * This routine parses /proc/stat and packs its values into doc.
 */

void get_proc_version(xmlNodePtr proc)
{

 int i,numfields;
 struct timeval tv;
 xmlNodePtr version;

 if(verbose==102){
   fprintf(stderr,"Starting get_proc_version().\n");
 }

 /* 
  * Now, for a clever trick.  We RESET the files without actually
  * closing or reopening them.  This should save the overhead of
  * an open/close (presumed relatively large, as one has to 
  * allocate/free certain kernel structures and meminfo the file in question 
  * on EACH open/close).
  */

 /* PROC_VERSION */
 errno = 2;
 if(stat_fd[PROC_VERSION]){
   rewind(stat_fd[PROC_VERSION]);	/* void, so tough to check errors */
 }
 if(errno == EBADF){
   fprintf(stderr,"Error: The %s file descriptor/stream is not seekable.\n",procpaths[PROC_VERSION]);
   fclose(stat_fd[PROC_VERSION]); 
   fprintf(stderr,"Closing and reopening %s.\n",procpaths[PROC_VERSION]);
   stat_fd[PROC_VERSION] = fopen(procpaths[PROC_VERSION],"r");
 }

 if(verbose == 102){
   fprintf(stderr,"Rewound %s.\n",procpaths[PROC_VERSION]);
 }

 while(TRUE){

   /* Normal EOF causes break from while loop */
   if((fgets(statbuf,K,stat_fd[PROC_VERSION]) == NULL)) break;

   if(verbose == 102){
     fprintf(stderr,"Parsing %s\n",statbuf);
   }

   /* parse the line into fields */
   numfields = parse(statbuf,fields,MAXFIELDNUMBER,K);

   /*
    * Now we go down a simple lookup table to assemble each statistic
    * by name.  fields[] now contains the parsed fields from a line of
    * /proc/meminfo.  We identify the line by its first entry (the name
    * of the /proc/meminfo entity) and use the following values to build 
    * one or more statistics.
    */

   /* Just want 3rd field (version number) */
   version = xmlNewChild(proc,NULL,(xmlChar*) "version",(xmlChar*) fields[2]);

 }

}

