/* window.c generated by valac 0.10.1, the Vala compiler
 * generated from window.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  TODO:
 *  - Follow GNOME bug #551184 to change accelerators hexa values
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
typedef struct _XnpWindowPrivate XnpWindowPrivate;

#define XNP_TYPE_ICON_BUTTON (xnp_icon_button_get_type ())
#define XNP_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButton))
#define XNP_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))
#define XNP_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_ICON_BUTTON))
#define XNP_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_ICON_BUTTON))
#define XNP_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))

typedef struct _XnpIconButton XnpIconButton;
typedef struct _XnpIconButtonClass XnpIconButtonClass;

#define XNP_TYPE_TITLE_BAR_BUTTON (xnp_title_bar_button_get_type ())
#define XNP_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton))
#define XNP_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))
#define XNP_IS_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_IS_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_TITLE_BAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))

typedef struct _XnpTitleBarButton XnpTitleBarButton;
typedef struct _XnpTitleBarButtonClass XnpTitleBarButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gdk_cursor_unref0(var) ((var == NULL) ? NULL : (var = (gdk_cursor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define XNP_TYPE_TITLE_BAR_BUTTON_TYPE (xnp_title_bar_button_type_get_type ())

#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;

struct _XnpWindow {
	GtkWindow parent_instance;
	XnpWindowPrivate * priv;
};

struct _XnpWindowClass {
	GtkWindowClass parent_class;
};

struct _XnpWindowPrivate {
	gint width;
	gint height;
	GtkMenu* menu;
	GtkCheckMenuItem* mi_above;
	GtkCheckMenuItem* mi_sticky;
	GtkImage* menu_image;
	GdkPixbuf* menu_pixbuf;
	GdkPixbuf* menu_hover_pixbuf;
	GtkLabel* title_label;
	XnpTitleBarButton* left_arrow_button;
	XnpTitleBarButton* right_arrow_button;
	XnpTitleBarButton* close_button;
	GtkVBox* content_box;
	GtkNotebook* notebook;
	GtkUIManager* ui;
	GtkActionGroup* action_group;
	gint CORNER_MARGIN;
	GdkCursor* CURSOR_RIGHT;
	GdkCursor* CURSOR_LEFT;
	GdkCursor* CURSOR_BOTTOM_RC;
	GdkCursor* CURSOR_BOTTOM;
	GdkCursor* CURSOR_BOTTOM_LC;
	GSList* window_list;
	char* _name;
	gint _n_pages;
	gint _tabs_position;
	gboolean _above;
	gboolean _sticky;
};

typedef enum  {
	XNP_TITLE_BAR_BUTTON_TYPE_EMPTY,
	XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_CLOSE
} XnpTitleBarButtonType;

struct _XnpNote {
	GtkBin parent_instance;
	XnpNotePrivate * priv;
	GtkScrolledWindow* scrolled_window;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkBinClass parent_class;
};


static gpointer xnp_window_parent_class = NULL;

GType xnp_window_get_type (void) G_GNUC_CONST;
GType xnp_icon_button_get_type (void) G_GNUC_CONST;
GType xnp_title_bar_button_get_type (void) G_GNUC_CONST;
#define XNP_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_WINDOW, XnpWindowPrivate))
enum  {
	XNP_WINDOW_DUMMY_PROPERTY,
	XNP_WINDOW_NAME,
	XNP_WINDOW_N_PAGES,
	XNP_WINDOW_SHOW_TABS,
	XNP_WINDOW_TABS_POSITION,
	XNP_WINDOW_ABOVE,
	XNP_WINDOW_STICKY
};
#define XNP_WINDOW_ui_string "\n" \
"<ui>\n" \
"  <accelerator action=\"close-window\" />\n" \
"  <accelerator action=\"new-window\" />\n" \
"  <accelerator action=\"delete-window\" />\n" \
"  <accelerator action=\"rename-window\" />\n" \
"  <accelerator action=\"new-note\" />\n" \
"  <accelerator action=\"delete-note\" />\n" \
"  <accelerator action=\"rename-note\" />\n" \
"  <accelerator action=\"cancel\" />\n" \
"  <accelerator action=\"next-note\" />\n" \
"  <accelerator action=\"prev-note\" />\n" \
"</ui>\n"
void xnp_window_hide (XnpWindow* self);
static void _xnp_window_hide_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_new_window (XnpWindow* self);
static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_delete_window (XnpWindow* self);
static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_rename_window (XnpWindow* self);
static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_new_note (XnpWindow* self);
static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_delete_note (XnpWindow* self);
static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_rename_note (XnpWindow* self);
static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_cancel (XnpWindow* self);
static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_next_note (XnpWindow* self);
static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_prev_note (XnpWindow* self);
static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action, gpointer self);
XnpWindow* xnp_window_new (void);
XnpWindow* xnp_window_construct (GType object_type);
static GtkMenu* xnp_window_build_menu (XnpWindow* self);
static gboolean _lambda8_ (XnpWindow* self);
static gboolean __lambda8__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda9_ (XnpWindow* self);
static gboolean __lambda9__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
GType xnp_title_bar_button_type_get_type (void) G_GNUC_CONST;
XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type);
XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type, XnpTitleBarButtonType icon_type);
static gboolean xnp_window_menu_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static void _xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static void _lambda10_ (XnpWindow* self);
static void __lambda10__xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static gboolean _lambda11_ (XnpWindow* self);
static gboolean __lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static gboolean _lambda12_ (XnpWindow* self);
static void xnp_window_update_navigation_sensitivity (XnpWindow* self, gint page_num);
static gboolean __lambda12__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _lambda13_ (XnpWindow* self);
static gboolean __lambda13__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean xnp_window_window_leaved_cb (XnpWindow* self);
static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean xnp_window_window_motion_cb (XnpWindow* self, GdkEventMotion* event);
static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean xnp_window_window_pressed_cb (XnpWindow* self, GdkEventButton* event);
static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean xnp_window_window_state_cb (XnpWindow* self, GdkEventWindowState* event);
static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self, GtkWidget* widget, GdkEventScroll* event);
static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void _lambda14_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self);
static void __lambda14__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda15_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self);
static void __lambda15__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void _lambda16_ (GtkNotebook* n, GtkNotebookPage* c, guint p, XnpWindow* self);
GType xnp_note_get_type (void) G_GNUC_CONST;
static void xnp_window_update_title (XnpWindow* self, const char* note_name);
const char* xnp_note_get_name (XnpNote* self);
static void __lambda16__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self);
static void _lambda17_ (XnpWindow* self);
static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda18_ (XnpWindow* self);
static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void xnp_window_unshade (XnpWindow* self);
gboolean xnp_window_get_above (XnpWindow* self);
void xnp_window_set_sticky (XnpWindow* self, gboolean value);
static void xnp_window_shade (XnpWindow* self);
static void xnp_window_note_notify_name_cb (XnpWindow* self, GObject* object, GParamSpec* pspec);
static void _xnp_window_notebook_update_tabs_angle (XnpWindow* self);
XnpNote* xnp_window_insert_note (XnpWindow* self);
void xnp_window_delete_current_note (XnpWindow* self);
void xnp_window_rename_current_note (XnpWindow* self);
GType xnp_hypertext_view_get_type (void) G_GNUC_CONST;
void xnp_hypertext_view_undo (XnpHypertextView* self);
static void xnp_window_menu_position (XnpWindow* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void xnp_window_update_menu_go (XnpWindow* self, GtkWidget* widget);
static void _xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda4_ (GtkCheckMenuItem* o, XnpWindow* self);
void xnp_window_set_above (XnpWindow* self, gboolean value);
static void __lambda4__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
gboolean xnp_window_get_sticky (XnpWindow* self);
static void _lambda5_ (GtkCheckMenuItem* o, XnpWindow* self);
static void __lambda5__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda6_ (XnpWindow* self);
static void __lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda7_ (XnpWindow* self);
static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda1_ (GtkWidget* w, XnpWindow* self);
static void __lambda1__gtk_callback (GtkWidget* widget, gpointer self);
const char* xnp_window_get_name (XnpWindow* self);
static void _lambda2_ (GtkMenuItem* i, XnpWindow* self);
static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda3_ (GtkMenuItem* i, XnpWindow* self);
static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height);
void xnp_window_set_window_list (XnpWindow* self, GSList* list);
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2);
gint xnp_window_get_current_page (XnpWindow* self);
void xnp_window_set_current_page (XnpWindow* self, gint page);
static gboolean xnp_window_note_name_exists (XnpWindow* self, const char* name);
XnpNote* xnp_note_new (const char* name);
XnpNote* xnp_note_construct (GType object_type, const char* name);
static void _xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda0_ (XnpNote* note, XnpWindow* self);
static void __lambda0__xnp_note_save_data (XnpNote* _sender, gpointer self);
gint xnp_window_get_n_pages (XnpWindow* self);
void xnp_window_set_n_pages (XnpWindow* self, gint value);
void xnp_note_set_name (XnpNote* self, const char* value);
void xnp_window_move_note (XnpWindow* self, const char* note_name, gint page);
char** xnp_window_get_note_names (XnpWindow* self, int* result_length1);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
void xnp_window_delete_note (XnpWindow* self, gint page);
void xnp_window_set_font (XnpWindow* self);
const char* xnp_hypertext_view_get_font (XnpHypertextView* self);
void xnp_hypertext_view_set_font (XnpHypertextView* self, const char* value);
void xnp_window_save_notes (XnpWindow* self);
gboolean xnp_note_get_dirty (XnpNote* self);
void xnp_note_set_dirty (XnpNote* self, gboolean value);
void xnp_window_set_name (XnpWindow* self, const char* value);
gboolean xnp_window_get_show_tabs (XnpWindow* self);
void xnp_window_set_show_tabs (XnpWindow* self, gboolean value);
gint xnp_window_get_tabs_position (XnpWindow* self);
void xnp_window_set_tabs_position (XnpWindow* self, gint value);
static GObject * xnp_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xnp_window_finalize (GObject* obj);
static void xnp_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xnp_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkActionEntry XNP_WINDOW_action_entries[10] = {{"close-window", NULL, NULL, "Escape", NULL, (GCallback) _xnp_window_hide_gtk_action_callback}, {"new-window", NULL, NULL, "<Ctrl><Shift>n", NULL, (GCallback) _xnp_window_action_new_window_gtk_action_callback}, {"delete-window", NULL, NULL, "<Ctrl><Shift>w", NULL, (GCallback) _xnp_window_action_delete_window_gtk_action_callback}, {"rename-window", NULL, NULL, "<Shift>F2", NULL, (GCallback) _xnp_window_action_rename_window_gtk_action_callback}, {"new-note", NULL, NULL, "<Ctrl>n", NULL, (GCallback) _xnp_window_action_new_note_gtk_action_callback}, {"delete-note", NULL, NULL, "<Ctrl>w", NULL, (GCallback) _xnp_window_action_delete_note_gtk_action_callback}, {"rename-note", NULL, NULL, "F2", NULL, (GCallback) _xnp_window_action_rename_note_gtk_action_callback}, {"cancel", NULL, NULL, "<Ctrl>z", NULL, (GCallback) _xnp_window_action_cancel_gtk_action_callback}, {"next-note", NULL, NULL, "<Ctrl>Page_Down", NULL, (GCallback) _xnp_window_action_next_note_gtk_action_callback}, {"prev-note", NULL, NULL, "<Ctrl>Page_Up", NULL, (GCallback) _xnp_window_action_prev_note_gtk_action_callback}};

static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void _xnp_window_hide_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_hide (self);
}


static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_new_window (self);
}


static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_delete_window (self);
}


static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_rename_window (self);
}


static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_rename_note (self);
}


static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_cancel (self);
}


static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_next_note (self);
}


static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_prev_note (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda8_ (XnpWindow* self) {
	gboolean result = FALSE;
	gtk_image_set_from_pixbuf (self->priv->menu_image, self->priv->menu_hover_pixbuf);
	result = FALSE;
	return result;
}


static gboolean __lambda8__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda8_ (self);
	return result;
}


static gboolean _lambda9_ (XnpWindow* self) {
	gboolean result = FALSE;
	gtk_image_set_from_pixbuf (self->priv->menu_image, self->priv->menu_pixbuf);
	result = FALSE;
	return result;
}


static gboolean __lambda9__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda9_ (self);
	return result;
}


static gboolean _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_window_menu_evbox_pressed_cb (self, _sender, event);
	return result;
}


static void _xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	xnp_window_action_prev_note (self);
}


static void _xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	xnp_window_action_next_note (self);
}


static void _lambda10_ (XnpWindow* self) {
	xnp_window_hide (self);
}


static void __lambda10__xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	_lambda10_ (self);
}


static gboolean _lambda11_ (XnpWindow* self) {
	gboolean result = FALSE;
	xnp_window_hide (self);
	result = TRUE;
	return result;
}


static gboolean __lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


static gboolean _lambda12_ (XnpWindow* self) {
	gboolean result = FALSE;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->menu_image, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_label, TRUE);
	xnp_window_update_navigation_sensitivity (self, gtk_notebook_get_current_page (self->priv->notebook));
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->close_button, TRUE);
	result = FALSE;
	return result;
}


static gboolean __lambda12__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


static gboolean _lambda13_ (XnpWindow* self) {
	gboolean result = FALSE;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->menu_image, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_label, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->left_arrow_button, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->right_arrow_button, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->close_button, FALSE);
	result = FALSE;
	return result;
}


static gboolean __lambda13__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_leaved_cb (self);
	return result;
}


static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_motion_cb (self, event);
	return result;
}


static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_pressed_cb (self, event);
	return result;
}


static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_state_cb (self, event);
	return result;
}


static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_window_title_evbox_pressed_cb (self, _sender, event);
	return result;
}


static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = xnp_window_title_evbox_scrolled_cb (self, _sender, event);
	return result;
}


static void _lambda14_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self) {
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	gtk_notebook_set_current_page (self->priv->notebook, (gint) p);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}


static void __lambda14__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda14_ (_sender, p0, p1, self);
}


static void _lambda15_ (GtkNotebook* n, GtkWidget* c, guint p, XnpWindow* self) {
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}


static void __lambda15__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	_lambda15_ (_sender, p0, p1, self);
}


static void _lambda16_ (GtkNotebook* n, GtkNotebookPage* c, guint p, XnpWindow* self) {
	XnpNote* note;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, (gint) p)));
	xnp_window_update_title (self, xnp_note_get_name (note));
	xnp_window_update_navigation_sensitivity (self, (gint) p);
	_g_object_unref0 (note);
}


static void __lambda16__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self) {
	_lambda16_ (_sender, page, page_num, self);
}


static void _lambda17_ (XnpWindow* self) {
	gint page;
	XnpNote* current_note;
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page == (-1)) {
		return;
	}
	current_note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)));
	xnp_window_update_title (self, xnp_note_get_name (current_note));
	_g_object_unref0 (current_note);
}


static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda17_ (self);
}


static void _lambda18_ (XnpWindow* self) {
	char* _tmp0_;
	char* _tmp1_;
	gtk_label_set_markup (self->priv->title_label, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("<b>", gtk_window_get_title ((GtkWindow*) self), NULL), "</b>", NULL));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda18_ (self);
}


XnpWindow* xnp_window_construct (GType object_type) {
	XnpWindow * self;
	GtkActionGroup* _tmp0_;
	GtkUIManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkFrame* frame;
	GtkRcStyle* style;
	GtkVBox* vbox_frame;
	GtkHBox* title_box;
	GtkEventBox* menu_evbox;
	GtkImage* _tmp13_;
	GtkEventBox* title_evbox;
	GtkLabel* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	XnpTitleBarButton* _tmp17_;
	XnpTitleBarButton* _tmp18_;
	XnpTitleBarButton* _tmp19_;
	char* _tmp20_;
	GtkVBox* _tmp21_;
	GtkNotebook* _tmp22_;
	GError * _inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK) | GDK_BUTTON_PRESS_MASK));
	self->priv->action_group = (_tmp0_ = gtk_action_group_new ("XNP"), _g_object_unref0 (self->priv->action_group), _tmp0_);
	gtk_action_group_add_actions (self->priv->action_group, XNP_WINDOW_action_entries, G_N_ELEMENTS (XNP_WINDOW_action_entries), self);
	self->priv->ui = (_tmp1_ = gtk_ui_manager_new (), _g_object_unref0 (self->priv->ui), _tmp1_);
	gtk_ui_manager_insert_action_group (self->priv->ui, self->priv->action_group, 0);
	{
		gtk_ui_manager_add_ui_from_string (self->priv->ui, XNP_WINDOW_ui_string, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		gtk_window_add_accel_group ((GtkWindow*) self, gtk_ui_manager_get_accel_group (self->priv->ui));
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("window.vala:185: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->menu = (_tmp2_ = xnp_window_build_menu (self), _g_object_unref0 (self->priv->menu), _tmp2_);
	gtk_widget_show_all ((GtkWidget*) self->priv->menu);
	frame = g_object_ref_sink ((GtkFrame*) gtk_frame_new (NULL));
	gtk_frame_set_shadow_type (frame, GTK_SHADOW_NONE);
	style = _g_object_ref0 (gtk_widget_get_modifier_style ((GtkWidget*) frame));
	style->xthickness = 1;
	style->ythickness = 3;
	gtk_widget_modify_style ((GtkWidget*) frame, style);
	gtk_widget_show ((GtkWidget*) frame);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) frame);
	vbox_frame = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_set_spacing ((GtkBox*) vbox_frame, 1);
	gtk_widget_show ((GtkWidget*) vbox_frame);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) vbox_frame);
	title_box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	menu_evbox = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
	gtk_widget_set_tooltip_text ((GtkWidget*) menu_evbox, _ ("Menu"));
	gtk_event_box_set_visible_window (menu_evbox, FALSE);
	{
		char* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		char* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp5_ = (_tmp4_ = gdk_pixbuf_new_from_file (_tmp3_ = g_strdup_printf ("%s/pixmaps/notes-menu.png", PKGDATADIR), &_inner_error_), _g_free0 (_tmp3_), _tmp4_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		self->priv->menu_pixbuf = (_tmp6_ = _tmp5_, _g_object_unref0 (self->priv->menu_pixbuf), _tmp6_);
		_tmp9_ = (_tmp8_ = gdk_pixbuf_new_from_file (_tmp7_ = g_strdup_printf ("%s/pixmaps/notes-menu-active.png", PKGDATADIR), &_inner_error_), _g_free0 (_tmp7_), _tmp8_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		self->priv->menu_hover_pixbuf = (_tmp10_ = _tmp9_, _g_object_unref0 (self->priv->menu_hover_pixbuf), _tmp10_);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			self->priv->menu_pixbuf = (_tmp12_ = _g_object_ref0 (self->priv->menu_hover_pixbuf = (_tmp11_ = NULL, _g_object_unref0 (self->priv->menu_hover_pixbuf), _tmp11_)), _g_object_unref0 (self->priv->menu_pixbuf), _tmp12_);
			_g_error_free0 (e);
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (menu_evbox);
		_g_object_unref0 (title_box);
		_g_object_unref0 (vbox_frame);
		_g_object_unref0 (style);
		_g_object_unref0 (frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->menu_image = (_tmp13_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_pixbuf (self->priv->menu_pixbuf)), _g_object_unref0 (self->priv->menu_image), _tmp13_);
	gtk_container_add ((GtkContainer*) menu_evbox, (GtkWidget*) self->priv->menu_image);
	g_signal_connect_object ((GtkWidget*) menu_evbox, "enter-notify-event", (GCallback) __lambda8__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) menu_evbox, "leave-notify-event", (GCallback) __lambda9__gtk_widget_leave_notify_event, self, 0);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) menu_evbox, FALSE, FALSE, (guint) 2);
	title_evbox = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
	gtk_event_box_set_visible_window (title_evbox, FALSE);
	self->priv->title_label = (_tmp14_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL)), _g_object_unref0 (self->priv->title_label), _tmp14_);
	gtk_label_set_markup (self->priv->title_label, _tmp16_ = g_strconcat (_tmp15_ = g_strconcat ("<b>", gtk_window_get_title ((GtkWindow*) self), NULL), "</b>", NULL));
	_g_free0 (_tmp16_);
	_g_free0 (_tmp15_);
	gtk_label_set_ellipsize (self->priv->title_label, PANGO_ELLIPSIZE_END);
	g_object_set ((GtkMisc*) self->priv->title_label, "xalign", (float) 0.0, NULL);
	gtk_container_add ((GtkContainer*) title_evbox, (GtkWidget*) self->priv->title_label);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) title_evbox, TRUE, TRUE, (guint) 6);
	self->priv->left_arrow_button = (_tmp17_ = g_object_ref_sink (xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW)), _g_object_unref0 (self->priv->left_arrow_button), _tmp17_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->left_arrow_button, gtk_accelerator_get_label ((guint) 0xff55, GDK_CONTROL_MASK));
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->left_arrow_button, FALSE);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) self->priv->left_arrow_button, FALSE, FALSE, (guint) 2);
	self->priv->right_arrow_button = (_tmp18_ = g_object_ref_sink (xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW)), _g_object_unref0 (self->priv->right_arrow_button), _tmp18_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->right_arrow_button, gtk_accelerator_get_label ((guint) 0xff56, GDK_CONTROL_MASK));
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->right_arrow_button, FALSE);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) self->priv->right_arrow_button, FALSE, FALSE, (guint) 2);
	self->priv->close_button = (_tmp19_ = g_object_ref_sink (xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_CLOSE)), _g_object_unref0 (self->priv->close_button), _tmp19_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->close_button, _tmp20_ = g_strdup_printf (_ ("Hide (%s)"), gtk_accelerator_get_label ((guint) 0xff1b, 0)));
	_g_free0 (_tmp20_);
	gtk_box_pack_start ((GtkBox*) title_box, (GtkWidget*) self->priv->close_button, FALSE, FALSE, (guint) 2);
	gtk_widget_show_all ((GtkWidget*) title_box);
	gtk_box_pack_start ((GtkBox*) vbox_frame, (GtkWidget*) title_box, FALSE, FALSE, (guint) 0);
	self->priv->content_box = (_tmp21_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (self->priv->content_box), _tmp21_);
	gtk_widget_show ((GtkWidget*) self->priv->content_box);
	gtk_box_pack_start ((GtkBox*) vbox_frame, (GtkWidget*) self->priv->content_box, TRUE, TRUE, (guint) 0);
	self->priv->notebook = (_tmp22_ = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ()), _g_object_unref0 (self->priv->notebook), _tmp22_);
	gtk_widget_set_name ((GtkWidget*) self->priv->notebook, "notes-notebook");
	gtk_notebook_set_show_border (self->priv->notebook, TRUE);
	gtk_notebook_set_show_tabs (self->priv->notebook, FALSE);
	gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_TOP);
	g_object_set (self->priv->notebook, "tab-border", (guint) 4, NULL);
	gtk_notebook_set_scrollable (self->priv->notebook, TRUE);
	gtk_widget_show ((GtkWidget*) self->priv->notebook);
	gtk_box_pack_start ((GtkBox*) self->priv->content_box, (GtkWidget*) self->priv->notebook, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) menu_evbox, "button-press-event", (GCallback) _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((XnpIconButton*) self->priv->left_arrow_button, "clicked", (GCallback) _xnp_window_action_prev_note_xnp_icon_button_clicked, self, 0);
	g_signal_connect_object ((XnpIconButton*) self->priv->right_arrow_button, "clicked", (GCallback) _xnp_window_action_next_note_xnp_icon_button_clicked, self, 0);
	g_signal_connect_object ((XnpIconButton*) self->priv->close_button, "clicked", (GCallback) __lambda10__xnp_icon_button_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda11__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) __lambda12__gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __lambda13__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_window_window_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _xnp_window_window_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xnp_window_window_state_cb_gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "button-press-event", (GCallback) _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "scroll-event", (GCallback) _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (self->priv->notebook, "page-added", (GCallback) __lambda14__gtk_notebook_page_added, self, 0);
	g_signal_connect_object (self->priv->notebook, "page-removed", (GCallback) __lambda15__gtk_notebook_page_removed, self, 0);
	g_signal_connect_object (self->priv->notebook, "switch-page", (GCallback) __lambda16__gtk_notebook_switch_page, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::name", (GCallback) __lambda17__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::title", (GCallback) __lambda18__g_object_notify, self, 0);
	_g_object_unref0 (title_evbox);
	_g_object_unref0 (menu_evbox);
	_g_object_unref0 (title_box);
	_g_object_unref0 (vbox_frame);
	_g_object_unref0 (style);
	_g_object_unref0 (frame);
	return self;
}


XnpWindow* xnp_window_new (void) {
	return xnp_window_construct (XNP_TYPE_WINDOW);
}


/**
 * hide:
 *
 * Save position before hidding.
 */
void xnp_window_hide (XnpWindow* self) {
	gint winx = 0;
	gint winy = 0;
	g_return_if_fail (self != NULL);
	gtk_window_get_position ((GtkWindow*) self, &winx, &winy);
	GTK_WIDGET_CLASS (xnp_window_parent_class)->hide ((GtkWidget*) GTK_WINDOW (self));
	gtk_window_deiconify ((GtkWindow*) self);
	xnp_window_unshade (self);
	gtk_window_move ((GtkWindow*) self, winx, winy);
	gtk_window_set_keep_above ((GtkWindow*) self, xnp_window_get_above (self));
}


/**
 * window_leaved_cb:
 *
 * Reset the mouse cursor.
 */
static gboolean xnp_window_window_leaved_cb (XnpWindow* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gdk_window_set_cursor (((GtkWidget*) self)->window, NULL);
	result = TRUE;
	return result;
}


/**
 * window_motion_cb:
 *
 * Update mouse cursor.
 */
static gboolean xnp_window_window_motion_cb (XnpWindow* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).x > 4) {
		_tmp2_ = (*event).y > 4;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (*event).x < (((GtkWidget*) self)->allocation.width - 4);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*event).y < (((GtkWidget*) self)->allocation.height - 4);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gdk_window_set_cursor (((GtkWidget*) self)->window, NULL);
		result = FALSE;
		return result;
	}
	if ((*event).x >= (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN)) {
		_tmp4_ = (*event).y >= self->priv->CORNER_MARGIN;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = (*event).y < (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gdk_window_set_cursor (((GtkWidget*) self)->window, self->priv->CURSOR_RIGHT);
	} else {
		gboolean _tmp5_ = FALSE;
		if ((*event).x >= (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN)) {
			_tmp5_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gdk_window_set_cursor (((GtkWidget*) self)->window, self->priv->CURSOR_BOTTOM_RC);
		} else {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if ((*event).x > self->priv->CORNER_MARGIN) {
				_tmp7_ = (*event).y > (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = (*event).x < (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gdk_window_set_cursor (((GtkWidget*) self)->window, self->priv->CURSOR_BOTTOM);
			} else {
				gboolean _tmp8_ = FALSE;
				if ((*event).x <= self->priv->CORNER_MARGIN) {
					_tmp8_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gdk_window_set_cursor (((GtkWidget*) self)->window, self->priv->CURSOR_BOTTOM_LC);
				} else {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					if ((*event).x <= self->priv->CORNER_MARGIN) {
						_tmp10_ = (*event).y >= self->priv->CORNER_MARGIN;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						_tmp9_ = (*event).y < (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						gdk_window_set_cursor (((GtkWidget*) self)->window, self->priv->CURSOR_LEFT);
					} else {
						gdk_window_set_cursor (((GtkWidget*) self)->window, NULL);
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


/**
 * window_pressed_cb:
 *
 * Start a window resize depending on mouse pointer location.
 */
static gboolean xnp_window_window_pressed_cb (XnpWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkWindowEdge edge = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).x > 4) {
		_tmp2_ = (*event).y > 4;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (*event).x < (((GtkWidget*) self)->allocation.width - 4);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*event).y < (((GtkWidget*) self)->allocation.height - 4);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if ((*event).y > self->priv->CORNER_MARGIN) {
		_tmp4_ = (*event).x > (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = (*event).y < (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		edge = GDK_WINDOW_EDGE_EAST;
	} else {
		gboolean _tmp5_ = FALSE;
		if ((*event).x >= (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN)) {
			_tmp5_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			edge = GDK_WINDOW_EDGE_SOUTH_EAST;
		} else {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if ((*event).x > self->priv->CORNER_MARGIN) {
				_tmp7_ = (*event).y > (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = (*event).x < (((GtkWidget*) self)->allocation.width - self->priv->CORNER_MARGIN);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				edge = GDK_WINDOW_EDGE_SOUTH;
			} else {
				gboolean _tmp8_ = FALSE;
				if ((*event).x <= self->priv->CORNER_MARGIN) {
					_tmp8_ = (*event).y >= (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					edge = GDK_WINDOW_EDGE_SOUTH_WEST;
				} else {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					if ((*event).y > self->priv->CORNER_MARGIN) {
						_tmp10_ = (*event).x < self->priv->CORNER_MARGIN;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						_tmp9_ = (*event).y < (((GtkWidget*) self)->allocation.height - self->priv->CORNER_MARGIN);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						edge = GDK_WINDOW_EDGE_WEST;
					} else {
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	gtk_window_begin_resize_drag ((GtkWindow*) self, edge, (gint) (*event).button, (gint) (*event).x_root, (gint) (*event).y_root, (*event).time);
	result = TRUE;
	return result;
}


/**
 * window_state_cb:
 *
 * Watch window manager actions always on top and sticky
 * window.
 */
static gboolean xnp_window_window_state_cb (XnpWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((gboolean) ((*event).changed_mask & GDK_WINDOW_STATE_ABOVE)) {
		gtk_check_menu_item_set_active (self->priv->mi_above, (gboolean) ((*event).new_window_state & GDK_WINDOW_STATE_ABOVE));
	}
	if ((gboolean) ((*event).changed_mask & GDK_WINDOW_STATE_STICKY)) {
		_tmp0_ = (gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self) & GTK_VISIBLE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		xnp_window_set_sticky (self, (gboolean) (((*event).new_window_state & GDK_WINDOW_STATE_STICKY) != 0));
	}
	result = FALSE;
	return result;
}


/**
 * title_evbox_pressed_cb:
 *
 * Raise/lower the window and popup window menu.
 */
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if ((*event).type != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	if ((*event).button == 1) {
		gint winx = 0;
		gint winy = 0;
		gint curx = 0;
		gint cury = 0;
		gdk_window_show (((GtkWidget*) self)->window);
		gtk_window_get_position ((GtkWindow*) self, &winx, &winy);
		gtk_widget_get_pointer ((GtkWidget*) self, &curx, &cury);
		winx = winx + curx;
		winy = winy + cury;
		gtk_window_begin_move_drag ((GtkWindow*) self, 1, winx, winy, gtk_get_current_event_time ());
	} else {
		if ((*event).button == 2) {
			gdk_window_lower (((GtkWidget*) self)->window);
		} else {
			if ((*event).button == 3) {
				gtk_menu_popup (self->priv->menu, NULL, NULL, NULL, NULL, (guint) 0, gtk_get_current_event_time ());
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * title_evbox_scrolled_cb:
 *
 * Shade/unshade the window and set transparency by holding ALT.
 */
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self, GtkWidget* widget, GdkEventScroll* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if ((gboolean) ((*event).state & GDK_MOD1_MASK)) {
		if ((*event).direction == GDK_SCROLL_UP) {
			gtk_window_set_opacity ((GtkWindow*) self, gtk_window_get_opacity ((GtkWindow*) self) + 0.1);
		} else {
			if ((*event).direction == GDK_SCROLL_DOWN) {
				if ((gtk_window_get_opacity ((GtkWindow*) self) - 0.1) >= 0.1) {
					gtk_window_set_opacity ((GtkWindow*) self, gtk_window_get_opacity ((GtkWindow*) self) - 0.1);
				}
			}
		}
	} else {
		if ((*event).direction == GDK_SCROLL_UP) {
			xnp_window_shade (self);
		} else {
			if ((*event).direction == GDK_SCROLL_DOWN) {
				xnp_window_unshade (self);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * note_notify_name_cb:
 *
 */
static void xnp_window_note_notify_name_cb (XnpWindow* self, GObject* object, GParamSpec* pspec) {
	GObject* _tmp0_;
	XnpNote* note;
	gint page;
	XnpNote* current_note;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	note = _g_object_ref0 ((_tmp0_ = object, XNP_IS_NOTE (_tmp0_) ? ((XnpNote*) _tmp0_) : NULL));
	gtk_notebook_set_tab_label_text (self->priv->notebook, (GtkWidget*) note, xnp_note_get_name (note));
	_xnp_window_notebook_update_tabs_angle (self);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	current_note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)));
	if (note == current_note) {
		xnp_window_update_title (self, xnp_note_get_name (note));
	}
	_g_object_unref0 (current_note);
	_g_object_unref0 (note);
}


static void xnp_window_action_new_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "create-new-window");
}


static void xnp_window_action_delete_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "delete");
}


static void xnp_window_action_rename_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "rename");
}


static void xnp_window_action_new_note (XnpWindow* self) {
	XnpNote* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_insert_note (self);
	_g_object_unref0 (_tmp0_);
}


static void xnp_window_action_delete_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_delete_current_note (self);
}


static void xnp_window_action_rename_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_rename_current_note (self);
}


static void xnp_window_action_cancel (XnpWindow* self) {
	gint page;
	GtkWidget* child;
	g_return_if_fail (self != NULL);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page < 0) {
		return;
	}
	child = _g_object_ref0 (gtk_notebook_get_nth_page (self->priv->notebook, page));
	xnp_hypertext_view_undo (XNP_NOTE (child)->text_view);
	_g_object_unref0 (child);
}


static void xnp_window_action_next_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_notebook_next_page (self->priv->notebook);
}


static void xnp_window_action_prev_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_notebook_prev_page (self->priv->notebook);
}


/**
 * menu_evbox_pressed_cb:
 *
 * Popup the window menu.
 */
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	xnp_window_menu_position (self, menu, x, y, push_in);
}


static gboolean xnp_window_menu_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	gtk_menu_popup (self->priv->menu, NULL, NULL, _xnp_window_menu_position_gtk_menu_position_func, self, (guint) 0, gtk_get_current_event_time ());
	result = FALSE;
	return result;
}


/**
 * menu_position:
 *
 * Menu position function for the window menu.
 */
static void xnp_window_menu_position (XnpWindow* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint winx = 0;
	gint winy = 0;
	gint width = 0;
	gint height = 0;
	gint depth = 0;
	GtkRequisition requisition = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	gdk_window_get_geometry (((GtkWidget*) self)->window, &winx, &winy, &width, &height, &depth);
	gdk_window_get_origin (((GtkWidget*) self)->window, x, y);
	gtk_widget_size_request ((GtkWidget*) menu, &requisition);
	if ((((*y) + ((GtkWidget*) self->priv->content_box)->allocation.y) + requisition.height) > gdk_screen_height ()) {
		*y = (*y) - requisition.height;
	} else {
		*y = (*y) + ((GtkWidget*) self->priv->content_box)->allocation.y;
	}
	if (((*x) + requisition.width) > gdk_screen_width ()) {
		*x = ((*x) - ((GtkWidget*) menu)->requisition.width) + ((GtkWidget*) self->priv->content_box)->allocation.y;
	}
}


/**
 * build_menu:
 *
 * Build the window menu.
 */
static void _xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	xnp_window_update_menu_go (self, _sender);
}


static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_rename_note (self);
}


static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_cancel (self);
}


static void _lambda4_ (GtkCheckMenuItem* o, XnpWindow* self) {
	g_return_if_fail (o != NULL);
	xnp_window_set_above (self, gtk_check_menu_item_get_active (o));
}


static void __lambda4__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _lambda5_ (GtkCheckMenuItem* o, XnpWindow* self) {
	g_return_if_fail (o != NULL);
	xnp_window_set_sticky (self, gtk_check_menu_item_get_active (o));
}


static void __lambda5__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (XnpWindow* self) {
	g_signal_emit_by_name (self, "action", "properties");
}


static void __lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda6_ (self);
}


static void _lambda7_ (XnpWindow* self) {
	g_signal_emit_by_name (self, "action", "about");
}


static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda7_ (self);
}


static GtkMenu* xnp_window_build_menu (XnpWindow* self) {
	GtkMenu* result = NULL;
	GtkMenu* menu;
	GtkMenuItem* mi;
	GtkMenu* menu_go;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkImage* image;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkCheckMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkCheckMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	menu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	gtk_menu_set_accel_group (menu, gtk_ui_manager_get_accel_group (self->priv->ui));
	mi = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Groups")));
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	menu_go = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	gtk_menu_set_accel_group (menu_go, gtk_ui_manager_get_accel_group (self->priv->ui));
	g_signal_connect_object ((GtkWidget*) menu_go, "show", (GCallback) _xnp_window_update_menu_go_gtk_widget_show, self, 0);
	gtk_menu_item_set_submenu (mi, (GtkWidget*) menu_go);
	mi = (_tmp0_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (mi), _tmp0_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp1_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, NULL)), _g_object_unref0 (mi), _tmp1_);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "new-note")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_new_note_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp2_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_DELETE, NULL)), _g_object_unref0 (mi), _tmp2_);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "delete-note")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_delete_note_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp3_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Rename"))), _g_object_unref0 (mi), _tmp3_);
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU));
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "rename-note")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_rename_note_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp4_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_UNDO, NULL)), _g_object_unref0 (mi), _tmp4_);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "cancel")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_cancel_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp5_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (mi), _tmp5_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp7_ = _g_object_ref0 ((GtkMenuItem*) (self->priv->mi_above = (_tmp6_ = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Always on top"))), _g_object_unref0 (self->priv->mi_above), _tmp6_))), _g_object_unref0 (mi), _tmp7_);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mi), xnp_window_get_above (self));
	g_signal_connect_object (GTK_CHECK_MENU_ITEM (mi), "toggled", (GCallback) __lambda4__gtk_check_menu_item_toggled, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp9_ = _g_object_ref0 ((GtkMenuItem*) (self->priv->mi_sticky = (_tmp8_ = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Sticky window"))), _g_object_unref0 (self->priv->mi_sticky), _tmp8_))), _g_object_unref0 (mi), _tmp9_);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mi), xnp_window_get_sticky (self));
	g_signal_connect_object (GTK_CHECK_MENU_ITEM (mi), "toggled", (GCallback) __lambda5__gtk_check_menu_item_toggled, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp10_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (mi), _tmp10_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp11_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PROPERTIES, NULL)), _g_object_unref0 (mi), _tmp11_);
	g_signal_connect_object (mi, "activate", (GCallback) __lambda6__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp12_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL)), _g_object_unref0 (mi), _tmp12_);
	g_signal_connect_object (mi, "activate", (GCallback) __lambda7__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	result = menu;
	_g_object_unref0 (image);
	_g_object_unref0 (menu_go);
	_g_object_unref0 (mi);
	return result;
}


/**
 * update_menu_go:
 *
 * Update the menu Go when it is shown.
 */
static void _lambda1_ (GtkWidget* w, XnpWindow* self) {
	g_return_if_fail (w != NULL);
	gtk_object_destroy ((GtkObject*) w);
}


static void __lambda1__gtk_callback (GtkWidget* widget, gpointer self) {
	_lambda1_ (widget, self);
}


static void _lambda2_ (GtkMenuItem* i, XnpWindow* self) {
	gint page;
	g_return_if_fail (i != NULL);
	page = GPOINTER_TO_INT (g_object_get_data ((GObject*) i, "page"));
	gtk_notebook_set_current_page (self->priv->notebook, page);
}


static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static void _lambda3_ (GtkMenuItem* i, XnpWindow* self) {
	XnpWindow* w;
	g_return_if_fail (i != NULL);
	w = _g_object_ref0 ((XnpWindow*) g_object_get_data ((GObject*) i, "window"));
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}


static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_rename_window (self);
}


static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_delete_window (self);
}


static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_new_window (self);
}


static void xnp_window_update_menu_go (XnpWindow* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	GtkMenu* menu;
	GtkMenuItem* mi;
	GtkImage* image;
	GtkMenuItem* _tmp8_;
	GtkImage* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkImage* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkImage* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	menu = _g_object_ref0 ((_tmp0_ = widget, GTK_IS_MENU (_tmp0_) ? ((GtkMenu*) _tmp0_) : NULL));
	mi = NULL;
	image = NULL;
	gtk_container_foreach ((GtkContainer*) menu, __lambda1__gtk_callback, self);
	{
		GSList* win_collection;
		GSList* win_it;
		win_collection = self->priv->window_list;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win;
			win = (XnpWindow*) win_it->data;
			{
				if (win == self) {
					GtkMenuItem* _tmp1_;
					gint current_page;
					XnpNote* current_note;
					gint n_pages;
					GtkMenuItem* _tmp5_;
					mi = (_tmp1_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (win->priv->_name)), _g_object_unref0 (mi), _tmp1_);
					gtk_widget_set_sensitive ((GtkWidget*) mi, FALSE);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
					current_page = gtk_notebook_get_current_page (self->priv->notebook);
					current_note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, current_page)));
					n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
					{
						gint p;
						p = 0;
						{
							gboolean _tmp2_;
							_tmp2_ = TRUE;
							while (TRUE) {
								XnpNote* note;
								GtkMenuItem* _tmp3_;
								if (!_tmp2_) {
									p++;
								}
								_tmp2_ = FALSE;
								if (!(p < n_pages)) {
									break;
								}
								note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)));
								mi = (_tmp3_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (xnp_note_get_name (note))), _g_object_unref0 (mi), _tmp3_);
								if (note == current_note) {
									GtkImage* _tmp4_;
									image = (_tmp4_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_MENU)), _g_object_unref0 (image), _tmp4_);
									gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
								}
								g_object_set_data_full ((GObject*) mi, "page", (void*) p, NULL);
								g_signal_connect_object (mi, "activate", (GCallback) __lambda2__gtk_menu_item_activate, self, 0);
								gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
								_g_object_unref0 (note);
							}
						}
					}
					mi = (_tmp5_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (mi), _tmp5_);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
					_g_object_unref0 (current_note);
				} else {
					GtkMenuItem* _tmp6_;
					GtkMenuItem* _tmp7_;
					mi = (_tmp6_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_label (win->priv->_name)), _g_object_unref0 (mi), _tmp6_);
					g_object_set_data_full ((GObject*) mi, "window", (void*) win, NULL);
					g_signal_connect_object (mi, "activate", (GCallback) __lambda3__gtk_menu_item_activate, self, 0);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
					mi = (_tmp7_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (mi), _tmp7_);
					gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
				}
			}
		}
	}
	mi = (_tmp8_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Rename group"))), _g_object_unref0 (mi), _tmp8_);
	image = (_tmp9_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU)), _g_object_unref0 (image), _tmp9_);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "rename-window")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_rename_window_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp10_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Delete group"))), _g_object_unref0 (mi), _tmp10_);
	image = (_tmp11_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_REMOVE, GTK_ICON_SIZE_MENU)), _g_object_unref0 (image), _tmp11_);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "delete-window")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_delete_window_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	mi = (_tmp12_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("_Add a new group"))), _g_object_unref0 (mi), _tmp12_);
	image = (_tmp13_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_ADD, GTK_ICON_SIZE_MENU)), _g_object_unref0 (image), _tmp13_);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (mi), (GtkWidget*) image);
	gtk_menu_item_set_accel_path (mi, gtk_action_get_accel_path (gtk_action_group_get_action (self->priv->action_group, "new-window")));
	g_signal_connect_object (mi, "activate", (GCallback) _xnp_window_action_new_window_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	gtk_widget_show_all ((GtkWidget*) menu);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
}


/**
 * get_geometry:
 *
 * Returns the X,Y position and width/height.
 */
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height) {
	g_return_if_fail (self != NULL);
	if (!((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->content_box) & GTK_VISIBLE))) {
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, NULL);
	} else {
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, &self->priv->height);
	}
	gtk_window_get_position ((GtkWindow*) self, winx, winy);
	*width = self->priv->width;
	*height = self->priv->height;
}


/**
 * set_window_list:
 *
 * Saves a list of window inside window.window_list to be shown
 * within the window menu.
 */
void xnp_window_set_window_list (XnpWindow* self, GSList* list) {
	g_return_if_fail (self != NULL);
	self->priv->window_list = list;
}


/**
 * compare_func:
 *
 * Compare function for the window name to use with GLib.CompareFunc delegates.
 */
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (win2 != NULL, 0);
	result = g_utf8_collate (self->priv->_name, win2->priv->_name);
	return result;
}


/**
 * get_current_page:
 *
 * Get the current page in the notebook.
 */
gint xnp_window_get_current_page (XnpWindow* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = gtk_notebook_get_current_page (self->priv->notebook);
	return result;
}


/**
 * set_current_page:
 *
 * Set the current page in the notebook.
 */
void xnp_window_set_current_page (XnpWindow* self, gint page) {
	g_return_if_fail (self != NULL);
	gtk_notebook_set_current_page (self->priv->notebook, page);
}


/**
 * shade:
 *
 * Shade the window (roll up) to show only the title bar.
 */
static void xnp_window_shade (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	if ((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->content_box) & GTK_VISIBLE)) {
		gtk_widget_hide ((GtkWidget*) self->priv->content_box);
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, &self->priv->height);
		gtk_window_resize ((GtkWindow*) self, self->priv->width, 1);
	}
}


/**
 * unshade:
 *
 * Unshade the window (roll down).
 */
static void xnp_window_unshade (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	if (!((gboolean) (GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->content_box) & GTK_VISIBLE))) {
		gtk_widget_show ((GtkWidget*) self->priv->content_box);
		gtk_window_get_size ((GtkWindow*) self, &self->priv->width, NULL);
		gtk_window_resize ((GtkWindow*) self, self->priv->width, self->priv->height);
	}
}


/**
 * update_title:
 *
 * Updates the window title.
 */
static void xnp_window_update_title (XnpWindow* self, const char* note_name) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	gtk_window_set_title ((GtkWindow*) self, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat (self->priv->_name, " - ", NULL), note_name, NULL));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


/**
 * update_navigation_sensitivity:
 *
 * Update the goleft/right sensitivities.
 */
static void xnp_window_update_navigation_sensitivity (XnpWindow* self, gint page_num) {
	gint n_pages;
	g_return_if_fail (self != NULL);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	if (n_pages <= 1) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->left_arrow_button, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->right_arrow_button, FALSE);
	} else {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (page_num > 0) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = FALSE;
		}
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->left_arrow_button, _tmp0_);
		if ((page_num + 1) < n_pages) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = FALSE;
		}
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->right_arrow_button, _tmp1_);
	}
}


/**
 * insert_note:
 *
 * Create a new note and insert it inside the notebook after
 * the current position.
 */
static void _xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xnp_window_note_notify_name_cb (self, _sender, pspec);
}


static void _lambda0_ (XnpNote* note, XnpWindow* self) {
	g_return_if_fail (note != NULL);
	g_signal_emit_by_name (self, "save-data", note);
}


static void __lambda0__xnp_note_save_data (XnpNote* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


XnpNote* xnp_window_insert_note (XnpWindow* self) {
	XnpNote* result = NULL;
	gint len;
	char* name;
	gint page;
	XnpNote* note;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	len = gtk_notebook_get_n_pages (self->priv->notebook);
	name = g_strdup (_ ("Notes"));
	{
		gint id;
		id = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					id++;
				}
				_tmp0_ = FALSE;
				if (!(id <= (len + 1))) {
					break;
				}
				if (id > 1) {
					char* _tmp1_;
					name = (_tmp1_ = g_strdup_printf (_ ("Notes %d"), id), _g_free0 (name), _tmp1_);
				}
				if (!xnp_window_note_name_exists (self, name)) {
					break;
				}
			}
		}
	}
	page = gtk_notebook_get_current_page (self->priv->notebook) + 1;
	note = g_object_ref_sink (xnp_note_new (name));
	g_signal_connect_object ((GObject*) note, "notify::name", (GCallback) _xnp_window_note_notify_name_cb_g_object_notify, self, 0);
	g_signal_connect_object (note, "save-data", (GCallback) __lambda0__xnp_note_save_data, self, 0);
	gtk_widget_show ((GtkWidget*) note);
	_tmp2_ = self->priv->_n_pages;
	xnp_window_set_n_pages (self, _tmp2_ + 1);
	_tmp2_;
	gtk_notebook_insert_page (self->priv->notebook, (GtkWidget*) note, NULL, page);
	gtk_notebook_set_tab_reorderable (self->priv->notebook, (GtkWidget*) note, TRUE);
	xnp_note_set_name (note, xnp_note_get_name (note));
	g_signal_emit_by_name (self, "note-inserted", note);
	_xnp_window_notebook_update_tabs_angle (self);
	result = note;
	_g_free0 (name);
	return result;
}


/**
 * move_note:
 *
 * Moves the note named @note_name to position @page.
 */
void xnp_window_move_note (XnpWindow* self, const char* note_name, gint page) {
	gint n_pages;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint p;
		p = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				XnpNote* note;
				if (!_tmp0_) {
					p++;
				}
				_tmp0_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)));
				if (_vala_strcmp0 (xnp_note_get_name (note), note_name) == 0) {
					gtk_notebook_reorder_child (self->priv->notebook, (GtkWidget*) note, page);
					xnp_window_update_navigation_sensitivity (self, page);
					_g_object_unref0 (note);
					break;
				}
				_g_object_unref0 (note);
			}
		}
	}
}


/**
 * get_note_names:
 *
 * Returns a string list of the note names in the order they are currently displayed
 * in the notebook.
 */
static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


char** xnp_window_get_note_names (XnpWindow* self, int* result_length1) {
	char** result = NULL;
	gint note_names_length1;
	gint _note_names_size_;
	char** _tmp0_;
	char** note_names;
	gint n_pages;
	char** _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	note_names = (_tmp0_ = NULL, note_names_length1 = 0, _note_names_size_ = note_names_length1, _tmp0_);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint p;
		p = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				XnpNote* note;
				if (!_tmp1_) {
					p++;
				}
				_tmp1_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)));
				_vala_array_add1 (&note_names, &note_names_length1, &_note_names_size_, g_strdup (xnp_note_get_name (note)));
				_g_object_unref0 (note);
			}
		}
	}
	result = (_tmp2_ = note_names, *result_length1 = note_names_length1, _tmp2_);
	return result;
	note_names = (_vala_array_free (note_names, note_names_length1, (GDestroyNotify) g_free), NULL);
}


/**
 * delete_current_note:
 *
 * Delete the current note.
 */
void xnp_window_delete_current_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_delete_note (self, gtk_notebook_get_current_page (self->priv->notebook));
}


/**
 * delete_note:
 *
 * Delete note at page @page.
 */
void xnp_window_delete_note (XnpWindow* self, gint page) {
	XnpNote* note;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)));
	if (gtk_text_buffer_get_char_count (gtk_text_view_get_buffer ((GtkTextView*) note->text_view)) > 0) {
		GtkMessageDialog* dialog;
		gint res;
		dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("Are you sure you want to delete this note?")));
		res = gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		if (res != GTK_RESPONSE_YES) {
			_g_object_unref0 (dialog);
			_g_object_unref0 (note);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp0_ = self->priv->_n_pages;
	xnp_window_set_n_pages (self, _tmp0_ - 1);
	_tmp0_;
	gtk_notebook_remove_page (self->priv->notebook, page);
	g_signal_emit_by_name (self, "note-deleted", note);
	gtk_object_destroy ((GtkObject*) note);
	if (gtk_notebook_get_n_pages (self->priv->notebook) == 0) {
		g_signal_emit_by_name (self, "action", "delete");
	}
	_g_object_unref0 (note);
}


/**
 * rename_current_note:
 *
 * Rename the current note.
 */
void xnp_window_rename_current_note (XnpWindow* self) {
	gint page;
	XnpNote* note;
	GtkDialog* dialog;
	GtkEntry* entry;
	gint res;
	g_return_if_fail (self != NULL);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page == (-1)) {
		return;
	}
	note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)));
	dialog = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename note"), GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) self)), (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT) | GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL));
	gtk_dialog_set_default_response (dialog, (gint) GTK_RESPONSE_OK);
	gtk_window_set_resizable ((GtkWindow*) dialog, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) dialog, GTK_STOCK_EDIT);
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 4);
	gtk_container_set_border_width ((GtkContainer*) dialog->vbox, (guint) 6);
	entry = g_object_ref_sink ((GtkEntry*) gtk_entry_new ());
	gtk_entry_set_text (entry, xnp_note_get_name (note));
	gtk_entry_set_activates_default (entry, TRUE);
	gtk_container_add ((GtkContainer*) dialog->vbox, (GtkWidget*) entry);
	gtk_widget_show_all ((GtkWidget*) dialog->vbox);
	res = gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	if (res == GTK_RESPONSE_OK) {
		const char* name;
		name = gtk_entry_get_text (entry);
		if (xnp_window_note_name_exists (self, name)) {
			GtkMessageDialog* error_dialog;
			error_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name %s is already in use"), name));
			gtk_dialog_run ((GtkDialog*) error_dialog);
			gtk_object_destroy ((GtkObject*) error_dialog);
			_g_object_unref0 (error_dialog);
		} else {
			char* old_name;
			old_name = g_strdup (xnp_note_get_name (note));
			xnp_note_set_name (note, name);
			g_signal_emit_by_name (self, "note-renamed", note, old_name);
			_g_free0 (old_name);
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (entry);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}


/**
 * set_font:
 *
 * Set the font for the window.
 */
void xnp_window_set_font (XnpWindow* self) {
	gint page;
	XnpNote* note;
	GtkFontSelectionDialog* dialog;
	gint res;
	g_return_if_fail (self != NULL);
	page = gtk_notebook_get_current_page (self->priv->notebook);
	if (page == (-1)) {
		return;
	}
	note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, page)));
	dialog = g_object_ref_sink ((GtkFontSelectionDialog*) gtk_font_selection_dialog_new ("Choose current note font"));
	gtk_font_selection_dialog_set_font_name (dialog, xnp_hypertext_view_get_font (note->text_view));
	res = gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	if (res == GTK_RESPONSE_OK) {
		xnp_hypertext_view_set_font (note->text_view, gtk_font_selection_dialog_get_font_name (dialog));
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}


/**
 * note_name_exists:
 *
 * Verify if the given name already exists in the notebook.
 */
static gboolean xnp_window_note_name_exists (XnpWindow* self, const char* name) {
	gboolean result = FALSE;
	gint n_pages;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint p;
		p = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				XnpNote* note;
				if (!_tmp0_) {
					p++;
				}
				_tmp0_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)));
				if (_vala_strcmp0 (xnp_note_get_name (note), name) == 0) {
					result = TRUE;
					_g_object_unref0 (note);
					return result;
				}
				_g_object_unref0 (note);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * save_notes:
 *
 * Send the save-data signal on every dirty note.
 */
void xnp_window_save_notes (XnpWindow* self) {
	gint n_pages;
	g_return_if_fail (self != NULL);
	n_pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint p;
		p = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				XnpNote* note;
				if (!_tmp0_) {
					p++;
				}
				_tmp0_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				note = _g_object_ref0 (XNP_NOTE (gtk_notebook_get_nth_page (self->priv->notebook, p)));
				if (xnp_note_get_dirty (note)) {
					xnp_note_set_dirty (note, FALSE);
					g_signal_emit_by_name (self, "save-data", note);
				}
				_g_object_unref0 (note);
			}
		}
	}
}


/**
 * _notebook_update_tabs_angle:
 *
 * Set the angle of each label in the tab.
 */
static void _xnp_window_notebook_update_tabs_angle (XnpWindow* self) {
	gint angle;
	gint pages;
	g_return_if_fail (self != NULL);
	angle = 0;
	if (self->priv->_tabs_position == 2) {
		angle = 270;
	} else {
		if (self->priv->_tabs_position == 4) {
			angle = 90;
		}
	}
	pages = gtk_notebook_get_n_pages (self->priv->notebook);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkWidget* widget;
				GtkWidget* _tmp1_;
				GtkLabel* label;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < pages)) {
					break;
				}
				widget = _g_object_ref0 (gtk_notebook_get_nth_page (self->priv->notebook, i));
				label = _g_object_ref0 ((_tmp1_ = gtk_notebook_get_tab_label (self->priv->notebook, widget), GTK_IS_LABEL (_tmp1_) ? ((GtkLabel*) _tmp1_) : NULL));
				if (GTK_IS_LABEL (label)) {
					gtk_label_set_angle (label, (double) angle);
				}
				_g_object_unref0 (label);
				_g_object_unref0 (widget);
			}
		}
	}
}


const char* xnp_window_get_name (XnpWindow* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void xnp_window_set_name (XnpWindow* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


gint xnp_window_get_n_pages (XnpWindow* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_pages;
	return result;
}


void xnp_window_set_n_pages (XnpWindow* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_n_pages = value;
	g_object_notify ((GObject *) self, "n-pages");
}


gboolean xnp_window_get_show_tabs (XnpWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_notebook_get_show_tabs (self->priv->notebook);
	return result;
}


void xnp_window_set_show_tabs (XnpWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	gtk_notebook_set_show_tabs (self->priv->notebook, value);
	g_object_notify ((GObject *) self, "show-tabs");
}


gint xnp_window_get_tabs_position (XnpWindow* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tabs_position;
	return result;
}


void xnp_window_set_tabs_position (XnpWindow* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_tabs_position = value;
	if (self->priv->_tabs_position == 0) {
		xnp_window_set_show_tabs (self, FALSE);
	} else {
		xnp_window_set_show_tabs (self, TRUE);
		_xnp_window_notebook_update_tabs_angle (self);
		if (self->priv->_tabs_position == 1) {
			gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_TOP);
		} else {
			if (self->priv->_tabs_position == 2) {
				gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_RIGHT);
			} else {
				if (self->priv->_tabs_position == 3) {
					gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_BOTTOM);
				} else {
					if (self->priv->_tabs_position == 4) {
						gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_LEFT);
					} else {
						xnp_window_set_show_tabs (self, FALSE);
						g_warning ("window.vala:118: Bad value for tabs-position");
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "tabs-position");
}


gboolean xnp_window_get_above (XnpWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_above;
	return result;
}


void xnp_window_set_above (XnpWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_above = value;
	gtk_window_set_keep_above ((GtkWindow*) self, value);
	g_object_notify ((GObject *) self, "above");
}


gboolean xnp_window_get_sticky (XnpWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sticky;
	return result;
}


void xnp_window_set_sticky (XnpWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_sticky = value;
	if (value == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	if (GTK_IS_CHECK_MENU_ITEM (self->priv->mi_sticky)) {
		gtk_check_menu_item_set_active (self->priv->mi_sticky, self->priv->_sticky);
	}
	g_object_notify ((GObject *) self, "sticky");
}


static GObject * xnp_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpWindow * self;
	parent_class = G_OBJECT_CLASS (xnp_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XNP_WINDOW (obj);
	{
		gtk_widget_set_name ((GtkWidget*) GTK_WINDOW (self), "notes-window");
		gtk_window_set_title ((GtkWindow*) self, _ ("Notes"));
		gtk_window_set_deletable ((GtkWindow*) self, FALSE);
		gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
		g_object_set ((GtkWindow*) self, "default-height", 380, NULL);
		g_object_set ((GtkWindow*) self, "default-width", 300, NULL);
		gtk_window_set_decorated ((GtkWindow*) self, FALSE);
		gtk_window_set_icon_name ((GtkWindow*) self, "xfce4-notes-plugin");
		xnp_window_set_sticky (self, TRUE);
		gtk_window_set_opacity ((GtkWindow*) self, 0.9);
	}
	return obj;
}


static void xnp_window_class_init (XnpWindowClass * klass) {
	xnp_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = xnp_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = xnp_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_N_PAGES, g_param_spec_int ("n-pages", "n-pages", "n-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_TABS, g_param_spec_boolean ("show-tabs", "show-tabs", "show-tabs", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_TABS_POSITION, g_param_spec_int ("tabs-position", "tabs-position", "tabs-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_ABOVE, g_param_spec_boolean ("above", "above", "above", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_STICKY, g_param_spec_boolean ("sticky", "sticky", "sticky", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("action", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("save_data", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_inserted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_deleted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_renamed", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, XNP_TYPE_NOTE, G_TYPE_STRING);
}


static void xnp_window_instance_init (XnpWindow * self) {
	self->priv = XNP_WINDOW_GET_PRIVATE (self);
	self->priv->CORNER_MARGIN = 20;
	self->priv->CURSOR_RIGHT = gdk_cursor_new (GDK_RIGHT_SIDE);
	self->priv->CURSOR_LEFT = gdk_cursor_new (GDK_LEFT_SIDE);
	self->priv->CURSOR_BOTTOM_RC = gdk_cursor_new (GDK_BOTTOM_RIGHT_CORNER);
	self->priv->CURSOR_BOTTOM = gdk_cursor_new (GDK_BOTTOM_SIDE);
	self->priv->CURSOR_BOTTOM_LC = gdk_cursor_new (GDK_BOTTOM_LEFT_CORNER);
	self->priv->_name = g_strdup (_ ("Notes"));
}


static void xnp_window_finalize (GObject* obj) {
	XnpWindow * self;
	self = XNP_WINDOW (obj);
	{
	}
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_above);
	_g_object_unref0 (self->priv->mi_sticky);
	_g_object_unref0 (self->priv->menu_image);
	_g_object_unref0 (self->priv->menu_pixbuf);
	_g_object_unref0 (self->priv->menu_hover_pixbuf);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->left_arrow_button);
	_g_object_unref0 (self->priv->right_arrow_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->content_box);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->ui);
	_g_object_unref0 (self->priv->action_group);
	_gdk_cursor_unref0 (self->priv->CURSOR_RIGHT);
	_gdk_cursor_unref0 (self->priv->CURSOR_LEFT);
	_gdk_cursor_unref0 (self->priv->CURSOR_BOTTOM_RC);
	_gdk_cursor_unref0 (self->priv->CURSOR_BOTTOM);
	_gdk_cursor_unref0 (self->priv->CURSOR_BOTTOM_LC);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (xnp_window_parent_class)->finalize (obj);
}


GType xnp_window_get_type (void) {
	static volatile gsize xnp_window_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindow), 0, (GInstanceInitFunc) xnp_window_instance_init, NULL };
		GType xnp_window_type_id;
		xnp_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "XnpWindow", &g_define_type_info, 0);
		g_once_init_leave (&xnp_window_type_id__volatile, xnp_window_type_id);
	}
	return xnp_window_type_id__volatile;
}


static void xnp_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpWindow * self;
	self = XNP_WINDOW (object);
	switch (property_id) {
		case XNP_WINDOW_NAME:
		g_value_set_string (value, xnp_window_get_name (self));
		break;
		case XNP_WINDOW_N_PAGES:
		g_value_set_int (value, xnp_window_get_n_pages (self));
		break;
		case XNP_WINDOW_SHOW_TABS:
		g_value_set_boolean (value, xnp_window_get_show_tabs (self));
		break;
		case XNP_WINDOW_TABS_POSITION:
		g_value_set_int (value, xnp_window_get_tabs_position (self));
		break;
		case XNP_WINDOW_ABOVE:
		g_value_set_boolean (value, xnp_window_get_above (self));
		break;
		case XNP_WINDOW_STICKY:
		g_value_set_boolean (value, xnp_window_get_sticky (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void xnp_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpWindow * self;
	self = XNP_WINDOW (object);
	switch (property_id) {
		case XNP_WINDOW_NAME:
		xnp_window_set_name (self, g_value_get_string (value));
		break;
		case XNP_WINDOW_N_PAGES:
		xnp_window_set_n_pages (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_SHOW_TABS:
		xnp_window_set_show_tabs (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_TABS_POSITION:
		xnp_window_set_tabs_position (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_ABOVE:
		xnp_window_set_above (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_STICKY:
		xnp_window_set_sticky (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}



