/* window.c generated by valac 0.19.0, the Vala compiler
 * generated from window.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  TODO:
 *  - Follow GNOME bug #551184 to change accelerators hexa values
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
typedef struct _XnpWindowPrivate XnpWindowPrivate;

#define XNP_TYPE_ICON_BUTTON (xnp_icon_button_get_type ())
#define XNP_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButton))
#define XNP_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))
#define XNP_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_ICON_BUTTON))
#define XNP_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_ICON_BUTTON))
#define XNP_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))

typedef struct _XnpIconButton XnpIconButton;
typedef struct _XnpIconButtonClass XnpIconButtonClass;

#define XNP_TYPE_TITLE_BAR_BUTTON (xnp_title_bar_button_get_type ())
#define XNP_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton))
#define XNP_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))
#define XNP_IS_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_IS_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_TITLE_BAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))

typedef struct _XnpTitleBarButton XnpTitleBarButton;
typedef struct _XnpTitleBarButtonClass XnpTitleBarButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gdk_cursor_unref0(var) ((var == NULL) ? NULL : (var = (gdk_cursor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define XNP_TYPE_TITLE_BAR_BUTTON_TYPE (xnp_title_bar_button_type_get_type ())

#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;

struct _XnpWindow {
	GtkWindow parent_instance;
	XnpWindowPrivate * priv;
};

struct _XnpWindowClass {
	GtkWindowClass parent_class;
};

struct _XnpWindowPrivate {
	gint width;
	gint height;
	GtkMenu* menu;
	GtkCheckMenuItem* mi_above;
	GtkCheckMenuItem* mi_sticky;
	GtkImage* menu_image;
	GdkPixbuf* menu_pixbuf;
	GdkPixbuf* menu_hover_pixbuf;
	GtkLabel* title_label;
	XnpTitleBarButton* refresh_button;
	XnpTitleBarButton* left_arrow_button;
	XnpTitleBarButton* right_arrow_button;
	XnpTitleBarButton* close_button;
	GtkVBox* content_box;
	GtkNotebook* notebook;
	GtkUIManager* ui;
	GtkActionGroup* action_group;
	gint CORNER_MARGIN;
	GdkCursor* CURSOR_RIGHT;
	GdkCursor* CURSOR_LEFT;
	GdkCursor* CURSOR_BOTTOM_RC;
	GdkCursor* CURSOR_BOTTOM;
	GdkCursor* CURSOR_BOTTOM_LC;
	GSList* window_list;
	gchar* _name;
	gint _n_pages;
	gint _tabs_position;
	gboolean _above;
	gboolean _sticky;
	gboolean _show_refresh_button;
};

typedef enum  {
	XNP_TITLE_BAR_BUTTON_TYPE_EMPTY,
	XNP_TITLE_BAR_BUTTON_TYPE_CLOSE,
	XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_REFRESH
} XnpTitleBarButtonType;

struct _XnpNote {
	GtkScrolledWindow parent_instance;
	XnpNotePrivate * priv;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkScrolledWindowClass parent_class;
};


static gpointer xnp_window_parent_class = NULL;

GType xnp_window_get_type (void) G_GNUC_CONST;
GType xnp_icon_button_get_type (void) G_GNUC_CONST;
GType xnp_title_bar_button_get_type (void) G_GNUC_CONST;
#define XNP_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_WINDOW, XnpWindowPrivate))
enum  {
	XNP_WINDOW_DUMMY_PROPERTY,
	XNP_WINDOW_NAME,
	XNP_WINDOW_N_PAGES,
	XNP_WINDOW_SHOW_TABS,
	XNP_WINDOW_TABS_POSITION,
	XNP_WINDOW_ABOVE,
	XNP_WINDOW_STICKY,
	XNP_WINDOW_SHOW_REFRESH_BUTTON
};
#define XNP_WINDOW_ui_string "\n" \
"<ui>\n" \
"  <accelerator action=\"close-window\" />\n" \
"  <accelerator action=\"new-window\" />\n" \
"  <accelerator action=\"delete-window\" />\n" \
"  <accelerator action=\"rename-window\" />\n" \
"  <accelerator action=\"new-note\" />\n" \
"  <accelerator action=\"delete-note\" />\n" \
"  <accelerator action=\"rename-note\" />\n" \
"  <accelerator action=\"cancel\" />\n" \
"  <accelerator action=\"next-note\" />\n" \
"  <accelerator action=\"prev-note\" />\n" \
"</ui>\n"
void xnp_window_hide (XnpWindow* self);
static void _xnp_window_hide_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_new_window (XnpWindow* self);
static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_delete_window (XnpWindow* self);
static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_rename_window (XnpWindow* self);
static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_new_note (XnpWindow* self);
static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_delete_note (XnpWindow* self);
static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_rename_note (XnpWindow* self);
static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_cancel (XnpWindow* self);
static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_next_note (XnpWindow* self);
static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action, gpointer self);
static void xnp_window_action_prev_note (XnpWindow* self);
static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action, gpointer self);
XnpWindow* xnp_window_new (void);
XnpWindow* xnp_window_construct (GType object_type);
static GtkMenu* xnp_window_build_menu (XnpWindow* self);
static gboolean __lambda10_ (XnpWindow* self);
static gboolean ___lambda10__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean __lambda11_ (XnpWindow* self);
static gboolean ___lambda11__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
GType xnp_title_bar_button_type_get_type (void) G_GNUC_CONST;
XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type);
XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type, XnpTitleBarButtonType icon_type);
static gboolean xnp_window_menu_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void xnp_window_action_refresh_notes (XnpWindow* self);
static void _xnp_window_action_refresh_notes_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static void _xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static void _xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static void __lambda12_ (XnpWindow* self);
static void ___lambda12__xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self);
static gboolean __lambda13_ (XnpWindow* self);
static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static gboolean __lambda14_ (XnpWindow* self);
static void xnp_window_update_navigation_sensitivity (XnpWindow* self, gint page_num);
static gboolean ___lambda14__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean __lambda15_ (XnpWindow* self);
static gboolean ___lambda15__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean xnp_window_window_leaved_cb (XnpWindow* self);
static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean xnp_window_window_motion_cb (XnpWindow* self, GdkEventMotion* event);
static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean xnp_window_window_pressed_cb (XnpWindow* self, GdkEventButton* event);
static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean xnp_window_window_state_cb (XnpWindow* self, GdkEventWindowState* event);
static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self, GtkWidget* widget, GdkEventScroll* event);
static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void __lambda16_ (XnpWindow* self, GtkNotebook* n, GtkWidget* c, guint p);
static void ___lambda16__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void __lambda17_ (XnpWindow* self, GtkNotebook* n, GtkWidget* c, guint p);
static void ___lambda17__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self);
static void __lambda18_ (XnpWindow* self, GtkNotebook* n, GtkNotebookPage* c, guint p);
GType xnp_note_get_type (void) G_GNUC_CONST;
static void xnp_window_update_title (XnpWindow* self, const gchar* note_name);
const gchar* xnp_note_get_name (XnpNote* self);
static void ___lambda18__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self);
static void __lambda19_ (XnpWindow* self);
static void ___lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda20_ (XnpWindow* self);
static void ___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void xnp_window_unshade (XnpWindow* self);
gboolean xnp_window_get_above (XnpWindow* self);
void xnp_window_set_sticky (XnpWindow* self, gboolean value);
static void xnp_window_shade (XnpWindow* self);
static void xnp_window_note_notify_name_cb (XnpWindow* self, GObject* object, GParamSpec* pspec);
static void _xnp_window_notebook_update_tabs_angle (XnpWindow* self);
XnpNote* xnp_window_insert_note (XnpWindow* self);
void xnp_window_delete_current_note (XnpWindow* self);
void xnp_window_rename_current_note (XnpWindow* self);
GType xnp_hypertext_view_get_type (void) G_GNUC_CONST;
void xnp_hypertext_view_undo (XnpHypertextView* self);
static void xnp_window_menu_position (XnpWindow* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void xnp_window_update_menu_go (XnpWindow* self, GtkWidget* widget);
static void _xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda6_ (XnpWindow* self, GtkCheckMenuItem* o);
void xnp_window_set_above (XnpWindow* self, gboolean value);
static void ___lambda6__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
gboolean xnp_window_get_sticky (XnpWindow* self);
static void __lambda7_ (XnpWindow* self, GtkCheckMenuItem* o);
static void ___lambda7__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda8_ (XnpWindow* self);
static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda9_ (XnpWindow* self);
static void ___lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda3_ (XnpWindow* self, GtkWidget* w);
static void ___lambda3__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* xnp_window_get_name (XnpWindow* self);
static void ________lambda4_ (XnpWindow* self, GtkMenuItem* i);
static void _________lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _____lambda5_ (XnpWindow* self, GtkMenuItem* i);
static void ______lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height);
void xnp_window_set_window_list (XnpWindow* self, GSList* list);
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2);
gint xnp_window_get_current_page (XnpWindow* self);
void xnp_window_set_current_page (XnpWindow* self, gint page);
static gboolean xnp_window_note_name_exists (XnpWindow* self, const gchar* name);
XnpNote* xnp_note_new (const gchar* name);
XnpNote* xnp_note_construct (GType object_type, const gchar* name);
static void _xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda2_ (XnpWindow* self, XnpNote* note);
static void ___lambda2__xnp_note_save_data (XnpNote* _sender, gpointer self);
gint xnp_window_get_n_pages (XnpWindow* self);
void xnp_window_set_n_pages (XnpWindow* self, gint value);
void xnp_note_set_name (XnpNote* self, const gchar* value);
void xnp_window_move_note (XnpWindow* self, const gchar* note_name, gint page);
gchar** xnp_window_get_note_names (XnpWindow* self, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
void xnp_window_delete_note (XnpWindow* self, gint page);
void xnp_window_set_font (XnpWindow* self);
const gchar* xnp_hypertext_view_get_font (XnpHypertextView* self);
void xnp_hypertext_view_set_font (XnpHypertextView* self, const gchar* value);
void xnp_window_save_notes (XnpWindow* self);
gboolean xnp_note_get_dirty (XnpNote* self);
void xnp_note_set_dirty (XnpNote* self, gboolean value);
void xnp_window_set_name (XnpWindow* self, const gchar* value);
gboolean xnp_window_get_show_tabs (XnpWindow* self);
void xnp_window_set_show_tabs (XnpWindow* self, gboolean value);
gint xnp_window_get_tabs_position (XnpWindow* self);
void xnp_window_set_tabs_position (XnpWindow* self, gint value);
gboolean xnp_window_get_show_refresh_button (XnpWindow* self);
void xnp_window_set_show_refresh_button (XnpWindow* self, gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * xnp_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xnp_window_finalize (GObject* obj);
static void _vala_xnp_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_xnp_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GtkActionEntry XNP_WINDOW_action_entries[10] = {{"close-window", NULL, NULL, "Escape", NULL, (GCallback) _xnp_window_hide_gtk_action_callback}, {"new-window", NULL, NULL, "<Ctrl><Shift>n", NULL, (GCallback) _xnp_window_action_new_window_gtk_action_callback}, {"delete-window", NULL, NULL, "<Ctrl><Shift>w", NULL, (GCallback) _xnp_window_action_delete_window_gtk_action_callback}, {"rename-window", NULL, NULL, "<Shift>F2", NULL, (GCallback) _xnp_window_action_rename_window_gtk_action_callback}, {"new-note", NULL, NULL, "<Ctrl>n", NULL, (GCallback) _xnp_window_action_new_note_gtk_action_callback}, {"delete-note", NULL, NULL, "<Ctrl>w", NULL, (GCallback) _xnp_window_action_delete_note_gtk_action_callback}, {"rename-note", NULL, NULL, "F2", NULL, (GCallback) _xnp_window_action_rename_note_gtk_action_callback}, {"cancel", NULL, NULL, "<Ctrl>z", NULL, (GCallback) _xnp_window_action_cancel_gtk_action_callback}, {"next-note", NULL, NULL, "<Ctrl>Page_Down", NULL, (GCallback) _xnp_window_action_next_note_gtk_action_callback}, {"prev-note", NULL, NULL, "<Ctrl>Page_Up", NULL, (GCallback) _xnp_window_action_prev_note_gtk_action_callback}};

static void _xnp_window_hide_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_hide (self);
}


static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_new_window (self);
}


static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_delete_window (self);
}


static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_rename_window (self);
}


static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_rename_note (self);
}


static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_cancel (self);
}


static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_next_note (self);
}


static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action, gpointer self) {
	xnp_window_action_prev_note (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda10_ (XnpWindow* self) {
	gboolean result = FALSE;
	GtkImage* _tmp0_;
	GdkPixbuf* _tmp1_;
	_tmp0_ = self->priv->menu_image;
	_tmp1_ = self->priv->menu_hover_pixbuf;
	gtk_image_set_from_pixbuf (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ___lambda10__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = __lambda10_ (self);
	return result;
}


static gboolean __lambda11_ (XnpWindow* self) {
	gboolean result = FALSE;
	GtkImage* _tmp0_;
	GdkPixbuf* _tmp1_;
	_tmp0_ = self->priv->menu_image;
	_tmp1_ = self->priv->menu_pixbuf;
	gtk_image_set_from_pixbuf (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ___lambda11__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = __lambda11_ (self);
	return result;
}


static gboolean _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_window_menu_evbox_pressed_cb (self, _sender, event);
	return result;
}


static void _xnp_window_action_refresh_notes_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	xnp_window_action_refresh_notes (self);
}


static void _xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	xnp_window_action_prev_note (self);
}


static void _xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	xnp_window_action_next_note (self);
}


static void __lambda12_ (XnpWindow* self) {
	xnp_window_hide (self);
}


static void ___lambda12__xnp_icon_button_clicked (XnpIconButton* _sender, gpointer self) {
	__lambda12_ (self);
}


static gboolean __lambda13_ (XnpWindow* self) {
	gboolean result = FALSE;
	xnp_window_hide (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = __lambda13_ (self);
	return result;
}


static gboolean __lambda14_ (XnpWindow* self) {
	gboolean result = FALSE;
	GtkImage* _tmp0_;
	GtkLabel* _tmp1_;
	XnpTitleBarButton* _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_ = 0;
	XnpTitleBarButton* _tmp5_;
	_tmp0_ = self->priv->menu_image;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->title_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->notebook;
	_tmp4_ = gtk_notebook_get_current_page (_tmp3_);
	xnp_window_update_navigation_sensitivity (self, _tmp4_);
	_tmp5_ = self->priv->close_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
	result = FALSE;
	return result;
}


static gboolean ___lambda14__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda14_ (self);
	return result;
}


static gboolean __lambda15_ (XnpWindow* self) {
	gboolean result = FALSE;
	GtkImage* _tmp0_;
	GtkLabel* _tmp1_;
	XnpTitleBarButton* _tmp2_;
	XnpTitleBarButton* _tmp3_;
	XnpTitleBarButton* _tmp4_;
	XnpTitleBarButton* _tmp5_;
	_tmp0_ = self->priv->menu_image;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->title_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->priv->left_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->right_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->close_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	result = FALSE;
	return result;
}


static gboolean ___lambda15__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda15_ (self);
	return result;
}


static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_leaved_cb (self);
	return result;
}


static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_motion_cb (self, event);
	return result;
}


static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_pressed_cb (self, event);
	return result;
}


static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = xnp_window_window_state_cb (self, event);
	return result;
}


static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_window_title_evbox_pressed_cb (self, _sender, event);
	return result;
}


static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = xnp_window_title_evbox_scrolled_cb (self, _sender, event);
	return result;
}


static void __lambda16_ (XnpWindow* self, GtkNotebook* n, GtkWidget* c, guint p) {
	GtkNotebook* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = p;
	gtk_notebook_set_current_page (_tmp0_, (gint) _tmp1_);
	_tmp2_ = p;
	xnp_window_update_navigation_sensitivity (self, (gint) _tmp2_);
}


static void ___lambda16__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	__lambda16_ (self, _sender, p0, p1);
}


static void __lambda17_ (XnpWindow* self, GtkNotebook* n, GtkWidget* c, guint p) {
	guint _tmp0_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = p;
	xnp_window_update_navigation_sensitivity (self, (gint) _tmp0_);
}


static void ___lambda17__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* p0, guint p1, gpointer self) {
	__lambda17_ (self, _sender, p0, p1);
}


static void __lambda18_ (XnpWindow* self, GtkNotebook* n, GtkNotebookPage* c, guint p) {
	GtkNotebook* _tmp0_;
	guint _tmp1_;
	GtkWidget* _tmp2_ = NULL;
	XnpNote* _tmp3_;
	XnpNote* note;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	guint _tmp6_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = p;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp0_, (gint) _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp3_;
	_tmp4_ = xnp_note_get_name (note);
	_tmp5_ = _tmp4_;
	xnp_window_update_title (self, _tmp5_);
	_tmp6_ = p;
	xnp_window_update_navigation_sensitivity (self, (gint) _tmp6_);
	_g_object_unref0 (note);
}


static void ___lambda18__gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self) {
	__lambda18_ (self, _sender, page, page_num);
}


static void __lambda19_ (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint page;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	XnpNote* _tmp6_;
	XnpNote* current_note;
	XnpNote* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->notebook;
	_tmp4_ = page;
	_tmp5_ = gtk_notebook_get_nth_page (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, XNP_TYPE_NOTE, XnpNote));
	current_note = _tmp6_;
	_tmp7_ = current_note;
	_tmp8_ = xnp_note_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	xnp_window_update_title (self, _tmp9_);
	_g_object_unref0 (current_note);
}


static void ___lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda19_ (self);
}


static void __lambda20_ (XnpWindow* self) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	_tmp0_ = self->priv->title_label;
	_tmp1_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
}


static void ___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda20_ (self);
}


XnpWindow* xnp_window_construct (GType object_type) {
	XnpWindow * self = NULL;
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkUIManager* _tmp2_;
	GtkUIManager* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkMenu* _tmp10_ = NULL;
	GtkMenu* _tmp11_;
	GtkFrame* _tmp12_;
	GtkFrame* frame;
	GtkFrame* _tmp13_;
	GtkFrame* _tmp14_;
	GtkRcStyle* _tmp15_ = NULL;
	GtkRcStyle* _tmp16_;
	GtkRcStyle* style;
	GtkRcStyle* _tmp17_;
	GtkRcStyle* _tmp18_;
	GtkFrame* _tmp19_;
	GtkRcStyle* _tmp20_;
	GtkFrame* _tmp21_;
	GtkFrame* _tmp22_;
	GtkVBox* _tmp23_;
	GtkVBox* vbox_frame;
	GtkVBox* _tmp24_;
	GtkVBox* _tmp25_;
	GtkFrame* _tmp26_;
	GtkVBox* _tmp27_;
	GtkHBox* _tmp28_;
	GtkHBox* title_box;
	GtkEventBox* _tmp29_;
	GtkEventBox* menu_evbox;
	GtkEventBox* _tmp30_;
	const gchar* _tmp31_ = NULL;
	GtkEventBox* _tmp32_;
	GdkPixbuf* _tmp45_;
	GtkImage* _tmp46_;
	GtkEventBox* _tmp47_;
	GtkImage* _tmp48_;
	GtkEventBox* _tmp49_;
	GtkEventBox* _tmp50_;
	GtkHBox* _tmp51_;
	GtkEventBox* _tmp52_;
	GtkEventBox* _tmp53_;
	GtkEventBox* title_evbox;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	GtkHBox* _tmp65_;
	XnpTitleBarButton* _tmp66_;
	XnpTitleBarButton* _tmp67_;
	const gchar* _tmp68_ = NULL;
	XnpTitleBarButton* _tmp69_;
	XnpTitleBarButton* _tmp70_;
	GtkHBox* _tmp71_;
	XnpTitleBarButton* _tmp72_;
	XnpTitleBarButton* _tmp73_;
	XnpTitleBarButton* _tmp74_;
	const gchar* _tmp75_ = NULL;
	XnpTitleBarButton* _tmp76_;
	GtkHBox* _tmp77_;
	XnpTitleBarButton* _tmp78_;
	XnpTitleBarButton* _tmp79_;
	XnpTitleBarButton* _tmp80_;
	const gchar* _tmp81_ = NULL;
	XnpTitleBarButton* _tmp82_;
	GtkHBox* _tmp83_;
	XnpTitleBarButton* _tmp84_;
	XnpTitleBarButton* _tmp85_;
	XnpTitleBarButton* _tmp86_;
	const gchar* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	gchar* _tmp90_;
	GtkHBox* _tmp91_;
	XnpTitleBarButton* _tmp92_;
	GtkHBox* _tmp93_;
	GtkVBox* _tmp94_;
	GtkHBox* _tmp95_;
	GtkVBox* _tmp96_;
	GtkVBox* _tmp97_;
	GtkVBox* _tmp98_;
	GtkVBox* _tmp99_;
	GtkNotebook* _tmp100_;
	GtkNotebook* _tmp101_;
	GtkNotebook* _tmp102_;
	GtkNotebook* _tmp103_;
	GtkNotebook* _tmp104_;
	GtkNotebook* _tmp105_;
	GtkNotebook* _tmp106_;
	GtkNotebook* _tmp107_;
	GtkVBox* _tmp108_;
	GtkNotebook* _tmp109_;
	GtkEventBox* _tmp110_;
	XnpTitleBarButton* _tmp111_;
	XnpTitleBarButton* _tmp112_;
	XnpTitleBarButton* _tmp113_;
	XnpTitleBarButton* _tmp114_;
	GtkNotebook* _tmp115_;
	GtkNotebook* _tmp116_;
	GtkNotebook* _tmp117_;
	GError * _inner_error_ = NULL;
	self = (XnpWindow*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK) | GDK_BUTTON_PRESS_MASK));
	_tmp0_ = gtk_action_group_new ("XNP");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp0_;
	_tmp1_ = self->priv->action_group;
	gtk_action_group_add_actions (_tmp1_, XNP_WINDOW_action_entries, G_N_ELEMENTS (XNP_WINDOW_action_entries), self);
	_tmp2_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui);
	self->priv->ui = _tmp2_;
	_tmp3_ = self->priv->ui;
	_tmp4_ = self->priv->action_group;
	gtk_ui_manager_insert_action_group (_tmp3_, _tmp4_, 0);
	{
		GtkUIManager* _tmp5_;
		GtkUIManager* _tmp6_;
		GtkAccelGroup* _tmp7_ = NULL;
		_tmp5_ = self->priv->ui;
		gtk_ui_manager_add_ui_from_string (_tmp5_, XNP_WINDOW_ui_string, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		_tmp6_ = self->priv->ui;
		_tmp7_ = gtk_ui_manager_get_accel_group (_tmp6_);
		gtk_window_add_accel_group ((GtkWindow*) self, _tmp7_);
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("window.vala:206: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = xnp_window_build_menu (self);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp10_;
	_tmp11_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp12_);
	frame = _tmp12_;
	_tmp13_ = frame;
	gtk_frame_set_shadow_type (_tmp13_, GTK_SHADOW_NONE);
	_tmp14_ = frame;
	_tmp15_ = gtk_widget_get_modifier_style ((GtkWidget*) _tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	style = _tmp16_;
	_tmp17_ = style;
	_tmp17_->xthickness = 1;
	_tmp18_ = style;
	_tmp18_->ythickness = 3;
	_tmp19_ = frame;
	_tmp20_ = style;
	gtk_widget_modify_style ((GtkWidget*) _tmp19_, _tmp20_);
	_tmp21_ = frame;
	gtk_widget_show ((GtkWidget*) _tmp21_);
	_tmp22_ = frame;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	g_object_ref_sink (_tmp23_);
	vbox_frame = _tmp23_;
	_tmp24_ = vbox_frame;
	gtk_box_set_spacing ((GtkBox*) _tmp24_, 1);
	_tmp25_ = vbox_frame;
	gtk_widget_show ((GtkWidget*) _tmp25_);
	_tmp26_ = frame;
	_tmp27_ = vbox_frame;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	g_object_ref_sink (_tmp28_);
	title_box = _tmp28_;
	_tmp29_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp29_);
	menu_evbox = _tmp29_;
	_tmp30_ = menu_evbox;
	_tmp31_ = _ ("Menu");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _tmp31_);
	_tmp32_ = menu_evbox;
	gtk_event_box_set_visible_window (_tmp32_, FALSE);
	{
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		GdkPixbuf* _tmp35_;
		GdkPixbuf* _tmp36_;
		GdkPixbuf* _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		GdkPixbuf* _tmp40_;
		GdkPixbuf* _tmp41_;
		GdkPixbuf* _tmp42_;
		_tmp33_ = g_strdup_printf ("%s/pixmaps/notes-menu.png", PKGDATADIR);
		_tmp34_ = _tmp33_;
		_tmp35_ = gdk_pixbuf_new_from_file (_tmp34_, &_inner_error_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		_tmp37_ = _tmp36_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_g_object_unref0 (self->priv->menu_pixbuf);
		self->priv->menu_pixbuf = _tmp37_;
		_tmp38_ = g_strdup_printf ("%s/pixmaps/notes-menu-active.png", PKGDATADIR);
		_tmp39_ = _tmp38_;
		_tmp40_ = gdk_pixbuf_new_from_file (_tmp39_, &_inner_error_);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		_tmp42_ = _tmp41_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_g_object_unref0 (self->priv->menu_hover_pixbuf);
		self->priv->menu_hover_pixbuf = _tmp42_;
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GdkPixbuf* _tmp43_;
		GdkPixbuf* _tmp44_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->menu_hover_pixbuf);
		self->priv->menu_hover_pixbuf = NULL;
		_tmp43_ = self->priv->menu_hover_pixbuf;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_g_object_unref0 (self->priv->menu_pixbuf);
		self->priv->menu_pixbuf = _tmp44_;
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (menu_evbox);
		_g_object_unref0 (title_box);
		_g_object_unref0 (vbox_frame);
		_g_object_unref0 (style);
		_g_object_unref0 (frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp45_ = self->priv->menu_pixbuf;
	_tmp46_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp45_);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->menu_image);
	self->priv->menu_image = _tmp46_;
	_tmp47_ = menu_evbox;
	_tmp48_ = self->priv->menu_image;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = menu_evbox;
	g_signal_connect_object ((GtkWidget*) _tmp49_, "enter-notify-event", (GCallback) ___lambda10__gtk_widget_enter_notify_event, self, 0);
	_tmp50_ = menu_evbox;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "leave-notify-event", (GCallback) ___lambda11__gtk_widget_leave_notify_event, self, 0);
	_tmp51_ = title_box;
	_tmp52_ = menu_evbox;
	gtk_box_pack_start ((GtkBox*) _tmp51_, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 2);
	_tmp53_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp53_);
	title_evbox = _tmp53_;
	gtk_event_box_set_visible_window (title_evbox, FALSE);
	_tmp54_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp54_;
	_tmp55_ = self->priv->title_label;
	_tmp56_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strconcat ("<b>", _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_strconcat (_tmp59_, "</b>", NULL);
	_tmp61_ = _tmp60_;
	gtk_label_set_markup (_tmp55_, _tmp61_);
	_g_free0 (_tmp61_);
	_g_free0 (_tmp59_);
	_tmp62_ = self->priv->title_label;
	gtk_label_set_ellipsize (_tmp62_, PANGO_ELLIPSIZE_END);
	_tmp63_ = self->priv->title_label;
	g_object_set ((GtkMisc*) _tmp63_, "xalign", (gfloat) 0.0, NULL);
	_tmp64_ = self->priv->title_label;
	gtk_container_add ((GtkContainer*) title_evbox, (GtkWidget*) _tmp64_);
	_tmp65_ = title_box;
	gtk_box_pack_start ((GtkBox*) _tmp65_, (GtkWidget*) title_evbox, TRUE, TRUE, (guint) 6);
	_tmp66_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_REFRESH);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->refresh_button);
	self->priv->refresh_button = _tmp66_;
	_tmp67_ = self->priv->refresh_button;
	_tmp68_ = _ ("Refresh notes");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp67_, _tmp68_);
	_tmp69_ = self->priv->refresh_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp69_, TRUE);
	_tmp70_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp70_, FALSE);
	_tmp71_ = title_box;
	_tmp72_ = self->priv->refresh_button;
	gtk_box_pack_start ((GtkBox*) _tmp71_, (GtkWidget*) _tmp72_, FALSE, FALSE, (guint) 2);
	_tmp73_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->left_arrow_button);
	self->priv->left_arrow_button = _tmp73_;
	_tmp74_ = self->priv->left_arrow_button;
	_tmp75_ = gtk_accelerator_get_label ((guint) 0xff55, GDK_CONTROL_MASK);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp74_, _tmp75_);
	_tmp76_ = self->priv->left_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp76_, FALSE);
	_tmp77_ = title_box;
	_tmp78_ = self->priv->left_arrow_button;
	gtk_box_pack_start ((GtkBox*) _tmp77_, (GtkWidget*) _tmp78_, FALSE, FALSE, (guint) 2);
	_tmp79_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW);
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->priv->right_arrow_button);
	self->priv->right_arrow_button = _tmp79_;
	_tmp80_ = self->priv->right_arrow_button;
	_tmp81_ = gtk_accelerator_get_label ((guint) 0xff56, GDK_CONTROL_MASK);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp80_, _tmp81_);
	_tmp82_ = self->priv->right_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp82_, FALSE);
	_tmp83_ = title_box;
	_tmp84_ = self->priv->right_arrow_button;
	gtk_box_pack_start ((GtkBox*) _tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE, (guint) 2);
	_tmp85_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_CLOSE);
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp85_;
	_tmp86_ = self->priv->close_button;
	_tmp87_ = _ ("Hide (%s)");
	_tmp88_ = gtk_accelerator_get_label ((guint) 0xff1b, 0);
	_tmp89_ = g_strdup_printf (_tmp87_, _tmp88_);
	_tmp90_ = _tmp89_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp86_, _tmp90_);
	_g_free0 (_tmp90_);
	_tmp91_ = title_box;
	_tmp92_ = self->priv->close_button;
	gtk_box_pack_start ((GtkBox*) _tmp91_, (GtkWidget*) _tmp92_, FALSE, FALSE, (guint) 2);
	_tmp93_ = title_box;
	gtk_widget_show_all ((GtkWidget*) _tmp93_);
	_tmp94_ = vbox_frame;
	_tmp95_ = title_box;
	gtk_box_pack_start ((GtkBox*) _tmp94_, (GtkWidget*) _tmp95_, FALSE, FALSE, (guint) 0);
	_tmp96_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	g_object_ref_sink (_tmp96_);
	_g_object_unref0 (self->priv->content_box);
	self->priv->content_box = _tmp96_;
	_tmp97_ = self->priv->content_box;
	gtk_widget_show ((GtkWidget*) _tmp97_);
	_tmp98_ = vbox_frame;
	_tmp99_ = self->priv->content_box;
	gtk_box_pack_start ((GtkBox*) _tmp98_, (GtkWidget*) _tmp99_, TRUE, TRUE, (guint) 0);
	_tmp100_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp100_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp100_;
	_tmp101_ = self->priv->notebook;
	gtk_widget_set_name ((GtkWidget*) _tmp101_, "notes-notebook");
	_tmp102_ = self->priv->notebook;
	gtk_notebook_set_show_border (_tmp102_, TRUE);
	_tmp103_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp103_, FALSE);
	_tmp104_ = self->priv->notebook;
	gtk_notebook_set_tab_pos (_tmp104_, GTK_POS_TOP);
	_tmp105_ = self->priv->notebook;
	g_object_set (_tmp105_, "tab-border", (guint) 4, NULL);
	_tmp106_ = self->priv->notebook;
	gtk_notebook_set_scrollable (_tmp106_, TRUE);
	_tmp107_ = self->priv->notebook;
	gtk_widget_show ((GtkWidget*) _tmp107_);
	_tmp108_ = self->priv->content_box;
	_tmp109_ = self->priv->notebook;
	gtk_box_pack_start ((GtkBox*) _tmp108_, (GtkWidget*) _tmp109_, TRUE, TRUE, (guint) 0);
	_tmp110_ = menu_evbox;
	g_signal_connect_object ((GtkWidget*) _tmp110_, "button-press-event", (GCallback) _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	_tmp111_ = self->priv->refresh_button;
	g_signal_connect_object ((XnpIconButton*) _tmp111_, "clicked", (GCallback) _xnp_window_action_refresh_notes_xnp_icon_button_clicked, self, 0);
	_tmp112_ = self->priv->left_arrow_button;
	g_signal_connect_object ((XnpIconButton*) _tmp112_, "clicked", (GCallback) _xnp_window_action_prev_note_xnp_icon_button_clicked, self, 0);
	_tmp113_ = self->priv->right_arrow_button;
	g_signal_connect_object ((XnpIconButton*) _tmp113_, "clicked", (GCallback) _xnp_window_action_next_note_xnp_icon_button_clicked, self, 0);
	_tmp114_ = self->priv->close_button;
	g_signal_connect_object ((XnpIconButton*) _tmp114_, "clicked", (GCallback) ___lambda12__xnp_icon_button_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda13__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) ___lambda14__gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda15__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_window_window_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _xnp_window_window_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xnp_window_window_state_cb_gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "button-press-event", (GCallback) _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "scroll-event", (GCallback) _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event, self, 0);
	_tmp115_ = self->priv->notebook;
	g_signal_connect_object (_tmp115_, "page-added", (GCallback) ___lambda16__gtk_notebook_page_added, self, 0);
	_tmp116_ = self->priv->notebook;
	g_signal_connect_object (_tmp116_, "page-removed", (GCallback) ___lambda17__gtk_notebook_page_removed, self, 0);
	_tmp117_ = self->priv->notebook;
	g_signal_connect_object (_tmp117_, "switch-page", (GCallback) ___lambda18__gtk_notebook_switch_page, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::name", (GCallback) ___lambda19__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::title", (GCallback) ___lambda20__g_object_notify, self, 0);
	_g_object_unref0 (title_evbox);
	_g_object_unref0 (menu_evbox);
	_g_object_unref0 (title_box);
	_g_object_unref0 (vbox_frame);
	_g_object_unref0 (style);
	_g_object_unref0 (frame);
	return self;
}


XnpWindow* xnp_window_new (void) {
	return xnp_window_construct (XNP_TYPE_WINDOW);
}


/**
 * hide:
 *
 * Save position before hidding.
 */
void xnp_window_hide (XnpWindow* self) {
	gint winx = 0;
	gint winy = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	winx = _tmp0_;
	winy = _tmp1_;
	GTK_WIDGET_CLASS (xnp_window_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow));
	gtk_window_deiconify ((GtkWindow*) self);
	xnp_window_unshade (self);
	gtk_window_move ((GtkWindow*) self, winx, winy);
	_tmp2_ = xnp_window_get_above (self);
	_tmp3_ = _tmp2_;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp3_);
}


/**
 * window_leaved_cb:
 *
 * Reset the mouse cursor.
 */
static gboolean xnp_window_window_leaved_cb (XnpWindow* self) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
	result = TRUE;
	return result;
}


/**
 * window_motion_cb:
 *
 * Update mouse cursor.
 */
static gboolean xnp_window_window_motion_cb (XnpWindow* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkEventMotion _tmp4_;
	gdouble _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GdkEventMotion _tmp22_;
	gdouble _tmp23_;
	GtkAllocation _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gboolean _tmp30_;
	gboolean _tmp36_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.x;
	if (_tmp5_ > ((gdouble) 4)) {
		GdkEventMotion _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.y;
		_tmp3_ = _tmp7_ > ((gdouble) 4);
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		GdkEventMotion _tmp9_;
		gdouble _tmp10_;
		GtkAllocation _tmp11_;
		gint _tmp12_;
		_tmp9_ = *event;
		_tmp10_ = _tmp9_.x;
		_tmp11_ = allocation;
		_tmp12_ = _tmp11_.width;
		_tmp2_ = _tmp10_ < ((gdouble) (_tmp12_ - 4));
	} else {
		_tmp2_ = FALSE;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		GdkEventMotion _tmp14_;
		gdouble _tmp15_;
		GtkAllocation _tmp16_;
		gint _tmp17_;
		_tmp14_ = *event;
		_tmp15_ = _tmp14_.y;
		_tmp16_ = allocation;
		_tmp17_ = _tmp16_.height;
		_tmp1_ = _tmp15_ < ((gdouble) (_tmp17_ - 4));
	} else {
		_tmp1_ = FALSE;
	}
	_tmp18_ = _tmp1_;
	if (_tmp18_) {
		GdkWindow* _tmp19_ = NULL;
		_tmp19_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp19_, NULL);
		result = FALSE;
		return result;
	}
	_tmp22_ = *event;
	_tmp23_ = _tmp22_.x;
	_tmp24_ = allocation;
	_tmp25_ = _tmp24_.width;
	_tmp26_ = self->priv->CORNER_MARGIN;
	if (_tmp23_ >= ((gdouble) (_tmp25_ - _tmp26_))) {
		GdkEventMotion _tmp27_;
		gdouble _tmp28_;
		gint _tmp29_;
		_tmp27_ = *event;
		_tmp28_ = _tmp27_.y;
		_tmp29_ = self->priv->CORNER_MARGIN;
		_tmp21_ = _tmp28_ >= ((gdouble) _tmp29_);
	} else {
		_tmp21_ = FALSE;
	}
	_tmp30_ = _tmp21_;
	if (_tmp30_) {
		GdkEventMotion _tmp31_;
		gdouble _tmp32_;
		GtkAllocation _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp31_ = *event;
		_tmp32_ = _tmp31_.y;
		_tmp33_ = allocation;
		_tmp34_ = _tmp33_.height;
		_tmp35_ = self->priv->CORNER_MARGIN;
		_tmp20_ = _tmp32_ < ((gdouble) (_tmp34_ - _tmp35_));
	} else {
		_tmp20_ = FALSE;
	}
	_tmp36_ = _tmp20_;
	if (_tmp36_) {
		GdkWindow* _tmp37_ = NULL;
		GdkCursor* _tmp38_;
		_tmp37_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp38_ = self->priv->CURSOR_RIGHT;
		gdk_window_set_cursor (_tmp37_, _tmp38_);
	} else {
		gboolean _tmp39_ = FALSE;
		GdkEventMotion _tmp40_;
		gdouble _tmp41_;
		GtkAllocation _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gboolean _tmp50_;
		_tmp40_ = *event;
		_tmp41_ = _tmp40_.x;
		_tmp42_ = allocation;
		_tmp43_ = _tmp42_.width;
		_tmp44_ = self->priv->CORNER_MARGIN;
		if (_tmp41_ >= ((gdouble) (_tmp43_ - _tmp44_))) {
			GdkEventMotion _tmp45_;
			gdouble _tmp46_;
			GtkAllocation _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			_tmp45_ = *event;
			_tmp46_ = _tmp45_.y;
			_tmp47_ = allocation;
			_tmp48_ = _tmp47_.height;
			_tmp49_ = self->priv->CORNER_MARGIN;
			_tmp39_ = _tmp46_ >= ((gdouble) (_tmp48_ - _tmp49_));
		} else {
			_tmp39_ = FALSE;
		}
		_tmp50_ = _tmp39_;
		if (_tmp50_) {
			GdkWindow* _tmp51_ = NULL;
			GdkCursor* _tmp52_;
			_tmp51_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp52_ = self->priv->CURSOR_BOTTOM_RC;
			gdk_window_set_cursor (_tmp51_, _tmp52_);
		} else {
			gboolean _tmp53_ = FALSE;
			gboolean _tmp54_ = FALSE;
			GdkEventMotion _tmp55_;
			gdouble _tmp56_;
			gint _tmp57_;
			gboolean _tmp63_;
			gboolean _tmp69_;
			_tmp55_ = *event;
			_tmp56_ = _tmp55_.x;
			_tmp57_ = self->priv->CORNER_MARGIN;
			if (_tmp56_ > ((gdouble) _tmp57_)) {
				GdkEventMotion _tmp58_;
				gdouble _tmp59_;
				GtkAllocation _tmp60_;
				gint _tmp61_;
				gint _tmp62_;
				_tmp58_ = *event;
				_tmp59_ = _tmp58_.y;
				_tmp60_ = allocation;
				_tmp61_ = _tmp60_.height;
				_tmp62_ = self->priv->CORNER_MARGIN;
				_tmp54_ = _tmp59_ > ((gdouble) (_tmp61_ - _tmp62_));
			} else {
				_tmp54_ = FALSE;
			}
			_tmp63_ = _tmp54_;
			if (_tmp63_) {
				GdkEventMotion _tmp64_;
				gdouble _tmp65_;
				GtkAllocation _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				_tmp64_ = *event;
				_tmp65_ = _tmp64_.x;
				_tmp66_ = allocation;
				_tmp67_ = _tmp66_.width;
				_tmp68_ = self->priv->CORNER_MARGIN;
				_tmp53_ = _tmp65_ < ((gdouble) (_tmp67_ - _tmp68_));
			} else {
				_tmp53_ = FALSE;
			}
			_tmp69_ = _tmp53_;
			if (_tmp69_) {
				GdkWindow* _tmp70_ = NULL;
				GdkCursor* _tmp71_;
				_tmp70_ = gtk_widget_get_window ((GtkWidget*) self);
				_tmp71_ = self->priv->CURSOR_BOTTOM;
				gdk_window_set_cursor (_tmp70_, _tmp71_);
			} else {
				gboolean _tmp72_ = FALSE;
				GdkEventMotion _tmp73_;
				gdouble _tmp74_;
				gint _tmp75_;
				gboolean _tmp81_;
				_tmp73_ = *event;
				_tmp74_ = _tmp73_.x;
				_tmp75_ = self->priv->CORNER_MARGIN;
				if (_tmp74_ <= ((gdouble) _tmp75_)) {
					GdkEventMotion _tmp76_;
					gdouble _tmp77_;
					GtkAllocation _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					_tmp76_ = *event;
					_tmp77_ = _tmp76_.y;
					_tmp78_ = allocation;
					_tmp79_ = _tmp78_.height;
					_tmp80_ = self->priv->CORNER_MARGIN;
					_tmp72_ = _tmp77_ >= ((gdouble) (_tmp79_ - _tmp80_));
				} else {
					_tmp72_ = FALSE;
				}
				_tmp81_ = _tmp72_;
				if (_tmp81_) {
					GdkWindow* _tmp82_ = NULL;
					GdkCursor* _tmp83_;
					_tmp82_ = gtk_widget_get_window ((GtkWidget*) self);
					_tmp83_ = self->priv->CURSOR_BOTTOM_LC;
					gdk_window_set_cursor (_tmp82_, _tmp83_);
				} else {
					gboolean _tmp84_ = FALSE;
					gboolean _tmp85_ = FALSE;
					GdkEventMotion _tmp86_;
					gdouble _tmp87_;
					gint _tmp88_;
					gboolean _tmp92_;
					gboolean _tmp98_;
					_tmp86_ = *event;
					_tmp87_ = _tmp86_.x;
					_tmp88_ = self->priv->CORNER_MARGIN;
					if (_tmp87_ <= ((gdouble) _tmp88_)) {
						GdkEventMotion _tmp89_;
						gdouble _tmp90_;
						gint _tmp91_;
						_tmp89_ = *event;
						_tmp90_ = _tmp89_.y;
						_tmp91_ = self->priv->CORNER_MARGIN;
						_tmp85_ = _tmp90_ >= ((gdouble) _tmp91_);
					} else {
						_tmp85_ = FALSE;
					}
					_tmp92_ = _tmp85_;
					if (_tmp92_) {
						GdkEventMotion _tmp93_;
						gdouble _tmp94_;
						GtkAllocation _tmp95_;
						gint _tmp96_;
						gint _tmp97_;
						_tmp93_ = *event;
						_tmp94_ = _tmp93_.y;
						_tmp95_ = allocation;
						_tmp96_ = _tmp95_.height;
						_tmp97_ = self->priv->CORNER_MARGIN;
						_tmp84_ = _tmp94_ < ((gdouble) (_tmp96_ - _tmp97_));
					} else {
						_tmp84_ = FALSE;
					}
					_tmp98_ = _tmp84_;
					if (_tmp98_) {
						GdkWindow* _tmp99_ = NULL;
						GdkCursor* _tmp100_;
						_tmp99_ = gtk_widget_get_window ((GtkWidget*) self);
						_tmp100_ = self->priv->CURSOR_LEFT;
						gdk_window_set_cursor (_tmp99_, _tmp100_);
					} else {
						GdkWindow* _tmp101_ = NULL;
						_tmp101_ = gtk_widget_get_window ((GtkWidget*) self);
						gdk_window_set_cursor (_tmp101_, NULL);
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


/**
 * window_pressed_cb:
 *
 * Start a window resize depending on mouse pointer location.
 */
static gboolean xnp_window_window_pressed_cb (XnpWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkWindowEdge edge = 0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkEventButton _tmp4_;
	gdouble _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GdkEventButton _tmp21_;
	gdouble _tmp22_;
	gint _tmp23_;
	gboolean _tmp29_;
	gboolean _tmp35_;
	GdkWindowEdge _tmp90_;
	GdkEventButton _tmp91_;
	guint _tmp92_;
	GdkEventButton _tmp93_;
	gdouble _tmp94_;
	GdkEventButton _tmp95_;
	gdouble _tmp96_;
	GdkEventButton _tmp97_;
	guint32 _tmp98_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.x;
	if (_tmp5_ > ((gdouble) 4)) {
		GdkEventButton _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.y;
		_tmp3_ = _tmp7_ > ((gdouble) 4);
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		GdkEventButton _tmp9_;
		gdouble _tmp10_;
		GtkAllocation _tmp11_;
		gint _tmp12_;
		_tmp9_ = *event;
		_tmp10_ = _tmp9_.x;
		_tmp11_ = allocation;
		_tmp12_ = _tmp11_.width;
		_tmp2_ = _tmp10_ < ((gdouble) (_tmp12_ - 4));
	} else {
		_tmp2_ = FALSE;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		GdkEventButton _tmp14_;
		gdouble _tmp15_;
		GtkAllocation _tmp16_;
		gint _tmp17_;
		_tmp14_ = *event;
		_tmp15_ = _tmp14_.y;
		_tmp16_ = allocation;
		_tmp17_ = _tmp16_.height;
		_tmp1_ = _tmp15_ < ((gdouble) (_tmp17_ - 4));
	} else {
		_tmp1_ = FALSE;
	}
	_tmp18_ = _tmp1_;
	if (_tmp18_) {
		result = FALSE;
		return result;
	}
	_tmp21_ = *event;
	_tmp22_ = _tmp21_.y;
	_tmp23_ = self->priv->CORNER_MARGIN;
	if (_tmp22_ > ((gdouble) _tmp23_)) {
		GdkEventButton _tmp24_;
		gdouble _tmp25_;
		GtkAllocation _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp24_ = *event;
		_tmp25_ = _tmp24_.x;
		_tmp26_ = allocation;
		_tmp27_ = _tmp26_.width;
		_tmp28_ = self->priv->CORNER_MARGIN;
		_tmp20_ = _tmp25_ > ((gdouble) (_tmp27_ - _tmp28_));
	} else {
		_tmp20_ = FALSE;
	}
	_tmp29_ = _tmp20_;
	if (_tmp29_) {
		GdkEventButton _tmp30_;
		gdouble _tmp31_;
		GtkAllocation _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp30_ = *event;
		_tmp31_ = _tmp30_.y;
		_tmp32_ = allocation;
		_tmp33_ = _tmp32_.height;
		_tmp34_ = self->priv->CORNER_MARGIN;
		_tmp19_ = _tmp31_ < ((gdouble) (_tmp33_ - _tmp34_));
	} else {
		_tmp19_ = FALSE;
	}
	_tmp35_ = _tmp19_;
	if (_tmp35_) {
		edge = GDK_WINDOW_EDGE_EAST;
	} else {
		gboolean _tmp36_ = FALSE;
		GdkEventButton _tmp37_;
		gdouble _tmp38_;
		GtkAllocation _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gboolean _tmp47_;
		_tmp37_ = *event;
		_tmp38_ = _tmp37_.x;
		_tmp39_ = allocation;
		_tmp40_ = _tmp39_.width;
		_tmp41_ = self->priv->CORNER_MARGIN;
		if (_tmp38_ >= ((gdouble) (_tmp40_ - _tmp41_))) {
			GdkEventButton _tmp42_;
			gdouble _tmp43_;
			GtkAllocation _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			_tmp42_ = *event;
			_tmp43_ = _tmp42_.y;
			_tmp44_ = allocation;
			_tmp45_ = _tmp44_.height;
			_tmp46_ = self->priv->CORNER_MARGIN;
			_tmp36_ = _tmp43_ >= ((gdouble) (_tmp45_ - _tmp46_));
		} else {
			_tmp36_ = FALSE;
		}
		_tmp47_ = _tmp36_;
		if (_tmp47_) {
			edge = GDK_WINDOW_EDGE_SOUTH_EAST;
		} else {
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_ = FALSE;
			GdkEventButton _tmp50_;
			gdouble _tmp51_;
			gint _tmp52_;
			gboolean _tmp58_;
			gboolean _tmp64_;
			_tmp50_ = *event;
			_tmp51_ = _tmp50_.x;
			_tmp52_ = self->priv->CORNER_MARGIN;
			if (_tmp51_ > ((gdouble) _tmp52_)) {
				GdkEventButton _tmp53_;
				gdouble _tmp54_;
				GtkAllocation _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				_tmp53_ = *event;
				_tmp54_ = _tmp53_.y;
				_tmp55_ = allocation;
				_tmp56_ = _tmp55_.height;
				_tmp57_ = self->priv->CORNER_MARGIN;
				_tmp49_ = _tmp54_ > ((gdouble) (_tmp56_ - _tmp57_));
			} else {
				_tmp49_ = FALSE;
			}
			_tmp58_ = _tmp49_;
			if (_tmp58_) {
				GdkEventButton _tmp59_;
				gdouble _tmp60_;
				GtkAllocation _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				_tmp59_ = *event;
				_tmp60_ = _tmp59_.x;
				_tmp61_ = allocation;
				_tmp62_ = _tmp61_.width;
				_tmp63_ = self->priv->CORNER_MARGIN;
				_tmp48_ = _tmp60_ < ((gdouble) (_tmp62_ - _tmp63_));
			} else {
				_tmp48_ = FALSE;
			}
			_tmp64_ = _tmp48_;
			if (_tmp64_) {
				edge = GDK_WINDOW_EDGE_SOUTH;
			} else {
				gboolean _tmp65_ = FALSE;
				GdkEventButton _tmp66_;
				gdouble _tmp67_;
				gint _tmp68_;
				gboolean _tmp74_;
				_tmp66_ = *event;
				_tmp67_ = _tmp66_.x;
				_tmp68_ = self->priv->CORNER_MARGIN;
				if (_tmp67_ <= ((gdouble) _tmp68_)) {
					GdkEventButton _tmp69_;
					gdouble _tmp70_;
					GtkAllocation _tmp71_;
					gint _tmp72_;
					gint _tmp73_;
					_tmp69_ = *event;
					_tmp70_ = _tmp69_.y;
					_tmp71_ = allocation;
					_tmp72_ = _tmp71_.height;
					_tmp73_ = self->priv->CORNER_MARGIN;
					_tmp65_ = _tmp70_ >= ((gdouble) (_tmp72_ - _tmp73_));
				} else {
					_tmp65_ = FALSE;
				}
				_tmp74_ = _tmp65_;
				if (_tmp74_) {
					edge = GDK_WINDOW_EDGE_SOUTH_WEST;
				} else {
					gboolean _tmp75_ = FALSE;
					gboolean _tmp76_ = FALSE;
					GdkEventButton _tmp77_;
					gdouble _tmp78_;
					gint _tmp79_;
					gboolean _tmp83_;
					gboolean _tmp89_;
					_tmp77_ = *event;
					_tmp78_ = _tmp77_.y;
					_tmp79_ = self->priv->CORNER_MARGIN;
					if (_tmp78_ > ((gdouble) _tmp79_)) {
						GdkEventButton _tmp80_;
						gdouble _tmp81_;
						gint _tmp82_;
						_tmp80_ = *event;
						_tmp81_ = _tmp80_.x;
						_tmp82_ = self->priv->CORNER_MARGIN;
						_tmp76_ = _tmp81_ < ((gdouble) _tmp82_);
					} else {
						_tmp76_ = FALSE;
					}
					_tmp83_ = _tmp76_;
					if (_tmp83_) {
						GdkEventButton _tmp84_;
						gdouble _tmp85_;
						GtkAllocation _tmp86_;
						gint _tmp87_;
						gint _tmp88_;
						_tmp84_ = *event;
						_tmp85_ = _tmp84_.y;
						_tmp86_ = allocation;
						_tmp87_ = _tmp86_.height;
						_tmp88_ = self->priv->CORNER_MARGIN;
						_tmp75_ = _tmp85_ < ((gdouble) (_tmp87_ - _tmp88_));
					} else {
						_tmp75_ = FALSE;
					}
					_tmp89_ = _tmp75_;
					if (_tmp89_) {
						edge = GDK_WINDOW_EDGE_WEST;
					} else {
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp90_ = edge;
	_tmp91_ = *event;
	_tmp92_ = _tmp91_.button;
	_tmp93_ = *event;
	_tmp94_ = _tmp93_.x_root;
	_tmp95_ = *event;
	_tmp96_ = _tmp95_.y_root;
	_tmp97_ = *event;
	_tmp98_ = _tmp97_.time;
	gtk_window_begin_resize_drag ((GtkWindow*) self, _tmp90_, (gint) _tmp92_, (gint) _tmp94_, (gint) _tmp96_, _tmp98_);
	result = TRUE;
	return result;
}


/**
 * window_state_cb:
 *
 * Watch window manager actions always on top and sticky
 * window.
 */
static gboolean xnp_window_window_state_cb (XnpWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkWindowState _tmp1_;
	gboolean _tmp5_ = FALSE;
	GdkEventWindowState _tmp6_;
	GdkWindowState _tmp7_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((gboolean) (_tmp1_ & GDK_WINDOW_STATE_ABOVE)) {
		GtkCheckMenuItem* _tmp2_;
		GdkEventWindowState _tmp3_;
		GdkWindowState _tmp4_;
		_tmp2_ = self->priv->mi_above;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.new_window_state;
		gtk_check_menu_item_set_active (_tmp2_, (gboolean) (_tmp4_ & GDK_WINDOW_STATE_ABOVE));
	}
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.changed_mask;
	if ((gboolean) (_tmp7_ & GDK_WINDOW_STATE_STICKY)) {
		gboolean _tmp8_ = FALSE;
		_tmp8_ = gtk_widget_get_visible ((GtkWidget*) self);
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		GdkEventWindowState _tmp10_;
		GdkWindowState _tmp11_;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.new_window_state;
		xnp_window_set_sticky (self, (gboolean) ((_tmp11_ & GDK_WINDOW_STATE_STICKY) != 0));
	}
	result = FALSE;
	return result;
}


/**
 * title_evbox_pressed_cb:
 *
 * Raise/lower the window and popup window menu.
 */
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	GdkEventType _tmp1_;
	GdkEventButton _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.button;
	if (_tmp3_ == ((guint) 1)) {
		GdkWindow* _tmp4_ = NULL;
		gint winx = 0;
		gint winy = 0;
		gint curx = 0;
		gint cury = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		guint32 _tmp15_ = 0U;
		_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_show (_tmp4_);
		gtk_window_get_position ((GtkWindow*) self, &_tmp5_, &_tmp6_);
		winx = _tmp5_;
		winy = _tmp6_;
		gtk_widget_get_pointer ((GtkWidget*) self, &_tmp7_, &_tmp8_);
		curx = _tmp7_;
		cury = _tmp8_;
		_tmp9_ = winx;
		_tmp10_ = curx;
		winx = _tmp9_ + _tmp10_;
		_tmp11_ = winy;
		_tmp12_ = cury;
		winy = _tmp11_ + _tmp12_;
		_tmp13_ = winx;
		_tmp14_ = winy;
		_tmp15_ = gtk_get_current_event_time ();
		gtk_window_begin_move_drag ((GtkWindow*) self, 1, _tmp13_, _tmp14_, _tmp15_);
	} else {
		GdkEventButton _tmp16_;
		guint _tmp17_;
		_tmp16_ = *event;
		_tmp17_ = _tmp16_.button;
		if (_tmp17_ == ((guint) 2)) {
			GdkWindow* _tmp18_ = NULL;
			_tmp18_ = gtk_widget_get_window ((GtkWidget*) self);
			gdk_window_lower (_tmp18_);
		} else {
			GdkEventButton _tmp19_;
			guint _tmp20_;
			_tmp19_ = *event;
			_tmp20_ = _tmp19_.button;
			if (_tmp20_ == ((guint) 3)) {
				GtkMenu* _tmp21_;
				guint32 _tmp22_ = 0U;
				_tmp21_ = self->priv->menu;
				_tmp22_ = gtk_get_current_event_time ();
				gtk_menu_popup (_tmp21_, NULL, NULL, NULL, NULL, (guint) 0, _tmp22_);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * title_evbox_scrolled_cb:
 *
 * Shade/unshade the window and set transparency by holding ALT.
 */
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self, GtkWidget* widget, GdkEventScroll* event) {
	gboolean result = FALSE;
	GdkEventScroll _tmp0_;
	GdkModifierType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.state;
	if ((gboolean) (_tmp1_ & GDK_MOD1_MASK)) {
		GdkEventScroll _tmp2_;
		GdkScrollDirection _tmp3_;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.direction;
		if (_tmp3_ == GDK_SCROLL_UP) {
			gdouble _tmp4_;
			gdouble _tmp5_;
			_tmp4_ = gtk_window_get_opacity ((GtkWindow*) self);
			_tmp5_ = _tmp4_;
			gtk_window_set_opacity ((GtkWindow*) self, _tmp5_ + 0.1);
		} else {
			GdkEventScroll _tmp6_;
			GdkScrollDirection _tmp7_;
			_tmp6_ = *event;
			_tmp7_ = _tmp6_.direction;
			if (_tmp7_ == GDK_SCROLL_DOWN) {
				gdouble _tmp8_;
				gdouble _tmp9_;
				_tmp8_ = gtk_window_get_opacity ((GtkWindow*) self);
				_tmp9_ = _tmp8_;
				if ((_tmp9_ - 0.1) >= 0.1) {
					gdouble _tmp10_;
					gdouble _tmp11_;
					_tmp10_ = gtk_window_get_opacity ((GtkWindow*) self);
					_tmp11_ = _tmp10_;
					gtk_window_set_opacity ((GtkWindow*) self, _tmp11_ - 0.1);
				}
			}
		}
	} else {
		GdkEventScroll _tmp12_;
		GdkScrollDirection _tmp13_;
		_tmp12_ = *event;
		_tmp13_ = _tmp12_.direction;
		if (_tmp13_ == GDK_SCROLL_UP) {
			xnp_window_shade (self);
		} else {
			GdkEventScroll _tmp14_;
			GdkScrollDirection _tmp15_;
			_tmp14_ = *event;
			_tmp15_ = _tmp14_.direction;
			if (_tmp15_ == GDK_SCROLL_DOWN) {
				xnp_window_unshade (self);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * note_notify_name_cb:
 *
 */
static void xnp_window_note_notify_name_cb (XnpWindow* self, GObject* object, GParamSpec* pspec) {
	GObject* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* note;
	GtkNotebook* _tmp2_;
	XnpNote* _tmp3_;
	XnpNote* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkNotebook* _tmp7_;
	gint _tmp8_ = 0;
	gint page;
	GtkNotebook* _tmp9_;
	gint _tmp10_;
	GtkWidget* _tmp11_ = NULL;
	XnpNote* _tmp12_;
	XnpNote* current_note;
	XnpNote* _tmp13_;
	XnpNote* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, XNP_TYPE_NOTE) ? ((XnpNote*) _tmp0_) : NULL);
	note = _tmp1_;
	_tmp2_ = self->priv->notebook;
	_tmp3_ = note;
	_tmp4_ = note;
	_tmp5_ = xnp_note_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_notebook_set_tab_label_text (_tmp2_, (GtkWidget*) _tmp3_, _tmp6_);
	_xnp_window_notebook_update_tabs_angle (self);
	_tmp7_ = self->priv->notebook;
	_tmp8_ = gtk_notebook_get_current_page (_tmp7_);
	page = _tmp8_;
	_tmp9_ = self->priv->notebook;
	_tmp10_ = page;
	_tmp11_ = gtk_notebook_get_nth_page (_tmp9_, _tmp10_);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, XNP_TYPE_NOTE, XnpNote));
	current_note = _tmp12_;
	_tmp13_ = note;
	_tmp14_ = current_note;
	if (_tmp13_ == _tmp14_) {
		XnpNote* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = note;
		_tmp16_ = xnp_note_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		xnp_window_update_title (self, _tmp17_);
	}
	_g_object_unref0 (current_note);
	_g_object_unref0 (note);
}


static void xnp_window_action_new_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "create-new-window");
}


static void xnp_window_action_delete_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "delete");
}


static void xnp_window_action_rename_window (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "rename");
}


static void xnp_window_action_new_note (XnpWindow* self) {
	XnpNote* _tmp0_ = NULL;
	XnpNote* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_insert_note (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static void xnp_window_action_delete_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_delete_current_note (self);
}


static void xnp_window_action_rename_note (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	xnp_window_rename_current_note (self);
}


static void xnp_window_action_cancel (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint page;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* child;
	GtkWidget* _tmp7_;
	XnpHypertextView* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ < 0) {
		return;
	}
	_tmp3_ = self->priv->notebook;
	_tmp4_ = page;
	_tmp5_ = gtk_notebook_get_nth_page (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	child = _tmp6_;
	_tmp7_ = child;
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, XNP_TYPE_NOTE, XnpNote)->text_view;
	xnp_hypertext_view_undo (_tmp8_);
	_g_object_unref0 (child);
}


static void xnp_window_action_refresh_notes (XnpWindow* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "action", "refresh-notes");
}


static void xnp_window_action_next_note (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_next_page (_tmp0_);
}


static void xnp_window_action_prev_note (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_prev_page (_tmp0_);
}


/**
 * menu_evbox_pressed_cb:
 *
 * Popup the window menu.
 */
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	xnp_window_menu_position (self, menu, x, y, push_in);
}


static gboolean xnp_window_menu_evbox_pressed_cb (XnpWindow* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkMenu* _tmp0_;
	guint32 _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->menu;
	_tmp1_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp0_, NULL, NULL, _xnp_window_menu_position_gtk_menu_position_func, self, (guint) 0, _tmp1_);
	result = FALSE;
	return result;
}


/**
 * menu_position:
 *
 * Menu position function for the window menu.
 */
static void xnp_window_menu_position (XnpWindow* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	gint winx = 0;
	gint winy = 0;
	gint width = 0;
	gint height = 0;
	GtkRequisition requisition = {0};
	GtkAllocation allocation = {0};
	GdkWindow* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkMenu* _tmp5_;
	GtkRequisition _tmp6_ = {0};
	GdkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkVBox* _tmp10_;
	GtkAllocation _tmp11_ = {0};
	gint _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GtkRequisition _tmp15_;
	gint _tmp16_;
	gint _tmp17_ = 0;
	gint _tmp24_;
	GtkRequisition _tmp25_;
	gint _tmp26_;
	gint _tmp27_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_geometry (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, NULL);
	winx = _tmp1_;
	winy = _tmp2_;
	width = _tmp3_;
	height = _tmp4_;
	_tmp5_ = menu;
	gtk_widget_size_request ((GtkWidget*) _tmp5_, &_tmp6_);
	requisition = _tmp6_;
	_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp7_, &_tmp8_, &_tmp9_);
	_vala_x = _tmp8_;
	_vala_y = _tmp9_;
	_vala_push_in = FALSE;
	_tmp10_ = self->priv->content_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp10_, &_tmp11_);
	allocation = _tmp11_;
	_tmp12_ = _vala_y;
	_tmp13_ = allocation;
	_tmp14_ = _tmp13_.y;
	_tmp15_ = requisition;
	_tmp16_ = _tmp15_.height;
	_tmp17_ = gdk_screen_height ();
	if (((_tmp12_ + _tmp14_) + _tmp16_) > _tmp17_) {
		gint _tmp18_;
		GtkRequisition _tmp19_;
		gint _tmp20_;
		_tmp18_ = _vala_y;
		_tmp19_ = requisition;
		_tmp20_ = _tmp19_.height;
		_vala_y = _tmp18_ - _tmp20_;
	} else {
		gint _tmp21_;
		GtkAllocation _tmp22_;
		gint _tmp23_;
		_tmp21_ = _vala_y;
		_tmp22_ = allocation;
		_tmp23_ = _tmp22_.y;
		_vala_y = _tmp21_ + _tmp23_;
	}
	_tmp24_ = _vala_x;
	_tmp25_ = requisition;
	_tmp26_ = _tmp25_.width;
	_tmp27_ = gdk_screen_width ();
	if ((_tmp24_ + _tmp26_) > _tmp27_) {
		gint _tmp28_;
		GtkMenu* _tmp29_;
		GtkRequisition _tmp30_;
		gint _tmp31_;
		GtkVBox* _tmp32_;
		GtkAllocation _tmp33_;
		gint _tmp34_;
		_tmp28_ = _vala_x;
		_tmp29_ = menu;
		_tmp30_ = ((GtkWidget*) _tmp29_)->requisition;
		_tmp31_ = _tmp30_.width;
		_tmp32_ = self->priv->content_box;
		_tmp33_ = ((GtkWidget*) _tmp32_)->allocation;
		_tmp34_ = _tmp33_.y;
		_vala_x = (_tmp28_ - _tmp31_) + _tmp34_;
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


/**
 * build_menu:
 *
 * Build the window menu.
 */
static void _xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	xnp_window_update_menu_go (self, _sender);
}


static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_new_note (self);
}


static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_delete_note (self);
}


static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_rename_note (self);
}


static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_cancel (self);
}


static void __lambda6_ (XnpWindow* self, GtkCheckMenuItem* o) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (o != NULL);
	_tmp0_ = o;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	xnp_window_set_above (self, _tmp2_);
}


static void ___lambda6__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda6_ (self, _sender);
}


static void __lambda7_ (XnpWindow* self, GtkCheckMenuItem* o) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (o != NULL);
	_tmp0_ = o;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	xnp_window_set_sticky (self, _tmp2_);
}


static void ___lambda7__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda7_ (self, _sender);
}


static void __lambda8_ (XnpWindow* self) {
	g_signal_emit_by_name (self, "action", "properties");
}


static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda8_ (self);
}


static void __lambda9_ (XnpWindow* self) {
	g_signal_emit_by_name (self, "action", "about");
}


static void ___lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda9_ (self);
}


static GtkMenu* xnp_window_build_menu (XnpWindow* self) {
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_;
	GtkMenu* menu;
	GtkUIManager* _tmp1_;
	GtkAccelGroup* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* mi;
	GtkMenuItem* _tmp5_;
	GtkMenu* _tmp6_;
	GtkMenu* menu_go;
	GtkUIManager* _tmp7_;
	GtkAccelGroup* _tmp8_ = NULL;
	GtkMenuItem* _tmp9_;
	GtkSeparatorMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkImageMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkActionGroup* _tmp14_;
	GtkAction* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_;
	GtkMenuItem* _tmp18_;
	GtkImageMenuItem* _tmp19_;
	GtkMenuItem* _tmp20_;
	GtkActionGroup* _tmp21_;
	GtkAction* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_;
	GtkMenuItem* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GtkImageMenuItem* _tmp27_;
	GtkImage* _tmp28_;
	GtkImage* image;
	GtkMenuItem* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkActionGroup* _tmp31_;
	GtkAction* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GtkMenuItem* _tmp34_;
	GtkMenuItem* _tmp35_;
	GtkImageMenuItem* _tmp36_;
	GtkMenuItem* _tmp37_;
	GtkActionGroup* _tmp38_;
	GtkAction* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkMenuItem* _tmp41_;
	GtkMenuItem* _tmp42_;
	GtkSeparatorMenuItem* _tmp43_;
	GtkMenuItem* _tmp44_;
	const gchar* _tmp45_ = NULL;
	GtkCheckMenuItem* _tmp46_;
	GtkCheckMenuItem* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenuItem* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	const gchar* _tmp54_ = NULL;
	GtkCheckMenuItem* _tmp55_;
	GtkCheckMenuItem* _tmp56_;
	GtkMenuItem* _tmp57_;
	GtkMenuItem* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	GtkMenuItem* _tmp61_;
	GtkMenuItem* _tmp62_;
	GtkSeparatorMenuItem* _tmp63_;
	GtkMenuItem* _tmp64_;
	GtkImageMenuItem* _tmp65_;
	GtkMenuItem* _tmp66_;
	GtkMenuItem* _tmp67_;
	GtkImageMenuItem* _tmp68_;
	GtkMenuItem* _tmp69_;
	GtkMenuItem* _tmp70_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = self->priv->ui;
	_tmp2_ = gtk_ui_manager_get_accel_group (_tmp1_);
	gtk_menu_set_accel_group (menu, _tmp2_);
	_tmp3_ = _ ("_Groups");
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp3_);
	g_object_ref_sink (_tmp4_);
	mi = _tmp4_;
	_tmp5_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp6_);
	menu_go = _tmp6_;
	_tmp7_ = self->priv->ui;
	_tmp8_ = gtk_ui_manager_get_accel_group (_tmp7_);
	gtk_menu_set_accel_group (menu_go, _tmp8_);
	g_signal_connect_object ((GtkWidget*) menu_go, "show", (GCallback) _xnp_window_update_menu_go_gtk_widget_show, self, 0);
	_tmp9_ = mi;
	gtk_menu_item_set_submenu (_tmp9_, (GtkWidget*) menu_go);
	_tmp10_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp10_;
	_tmp11_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, NULL);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp12_;
	_tmp13_ = mi;
	_tmp14_ = self->priv->action_group;
	_tmp15_ = gtk_action_group_get_action (_tmp14_, "new-note");
	_tmp16_ = gtk_action_get_accel_path (_tmp15_);
	gtk_menu_item_set_accel_path (_tmp13_, _tmp16_);
	_tmp17_ = mi;
	g_signal_connect_object (_tmp17_, "activate", (GCallback) _xnp_window_action_new_note_gtk_menu_item_activate, self, 0);
	_tmp18_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp18_);
	_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_DELETE, NULL);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp19_;
	_tmp20_ = mi;
	_tmp21_ = self->priv->action_group;
	_tmp22_ = gtk_action_group_get_action (_tmp21_, "delete-note");
	_tmp23_ = gtk_action_get_accel_path (_tmp22_);
	gtk_menu_item_set_accel_path (_tmp20_, _tmp23_);
	_tmp24_ = mi;
	g_signal_connect_object (_tmp24_, "activate", (GCallback) _xnp_window_action_delete_note_gtk_menu_item_activate, self, 0);
	_tmp25_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp25_);
	_tmp26_ = _ ("_Rename");
	_tmp27_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp27_;
	_tmp28_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp28_);
	image = _tmp28_;
	_tmp29_ = mi;
	gtk_image_menu_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GTK_TYPE_IMAGE_MENU_ITEM, GtkImageMenuItem), (GtkWidget*) image);
	_tmp30_ = mi;
	_tmp31_ = self->priv->action_group;
	_tmp32_ = gtk_action_group_get_action (_tmp31_, "rename-note");
	_tmp33_ = gtk_action_get_accel_path (_tmp32_);
	gtk_menu_item_set_accel_path (_tmp30_, _tmp33_);
	_tmp34_ = mi;
	g_signal_connect_object (_tmp34_, "activate", (GCallback) _xnp_window_action_rename_note_gtk_menu_item_activate, self, 0);
	_tmp35_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_UNDO, NULL);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp36_;
	_tmp37_ = mi;
	_tmp38_ = self->priv->action_group;
	_tmp39_ = gtk_action_group_get_action (_tmp38_, "cancel");
	_tmp40_ = gtk_action_get_accel_path (_tmp39_);
	gtk_menu_item_set_accel_path (_tmp37_, _tmp40_);
	_tmp41_ = mi;
	g_signal_connect_object (_tmp41_, "activate", (GCallback) _xnp_window_action_cancel_gtk_menu_item_activate, self, 0);
	_tmp42_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp42_);
	_tmp43_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp43_;
	_tmp44_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp44_);
	_tmp45_ = _ ("Always on top");
	_tmp46_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp45_);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->mi_above);
	self->priv->mi_above = _tmp46_;
	_tmp47_ = self->priv->mi_above;
	_tmp48_ = _g_object_ref0 ((GtkMenuItem*) _tmp47_);
	_g_object_unref0 (mi);
	mi = _tmp48_;
	_tmp49_ = mi;
	_tmp50_ = xnp_window_get_above (self);
	_tmp51_ = _tmp50_;
	gtk_check_menu_item_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItem), _tmp51_);
	_tmp52_ = mi;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItem), "toggled", (GCallback) ___lambda6__gtk_check_menu_item_toggled, self, 0);
	_tmp53_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp53_);
	_tmp54_ = _ ("Sticky window");
	_tmp55_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp54_);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->mi_sticky);
	self->priv->mi_sticky = _tmp55_;
	_tmp56_ = self->priv->mi_sticky;
	_tmp57_ = _g_object_ref0 ((GtkMenuItem*) _tmp56_);
	_g_object_unref0 (mi);
	mi = _tmp57_;
	_tmp58_ = mi;
	_tmp59_ = xnp_window_get_sticky (self);
	_tmp60_ = _tmp59_;
	gtk_check_menu_item_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItem), _tmp60_);
	_tmp61_ = mi;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItem), "toggled", (GCallback) ___lambda7__gtk_check_menu_item_toggled, self, 0);
	_tmp62_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp62_);
	_tmp63_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp63_;
	_tmp64_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp64_);
	_tmp65_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PROPERTIES, NULL);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp65_;
	_tmp66_ = mi;
	g_signal_connect_object (_tmp66_, "activate", (GCallback) ___lambda8__gtk_menu_item_activate, self, 0);
	_tmp67_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp67_);
	_tmp68_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp68_;
	_tmp69_ = mi;
	g_signal_connect_object (_tmp69_, "activate", (GCallback) ___lambda9__gtk_menu_item_activate, self, 0);
	_tmp70_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) _tmp70_);
	result = menu;
	_g_object_unref0 (image);
	_g_object_unref0 (menu_go);
	_g_object_unref0 (mi);
	return result;
}


/**
 * update_menu_go:
 *
 * Update the menu Go when it is shown.
 */
static void __lambda3_ (XnpWindow* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	gtk_object_destroy ((GtkObject*) _tmp0_);
}


static void ___lambda3__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda3_ (self, widget);
}


static void ________lambda4_ (XnpWindow* self, GtkMenuItem* i) {
	GtkMenuItem* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gint page;
	GtkNotebook* _tmp2_;
	g_return_if_fail (i != NULL);
	_tmp0_ = i;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "page");
	page = (gint) ((gintptr) _tmp1_);
	_tmp2_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp2_, page);
}


static void _________lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	________lambda4_ (self, _sender);
}


static void _____lambda5_ (XnpWindow* self, GtkMenuItem* i) {
	GtkMenuItem* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	XnpWindow* _tmp2_;
	XnpWindow* w;
	g_return_if_fail (i != NULL);
	_tmp0_ = i;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "window");
	_tmp2_ = _g_object_ref0 ((XnpWindow*) _tmp1_);
	w = _tmp2_;
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}


static void ______lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_____lambda5_ (self, _sender);
}


static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_rename_window (self);
}


static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_delete_window (self);
}


static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xnp_window_action_new_window (self);
}


static void xnp_window_update_menu_go (XnpWindow* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* menu;
	GtkMenuItem* mi = NULL;
	GtkImage* image = NULL;
	GtkMenu* _tmp2_;
	GSList* _tmp3_;
	const gchar* _tmp57_ = NULL;
	GtkImageMenuItem* _tmp58_;
	GtkImage* _tmp59_;
	GtkMenuItem* _tmp60_;
	GtkImage* _tmp61_;
	GtkMenuItem* _tmp62_;
	GtkActionGroup* _tmp63_;
	GtkAction* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	GtkMenuItem* _tmp66_;
	GtkMenu* _tmp67_;
	GtkMenuItem* _tmp68_;
	const gchar* _tmp69_ = NULL;
	GtkImageMenuItem* _tmp70_;
	GtkImage* _tmp71_;
	GtkMenuItem* _tmp72_;
	GtkImage* _tmp73_;
	GtkMenuItem* _tmp74_;
	GtkActionGroup* _tmp75_;
	GtkAction* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	GtkMenuItem* _tmp78_;
	GtkMenu* _tmp79_;
	GtkMenuItem* _tmp80_;
	const gchar* _tmp81_ = NULL;
	GtkImageMenuItem* _tmp82_;
	GtkImage* _tmp83_;
	GtkMenuItem* _tmp84_;
	GtkImage* _tmp85_;
	GtkMenuItem* _tmp86_;
	GtkActionGroup* _tmp87_;
	GtkAction* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	GtkMenuItem* _tmp90_;
	GtkMenu* _tmp91_;
	GtkMenuItem* _tmp92_;
	GtkMenu* _tmp93_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_MENU) ? ((GtkMenu*) _tmp0_) : NULL);
	menu = _tmp1_;
	_tmp2_ = menu;
	gtk_container_foreach ((GtkContainer*) _tmp2_, ___lambda3__gtk_callback, self);
	_tmp3_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp3_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* win = NULL;
			win = (XnpWindow*) win_it->data;
			{
				XnpWindow* _tmp4_;
				_tmp4_ = win;
				if (_tmp4_ == self) {
					XnpWindow* _tmp5_;
					const gchar* _tmp6_;
					GtkMenuItem* _tmp7_;
					GtkMenuItem* _tmp8_;
					GtkMenu* _tmp9_;
					GtkMenuItem* _tmp10_;
					GtkNotebook* _tmp11_;
					gint _tmp12_ = 0;
					gint current_page;
					GtkNotebook* _tmp13_;
					gint _tmp14_;
					GtkWidget* _tmp15_ = NULL;
					XnpNote* _tmp16_;
					XnpNote* current_note;
					GtkNotebook* _tmp17_;
					gint _tmp18_ = 0;
					gint n_pages;
					GtkSeparatorMenuItem* _tmp43_;
					GtkMenu* _tmp44_;
					GtkMenuItem* _tmp45_;
					_tmp5_ = win;
					_tmp6_ = _tmp5_->priv->_name;
					_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp6_);
					g_object_ref_sink (_tmp7_);
					_g_object_unref0 (mi);
					mi = _tmp7_;
					_tmp8_ = mi;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
					_tmp9_ = menu;
					_tmp10_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp9_, (GtkWidget*) _tmp10_);
					_tmp11_ = self->priv->notebook;
					_tmp12_ = gtk_notebook_get_current_page (_tmp11_);
					current_page = _tmp12_;
					_tmp13_ = self->priv->notebook;
					_tmp14_ = current_page;
					_tmp15_ = gtk_notebook_get_nth_page (_tmp13_, _tmp14_);
					_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, XNP_TYPE_NOTE, XnpNote));
					current_note = _tmp16_;
					_tmp17_ = self->priv->notebook;
					_tmp18_ = gtk_notebook_get_n_pages (_tmp17_);
					n_pages = _tmp18_;
					{
						gint p;
						p = 0;
						{
							gboolean _tmp19_;
							_tmp19_ = TRUE;
							while (TRUE) {
								gboolean _tmp20_;
								gint _tmp22_;
								gint _tmp23_;
								GtkNotebook* _tmp24_;
								gint _tmp25_;
								GtkWidget* _tmp26_ = NULL;
								XnpNote* _tmp27_;
								XnpNote* note;
								XnpNote* _tmp28_;
								const gchar* _tmp29_;
								const gchar* _tmp30_;
								GtkImageMenuItem* _tmp31_;
								XnpNote* _tmp32_;
								XnpNote* _tmp33_;
								GtkMenuItem* _tmp37_;
								gint _tmp38_;
								void* _tmp39_ = NULL;
								GtkMenuItem* _tmp40_;
								GtkMenu* _tmp41_;
								GtkMenuItem* _tmp42_;
								_tmp20_ = _tmp19_;
								if (!_tmp20_) {
									gint _tmp21_;
									_tmp21_ = p;
									p = _tmp21_ + 1;
								}
								_tmp19_ = FALSE;
								_tmp22_ = p;
								_tmp23_ = n_pages;
								if (!(_tmp22_ < _tmp23_)) {
									break;
								}
								_tmp24_ = self->priv->notebook;
								_tmp25_ = p;
								_tmp26_ = gtk_notebook_get_nth_page (_tmp24_, _tmp25_);
								_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, XNP_TYPE_NOTE, XnpNote));
								note = _tmp27_;
								_tmp28_ = note;
								_tmp29_ = xnp_note_get_name (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp31_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp30_);
								g_object_ref_sink (_tmp31_);
								_g_object_unref0 (mi);
								mi = (GtkMenuItem*) _tmp31_;
								_tmp32_ = note;
								_tmp33_ = current_note;
								if (_tmp32_ == _tmp33_) {
									GtkImage* _tmp34_;
									GtkMenuItem* _tmp35_;
									GtkImage* _tmp36_;
									_tmp34_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_MENU);
									g_object_ref_sink (_tmp34_);
									_g_object_unref0 (image);
									image = _tmp34_;
									_tmp35_ = mi;
									_tmp36_ = image;
									gtk_image_menu_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GTK_TYPE_IMAGE_MENU_ITEM, GtkImageMenuItem), (GtkWidget*) _tmp36_);
								}
								_tmp37_ = mi;
								_tmp38_ = p;
								_tmp39_ = GINT_TO_POINTER (_tmp38_);
								g_object_set_data_full ((GObject*) _tmp37_, "page", _tmp39_, NULL);
								_tmp40_ = mi;
								g_signal_connect_object (_tmp40_, "activate", (GCallback) _________lambda4__gtk_menu_item_activate, self, 0);
								_tmp41_ = menu;
								_tmp42_ = mi;
								gtk_menu_shell_append ((GtkMenuShell*) _tmp41_, (GtkWidget*) _tmp42_);
								_g_object_unref0 (note);
							}
						}
					}
					_tmp43_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
					g_object_ref_sink (_tmp43_);
					_g_object_unref0 (mi);
					mi = (GtkMenuItem*) _tmp43_;
					_tmp44_ = menu;
					_tmp45_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp44_, (GtkWidget*) _tmp45_);
					_g_object_unref0 (current_note);
				} else {
					XnpWindow* _tmp46_;
					const gchar* _tmp47_;
					GtkMenuItem* _tmp48_;
					GtkMenuItem* _tmp49_;
					XnpWindow* _tmp50_;
					GtkMenuItem* _tmp51_;
					GtkMenu* _tmp52_;
					GtkMenuItem* _tmp53_;
					GtkSeparatorMenuItem* _tmp54_;
					GtkMenu* _tmp55_;
					GtkMenuItem* _tmp56_;
					_tmp46_ = win;
					_tmp47_ = _tmp46_->priv->_name;
					_tmp48_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp47_);
					g_object_ref_sink (_tmp48_);
					_g_object_unref0 (mi);
					mi = _tmp48_;
					_tmp49_ = mi;
					_tmp50_ = win;
					g_object_set_data_full ((GObject*) _tmp49_, "window", (void*) _tmp50_, NULL);
					_tmp51_ = mi;
					g_signal_connect_object (_tmp51_, "activate", (GCallback) ______lambda5__gtk_menu_item_activate, self, 0);
					_tmp52_ = menu;
					_tmp53_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp52_, (GtkWidget*) _tmp53_);
					_tmp54_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
					g_object_ref_sink (_tmp54_);
					_g_object_unref0 (mi);
					mi = (GtkMenuItem*) _tmp54_;
					_tmp55_ = menu;
					_tmp56_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp55_, (GtkWidget*) _tmp56_);
				}
			}
		}
	}
	_tmp57_ = _ ("_Rename group");
	_tmp58_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp57_);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp58_;
	_tmp59_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (image);
	image = _tmp59_;
	_tmp60_ = mi;
	_tmp61_ = image;
	gtk_image_menu_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, GTK_TYPE_IMAGE_MENU_ITEM, GtkImageMenuItem), (GtkWidget*) _tmp61_);
	_tmp62_ = mi;
	_tmp63_ = self->priv->action_group;
	_tmp64_ = gtk_action_group_get_action (_tmp63_, "rename-window");
	_tmp65_ = gtk_action_get_accel_path (_tmp64_);
	gtk_menu_item_set_accel_path (_tmp62_, _tmp65_);
	_tmp66_ = mi;
	g_signal_connect_object (_tmp66_, "activate", (GCallback) _xnp_window_action_rename_window_gtk_menu_item_activate, self, 0);
	_tmp67_ = menu;
	_tmp68_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = _ ("_Delete group");
	_tmp70_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp69_);
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp70_;
	_tmp71_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_REMOVE, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (image);
	image = _tmp71_;
	_tmp72_ = mi;
	_tmp73_ = image;
	gtk_image_menu_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, GTK_TYPE_IMAGE_MENU_ITEM, GtkImageMenuItem), (GtkWidget*) _tmp73_);
	_tmp74_ = mi;
	_tmp75_ = self->priv->action_group;
	_tmp76_ = gtk_action_group_get_action (_tmp75_, "delete-window");
	_tmp77_ = gtk_action_get_accel_path (_tmp76_);
	gtk_menu_item_set_accel_path (_tmp74_, _tmp77_);
	_tmp78_ = mi;
	g_signal_connect_object (_tmp78_, "activate", (GCallback) _xnp_window_action_delete_window_gtk_menu_item_activate, self, 0);
	_tmp79_ = menu;
	_tmp80_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp79_, (GtkWidget*) _tmp80_);
	_tmp81_ = _ ("_Add a new group");
	_tmp82_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp81_);
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp82_;
	_tmp83_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_ADD, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp83_);
	_g_object_unref0 (image);
	image = _tmp83_;
	_tmp84_ = mi;
	_tmp85_ = image;
	gtk_image_menu_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GTK_TYPE_IMAGE_MENU_ITEM, GtkImageMenuItem), (GtkWidget*) _tmp85_);
	_tmp86_ = mi;
	_tmp87_ = self->priv->action_group;
	_tmp88_ = gtk_action_group_get_action (_tmp87_, "new-window");
	_tmp89_ = gtk_action_get_accel_path (_tmp88_);
	gtk_menu_item_set_accel_path (_tmp86_, _tmp89_);
	_tmp90_ = mi;
	g_signal_connect_object (_tmp90_, "activate", (GCallback) _xnp_window_action_new_window_gtk_menu_item_activate, self, 0);
	_tmp91_ = menu;
	_tmp92_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp93_);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
}


/**
 * get_geometry:
 *
 * Returns the X,Y position and width/height.
 */
void xnp_window_get_geometry (XnpWindow* self, gint* winx, gint* winy, gint* width, gint* height) {
	gint _vala_winx = 0;
	gint _vala_winy = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	GtkVBox* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	if (!_tmp1_) {
		gint _tmp2_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, NULL);
		self->priv->width = _tmp2_;
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
		self->priv->width = _tmp3_;
		self->priv->height = _tmp4_;
	}
	gtk_window_get_position ((GtkWindow*) self, &_tmp5_, &_tmp6_);
	_vala_winx = _tmp5_;
	_vala_winy = _tmp6_;
	_tmp7_ = self->priv->width;
	_vala_width = _tmp7_;
	_tmp8_ = self->priv->height;
	_vala_height = _tmp8_;
	if (winx) {
		*winx = _vala_winx;
	}
	if (winy) {
		*winy = _vala_winy;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


/**
 * set_window_list:
 *
 * Saves a list of window inside window.window_list to be shown
 * within the window menu.
 */
void xnp_window_set_window_list (XnpWindow* self, GSList* list) {
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = list;
	self->priv->window_list = _tmp0_;
}


/**
 * compare_func:
 *
 * Compare function for the window name to use with GLib.CompareFunc delegates.
 */
gint xnp_window_compare_func (XnpWindow* self, XnpWindow* win2) {
	gint result = 0;
	const gchar* _tmp0_;
	XnpWindow* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (win2 != NULL, 0);
	_tmp0_ = self->priv->_name;
	_tmp1_ = win2;
	_tmp2_ = _tmp1_->priv->_name;
	_tmp3_ = g_utf8_collate (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


/**
 * get_current_page:
 *
 * Get the current page in the notebook.
 */
gint xnp_window_get_current_page (XnpWindow* self) {
	gint result = 0;
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * set_current_page:
 *
 * Set the current page in the notebook.
 */
void xnp_window_set_current_page (XnpWindow* self, gint page) {
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = page;
	gtk_notebook_set_current_page (_tmp0_, _tmp1_);
}


/**
 * shade:
 *
 * Shade the window (roll up) to show only the title bar.
 */
static void xnp_window_shade (XnpWindow* self) {
	GtkVBox* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	if (_tmp1_) {
		GtkVBox* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_;
		_tmp2_ = self->priv->content_box;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
		self->priv->width = _tmp3_;
		self->priv->height = _tmp4_;
		_tmp5_ = self->priv->width;
		gtk_window_resize ((GtkWindow*) self, _tmp5_, 1);
	}
}


/**
 * unshade:
 *
 * Unshade the window (roll down).
 */
static void xnp_window_unshade (XnpWindow* self) {
	GtkVBox* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	if (!_tmp1_) {
		GtkVBox* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->priv->content_box;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		gtk_window_get_size ((GtkWindow*) self, &_tmp3_, NULL);
		self->priv->width = _tmp3_;
		_tmp4_ = self->priv->width;
		_tmp5_ = self->priv->height;
		gtk_window_resize ((GtkWindow*) self, _tmp4_, _tmp5_);
	}
}


/**
 * update_title:
 *
 * Updates the window title.
 */
static void xnp_window_update_title (XnpWindow* self, const gchar* note_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strconcat (_tmp0_, " - ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = note_name;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}


/**
 * update_navigation_sensitivity:
 *
 * Update the goleft/right sensitivities.
 */
static void xnp_window_update_navigation_sensitivity (XnpWindow* self, gint page_num) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint n_pages;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
	n_pages = _tmp1_;
	_tmp2_ = n_pages;
	if (_tmp2_ <= 1) {
		XnpTitleBarButton* _tmp3_;
		XnpTitleBarButton* _tmp4_;
		_tmp3_ = self->priv->left_arrow_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->right_arrow_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	} else {
		gboolean _tmp5_ = FALSE;
		gint _tmp6_;
		XnpTitleBarButton* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		gint _tmp11_;
		XnpTitleBarButton* _tmp12_;
		gboolean _tmp13_;
		_tmp6_ = page_num;
		if (_tmp6_ > 0) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp7_ = self->priv->left_arrow_button;
		_tmp8_ = _tmp5_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp8_);
		_tmp10_ = page_num;
		_tmp11_ = n_pages;
		if ((_tmp10_ + 1) < _tmp11_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp12_ = self->priv->right_arrow_button;
		_tmp13_ = _tmp9_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp13_);
	}
}


/**
 * insert_note:
 *
 * Create a new note and insert it inside the notebook after
 * the current position.
 */
static void _xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xnp_window_note_notify_name_cb (self, _sender, pspec);
}


static void __lambda2_ (XnpWindow* self, XnpNote* note) {
	XnpNote* _tmp0_;
	g_return_if_fail (note != NULL);
	_tmp0_ = note;
	g_signal_emit_by_name (self, "save-data", _tmp0_);
}


static void ___lambda2__xnp_note_save_data (XnpNote* _sender, gpointer self) {
	__lambda2_ (self, _sender);
}


XnpNote* xnp_window_insert_note (XnpWindow* self) {
	XnpNote* result = NULL;
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint len;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* name;
	GtkNotebook* _tmp15_;
	gint _tmp16_ = 0;
	gint page;
	const gchar* _tmp17_;
	XnpNote* _tmp18_;
	XnpNote* note;
	gint _tmp19_;
	GtkNotebook* _tmp20_;
	GtkNotebook* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
	len = _tmp1_;
	_tmp2_ = _ ("Notes");
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	{
		gint id;
		id = 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp13_;
				gboolean _tmp14_ = FALSE;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = id;
					id = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = id;
				_tmp8_ = len;
				if (!(_tmp7_ <= (_tmp8_ + 1))) {
					break;
				}
				_tmp9_ = id;
				if (_tmp9_ > 1) {
					const gchar* _tmp10_ = NULL;
					gint _tmp11_;
					gchar* _tmp12_ = NULL;
					_tmp10_ = _ ("Notes %d");
					_tmp11_ = id;
					_tmp12_ = g_strdup_printf (_tmp10_, _tmp11_);
					_g_free0 (name);
					name = _tmp12_;
				}
				_tmp13_ = name;
				_tmp14_ = xnp_window_note_name_exists (self, _tmp13_);
				if (!_tmp14_) {
					break;
				}
			}
		}
	}
	_tmp15_ = self->priv->notebook;
	_tmp16_ = gtk_notebook_get_current_page (_tmp15_);
	page = _tmp16_ + 1;
	_tmp17_ = name;
	_tmp18_ = xnp_note_new (_tmp17_);
	g_object_ref_sink (_tmp18_);
	note = _tmp18_;
	g_signal_connect_object ((GObject*) note, "notify::name", (GCallback) _xnp_window_note_notify_name_cb_g_object_notify, self, 0);
	g_signal_connect_object (note, "save-data", (GCallback) ___lambda2__xnp_note_save_data, self, 0);
	gtk_widget_show ((GtkWidget*) note);
	_tmp19_ = self->priv->_n_pages;
	xnp_window_set_n_pages (self, _tmp19_ + 1);
	_tmp20_ = self->priv->notebook;
	gtk_notebook_insert_page (_tmp20_, (GtkWidget*) note, NULL, page);
	_tmp21_ = self->priv->notebook;
	gtk_notebook_set_tab_reorderable (_tmp21_, (GtkWidget*) note, TRUE);
	_tmp22_ = xnp_note_get_name (note);
	_tmp23_ = _tmp22_;
	xnp_note_set_name (note, _tmp23_);
	g_signal_emit_by_name (self, "note-inserted", note);
	_xnp_window_notebook_update_tabs_angle (self);
	result = note;
	_g_free0 (name);
	return result;
}


/**
 * move_note:
 *
 * Moves the note named @note_name to position @page.
 */
void xnp_window_move_note (XnpWindow* self, const gchar* note_name, gint page) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint n_pages;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
	n_pages = _tmp1_;
	{
		gint p;
		p = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				GtkNotebook* _tmp7_;
				gint _tmp8_;
				GtkWidget* _tmp9_ = NULL;
				XnpNote* _tmp10_;
				XnpNote* note;
				XnpNote* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = p;
					p = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = p;
				_tmp6_ = n_pages;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->notebook;
				_tmp8_ = p;
				_tmp9_ = gtk_notebook_get_nth_page (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp10_;
				_tmp11_ = note;
				_tmp12_ = xnp_note_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = note_name;
				if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
					GtkNotebook* _tmp15_;
					XnpNote* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = self->priv->notebook;
					_tmp16_ = note;
					_tmp17_ = page;
					gtk_notebook_reorder_child (_tmp15_, (GtkWidget*) _tmp16_, _tmp17_);
					_tmp18_ = page;
					xnp_window_update_navigation_sensitivity (self, _tmp18_);
					_g_object_unref0 (note);
					break;
				}
				_g_object_unref0 (note);
			}
		}
	}
}


/**
 * get_note_names:
 *
 * Returns a string list of the note names in the order they are currently displayed
 * in the notebook.
 */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** xnp_window_get_note_names (XnpWindow* self, int* result_length1) {
	gchar** result = NULL;
	gchar** note_names;
	gint note_names_length1;
	gint _note_names_size_;
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint n_pages;
	gchar** _tmp16_;
	gint _tmp16__length1;
	g_return_val_if_fail (self != NULL, NULL);
	note_names = NULL;
	note_names_length1 = 0;
	_note_names_size_ = note_names_length1;
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
	n_pages = _tmp1_;
	{
		gint p;
		p = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				GtkNotebook* _tmp7_;
				gint _tmp8_;
				GtkWidget* _tmp9_ = NULL;
				XnpNote* _tmp10_;
				XnpNote* note;
				gchar** _tmp11_;
				gint _tmp11__length1;
				XnpNote* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = p;
					p = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = p;
				_tmp6_ = n_pages;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->notebook;
				_tmp8_ = p;
				_tmp9_ = gtk_notebook_get_nth_page (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp10_;
				_tmp11_ = note_names;
				_tmp11__length1 = note_names_length1;
				_tmp12_ = note;
				_tmp13_ = xnp_note_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup (_tmp14_);
				_vala_array_add1 (&note_names, &note_names_length1, &_note_names_size_, _tmp15_);
				_g_object_unref0 (note);
			}
		}
	}
	_tmp16_ = note_names;
	_tmp16__length1 = note_names_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


/**
 * delete_current_note:
 *
 * Delete the current note.
 */
void xnp_window_delete_current_note (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
	xnp_window_delete_note (self, _tmp1_);
}


/**
 * delete_note:
 *
 * Delete note at page @page.
 */
void xnp_window_delete_note (XnpWindow* self, gint page) {
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	GtkWidget* _tmp2_ = NULL;
	XnpNote* _tmp3_;
	XnpNote* note;
	XnpNote* _tmp4_;
	XnpHypertextView* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp15_;
	GtkNotebook* _tmp16_;
	gint _tmp17_;
	XnpNote* _tmp18_;
	XnpNote* _tmp19_;
	GtkNotebook* _tmp20_;
	gint _tmp21_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = page;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp3_;
	_tmp4_ = note;
	_tmp5_ = _tmp4_->text_view;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_text_buffer_get_char_count (_tmp7_);
	if (_tmp8_ > 0) {
		const gchar* _tmp9_ = NULL;
		GtkMessageDialog* _tmp10_;
		GtkMessageDialog* dialog;
		GtkMessageDialog* _tmp11_;
		gint _tmp12_ = 0;
		gint res;
		GtkMessageDialog* _tmp13_;
		gint _tmp14_;
		_tmp9_ = _ ("Are you sure you want to delete this note?");
		_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp9_);
		g_object_ref_sink (_tmp10_);
		dialog = _tmp10_;
		_tmp11_ = dialog;
		_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
		res = _tmp12_;
		_tmp13_ = dialog;
		gtk_object_destroy ((GtkObject*) _tmp13_);
		_tmp14_ = res;
		if (_tmp14_ != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dialog);
			_g_object_unref0 (note);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp15_ = self->priv->_n_pages;
	xnp_window_set_n_pages (self, _tmp15_ - 1);
	_tmp16_ = self->priv->notebook;
	_tmp17_ = page;
	gtk_notebook_remove_page (_tmp16_, _tmp17_);
	_tmp18_ = note;
	g_signal_emit_by_name (self, "note-deleted", _tmp18_);
	_tmp19_ = note;
	gtk_object_destroy ((GtkObject*) _tmp19_);
	_tmp20_ = self->priv->notebook;
	_tmp21_ = gtk_notebook_get_n_pages (_tmp20_);
	if (_tmp21_ == 0) {
		g_signal_emit_by_name (self, "action", "delete");
	}
	_g_object_unref0 (note);
}


/**
 * rename_current_note:
 *
 * Rename the current note.
 */
void xnp_window_rename_current_note (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint page;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	XnpNote* _tmp6_;
	XnpNote* note;
	const gchar* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkDialog* _tmp9_;
	GtkDialog* dialog;
	GtkDialog* _tmp10_;
	GtkWidget* _tmp11_ = NULL;
	GtkBox* _tmp12_;
	GtkBox* content_area;
	GtkDialog* _tmp13_;
	GtkDialog* _tmp14_;
	GtkDialog* _tmp15_;
	GtkDialog* _tmp16_;
	GtkBox* _tmp17_;
	GtkEntry* _tmp18_;
	GtkEntry* entry;
	GtkEntry* _tmp19_;
	XnpNote* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GtkEntry* _tmp23_;
	GtkBox* _tmp24_;
	GtkEntry* _tmp25_;
	GtkBox* _tmp26_;
	GtkDialog* _tmp27_;
	gint _tmp28_ = 0;
	gint res;
	GtkDialog* _tmp29_;
	gint _tmp30_;
	GtkDialog* _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->notebook;
	_tmp4_ = page;
	_tmp5_ = gtk_notebook_get_nth_page (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp6_;
	_tmp7_ = _ ("Rename note");
	_tmp8_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp9_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_WINDOW, GtkWindow), (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT) | GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp9_);
	dialog = _tmp9_;
	_tmp10_ = dialog;
	_tmp11_ = gtk_dialog_get_content_area (_tmp10_);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GTK_TYPE_BOX, GtkBox));
	content_area = _tmp12_;
	_tmp13_ = dialog;
	gtk_dialog_set_default_response (_tmp13_, (gint) GTK_RESPONSE_OK);
	_tmp14_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp14_, FALSE);
	_tmp15_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp15_, GTK_STOCK_EDIT);
	_tmp16_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp16_, (guint) 4);
	_tmp17_ = content_area;
	gtk_container_set_border_width ((GtkContainer*) _tmp17_, (guint) 6);
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp18_);
	entry = _tmp18_;
	_tmp19_ = entry;
	_tmp20_ = note;
	_tmp21_ = xnp_note_get_name (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_entry_set_text (_tmp19_, _tmp22_);
	_tmp23_ = entry;
	gtk_entry_set_activates_default (_tmp23_, TRUE);
	_tmp24_ = content_area;
	_tmp25_ = entry;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = dialog;
	_tmp28_ = gtk_dialog_run (_tmp27_);
	res = _tmp28_;
	_tmp29_ = dialog;
	gtk_widget_hide ((GtkWidget*) _tmp29_);
	_tmp30_ = res;
	if (_tmp30_ == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* name;
		const gchar* _tmp34_;
		gboolean _tmp35_ = FALSE;
		_tmp31_ = entry;
		_tmp32_ = gtk_entry_get_text (_tmp31_);
		_tmp33_ = _tmp32_;
		name = _tmp33_;
		_tmp34_ = name;
		_tmp35_ = xnp_window_note_name_exists (self, _tmp34_);
		if (_tmp35_) {
			const gchar* _tmp36_ = NULL;
			const gchar* _tmp37_;
			GtkMessageDialog* _tmp38_;
			GtkMessageDialog* error_dialog;
			GtkMessageDialog* _tmp39_;
			GtkMessageDialog* _tmp40_;
			_tmp36_ = _ ("The name %s is already in use");
			_tmp37_ = name;
			_tmp38_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp36_, _tmp37_);
			g_object_ref_sink (_tmp38_);
			error_dialog = _tmp38_;
			_tmp39_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp39_);
			_tmp40_ = error_dialog;
			gtk_object_destroy ((GtkObject*) _tmp40_);
			_g_object_unref0 (error_dialog);
		} else {
			XnpNote* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* old_name;
			XnpNote* _tmp45_;
			const gchar* _tmp46_;
			XnpNote* _tmp47_;
			const gchar* _tmp48_;
			_tmp41_ = note;
			_tmp42_ = xnp_note_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strdup (_tmp43_);
			old_name = _tmp44_;
			_tmp45_ = note;
			_tmp46_ = name;
			xnp_note_set_name (_tmp45_, _tmp46_);
			_tmp47_ = note;
			_tmp48_ = old_name;
			g_signal_emit_by_name (self, "note-renamed", _tmp47_, _tmp48_);
			_g_free0 (old_name);
		}
	}
	_tmp49_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp49_);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}


/**
 * set_font:
 *
 * Set the font for the window.
 */
void xnp_window_set_font (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint page;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	XnpNote* _tmp6_;
	XnpNote* note;
	GtkFontSelectionDialog* _tmp7_;
	GtkFontSelectionDialog* dialog;
	GtkFontSelectionDialog* _tmp8_;
	XnpNote* _tmp9_;
	XnpHypertextView* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkFontSelectionDialog* _tmp13_;
	gint _tmp14_ = 0;
	gint res;
	GtkFontSelectionDialog* _tmp15_;
	gint _tmp16_;
	GtkFontSelectionDialog* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->notebook;
	_tmp4_ = page;
	_tmp5_ = gtk_notebook_get_nth_page (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp6_;
	_tmp7_ = (GtkFontSelectionDialog*) gtk_font_selection_dialog_new ("Choose current note font");
	g_object_ref_sink (_tmp7_);
	dialog = _tmp7_;
	_tmp8_ = dialog;
	_tmp9_ = note;
	_tmp10_ = _tmp9_->text_view;
	_tmp11_ = xnp_hypertext_view_get_font (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_font_selection_dialog_set_font_name (_tmp8_, _tmp12_);
	_tmp13_ = dialog;
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
	res = _tmp14_;
	_tmp15_ = dialog;
	gtk_widget_hide ((GtkWidget*) _tmp15_);
	_tmp16_ = res;
	if (_tmp16_ == ((gint) GTK_RESPONSE_OK)) {
		XnpNote* _tmp17_;
		XnpHypertextView* _tmp18_;
		GtkFontSelectionDialog* _tmp19_;
		const gchar* _tmp20_ = NULL;
		_tmp17_ = note;
		_tmp18_ = _tmp17_->text_view;
		_tmp19_ = dialog;
		_tmp20_ = gtk_font_selection_dialog_get_font_name (_tmp19_);
		xnp_hypertext_view_set_font (_tmp18_, _tmp20_);
	}
	_tmp21_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp21_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}


/**
 * note_name_exists:
 *
 * Verify if the given name already exists in the notebook.
 */
static gboolean xnp_window_note_name_exists (XnpWindow* self, const gchar* name) {
	gboolean result = FALSE;
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint n_pages;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
	n_pages = _tmp1_;
	{
		gint p;
		p = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				GtkNotebook* _tmp7_;
				gint _tmp8_;
				GtkWidget* _tmp9_ = NULL;
				XnpNote* _tmp10_;
				XnpNote* note;
				XnpNote* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = p;
					p = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = p;
				_tmp6_ = n_pages;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->notebook;
				_tmp8_ = p;
				_tmp9_ = gtk_notebook_get_nth_page (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp10_;
				_tmp11_ = note;
				_tmp12_ = xnp_note_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = name;
				if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
					result = TRUE;
					_g_object_unref0 (note);
					return result;
				}
				_g_object_unref0 (note);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * save_notes:
 *
 * Send the save-data signal on every dirty note.
 */
void xnp_window_save_notes (XnpWindow* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint n_pages;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
	n_pages = _tmp1_;
	{
		gint p;
		p = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				GtkNotebook* _tmp7_;
				gint _tmp8_;
				GtkWidget* _tmp9_ = NULL;
				XnpNote* _tmp10_;
				XnpNote* note;
				XnpNote* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = p;
					p = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = p;
				_tmp6_ = n_pages;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->notebook;
				_tmp8_ = p;
				_tmp9_ = gtk_notebook_get_nth_page (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp10_;
				_tmp11_ = note;
				_tmp12_ = xnp_note_get_dirty (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_) {
					XnpNote* _tmp14_;
					XnpNote* _tmp15_;
					_tmp14_ = note;
					xnp_note_set_dirty (_tmp14_, FALSE);
					_tmp15_ = note;
					g_signal_emit_by_name (self, "save-data", _tmp15_);
				}
				_g_object_unref0 (note);
			}
		}
	}
}


/**
 * _notebook_update_tabs_angle:
 *
 * Set the angle of each label in the tab.
 */
static void _xnp_window_notebook_update_tabs_angle (XnpWindow* self) {
	gint angle;
	gint _tmp0_;
	GtkNotebook* _tmp2_;
	gint _tmp3_ = 0;
	gint pages;
	g_return_if_fail (self != NULL);
	angle = 0;
	_tmp0_ = self->priv->_tabs_position;
	if (_tmp0_ == 2) {
		angle = 270;
	} else {
		gint _tmp1_;
		_tmp1_ = self->priv->_tabs_position;
		if (_tmp1_ == 4) {
			angle = 90;
		}
	}
	_tmp2_ = self->priv->notebook;
	_tmp3_ = gtk_notebook_get_n_pages (_tmp2_);
	pages = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gint _tmp8_;
				GtkNotebook* _tmp9_;
				gint _tmp10_;
				GtkWidget* _tmp11_ = NULL;
				GtkWidget* _tmp12_;
				GtkWidget* widget;
				GtkNotebook* _tmp13_;
				GtkWidget* _tmp14_;
				GtkWidget* _tmp15_ = NULL;
				GtkLabel* _tmp16_;
				GtkLabel* label;
				GtkLabel* _tmp17_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = pages;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->notebook;
				_tmp10_ = i;
				_tmp11_ = gtk_notebook_get_nth_page (_tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				widget = _tmp12_;
				_tmp13_ = self->priv->notebook;
				_tmp14_ = widget;
				_tmp15_ = gtk_notebook_get_tab_label (_tmp13_, _tmp14_);
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp15_) : NULL);
				label = _tmp16_;
				_tmp17_ = label;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GTK_TYPE_LABEL)) {
					GtkLabel* _tmp18_;
					gint _tmp19_;
					_tmp18_ = label;
					_tmp19_ = angle;
					gtk_label_set_angle (_tmp18_, (gdouble) _tmp19_);
				}
				_g_object_unref0 (label);
				_g_object_unref0 (widget);
			}
		}
	}
}


const gchar* xnp_window_get_name (XnpWindow* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void xnp_window_set_name (XnpWindow* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


gint xnp_window_get_n_pages (XnpWindow* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_n_pages;
	result = _tmp0_;
	return result;
}


void xnp_window_set_n_pages (XnpWindow* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_n_pages = _tmp0_;
	g_object_notify ((GObject *) self, "n-pages");
}


gboolean xnp_window_get_show_tabs (XnpWindow* self) {
	gboolean result;
	GtkNotebook* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_show_tabs (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void xnp_window_set_show_tabs (XnpWindow* self, gboolean value) {
	GtkNotebook* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = value;
	gtk_notebook_set_show_tabs (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "show-tabs");
}


gint xnp_window_get_tabs_position (XnpWindow* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_tabs_position;
	result = _tmp0_;
	return result;
}


void xnp_window_set_tabs_position (XnpWindow* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_tabs_position = _tmp0_;
	_tmp1_ = self->priv->_tabs_position;
	if (_tmp1_ == 0) {
		xnp_window_set_show_tabs (self, FALSE);
	} else {
		gint _tmp2_;
		xnp_window_set_show_tabs (self, TRUE);
		_xnp_window_notebook_update_tabs_angle (self);
		_tmp2_ = self->priv->_tabs_position;
		if (_tmp2_ == 1) {
			GtkNotebook* _tmp3_;
			_tmp3_ = self->priv->notebook;
			gtk_notebook_set_tab_pos (_tmp3_, GTK_POS_TOP);
		} else {
			gint _tmp4_;
			_tmp4_ = self->priv->_tabs_position;
			if (_tmp4_ == 2) {
				GtkNotebook* _tmp5_;
				_tmp5_ = self->priv->notebook;
				gtk_notebook_set_tab_pos (_tmp5_, GTK_POS_RIGHT);
			} else {
				gint _tmp6_;
				_tmp6_ = self->priv->_tabs_position;
				if (_tmp6_ == 3) {
					GtkNotebook* _tmp7_;
					_tmp7_ = self->priv->notebook;
					gtk_notebook_set_tab_pos (_tmp7_, GTK_POS_BOTTOM);
				} else {
					gint _tmp8_;
					_tmp8_ = self->priv->_tabs_position;
					if (_tmp8_ == 4) {
						GtkNotebook* _tmp9_;
						_tmp9_ = self->priv->notebook;
						gtk_notebook_set_tab_pos (_tmp9_, GTK_POS_LEFT);
					} else {
						xnp_window_set_show_tabs (self, FALSE);
						g_warning ("window.vala:123: Bad value for tabs-position");
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "tabs-position");
}


gboolean xnp_window_get_above (XnpWindow* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_above;
	result = _tmp0_;
	return result;
}


void xnp_window_set_above (XnpWindow* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_above = _tmp0_;
	_tmp1_ = value;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp1_);
	g_object_notify ((GObject *) self, "above");
}


gboolean xnp_window_get_sticky (XnpWindow* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_sticky;
	result = _tmp0_;
	return result;
}


void xnp_window_set_sticky (XnpWindow* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkCheckMenuItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_sticky = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	_tmp2_ = self->priv->mi_sticky;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_CHECK_MENU_ITEM)) {
		GtkCheckMenuItem* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->priv->mi_sticky;
		_tmp4_ = self->priv->_sticky;
		gtk_check_menu_item_set_active (_tmp3_, _tmp4_);
	}
	g_object_notify ((GObject *) self, "sticky");
}


gboolean xnp_window_get_show_refresh_button (XnpWindow* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_refresh_button;
	result = _tmp0_;
	return result;
}


void xnp_window_set_show_refresh_button (XnpWindow* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_refresh_button = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ == TRUE) {
		XnpTitleBarButton* _tmp2_;
		_tmp2_ = self->priv->refresh_button;
		gtk_widget_show ((GtkWidget*) _tmp2_);
	} else {
		XnpTitleBarButton* _tmp3_;
		_tmp3_ = self->priv->refresh_button;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
	g_object_notify ((GObject *) self, "show-refresh-button");
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static GObject * xnp_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpWindow * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (xnp_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW, XnpWindow);
	gtk_widget_set_name (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WIDGET, GtkWidget), "notes-window");
	_tmp0_ = _ ("Notes");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	g_object_set ((GtkWindow*) self, "default-height", 380, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 300, NULL);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) self, "xfce4-notes-plugin");
	xnp_window_set_sticky (self, TRUE);
	gtk_window_set_opacity ((GtkWindow*) self, 0.9);
	return obj;
}


static void xnp_window_class_init (XnpWindowClass * klass) {
	xnp_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_N_PAGES, g_param_spec_int ("n-pages", "n-pages", "n-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_TABS, g_param_spec_boolean ("show-tabs", "show-tabs", "show-tabs", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_TABS_POSITION, g_param_spec_int ("tabs-position", "tabs-position", "tabs-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_ABOVE, g_param_spec_boolean ("above", "above", "above", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_STICKY, g_param_spec_boolean ("sticky", "sticky", "sticky", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_REFRESH_BUTTON, g_param_spec_boolean ("show-refresh-button", "show-refresh-button", "show-refresh-button", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("action", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("save_data", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_inserted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_deleted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	g_signal_new ("note_renamed", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, XNP_TYPE_NOTE, G_TYPE_STRING);
}


static void xnp_window_instance_init (XnpWindow * self) {
	GdkCursor* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	self->priv = XNP_WINDOW_GET_PRIVATE (self);
	self->priv->CORNER_MARGIN = 20;
	_tmp0_ = gdk_cursor_new (GDK_RIGHT_SIDE);
	self->priv->CURSOR_RIGHT = _tmp0_;
	_tmp1_ = gdk_cursor_new (GDK_LEFT_SIDE);
	self->priv->CURSOR_LEFT = _tmp1_;
	_tmp2_ = gdk_cursor_new (GDK_BOTTOM_RIGHT_CORNER);
	self->priv->CURSOR_BOTTOM_RC = _tmp2_;
	_tmp3_ = gdk_cursor_new (GDK_BOTTOM_SIDE);
	self->priv->CURSOR_BOTTOM = _tmp3_;
	_tmp4_ = gdk_cursor_new (GDK_BOTTOM_LEFT_CORNER);
	self->priv->CURSOR_BOTTOM_LC = _tmp4_;
	_tmp5_ = _ ("Notes");
	_tmp6_ = g_strdup (_tmp5_);
	self->priv->_name = _tmp6_;
}


static void xnp_window_finalize (GObject* obj) {
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW, XnpWindow);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_above);
	_g_object_unref0 (self->priv->mi_sticky);
	_g_object_unref0 (self->priv->menu_image);
	_g_object_unref0 (self->priv->menu_pixbuf);
	_g_object_unref0 (self->priv->menu_hover_pixbuf);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->refresh_button);
	_g_object_unref0 (self->priv->left_arrow_button);
	_g_object_unref0 (self->priv->right_arrow_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->content_box);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->ui);
	_g_object_unref0 (self->priv->action_group);
	_gdk_cursor_unref0 (self->priv->CURSOR_RIGHT);
	_gdk_cursor_unref0 (self->priv->CURSOR_LEFT);
	_gdk_cursor_unref0 (self->priv->CURSOR_BOTTOM_RC);
	_gdk_cursor_unref0 (self->priv->CURSOR_BOTTOM);
	_gdk_cursor_unref0 (self->priv->CURSOR_BOTTOM_LC);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (xnp_window_parent_class)->finalize (obj);
}


GType xnp_window_get_type (void) {
	static volatile gsize xnp_window_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindow), 0, (GInstanceInitFunc) xnp_window_instance_init, NULL };
		GType xnp_window_type_id;
		xnp_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "XnpWindow", &g_define_type_info, 0);
		g_once_init_leave (&xnp_window_type_id__volatile, xnp_window_type_id);
	}
	return xnp_window_type_id__volatile;
}


static void _vala_xnp_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_WINDOW, XnpWindow);
	switch (property_id) {
		case XNP_WINDOW_NAME:
		g_value_set_string (value, xnp_window_get_name (self));
		break;
		case XNP_WINDOW_N_PAGES:
		g_value_set_int (value, xnp_window_get_n_pages (self));
		break;
		case XNP_WINDOW_SHOW_TABS:
		g_value_set_boolean (value, xnp_window_get_show_tabs (self));
		break;
		case XNP_WINDOW_TABS_POSITION:
		g_value_set_int (value, xnp_window_get_tabs_position (self));
		break;
		case XNP_WINDOW_ABOVE:
		g_value_set_boolean (value, xnp_window_get_above (self));
		break;
		case XNP_WINDOW_STICKY:
		g_value_set_boolean (value, xnp_window_get_sticky (self));
		break;
		case XNP_WINDOW_SHOW_REFRESH_BUTTON:
		g_value_set_boolean (value, xnp_window_get_show_refresh_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_xnp_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_WINDOW, XnpWindow);
	switch (property_id) {
		case XNP_WINDOW_NAME:
		xnp_window_set_name (self, g_value_get_string (value));
		break;
		case XNP_WINDOW_N_PAGES:
		xnp_window_set_n_pages (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_SHOW_TABS:
		xnp_window_set_show_tabs (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_TABS_POSITION:
		xnp_window_set_tabs_position (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_ABOVE:
		xnp_window_set_above (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_STICKY:
		xnp_window_set_sticky (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_SHOW_REFRESH_BUTTON:
		xnp_window_set_show_refresh_button (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



